#!/bin/bash

echo '### ### ###    ##  # # #   #   ### ## # # ##    ### ### ### #   ###
# # # # #      # # # # #   #   #   #  # # #      #  # # # # #   #
### ### #   ## ##  # # #   #   ### ## # # ## ##  #  # # # # #   ###
#   #   #      # # # # #   #     # #   #  #      #  # # # # #     #
#   #   ###    ##  ### ### ### ### ##  #  ##     #  ### ### ### ###'
echo "Made in 2022 by mueller_minki. Feel free to distribute/modify this."
sleep 1

echo "Adding scripts and desktop entries..."
mv debian-bullseye-ppc-extra-ppas.sh /tmp/
mkdir "$HOME"/.local
mkdir "$HOME"/.local/bin
mkdir "$HOME"/.local/share
mkdir "$HOME"/.local/share/applications
mv profile.sh keep-cool.sh "$HOME"/.local/bin/
mv profile.desktop keep-cool.desktop "$HOME"/.local/share/applications
chmod +x "$HOME"/.local/bin/profile.sh
chmod +x "$HOME"/.local/bin/keep-cool.sh
chmod +x "$HOME"/.local/share/applications/profile.desktop
chmod +x "$HOME"/.local/share/applications/keep-cool.desktop

cd /tmp
echo "Adding PPAs..."
sleep 1
./debian-bullseye-ppc-extra-ppas.sh

echo "Installing additional software..."
sleep 1
sudo apt -y install qemu-system-x86 dosbox epiphany-browser git make build-essential gcc
xdg-settings set default-web-browser epiphany-browser.desktop
sudo apt -y install libreoffice-core=1:6.4.4-1 libreoffice-writer=1:6.4.4-1 libreoffice-math=1:6.4.4-1 libreoffice-impress=1:6.4.4-1 libreoffice-common=1:6.4.4-1 libreoffice-draw=1:6.4.4-1 libreoffice-base-core=1:6.4.4-1 ure=1:6.4.4-1 uno-libs-private=1:6.4.4-1 libuno-cppuhelpergcc3-3=1:6.4.4-1
sudo apt -y install retroarch libretro-core-info libretro-beetle-psx libretro-mgba libretro-nestopia libretro-mupen64plus libretro-gambatte libretro-bsnes-mercury-performance
echo ""

echo "Installing Java..."
sleep 1
cd /tmp
wget https://archive.org/download/ibm-j2sdk1.6_1.6.0_powerpc_202109/ibm-j2sdk1.6_1.6.0_powerpc.deb
sudo mkdir /usr/lib/j2sdk1.6-ibm
sudo mkdir /usr/lib/j2sdk1.6-ibm/jre
sudo mkdir /usr/lib/j2sdk1.6-ibm/jre/bin
sudo mkdir /usr/lib/j2sdk1.6-ibm/jre/bin/ns7
sudo touch /usr/lib/j2sdk1.6-ibm/jre/bin/libjavaplugin_oji.so
sudo touch /usr/lib/j2sdk1.6-ibm/jre/bin/ns7/libjavaplugin_oji.so
sudo apt -y install ./ibm-j2sdk1.6_1.6.0_powerpc.deb
echo "Java installed successfully."
sleep 1

echo "Optimizing the install..."
sleep 1
sudo apt -y install preload
sudo apt -y install tuned tuned-utils tuned-utils-systemtap
sudo systemctl enable tuned
sudo systemctl start tuned
echo "Showing the activated profile..."
sudo tuned-adm active
echo "Setup completed. Rebooting in 8 seconds. Enjoy ;-D"
sleep 8
