/*
 * Decompiled with CFR 0.152.
 */
package optifine.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import optifine.json.JSONArray;
import optifine.json.JSONAware;
import optifine.json.JSONObject;
import optifine.json.JSONParser;
import optifine.json.JSONStreamAware;
import optifine.json.ParseException;

public class JSONValue {
    public static Object parse(Reader in2) {
        try {
            JSONParser jsonparser = new JSONParser();
            return jsonparser.parse(in2);
        }
        catch (Exception var2) {
            return null;
        }
    }

    public static Object parse(String s2) {
        StringReader stringreader = new StringReader(s2);
        return JSONValue.parse(stringreader);
    }

    public static Object parseWithException(Reader in2) throws IOException, ParseException {
        JSONParser jsonparser = new JSONParser();
        return jsonparser.parse(in2);
    }

    public static Object parseWithException(String s2) throws ParseException {
        JSONParser jsonparser = new JSONParser();
        return jsonparser.parse(s2);
    }

    public static void writeJSONString(Object value, Writer out) throws IOException {
        if (value == null) {
            out.write("null");
        } else if (value instanceof String) {
            out.write(34);
            out.write(JSONValue.escape((String)value));
            out.write(34);
        } else if (value instanceof Double) {
            if (!((Double)value).isInfinite() && !((Double)value).isNaN()) {
                out.write(value.toString());
            } else {
                out.write("null");
            }
        } else if (!(value instanceof Float)) {
            if (value instanceof Number) {
                out.write(value.toString());
            } else if (value instanceof Boolean) {
                out.write(value.toString());
            } else if (value instanceof JSONStreamAware) {
                ((JSONStreamAware)value).writeJSONString(out);
            } else if (value instanceof JSONAware) {
                out.write(((JSONAware)value).toJSONString());
            } else if (value instanceof Map) {
                JSONObject.writeJSONString((Map)value, out);
            } else if (value instanceof List) {
                JSONArray.writeJSONString((List)value, out);
            } else {
                out.write(value.toString());
            }
        } else if (!((Float)value).isInfinite() && !((Float)value).isNaN()) {
            out.write(value.toString());
        } else {
            out.write("null");
        }
    }

    public static String toJSONString(Object value) {
        return value == null ? "null" : (value instanceof String ? "\"" + JSONValue.escape((String)value) + "\"" : (value instanceof Double ? (!((Double)value).isInfinite() && !((Double)value).isNaN() ? value.toString() : "null") : (value instanceof Float ? (!((Float)value).isInfinite() && !((Float)value).isNaN() ? value.toString() : "null") : (value instanceof Number ? value.toString() : (value instanceof Boolean ? value.toString() : (value instanceof JSONAware ? ((JSONAware)value).toJSONString() : (value instanceof Map ? JSONObject.toJSONString((Map)value) : (value instanceof List ? JSONArray.toJSONString((List)value) : value.toString()))))))));
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuffer stringbuffer = new StringBuffer();
        JSONValue.escape(s2, stringbuffer);
        return stringbuffer.toString();
    }

    static void escape(String s2, StringBuffer sb2) {
        block9: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char c0 = s2.charAt(i2);
            switch (c0) {
                case '\b': {
                    sb2.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb2.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb2.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb2.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb2.append("\\r");
                    continue block9;
                }
                case '\"': {
                    sb2.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb2.append("\\\\");
                    continue block9;
                }
                default: {
                    if (c0 >= '\u0000' && c0 <= '\u001f' || c0 >= '\u007f' && c0 <= '\u009f' || c0 >= '\u2000' && c0 <= '\u20ff') {
                        String s1 = Integer.toHexString(c0);
                        sb2.append("\\u");
                        for (int j2 = 0; j2 < 4 - s1.length(); ++j2) {
                            sb2.append('0');
                        }
                        sb2.append(s1.toUpperCase());
                        continue block9;
                    }
                    sb2.append(c0);
                }
            }
        }
    }
}

