/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;

public class Utils {
    public static final String MAC_OS_HOME_PREFIX = "Library/Application Support";
    private static final char[] hexTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static File getWorkingDirectory() {
        return Utils.getWorkingDirectory("minecraft");
    }

    public static File getWorkingDirectory(String applicationName) {
        String s2 = System.getProperty("user.home", ".");
        File file1 = null;
        switch (Utils.getPlatform().ordinal()) {
            case 1: 
            case 2: {
                file1 = new File(s2, '.' + applicationName + '/');
                break;
            }
            case 3: {
                String s1 = System.getenv("APPDATA");
                if (s1 != null) {
                    file1 = new File(s1, "." + applicationName + '/');
                    break;
                }
                file1 = new File(s2, '.' + applicationName + '/');
                break;
            }
            case 4: {
                file1 = new File(s2, "Library/Application Support/" + applicationName);
                break;
            }
            default: {
                file1 = new File(s2, applicationName + '/');
            }
        }
        if (!file1.exists() && !file1.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + file1);
        }
        return file1;
    }

    public static OS getPlatform() {
        String s2 = System.getProperty("os.name").toLowerCase();
        return s2.contains("win") ? OS.WINDOWS : (s2.contains("mac") ? OS.MACOS : (s2.contains("solaris") ? OS.SOLARIS : (s2.contains("sunos") ? OS.SOLARIS : (s2.contains("linux") ? OS.LINUX : (s2.contains("unix") ? OS.LINUX : OS.UNKNOWN)))));
    }

    public static int find(byte[] buf, byte[] pattern) {
        return Utils.find(buf, 0, pattern);
    }

    public static int find(byte[] buf, int index, byte[] pattern) {
        for (int i2 = index; i2 < buf.length - pattern.length; ++i2) {
            boolean flag = true;
            for (int j2 = 0; j2 < pattern.length; ++j2) {
                if (pattern[j2] == buf[i2 + j2]) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return i2;
        }
        return -1;
    }

    public static byte[] readAll(InputStream is2) throws IOException {
        ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
        byte[] abyte = new byte[1024];
        while (true) {
            int i2;
            if ((i2 = is2.read(abyte)) < 0) {
                is2.close();
                byte[] abyte1 = bytearrayoutputstream.toByteArray();
                return abyte1;
            }
            bytearrayoutputstream.write(abyte, 0, i2);
        }
    }

    public static void dbg(String str) {
        System.out.println(str);
    }

    public static String[] tokenize(String str, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer stringtokenizer = new StringTokenizer(str, delim);
        while (stringtokenizer.hasMoreTokens()) {
            String s2 = stringtokenizer.nextToken();
            list.add(s2);
        }
        String[] astring = list.toArray(new String[list.size()]);
        return astring;
    }

    public static String getExceptionStackTrace(Throwable e2) {
        StringWriter stringwriter = new StringWriter();
        PrintWriter printwriter = new PrintWriter(stringwriter);
        e2.printStackTrace(printwriter);
        printwriter.close();
        try {
            stringwriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringwriter.getBuffer().toString();
    }

    public static void copyFile(File fileSrc, File fileDest) throws IOException {
        if (!fileSrc.getCanonicalPath().equals(fileDest.getCanonicalPath())) {
            FileInputStream fileinputstream = new FileInputStream(fileSrc);
            FileOutputStream fileoutputstream = new FileOutputStream(fileDest);
            Utils.copyAll(fileinputstream, fileoutputstream);
            fileoutputstream.flush();
            fileinputstream.close();
            fileoutputstream.close();
        }
    }

    public static void copyAll(InputStream is2, OutputStream os2) throws IOException {
        byte[] abyte = new byte[1024];
        int i2;
        while ((i2 = is2.read(abyte)) >= 0) {
            os2.write(abyte, 0, i2);
        }
        return;
    }

    public static void showMessage(String msg) {
        JOptionPane.showMessageDialog(null, msg, "OptiFine", 1);
    }

    public static void showErrorMessage(String msg) {
        JOptionPane.showMessageDialog(null, msg, "Error", 0);
    }

    public static String readFile(File file) throws IOException {
        return Utils.readFile(file, "ASCII");
    }

    public static String readFile(File file, String encoding) throws IOException {
        FileInputStream fileinputstream = new FileInputStream(file);
        return Utils.readText(fileinputstream, encoding);
    }

    public static String readText(InputStream in2, String encoding) throws IOException {
        InputStreamReader inputstreamreader = new InputStreamReader(in2, encoding);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        StringBuffer stringbuffer = new StringBuffer();
        while (true) {
            String s2;
            if ((s2 = bufferedreader.readLine()) == null) {
                bufferedreader.close();
                inputstreamreader.close();
                in2.close();
                return stringbuffer.toString();
            }
            stringbuffer.append(s2);
            stringbuffer.append("\n");
        }
    }

    public static String[] readLines(InputStream in2, String encoding) throws IOException {
        String s2 = Utils.readText(in2, encoding);
        String[] astring = Utils.tokenize(s2, "\n\r");
        return astring;
    }

    public static void centerWindow(Component c2, Component par) {
        if (c2 != null) {
            Rectangle rectangle1;
            Rectangle rectangle = c2.getBounds();
            if (par != null && par.isVisible()) {
                rectangle1 = par.getBounds();
            } else {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                rectangle1 = new Rectangle(0, 0, dimension.width, dimension.height);
            }
            int j2 = rectangle1.x + (rectangle1.width - rectangle.width) / 2;
            int i2 = rectangle1.y + (rectangle1.height - rectangle.height) / 2;
            if (j2 < 0) {
                j2 = 0;
            }
            if (i2 < 0) {
                i2 = 0;
            }
            c2.setBounds(j2, i2, rectangle.width, rectangle.height);
        }
    }

    public static String byteArrayToHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            byte b0 = bytes[i2];
            stringbuffer.append(hexTable[b0 >> 4 & 0xF]);
            stringbuffer.append(hexTable[b0 & 0xF]);
        }
        return stringbuffer.toString();
    }

    public static String arrayToCommaSeparatedString(Object[] arr2) {
        if (arr2 == null) {
            return "";
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (int i2 = 0; i2 < arr2.length; ++i2) {
            Object object = arr2[i2];
            if (i2 > 0) {
                stringbuffer.append(", ");
            }
            if (object == null) {
                stringbuffer.append("null");
                continue;
            }
            if (!object.getClass().isArray()) {
                stringbuffer.append(arr2[i2]);
                continue;
            }
            stringbuffer.append("[");
            if (object instanceof Object[]) {
                Object[] aobject = (Object[])object;
                stringbuffer.append(Utils.arrayToCommaSeparatedString(aobject));
            } else {
                for (int j2 = 0; j2 < Array.getLength(object); ++j2) {
                    if (j2 > 0) {
                        stringbuffer.append(", ");
                    }
                    stringbuffer.append(Array.get(object, j2));
                }
            }
            stringbuffer.append("]");
        }
        return stringbuffer.toString();
    }

    public static String removePrefix(String str, String prefix) {
        if (str != null && prefix != null) {
            if (str.startsWith(prefix)) {
                str = str.substring(prefix.length());
            }
            return str;
        }
        return str;
    }

    public static String removePrefix(String str, String[] prefixes) {
        if (str != null && prefixes != null) {
            String s2;
            int i2 = str.length();
            for (int j2 = 0; j2 < prefixes.length && (str = Utils.removePrefix(str, s2 = prefixes[j2])).length() == i2; ++j2) {
            }
            return str;
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        if (str != null && suffix != null) {
            if (str.endsWith(suffix)) {
                str = str.substring(0, str.length() - suffix.length());
            }
            return str;
        }
        return str;
    }

    public static String removeSuffix(String str, String[] suffixes) {
        if (str != null && suffixes != null) {
            String s2;
            int i2 = str.length();
            for (int j2 = 0; j2 < suffixes.length && (str = Utils.removeSuffix(str, s2 = suffixes[j2])).length() == i2; ++j2) {
            }
            return str;
        }
        return str;
    }

    public static String ensurePrefix(String str, String prefix) {
        if (str != null && prefix != null) {
            if (!str.startsWith(prefix)) {
                str = prefix + str;
            }
            return str;
        }
        return str;
    }

    public static boolean equals(Object o1, Object o2) {
        return o1 == o2 ? true : (o1 == null ? false : o1.equals(o2));
    }

    public static int parseInt(String str, int defVal) {
        try {
            if (str == null) {
                return defVal;
            }
            str = str.trim();
            return Integer.parseInt(str);
        }
        catch (NumberFormatException var3) {
            return defVal;
        }
    }

    public static boolean equalsMask(String str, String mask, char wildChar) {
        if (mask != null && str != null) {
            String s1;
            if (mask.indexOf(wildChar) < 0) {
                return mask.equals(str);
            }
            ArrayList<String> list = new ArrayList<String>();
            String s2 = "" + wildChar;
            if (mask.startsWith(s2)) {
                list.add("");
            }
            StringTokenizer stringtokenizer = new StringTokenizer(mask, s2);
            while (stringtokenizer.hasMoreElements()) {
                list.add(stringtokenizer.nextToken());
            }
            if (mask.endsWith(s2)) {
                list.add("");
            }
            if (!str.startsWith(s1 = (String)list.get(0))) {
                return false;
            }
            String s22 = (String)list.get(list.size() - 1);
            if (!str.endsWith(s22)) {
                return false;
            }
            int i2 = 0;
            for (int j2 = 0; j2 < list.size(); ++j2) {
                String s3 = (String)list.get(j2);
                if (s3.length() <= 0) continue;
                int k2 = str.indexOf(s3, i2);
                if (k2 < 0) {
                    return false;
                }
                i2 = k2 + s3.length();
            }
            return true;
        }
        return mask == str;
    }

    public static Object[] addObjectToArray(Object[] arr2, Object obj) {
        if (arr2 == null) {
            throw new NullPointerException("The given array is NULL");
        }
        int i2 = arr2.length;
        int j2 = i2 + 1;
        Object[] aobject = (Object[])Array.newInstance(arr2.getClass().getComponentType(), j2);
        System.arraycopy(arr2, 0, aobject, 0, i2);
        aobject[i2] = obj;
        return aobject;
    }

    public static Object[] addObjectToArray(Object[] arr2, Object obj, int index) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr2));
        list.add(index, obj);
        Object[] aobject = (Object[])Array.newInstance(arr2.getClass().getComponentType(), list.size());
        return list.toArray(aobject);
    }

    public static Object[] addObjectsToArray(Object[] arr2, Object[] objs) {
        if (arr2 == null) {
            throw new NullPointerException("The given array is NULL");
        }
        if (objs.length == 0) {
            return arr2;
        }
        int i2 = arr2.length;
        int j2 = i2 + objs.length;
        Object[] aobject = (Object[])Array.newInstance(arr2.getClass().getComponentType(), j2);
        System.arraycopy(arr2, 0, aobject, 0, i2);
        System.arraycopy(objs, 0, aobject, i2, objs.length);
        return aobject;
    }

    public static Object[] removeObjectFromArray(Object[] arr2, Object obj) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arr2));
        list.remove(obj);
        Object[] aobject = Utils.collectionToArray(list, arr2.getClass().getComponentType());
        return aobject;
    }

    public static Object[] collectionToArray(Collection coll, Class elementClass) {
        if (coll == null) {
            return null;
        }
        if (elementClass == null) {
            return null;
        }
        if (elementClass.isPrimitive()) {
            throw new IllegalArgumentException("Can not make arrays with primitive elements (int, double), element class: " + elementClass);
        }
        Object[] aobject = (Object[])Array.newInstance(elementClass, coll.size());
        return coll.toArray(aobject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS,
        MACOS,
        UNKNOWN;

    }
}

