/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<T> {
    private Node<T> first;
    private Node<T> last;
    private int size;

    public void addFirst(Node<T> node) {
        this.checkNoParent(node);
        if (this.isEmpty()) {
            this.first = node;
            this.last = node;
        } else {
            Node<T> nodeFirst = this.first;
            ((Node)node).setNext((Node)nodeFirst);
            ((Node)nodeFirst).setPrev((Node)node);
            this.first = node;
        }
        ((Node)node).setParent(this);
        ++this.size;
    }

    public void addLast(Node<T> node) {
        this.checkNoParent(node);
        if (this.isEmpty()) {
            this.first = node;
            this.last = node;
        } else {
            Node<T> nodeLast = this.last;
            ((Node)node).setPrev((Node)nodeLast);
            ((Node)nodeLast).setNext((Node)node);
            this.last = node;
        }
        ((Node)node).setParent(this);
        ++this.size;
    }

    public void addAfter(Node<T> nodePrev, Node<T> node) {
        if (nodePrev == null) {
            this.addFirst(node);
        } else if (nodePrev == this.last) {
            this.addLast(node);
        } else {
            this.checkParent(nodePrev);
            this.checkNoParent(node);
            Node<T> nodeNext = nodePrev.getNext();
            ((Node)nodePrev).setNext((Node)nodeNext);
            ((Node)node).setPrev((Node)nodePrev);
            ((Node)nodeNext).setPrev((Node)node);
            ((Node)node).setNext((Node)node);
            ((Node)node).setParent(this);
            ++this.size;
        }
    }

    public Node<T> remove(Node<T> node) {
        this.checkParent(node);
        Node<T> nodePrev = node.getPrev();
        Node<T> node1 = node.getNext();
        if (nodePrev != null) {
            ((Node)nodePrev).setNext((Node)node1);
        } else {
            this.first = node1;
        }
        if (node1 != null) {
            ((Node)node1).setPrev((Node)nodePrev);
        } else {
            this.last = node;
        }
        ((Node)node).setPrev((Node)null);
        ((Node)node).setNext((Node)null);
        ((Node)node).setParent(null);
        --this.size;
        return node;
    }

    public void moveAfter(Node<T> nodePrev, Node<T> node) {
        this.remove(node);
        this.addAfter(nodePrev, node);
    }

    public boolean find(Node<T> nodeFind, Node<T> nodeFrom, Node<T> nodeTo) {
        Node<T> node;
        this.checkParent(nodeFrom);
        if (nodeTo != null) {
            this.checkParent(nodeTo);
        }
        for (node = nodeFrom; node != null && node != nodeTo; node = node.getNext()) {
            if (node != nodeFind) continue;
            return true;
        }
        if (node != nodeTo) {
            throw new IllegalArgumentException("Sublist is not linked, from: " + nodeFrom + ", to: " + nodeTo);
        }
        return false;
    }

    private void checkParent(Node<T> node) {
        if (((Node)node).parent != this) {
            throw new IllegalArgumentException("Node has different parent, node: " + node + ", parent: " + ((Node)node).parent + ", this: " + this);
        }
    }

    private void checkNoParent(Node<T> node) {
        if (((Node)node).parent != null) {
            throw new IllegalArgumentException("Node has different parent, node: " + node + ", parent: " + ((Node)node).parent + ", this: " + this);
        }
    }

    public boolean contains(Node<T> node) {
        return ((Node)node).parent == this;
    }

    public Iterator<Node<T>> iterator() {
        Iterator iterator = new Iterator<Node<T>>(){
            Node<T> node;
            {
                this.node = LinkedList.this.getFirst();
            }

            @Override
            public boolean hasNext() {
                return this.node != null;
            }

            @Override
            public Node<T> next() {
                Node node = this.node;
                if (this.node != null) {
                    this.node = this.node.next;
                }
                return node;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return iterator;
    }

    public Node<T> getFirst() {
        return this.first;
    }

    public Node<T> getLast() {
        return this.last;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        Iterator<Node<T>> it2 = this.iterator();
        while (it2.hasNext()) {
            Node<T> node = it2.next();
            if (stringbuffer.length() > 0) {
                stringbuffer.append(", ");
            }
            stringbuffer.append(node.getItem());
        }
        return "" + this.size + " [" + stringbuffer.toString() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Node<T> {
        private final T item;
        private Node<T> prev;
        private Node<T> next;
        private LinkedList<T> parent;

        public Node(T item) {
            this.item = item;
        }

        public T getItem() {
            return this.item;
        }

        public Node<T> getPrev() {
            return this.prev;
        }

        public Node<T> getNext() {
            return this.next;
        }

        private void setPrev(Node<T> prev) {
            this.prev = prev;
        }

        private void setNext(Node<T> next) {
            this.next = next;
        }

        private void setParent(LinkedList<T> parent) {
            this.parent = parent;
        }

        public String toString() {
            return "" + this.item;
        }
    }
}

