/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.uniform;

import net.optifine.expr.ExpressionType;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionBool;
import net.optifine.expr.IExpressionFloat;
import net.optifine.expr.IExpressionFloatArray;
import net.optifine.shaders.uniform.ShaderUniform1f;
import net.optifine.shaders.uniform.ShaderUniform1i;
import net.optifine.shaders.uniform.ShaderUniform2f;
import net.optifine.shaders.uniform.ShaderUniform3f;
import net.optifine.shaders.uniform.ShaderUniform4f;
import net.optifine.shaders.uniform.ShaderUniformBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UniformType {
    BOOL,
    INT,
    FLOAT,
    VEC2,
    VEC3,
    VEC4;


    public ShaderUniformBase makeShaderUniform(String name) {
        switch (this) {
            case BOOL: {
                return new ShaderUniform1i(name);
            }
            case INT: {
                return new ShaderUniform1i(name);
            }
            case FLOAT: {
                return new ShaderUniform1f(name);
            }
            case VEC2: {
                return new ShaderUniform2f(name);
            }
            case VEC3: {
                return new ShaderUniform3f(name);
            }
            case VEC4: {
                return new ShaderUniform4f(name);
            }
        }
        throw new RuntimeException("Unknown uniform type: " + (Object)((Object)this));
    }

    public void updateUniform(IExpression expression, ShaderUniformBase uniform) {
        switch (this) {
            case BOOL: {
                this.updateUniformBool((IExpressionBool)expression, (ShaderUniform1i)uniform);
                return;
            }
            case INT: {
                this.updateUniformInt((IExpressionFloat)expression, (ShaderUniform1i)uniform);
                return;
            }
            case FLOAT: {
                this.updateUniformFloat((IExpressionFloat)expression, (ShaderUniform1f)uniform);
                return;
            }
            case VEC2: {
                this.updateUniformFloat2((IExpressionFloatArray)expression, (ShaderUniform2f)uniform);
                return;
            }
            case VEC3: {
                this.updateUniformFloat3((IExpressionFloatArray)expression, (ShaderUniform3f)uniform);
                return;
            }
            case VEC4: {
                this.updateUniformFloat4((IExpressionFloatArray)expression, (ShaderUniform4f)uniform);
                return;
            }
        }
        throw new RuntimeException("Unknown uniform type: " + (Object)((Object)this));
    }

    private void updateUniformBool(IExpressionBool expression, ShaderUniform1i uniform) {
        boolean flag = expression.eval();
        int i2 = flag ? 1 : 0;
        uniform.setValue(i2);
    }

    private void updateUniformInt(IExpressionFloat expression, ShaderUniform1i uniform) {
        int i2 = (int)expression.eval();
        uniform.setValue(i2);
    }

    private void updateUniformFloat(IExpressionFloat expression, ShaderUniform1f uniform) {
        float f2 = expression.eval();
        uniform.setValue(f2);
    }

    private void updateUniformFloat2(IExpressionFloatArray expression, ShaderUniform2f uniform) {
        float[] afloat = expression.eval();
        if (afloat.length != 2) {
            throw new RuntimeException("Value length is not 2, length: " + afloat.length);
        }
        uniform.setValue(afloat[0], afloat[1]);
    }

    private void updateUniformFloat3(IExpressionFloatArray expression, ShaderUniform3f uniform) {
        float[] afloat = expression.eval();
        if (afloat.length != 3) {
            throw new RuntimeException("Value length is not 3, length: " + afloat.length);
        }
        uniform.setValue(afloat[0], afloat[1], afloat[2]);
    }

    private void updateUniformFloat4(IExpressionFloatArray expression, ShaderUniform4f uniform) {
        float[] afloat = expression.eval();
        if (afloat.length != 4) {
            throw new RuntimeException("Value length is not 4, length: " + afloat.length);
        }
        uniform.setValue(afloat[0], afloat[1], afloat[2], afloat[3]);
    }

    public boolean matchesExpressionType(ExpressionType expressionType) {
        switch (this) {
            case BOOL: {
                return expressionType == ExpressionType.BOOL;
            }
            case INT: {
                return expressionType == ExpressionType.FLOAT;
            }
            case FLOAT: {
                return expressionType == ExpressionType.FLOAT;
            }
            case VEC2: 
            case VEC3: 
            case VEC4: {
                return expressionType == ExpressionType.FLOAT_ARRAY;
            }
        }
        throw new RuntimeException("Unknown uniform type: " + (Object)((Object)this));
    }

    public static UniformType parse(String type) {
        UniformType[] auniformtype = UniformType.values();
        for (int i2 = 0; i2 < auniformtype.length; ++i2) {
            UniformType uniformtype = auniformtype[i2];
            if (!uniformtype.name().toLowerCase().equals(type)) continue;
            return uniformtype;
        }
        return null;
    }
}

