/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders.config;

import java.util.Map;
import net.optifine.expr.ConstantFloat;
import net.optifine.expr.FunctionBool;
import net.optifine.expr.FunctionType;
import net.optifine.expr.IExpression;
import net.optifine.expr.IExpressionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacroExpressionResolver
implements IExpressionResolver {
    private Map<String, String> mapMacroValues = null;

    public MacroExpressionResolver(Map<String, String> mapMacroValues) {
        this.mapMacroValues = mapMacroValues;
    }

    @Override
    public IExpression getExpression(String name) {
        String s1;
        String s2 = "defined_";
        if (name.startsWith(s2)) {
            String s22 = name.substring(s2.length());
            return this.mapMacroValues.containsKey(s22) ? new FunctionBool(FunctionType.TRUE, null) : new FunctionBool(FunctionType.FALSE, null);
        }
        while (this.mapMacroValues.containsKey(name) && (s1 = this.mapMacroValues.get(name)) != null && !s1.equals(name)) {
            name = s1;
        }
        int i2 = Config.parseInt(name, Integer.MIN_VALUE);
        if (i2 == Integer.MIN_VALUE) {
            Config.warn("Unknown macro value: " + name);
            return new ConstantFloat(0.0f);
        }
        return new ConstantFloat(i2);
    }
}

