/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.optifine.shaders.MultiTexID;
import net.optifine.shaders.SMCLog;
import net.optifine.shaders.Shaders;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShadersTex {
    public static final int initialBufferSize = 0x100000;
    public static ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)0x400000);
    public static IntBuffer intBuffer = byteBuffer.asIntBuffer();
    public static int[] intArray = new int[0x100000];
    public static final int defBaseTexColor = 0;
    public static final int defNormTexColor = -8421377;
    public static final int defSpecTexColor = 0;
    public static Map<Integer, MultiTexID> multiTexMap = new HashMap<Integer, MultiTexID>();

    public static IntBuffer getIntBuffer(int size) {
        if (intBuffer.capacity() < size) {
            int i2 = ShadersTex.roundUpPOT(size);
            byteBuffer = BufferUtils.createByteBuffer((int)(i2 * 4));
            intBuffer = byteBuffer.asIntBuffer();
        }
        return intBuffer;
    }

    public static int[] getIntArray(int size) {
        if (intArray == null) {
            intArray = new int[0x100000];
        }
        if (intArray.length < size) {
            intArray = new int[ShadersTex.roundUpPOT(size)];
        }
        return intArray;
    }

    public static int roundUpPOT(int x2) {
        int i2 = x2 - 1;
        i2 |= i2 >> 1;
        i2 |= i2 >> 2;
        i2 |= i2 >> 4;
        i2 |= i2 >> 8;
        i2 |= i2 >> 16;
        return i2 + 1;
    }

    public static int log2(int x2) {
        int i2 = 0;
        if ((x2 & 0xFFFF0000) != 0) {
            i2 += 16;
            x2 >>= 16;
        }
        if ((x2 & 0xFF00) != 0) {
            i2 += 8;
            x2 >>= 8;
        }
        if ((x2 & 0xF0) != 0) {
            i2 += 4;
            x2 >>= 4;
        }
        if ((x2 & 6) != 0) {
            i2 += 2;
            x2 >>= 2;
        }
        if ((x2 & 2) != 0) {
            ++i2;
        }
        return i2;
    }

    public static IntBuffer fillIntBuffer(int size, int value) {
        int[] aint = ShadersTex.getIntArray(size);
        IntBuffer intbuffer = ShadersTex.getIntBuffer(size);
        Arrays.fill(intArray, 0, size, value);
        intBuffer.put(intArray, 0, size);
        return intBuffer;
    }

    public static int[] createAIntImage(int size) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, 0);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static int[] createAIntImage(int size, int color) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, color);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static MultiTexID getMultiTexID(bly tex) {
        MultiTexID multitexid = tex.multiTex;
        if (multitexid == null) {
            int i2 = tex.b();
            multitexid = multiTexMap.get(i2);
            if (multitexid == null) {
                multitexid = new MultiTexID(i2, GL11.glGenTextures(), GL11.glGenTextures());
                multiTexMap.put(i2, multitexid);
            }
            tex.multiTex = multitexid;
        }
        return multitexid;
    }

    public static void deleteTextures(bly atex, int texid) {
        MultiTexID multitexid = atex.multiTex;
        if (multitexid != null) {
            atex.multiTex = null;
            multiTexMap.remove(multitexid.base);
            bfl.h(multitexid.norm);
            bfl.h(multitexid.spec);
            if (multitexid.base != texid) {
                SMCLog.warning("Error : MultiTexID.base mismatch: " + multitexid.base + ", texid: " + texid);
                bfl.h(multitexid.base);
            }
        }
    }

    public static void bindNSTextures(int normTex, int specTex) {
        if (Shaders.isRenderingWorld && bfl.getActiveTextureUnit() == 33984) {
            bfl.g(33986);
            bfl.i(normTex);
            bfl.g(33987);
            bfl.i(specTex);
            bfl.g(33984);
        }
    }

    public static void bindNSTextures(MultiTexID multiTex) {
        ShadersTex.bindNSTextures(multiTex.norm, multiTex.spec);
    }

    public static void bindTextures(int baseTex, int normTex, int specTex) {
        if (Shaders.isRenderingWorld && bfl.getActiveTextureUnit() == 33984) {
            bfl.g(33986);
            bfl.i(normTex);
            bfl.g(33987);
            bfl.i(specTex);
            bfl.g(33984);
        }
        bfl.i(baseTex);
    }

    public static void bindTextures(MultiTexID multiTex) {
        if (Shaders.isRenderingWorld && bfl.getActiveTextureUnit() == 33984) {
            if (Shaders.configNormalMap) {
                bfl.g(33986);
                bfl.i(multiTex.norm);
            }
            if (Shaders.configSpecularMap) {
                bfl.g(33987);
                bfl.i(multiTex.spec);
            }
            bfl.g(33984);
        }
        bfl.i(multiTex.base);
    }

    public static void bindTexture(bmk tex) {
        int i2 = tex.b();
        ShadersTex.bindTextures(tex.getMultiTexID());
        if (bfl.getActiveTextureUnit() == 33984) {
            int j2 = Shaders.atlasSizeX;
            int k2 = Shaders.atlasSizeY;
            if (tex instanceof bmh) {
                Shaders.atlasSizeX = ((bmh)tex).atlasWidth;
                Shaders.atlasSizeY = ((bmh)tex).atlasHeight;
            } else {
                Shaders.atlasSizeX = 0;
                Shaders.atlasSizeY = 0;
            }
            if (Shaders.atlasSizeX != j2 || Shaders.atlasSizeY != k2) {
                Shaders.uniform_atlasSize.setValue(Shaders.atlasSizeX, Shaders.atlasSizeY);
            }
        }
    }

    public static void bindTextures(int baseTex) {
        MultiTexID multitexid = multiTexMap.get(baseTex);
        ShadersTex.bindTextures(multitexid);
    }

    public static void initDynamicTexture(int texID, int width, int height, blz tex) {
        MultiTexID multitexid = tex.getMultiTexID();
        int[] aint = tex.e();
        int i2 = width * height;
        Arrays.fill(aint, i2, i2 * 2, -8421377);
        Arrays.fill(aint, i2 * 2, i2 * 3, 0);
        bml.a(multitexid.base, width, height);
        bml.a(false, false);
        bml.a(false);
        bml.a(multitexid.norm, width, height);
        bml.a(false, false);
        bml.a(false);
        bml.a(multitexid.spec, width, height);
        bml.a(false, false);
        bml.a(false);
        bfl.i(multitexid.base);
    }

    public static void updateDynamicTexture(int texID, int[] src, int width, int height, blz tex) {
        MultiTexID multitexid = tex.getMultiTexID();
        bfl.i(multitexid.base);
        ShadersTex.updateDynTexSubImage1(src, width, height, 0, 0, 0);
        bfl.i(multitexid.norm);
        ShadersTex.updateDynTexSubImage1(src, width, height, 0, 0, 1);
        bfl.i(multitexid.spec);
        ShadersTex.updateDynTexSubImage1(src, width, height, 0, 0, 2);
        bfl.i(multitexid.base);
    }

    public static void updateDynTexSubImage1(int[] src, int width, int height, int posX, int posY, int page) {
        int i2 = width * height;
        IntBuffer intbuffer = ShadersTex.getIntBuffer(i2);
        intbuffer.clear();
        int j2 = page * i2;
        if (src.length >= j2 + i2) {
            intbuffer.put(src, j2, i2).position(0).limit(i2);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intbuffer);
            intbuffer.clear();
        }
    }

    public static bmk createDefaultTexture() {
        blz dynamictexture = new blz(1, 1);
        dynamictexture.e()[0] = -1;
        dynamictexture.d();
        return dynamictexture;
    }

    public static void allocateTextureMap(int texID, int mipmapLevels, int width, int height, bmf stitcher, bmh tex) {
        SMCLog.info("allocateTextureMap " + mipmapLevels + " " + width + " " + height + " ");
        tex.atlasWidth = width;
        tex.atlasHeight = height;
        MultiTexID multitexid = ShadersTex.getMultiTexID(tex);
        bml.a(multitexid.base, mipmapLevels, width, height);
        if (Shaders.configNormalMap) {
            bml.a(multitexid.norm, mipmapLevels, width, height);
        }
        if (Shaders.configSpecularMap) {
            bml.a(multitexid.spec, mipmapLevels, width, height);
        }
        bfl.i(texID);
    }

    public static void uploadTexSubForLoadAtlas(bmh textureMap, String iconName, int[][] data, int width, int height, int xoffset, int yoffset, boolean linear, boolean clamp) {
        MultiTexID multitexid = textureMap.multiTex;
        bml.a(data, width, height, xoffset, yoffset, linear, clamp);
        boolean flag = false;
        if (Shaders.configNormalMap) {
            int[][] aint = ShadersTex.readImageAndMipmaps(textureMap, iconName + "_n", width, height, data.length, flag, -8421377);
            bfl.i(multitexid.norm);
            bml.a(aint, width, height, xoffset, yoffset, linear, clamp);
        }
        if (Shaders.configSpecularMap) {
            int[][] aint1 = ShadersTex.readImageAndMipmaps(textureMap, iconName + "_s", width, height, data.length, flag, 0);
            bfl.i(multitexid.spec);
            bml.a(aint1, width, height, xoffset, yoffset, linear, clamp);
        }
        bfl.i(multitexid.base);
    }

    public static int[][] readImageAndMipmaps(bmh updatingTextureMap, String name, int width, int height, int numLevels, boolean border, int defColor) {
        MultiTexID multitexid = updatingTextureMap.multiTex;
        Object aint = new int[numLevels][];
        int[] aint1 = new int[width * height];
        aint[0] = aint1;
        boolean flag = false;
        BufferedImage bufferedimage = ShadersTex.readImage(updatingTextureMap.completeResourceLocation(new jy(name)));
        if (bufferedimage != null) {
            int i2 = bufferedimage.getWidth();
            int j2 = bufferedimage.getHeight();
            if (i2 + (border ? 16 : 0) == width) {
                flag = true;
                bufferedimage.getRGB(0, 0, i2, i2, aint1, 0, i2);
            }
        }
        if (!flag) {
            Arrays.fill(aint1, defColor);
        }
        bfl.i(multitexid.spec);
        aint = ShadersTex.genMipmapsSimple(((int[][])aint).length - 1, width, aint);
        return aint;
    }

    public static BufferedImage readImage(jy resLoc) {
        try {
            if (!Config.hasResource(resLoc)) {
                return null;
            }
            InputStream inputstream = Config.getResourceStream(resLoc);
            if (inputstream == null) {
                return null;
            }
            BufferedImage bufferedimage = ImageIO.read(inputstream);
            inputstream.close();
            return bufferedimage;
        }
        catch (IOException var3) {
            return null;
        }
    }

    public static int[][] genMipmapsSimple(int maxLevel, int width, int[][] data) {
        for (int i2 = 1; i2 <= maxLevel; ++i2) {
            if (data[i2] != null) continue;
            int j2 = width >> i2;
            int k2 = j2 * 2;
            int[] aint = data[i2 - 1];
            data[i2] = new int[j2 * j2];
            int[] aint1 = data[i2];
            for (int i1 = 0; i1 < j2; ++i1) {
                for (int l2 = 0; l2 < j2; ++l2) {
                    int j1 = i1 * 2 * k2 + l2 * 2;
                    aint1[i1 * j2 + l2] = ShadersTex.blend4Simple(aint[j1], aint[j1 + 1], aint[j1 + k2], aint[j1 + k2 + 1]);
                }
            }
        }
        return data;
    }

    public static void uploadTexSub1(int[][] src, int width, int height, int posX, int posY, int page) {
        int i2 = width * height;
        IntBuffer intbuffer = ShadersTex.getIntBuffer(i2);
        int j2 = src.length;
        int k2 = 0;
        int l2 = width;
        int i1 = height;
        int j1 = posX;
        int k1 = posY;
        while (l2 > 0 && i1 > 0 && k2 < j2) {
            int l1 = l2 * i1;
            int[] aint = src[k2];
            intbuffer.clear();
            if (aint.length >= l1 * (page + 1)) {
                intbuffer.put(aint, l1 * page, l1).position(0).limit(l1);
                GL11.glTexSubImage2D((int)3553, (int)k2, (int)j1, (int)k1, (int)l2, (int)i1, (int)32993, (int)33639, (IntBuffer)intbuffer);
            }
            l2 >>= 1;
            i1 >>= 1;
            j1 >>= 1;
            k1 >>= 1;
            ++k2;
        }
        intbuffer.clear();
    }

    public static int blend4Alpha(int c0, int c1, int c2, int c3) {
        int k1;
        int i2 = c0 >>> 24 & 0xFF;
        int j2 = c1 >>> 24 & 0xFF;
        int k2 = c2 >>> 24 & 0xFF;
        int l2 = c3 >>> 24 & 0xFF;
        int i1 = i2 + j2 + k2 + l2;
        int j1 = (i1 + 2) / 4;
        if (i1 != 0) {
            k1 = i1;
        } else {
            k1 = 4;
            i2 = 1;
            j2 = 1;
            k2 = 1;
            l2 = 1;
        }
        int l1 = (k1 + 1) / 2;
        int i22 = j1 << 24 | ((c0 >>> 16 & 0xFF) * i2 + (c1 >>> 16 & 0xFF) * j2 + (c2 >>> 16 & 0xFF) * k2 + (c3 >>> 16 & 0xFF) * l2 + l1) / k1 << 16 | ((c0 >>> 8 & 0xFF) * i2 + (c1 >>> 8 & 0xFF) * j2 + (c2 >>> 8 & 0xFF) * k2 + (c3 >>> 8 & 0xFF) * l2 + l1) / k1 << 8 | ((c0 >>> 0 & 0xFF) * i2 + (c1 >>> 0 & 0xFF) * j2 + (c2 >>> 0 & 0xFF) * k2 + (c3 >>> 0 & 0xFF) * l2 + l1) / k1 << 0;
        return i22;
    }

    public static int blend4Simple(int c0, int c1, int c2, int c3) {
        int i2 = ((c0 >>> 24 & 0xFF) + (c1 >>> 24 & 0xFF) + (c2 >>> 24 & 0xFF) + (c3 >>> 24 & 0xFF) + 2) / 4 << 24 | ((c0 >>> 16 & 0xFF) + (c1 >>> 16 & 0xFF) + (c2 >>> 16 & 0xFF) + (c3 >>> 16 & 0xFF) + 2) / 4 << 16 | ((c0 >>> 8 & 0xFF) + (c1 >>> 8 & 0xFF) + (c2 >>> 8 & 0xFF) + (c3 >>> 8 & 0xFF) + 2) / 4 << 8 | ((c0 >>> 0 & 0xFF) + (c1 >>> 0 & 0xFF) + (c2 >>> 0 & 0xFF) + (c3 >>> 0 & 0xFF) + 2) / 4 << 0;
        return i2;
    }

    public static void genMipmapAlpha(int[] aint, int offset, int width, int height) {
        Math.min(width, height);
        int o2 = offset;
        int w2 = width;
        int h2 = height;
        int o1 = 0;
        int w1 = 0;
        int h1 = 0;
        int i2 = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int l1 = 0; l1 < h1; ++l1) {
                int i22 = o1 + l1 * w1;
                int j2 = o2 + l1 * 2 * w2;
                for (int k2 = 0; k2 < w1; ++k2) {
                    aint[i22 + k2] = ShadersTex.blend4Alpha(aint[j2 + k2 * 2], aint[j2 + k2 * 2 + 1], aint[j2 + w2 + k2 * 2], aint[j2 + w2 + k2 * 2 + 1]);
                }
            }
            ++i2;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (i2 > 0) {
            w2 = width >> --i2;
            h2 = height >> i2;
            int l2 = o2 = o1 - w2 * h2;
            for (int i3 = 0; i3 < h2; ++i3) {
                for (int j3 = 0; j3 < w2; ++j3) {
                    if (aint[l2] == 0) {
                        aint[l2] = aint[o1 + i3 / 2 * w1 + j3 / 2] & 0xFFFFFF;
                    }
                    ++l2;
                }
            }
            o1 = o2;
            w1 = w2;
        }
    }

    public static void genMipmapSimple(int[] aint, int offset, int width, int height) {
        Math.min(width, height);
        int o2 = offset;
        int w2 = width;
        int h2 = height;
        int o1 = 0;
        int w1 = 0;
        int h1 = 0;
        int i2 = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int l1 = 0; l1 < h1; ++l1) {
                int i22 = o1 + l1 * w1;
                int j2 = o2 + l1 * 2 * w2;
                for (int k2 = 0; k2 < w1; ++k2) {
                    aint[i22 + k2] = ShadersTex.blend4Simple(aint[j2 + k2 * 2], aint[j2 + k2 * 2 + 1], aint[j2 + w2 + k2 * 2], aint[j2 + w2 + k2 * 2 + 1]);
                }
            }
            ++i2;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (i2 > 0) {
            w2 = width >> --i2;
            h2 = height >> i2;
            int l2 = o2 = o1 - w2 * h2;
            for (int i3 = 0; i3 < h2; ++i3) {
                for (int j3 = 0; j3 < w2; ++j3) {
                    if (aint[l2] == 0) {
                        aint[l2] = aint[o1 + i3 / 2 * w1 + j3 / 2] & 0xFFFFFF;
                    }
                    ++l2;
                }
            }
            o1 = o2;
            w1 = w2;
        }
    }

    public static boolean isSemiTransparent(int[] aint, int width, int height) {
        int i2 = width * height;
        if (aint[0] >>> 24 == 255 && aint[i2 - 1] == 0) {
            return true;
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = aint[j2] >>> 24;
            if (k2 == 0 || k2 == 255) continue;
            return true;
        }
        return false;
    }

    public static void updateSubTex1(int[] src, int width, int height, int posX, int posY) {
        int i2 = 0;
        int j2 = width;
        int k2 = height;
        int l2 = posX;
        int i1 = posY;
        while (j2 > 0 && k2 > 0) {
            GL11.glCopyTexSubImage2D((int)3553, (int)i2, (int)l2, (int)i1, (int)0, (int)0, (int)j2, (int)k2);
            ++i2;
            j2 /= 2;
            k2 /= 2;
            l2 /= 2;
            i1 /= 2;
        }
    }

    public static void setupTexture(MultiTexID multiTex, int[] src, int width, int height, boolean linear, boolean clamp) {
        int i2 = linear ? 9729 : 9728;
        int j2 = clamp ? 33071 : 10497;
        int k2 = width * height;
        IntBuffer intbuffer = ShadersTex.getIntBuffer(k2);
        intbuffer.clear();
        intbuffer.put(src, 0, k2).position(0).limit(k2);
        bfl.i(multiTex.base);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)intbuffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)i2);
        GL11.glTexParameteri((int)3553, (int)10240, (int)i2);
        GL11.glTexParameteri((int)3553, (int)10242, (int)j2);
        GL11.glTexParameteri((int)3553, (int)10243, (int)j2);
        intbuffer.put(src, k2, k2).position(0).limit(k2);
        bfl.i(multiTex.norm);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)intbuffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)i2);
        GL11.glTexParameteri((int)3553, (int)10240, (int)i2);
        GL11.glTexParameteri((int)3553, (int)10242, (int)j2);
        GL11.glTexParameteri((int)3553, (int)10243, (int)j2);
        intbuffer.put(src, k2 * 2, k2).position(0).limit(k2);
        bfl.i(multiTex.spec);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)intbuffer);
        GL11.glTexParameteri((int)3553, (int)10241, (int)i2);
        GL11.glTexParameteri((int)3553, (int)10240, (int)i2);
        GL11.glTexParameteri((int)3553, (int)10242, (int)j2);
        GL11.glTexParameteri((int)3553, (int)10243, (int)j2);
        bfl.i(multiTex.base);
    }

    public static void updateSubImage(MultiTexID multiTex, int[] src, int width, int height, int posX, int posY, boolean linear, boolean clamp) {
        int i2 = width * height;
        IntBuffer intbuffer = ShadersTex.getIntBuffer(i2);
        intbuffer.clear();
        intbuffer.put(src, 0, i2);
        intbuffer.position(0).limit(i2);
        bfl.i(multiTex.base);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intbuffer);
        if (src.length == i2 * 3) {
            intbuffer.clear();
            intbuffer.put(src, i2, i2).position(0);
            intbuffer.position(0).limit(i2);
        }
        bfl.i(multiTex.norm);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intbuffer);
        if (src.length == i2 * 3) {
            intbuffer.clear();
            intbuffer.put(src, i2 * 2, i2);
            intbuffer.position(0).limit(i2);
        }
        bfl.i(multiTex.spec);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intbuffer);
        bfl.g(33984);
    }

    public static jy getNSMapLocation(jy location, String mapName) {
        if (location == null) {
            return null;
        }
        String s2 = location.a();
        String[] astring = s2.split(".png");
        String s1 = astring[0];
        return new jy(location.b(), s1 + "_" + mapName + ".png");
    }

    public static void loadNSMap(bni manager, jy location, int width, int height, int[] aint) {
        if (Shaders.configNormalMap) {
            ShadersTex.loadNSMap1(manager, ShadersTex.getNSMapLocation(location, "n"), width, height, aint, width * height, -8421377);
        }
        if (Shaders.configSpecularMap) {
            ShadersTex.loadNSMap1(manager, ShadersTex.getNSMapLocation(location, "s"), width, height, aint, width * height * 2, 0);
        }
    }

    private static void loadNSMap1(bni manager, jy location, int width, int height, int[] aint, int offset, int defaultColor) {
        if (!ShadersTex.loadNSMapFile(manager, location, width, height, aint, offset)) {
            Arrays.fill(aint, offset, offset + width * height, defaultColor);
        }
    }

    private static boolean loadNSMapFile(bni manager, jy location, int width, int height, int[] aint, int offset) {
        if (location == null) {
            return false;
        }
        try {
            bnh iresource = manager.a(location);
            BufferedImage bufferedimage = ImageIO.read(iresource.b());
            if (bufferedimage == null) {
                return false;
            }
            if (bufferedimage.getWidth() == width && bufferedimage.getHeight() == height) {
                bufferedimage.getRGB(0, 0, width, height, aint, offset, width);
                return true;
            }
            return false;
        }
        catch (IOException var8) {
            return false;
        }
    }

    public static int loadSimpleTexture(int textureID, BufferedImage bufferedimage, boolean linear, boolean clamp, bni resourceManager, jy location, MultiTexID multiTex) {
        int i2 = bufferedimage.getWidth();
        int j2 = bufferedimage.getHeight();
        int k2 = i2 * j2;
        int[] aint = ShadersTex.getIntArray(k2 * 3);
        bufferedimage.getRGB(0, 0, i2, j2, aint, 0, i2);
        ShadersTex.loadNSMap(resourceManager, location, i2, j2, aint);
        ShadersTex.setupTexture(multiTex, aint, i2, j2, linear, clamp);
        return textureID;
    }

    public static void mergeImage(int[] aint, int dstoff, int srcoff, int size) {
    }

    public static int blendColor(int color1, int color2, int factor1) {
        int i2 = 255 - factor1;
        return ((color1 >>> 24 & 0xFF) * factor1 + (color2 >>> 24 & 0xFF) * i2) / 255 << 24 | ((color1 >>> 16 & 0xFF) * factor1 + (color2 >>> 16 & 0xFF) * i2) / 255 << 16 | ((color1 >>> 8 & 0xFF) * factor1 + (color2 >>> 8 & 0xFF) * i2) / 255 << 8 | ((color1 >>> 0 & 0xFF) * factor1 + (color2 >>> 0 & 0xFF) * i2) / 255 << 0;
    }

    public static void loadLayeredTexture(bmd tex, bni manager, List<String> list) {
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        int[] aint = null;
        for (String s2 : list) {
            if (s2 == null) continue;
            try {
                jy resourcelocation = new jy(s2);
                InputStream inputstream = manager.a(resourcelocation).b();
                BufferedImage bufferedimage = ImageIO.read(inputstream);
                if (k2 == 0) {
                    i2 = bufferedimage.getWidth();
                    j2 = bufferedimage.getHeight();
                    k2 = i2 * j2;
                    aint = ShadersTex.createAIntImage(k2, 0);
                }
                int[] aint1 = ShadersTex.getIntArray(k2 * 3);
                bufferedimage.getRGB(0, 0, i2, j2, aint1, 0, i2);
                ShadersTex.loadNSMap(manager, resourcelocation, i2, j2, aint1);
                for (int l2 = 0; l2 < k2; ++l2) {
                    int i1 = aint1[l2] >>> 24 & 0xFF;
                    aint[k2 * 0 + l2] = ShadersTex.blendColor(aint1[k2 * 0 + l2], aint[k2 * 0 + l2], i1);
                    aint[k2 * 1 + l2] = ShadersTex.blendColor(aint1[k2 * 1 + l2], aint[k2 * 1 + l2], i1);
                    aint[k2 * 2 + l2] = ShadersTex.blendColor(aint1[k2 * 2 + l2], aint[k2 * 2 + l2], i1);
                }
            }
            catch (IOException ioexception) {
                ioexception.printStackTrace();
            }
        }
        ShadersTex.setupTexture(tex.getMultiTexID(), aint, i2, j2, false, false);
    }

    public static void updateTextureMinMagFilter() {
        bmj texturemanager = ave.A().P();
        bmk itextureobject = texturemanager.b(bmh.g);
        if (itextureobject != null) {
            MultiTexID multitexid = itextureobject.getMultiTexID();
            bfl.i(multitexid.base);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilB]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilB]);
            bfl.i(multitexid.norm);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilN]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilN]);
            bfl.i(multitexid.spec);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilS]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilS]);
            bfl.i(0);
        }
    }

    public static int[][] getFrameTexData(int[][] src, int width, int height, int frameIndex) {
        int i2 = src.length;
        int[][] aint = new int[i2][];
        for (int j2 = 0; j2 < i2; ++j2) {
            int[] aint1 = src[j2];
            if (aint1 == null) continue;
            int k2 = (width >> j2) * (height >> j2);
            int[] aint2 = new int[k2 * 3];
            aint[j2] = aint2;
            int l2 = aint1.length / 3;
            int i1 = k2 * frameIndex;
            int j1 = 0;
            System.arraycopy(aint1, i1, aint2, j1, k2);
            System.arraycopy(aint1, i1 += l2, aint2, j1 += k2, k2);
            System.arraycopy(aint1, i1 += l2, aint2, j1 += k2, k2);
        }
        return aint;
    }

    public static int[][] prepareAF(bmi tas, int[][] src, int width, int height) {
        boolean flag = true;
        return src;
    }

    public static void fixTransparentColor(bmi tas, int[] aint) {
    }
}

