/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.shaders;

import java.util.Iterator;
import net.optifine.BlockPosM;
import net.optifine.shaders.IteratorAxis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterator3d
implements Iterator<cj> {
    private IteratorAxis iteratorAxis;
    private BlockPosM blockPos = new BlockPosM(0, 0, 0);
    private int axis = 0;
    private int kX;
    private int kY;
    private int kZ;
    private static final int AXIS_X = 0;
    private static final int AXIS_Y = 1;
    private static final int AXIS_Z = 2;

    public Iterator3d(cj posStart, cj posEnd, int width, int height) {
        boolean flag = posStart.n() > posEnd.n();
        boolean flag1 = posStart.o() > posEnd.o();
        boolean flag2 = posStart.p() > posEnd.p();
        posStart = this.reverseCoord(posStart, flag, flag1, flag2);
        posEnd = this.reverseCoord(posEnd, flag, flag1, flag2);
        this.kX = flag ? -1 : 1;
        this.kY = flag1 ? -1 : 1;
        this.kZ = flag2 ? -1 : 1;
        aui vec3 = new aui(posEnd.n() - posStart.n(), posEnd.o() - posStart.o(), posEnd.p() - posStart.p());
        aui vec31 = vec3.a();
        aui vec32 = new aui(1.0, 0.0, 0.0);
        double d0 = vec31.b(vec32);
        double d1 = Math.abs(d0);
        aui vec33 = new aui(0.0, 1.0, 0.0);
        double d2 = vec31.b(vec33);
        double d3 = Math.abs(d2);
        aui vec34 = new aui(0.0, 0.0, 1.0);
        double d4 = vec31.b(vec34);
        double d5 = Math.abs(d4);
        if (d5 >= d3 && d5 >= d1) {
            this.axis = 2;
            cj blockpos3 = new cj(posStart.p(), posStart.o() - width, posStart.n() - height);
            cj blockpos5 = new cj(posEnd.p(), posStart.o() + width + 1, posStart.n() + height + 1);
            int k2 = posEnd.p() - posStart.p();
            double d9 = (double)(posEnd.o() - posStart.o()) / (1.0 * (double)k2);
            double d11 = (double)(posEnd.n() - posStart.n()) / (1.0 * (double)k2);
            this.iteratorAxis = new IteratorAxis(blockpos3, blockpos5, d9, d11);
        } else if (d3 >= d1 && d3 >= d5) {
            this.axis = 1;
            cj blockpos2 = new cj(posStart.o(), posStart.n() - width, posStart.p() - height);
            cj blockpos4 = new cj(posEnd.o(), posStart.n() + width + 1, posStart.p() + height + 1);
            int j2 = posEnd.o() - posStart.o();
            double d8 = (double)(posEnd.n() - posStart.n()) / (1.0 * (double)j2);
            double d10 = (double)(posEnd.p() - posStart.p()) / (1.0 * (double)j2);
            this.iteratorAxis = new IteratorAxis(blockpos2, blockpos4, d8, d10);
        } else {
            this.axis = 0;
            cj blockpos = new cj(posStart.n(), posStart.o() - width, posStart.p() - height);
            cj blockpos1 = new cj(posEnd.n(), posStart.o() + width + 1, posStart.p() + height + 1);
            int i2 = posEnd.n() - posStart.n();
            double d6 = (double)(posEnd.o() - posStart.o()) / (1.0 * (double)i2);
            double d7 = (double)(posEnd.p() - posStart.p()) / (1.0 * (double)i2);
            this.iteratorAxis = new IteratorAxis(blockpos, blockpos1, d6, d7);
        }
    }

    private cj reverseCoord(cj pos, boolean revX, boolean revY, boolean revZ) {
        if (revX) {
            pos = new cj(-pos.n(), pos.o(), pos.p());
        }
        if (revY) {
            pos = new cj(pos.n(), -pos.o(), pos.p());
        }
        if (revZ) {
            pos = new cj(pos.n(), pos.o(), -pos.p());
        }
        return pos;
    }

    @Override
    public boolean hasNext() {
        return this.iteratorAxis.hasNext();
    }

    @Override
    public cj next() {
        cj blockpos = this.iteratorAxis.next();
        switch (this.axis) {
            case 0: {
                this.blockPos.setXyz(blockpos.n() * this.kX, blockpos.o() * this.kY, blockpos.p() * this.kZ);
                return this.blockPos;
            }
            case 1: {
                this.blockPos.setXyz(blockpos.o() * this.kX, blockpos.n() * this.kY, blockpos.p() * this.kZ);
                return this.blockPos;
            }
            case 2: {
                this.blockPos.setXyz(blockpos.p() * this.kX, blockpos.o() * this.kY, blockpos.n() * this.kZ);
                return this.blockPos;
            }
        }
        this.blockPos.setXyz(blockpos.n() * this.kX, blockpos.o() * this.kY, blockpos.p() * this.kZ);
        return this.blockPos;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not supported");
    }

    public static void main(String[] args) {
        cj blockpos = new cj(10, 20, 30);
        cj blockpos1 = new cj(30, 40, 20);
        Iterator3d iterator3d = new Iterator3d(blockpos, blockpos1, 1, 1);
        while (iterator3d.hasNext()) {
            cj blockpos2 = iterator3d.next();
            System.out.println("" + blockpos2);
        }
    }
}

