/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.expr.ExpressionType;
import net.optifine.expr.IExpressionFloat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum RenderEntityParameterFloat implements IExpressionFloat
{
    LIMB_SWING("limb_swing"),
    LIMB_SWING_SPEED("limb_speed"),
    AGE("age"),
    HEAD_YAW("head_yaw"),
    HEAD_PITCH("head_pitch"),
    SCALE("scale"),
    HEALTH("health"),
    HURT_TIME("hurt_time"),
    IDLE_TIME("idle_time"),
    MAX_HEALTH("max_health"),
    MOVE_FORWARD("move_forward"),
    MOVE_STRAFING("move_strafing"),
    PARTIAL_TICKS("partial_ticks"),
    POS_X("pos_x"),
    POS_Y("pos_y"),
    POS_Z("pos_z"),
    REVENGE_TIME("revenge_time"),
    SWING_PROGRESS("swing_progress");

    private String name;
    private biu renderManager;
    private static final RenderEntityParameterFloat[] VALUES;

    private RenderEntityParameterFloat(String name) {
        this.name = name;
        this.renderManager = ave.A().af();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.FLOAT;
    }

    @Override
    public float eval() {
        biv render = this.renderManager.renderRender;
        if (render == null) {
            return 0.0f;
        }
        if (render instanceof bjl) {
            bjl rendererlivingentity = (bjl)render;
            switch (this) {
                case LIMB_SWING: {
                    return rendererlivingentity.renderLimbSwing;
                }
                case LIMB_SWING_SPEED: {
                    return rendererlivingentity.renderLimbSwingAmount;
                }
                case AGE: {
                    return rendererlivingentity.renderAgeInTicks;
                }
                case HEAD_YAW: {
                    return rendererlivingentity.renderHeadYaw;
                }
                case HEAD_PITCH: {
                    return rendererlivingentity.renderHeadPitch;
                }
                case SCALE: {
                    return rendererlivingentity.renderScaleFactor;
                }
            }
            pr entitylivingbase = rendererlivingentity.renderEntity;
            if (entitylivingbase == null) {
                return 0.0f;
            }
            switch (this) {
                case HEALTH: {
                    return entitylivingbase.bn();
                }
                case HURT_TIME: {
                    return entitylivingbase.au;
                }
                case IDLE_TIME: {
                    return entitylivingbase.bh();
                }
                case MAX_HEALTH: {
                    return entitylivingbase.bu();
                }
                case MOVE_FORWARD: {
                    return entitylivingbase.ba;
                }
                case MOVE_STRAFING: {
                    return entitylivingbase.aZ;
                }
                case POS_X: {
                    return (float)entitylivingbase.s;
                }
                case POS_Y: {
                    return (float)entitylivingbase.t;
                }
                case POS_Z: {
                    return (float)entitylivingbase.u;
                }
                case REVENGE_TIME: {
                    return entitylivingbase.be();
                }
                case SWING_PROGRESS: {
                    return entitylivingbase.l(rendererlivingentity.renderPartialTicks);
                }
            }
        }
        return 0.0f;
    }

    public static RenderEntityParameterFloat parse(String str) {
        if (str == null) {
            return null;
        }
        for (int i2 = 0; i2 < VALUES.length; ++i2) {
            RenderEntityParameterFloat renderentityparameterfloat = VALUES[i2];
            if (!renderentityparameterfloat.getName().equals(str)) continue;
            return renderentityparameterfloat;
        }
        return null;
    }

    static {
        VALUES = RenderEntityParameterFloat.values();
    }
}

