/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.util.regex.Pattern;
import net.minecraft.util.JavaBackportUtil;
import net.optifine.util.StrUtils;
import org.apache.commons.lang3.StringEscapeUtils;

public class NbtTagValue {
    private String[] parents = null;
    private String name = null;
    private boolean negative = false;
    private int type = 0;
    private String value = null;
    private int valueFormat = 0;
    private static final int TYPE_TEXT = 0;
    private static final int TYPE_PATTERN = 1;
    private static final int TYPE_IPATTERN = 2;
    private static final int TYPE_REGEX = 3;
    private static final int TYPE_IREGEX = 4;
    private static final String PREFIX_PATTERN = "pattern:";
    private static final String PREFIX_IPATTERN = "ipattern:";
    private static final String PREFIX_REGEX = "regex:";
    private static final String PREFIX_IREGEX = "iregex:";
    private static final int FORMAT_DEFAULT = 0;
    private static final int FORMAT_HEX_COLOR = 1;
    private static final String PREFIX_HEX_COLOR = "#";
    private static final Pattern PATTERN_HEX_COLOR = Pattern.compile("^#[0-9a-f]{6}+$");

    public NbtTagValue(String tag, String value) {
        String[] astring = Config.tokenize(tag, ".");
        this.parents = JavaBackportUtil.arrayCopyOfRange(astring, 0, astring.length - 1);
        this.name = astring[astring.length - 1];
        if (value.startsWith("!")) {
            this.negative = true;
            value = value.substring(1);
        }
        if (value.startsWith(PREFIX_PATTERN)) {
            this.type = 1;
            value = value.substring(PREFIX_PATTERN.length());
        } else if (value.startsWith(PREFIX_IPATTERN)) {
            this.type = 2;
            value = value.substring(PREFIX_IPATTERN.length()).toLowerCase();
        } else if (value.startsWith(PREFIX_REGEX)) {
            this.type = 3;
            value = value.substring(PREFIX_REGEX.length());
        } else if (value.startsWith(PREFIX_IREGEX)) {
            this.type = 4;
            value = value.substring(PREFIX_IREGEX.length()).toLowerCase();
        } else {
            this.type = 0;
        }
        value = StringEscapeUtils.unescapeJava((String)value);
        if (this.type == 0 && PATTERN_HEX_COLOR.matcher(value).matches()) {
            this.valueFormat = 1;
        }
        this.value = value;
    }

    public boolean matches(dn nbt) {
        return this.negative ? !this.matchesCompound(nbt) : this.matchesCompound(nbt);
    }

    public boolean matchesCompound(dn nbt) {
        if (nbt == null) {
            return false;
        }
        eb nbtbase = nbt;
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String s2 = this.parents[i2];
            if ((nbtbase = NbtTagValue.getChildTag(nbtbase, s2)) != null) continue;
            return false;
        }
        if (this.name.equals("*")) {
            return this.matchesAnyChild(nbtbase);
        }
        if ((nbtbase = NbtTagValue.getChildTag(nbtbase, this.name)) == null) {
            return false;
        }
        return this.matchesBase(nbtbase);
    }

    private boolean matchesAnyChild(eb tagBase) {
        if (tagBase instanceof dn) {
            dn nbttagcompound = (dn)tagBase;
            for (String s2 : nbttagcompound.c()) {
                eb nbtbase = nbttagcompound.a(s2);
                if (!this.matchesBase(nbtbase)) continue;
                return true;
            }
        }
        if (tagBase instanceof du) {
            du nbttaglist = (du)tagBase;
            int i2 = nbttaglist.c();
            for (int j2 = 0; j2 < i2; ++j2) {
                eb nbtbase1 = nbttaglist.g(j2);
                if (!this.matchesBase(nbtbase1)) continue;
                return true;
            }
        }
        return false;
    }

    private static eb getChildTag(eb tagBase, String tag) {
        if (tagBase instanceof dn) {
            dn nbttagcompound = (dn)tagBase;
            return nbttagcompound.a(tag);
        }
        if (tagBase instanceof du) {
            du nbttaglist = (du)tagBase;
            if (tag.equals("count")) {
                return new dt(nbttaglist.c());
            }
            int i2 = Config.parseInt(tag, -1);
            return i2 >= 0 && i2 < nbttaglist.c() ? nbttaglist.g(i2) : null;
        }
        return null;
    }

    public boolean matchesBase(eb nbtBase) {
        if (nbtBase == null) {
            return false;
        }
        String s2 = NbtTagValue.getNbtString(nbtBase, this.valueFormat);
        return this.matchesValue(s2);
    }

    public boolean matchesValue(String nbtValue) {
        if (nbtValue == null) {
            return false;
        }
        switch (this.type) {
            case 0: {
                return nbtValue.equals(this.value);
            }
            case 1: {
                return this.matchesPattern(nbtValue, this.value);
            }
            case 2: {
                return this.matchesPattern(nbtValue.toLowerCase(), this.value);
            }
            case 3: {
                return this.matchesRegex(nbtValue, this.value);
            }
            case 4: {
                return this.matchesRegex(nbtValue.toLowerCase(), this.value);
            }
        }
        throw new IllegalArgumentException("Unknown NbtTagValue type: " + this.type);
    }

    private boolean matchesPattern(String str, String pattern) {
        return StrUtils.equalsMask(str, pattern, '*', '?');
    }

    private boolean matchesRegex(String str, String regex) {
        return str.matches(regex);
    }

    private static String getNbtString(eb nbtBase, int format) {
        if (nbtBase == null) {
            return null;
        }
        if (nbtBase instanceof ea) {
            ea nbttagstring = (ea)nbtBase;
            return nbttagstring.a_();
        }
        if (nbtBase instanceof dt) {
            dt nbttagint = (dt)nbtBase;
            return format == 1 ? PREFIX_HEX_COLOR + StrUtils.fillLeft(Integer.toHexString(nbttagint.d()), 6, '0') : Integer.toString(nbttagint.d());
        }
        if (nbtBase instanceof dm) {
            dm nbttagbyte = (dm)nbtBase;
            return Byte.toString(nbttagbyte.f());
        }
        if (nbtBase instanceof dz) {
            dz nbttagshort = (dz)nbtBase;
            return Short.toString(nbttagshort.e());
        }
        if (nbtBase instanceof dv) {
            dv nbttaglong = (dv)nbtBase;
            return Long.toString(nbttaglong.c());
        }
        if (nbtBase instanceof dr) {
            dr nbttagfloat = (dr)nbtBase;
            return Float.toString(nbttagfloat.h());
        }
        if (nbtBase instanceof dp) {
            dp nbttagdouble = (dp)nbtBase;
            return Double.toString(nbttagdouble.g());
        }
        return nbtBase.toString();
    }

    public String toString() {
        StringBuffer stringbuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.parents.length; ++i2) {
            String s2 = this.parents[i2];
            if (i2 > 0) {
                stringbuffer.append(".");
            }
            stringbuffer.append(s2);
        }
        if (stringbuffer.length() > 0) {
            stringbuffer.append(".");
        }
        stringbuffer.append(this.name);
        stringbuffer.append(" = ");
        stringbuffer.append(this.value);
        return stringbuffer.toString();
    }
}

