/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.optifine.IRandomEntity;
import net.optifine.RandomEntity;
import net.optifine.RandomEntityProperties;
import net.optifine.RandomTileEntity;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorRaw;
import net.optifine.util.IntegratedServerUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

public class RandomEntities {
    private static Map<String, RandomEntityProperties> mapProperties = new HashMap<String, RandomEntityProperties>();
    private static boolean active = false;
    private static bfr renderGlobal;
    private static RandomEntity randomEntity;
    private static bhc tileEntityRendererDispatcher;
    private static RandomTileEntity randomTileEntity;
    private static boolean working;
    public static final String SUFFIX_PNG = ".png";
    public static final String SUFFIX_PROPERTIES = ".properties";
    public static final String PREFIX_TEXTURES_ENTITY = "textures/entity/";
    public static final String PREFIX_TEXTURES_PAINTING = "textures/painting/";
    public static final String PREFIX_TEXTURES = "textures/";
    public static final String PREFIX_OPTIFINE_RANDOM = "optifine/random/";
    public static final String PREFIX_MCPATCHER_MOB = "mcpatcher/mob/";
    private static final String[] DEPENDANT_SUFFIXES;
    private static final String PREFIX_DYNAMIC_TEXTURE_HORSE = "horse/";
    private static final String[] HORSE_TEXTURES;
    private static final String[] HORSE_TEXTURES_ABBR;

    public static void entityLoaded(pk entity, adm world) {
        if (world != null) {
            pz datawatcher = entity.H();
            datawatcher.spawnPosition = entity.c();
            datawatcher.spawnBiome = world.b(datawatcher.spawnPosition);
            UUID uuid = entity.aK();
            if (entity instanceof wi) {
                RandomEntities.updateEntityVillager(uuid, (wi)entity);
            }
        }
    }

    public static void entityUnloaded(pk entity, adm world) {
    }

    private static void updateEntityVillager(UUID uuid, wi ev2) {
        pk entity = IntegratedServerUtils.getEntity(uuid);
        if (entity instanceof wi) {
            wi entityvillager = (wi)entity;
            int i2 = entityvillager.cl();
            ev2.r(i2);
            int j2 = Reflector.getFieldValueInt(entityvillager, Reflector.EntityVillager_careerId, 0);
            Reflector.setFieldValueInt(ev2, Reflector.EntityVillager_careerId, j2);
            int k2 = Reflector.getFieldValueInt(entityvillager, Reflector.EntityVillager_careerLevel, 0);
            Reflector.setFieldValueInt(ev2, Reflector.EntityVillager_careerLevel, k2);
        }
    }

    public static void worldChanged(adm oldWorld, adm newWorld) {
        if (newWorld != null) {
            List<pk> list = newWorld.E();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                pk entity = list.get(i2);
                RandomEntities.entityLoaded(entity, newWorld);
            }
        }
        randomEntity.setEntity(null);
        randomTileEntity.setTileEntity(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static jy getTextureLocation(jy loc) {
        jy name;
        if (!active) {
            return loc;
        }
        if (working) {
            return loc;
        }
        try {
            working = true;
            IRandomEntity irandomentity = RandomEntities.getRandomEntityRendered();
            if (irandomentity != null) {
                jy resourcelocation1;
                String s2 = loc.a();
                if (s2.startsWith(PREFIX_DYNAMIC_TEXTURE_HORSE)) {
                    s2 = RandomEntities.getHorseTexturePath(s2, PREFIX_DYNAMIC_TEXTURE_HORSE.length());
                }
                if (!s2.startsWith(PREFIX_TEXTURES_ENTITY) && !s2.startsWith(PREFIX_TEXTURES_PAINTING)) {
                    jy resourcelocation2;
                    jy jy2 = resourcelocation2 = loc;
                    return jy2;
                }
                RandomEntityProperties randomentityproperties = mapProperties.get(s2);
                if (randomentityproperties == null) {
                    jy resourcelocation3;
                    jy jy3 = resourcelocation3 = loc;
                    return jy3;
                }
                jy jy4 = resourcelocation1 = randomentityproperties.getTextureLocation(loc, irandomentity);
                return jy4;
            }
            name = loc;
        }
        finally {
            working = false;
        }
        return name;
    }

    private static String getHorseTexturePath(String path, int pos) {
        if (HORSE_TEXTURES != null && HORSE_TEXTURES_ABBR != null) {
            for (int i2 = 0; i2 < HORSE_TEXTURES_ABBR.length; ++i2) {
                String s2 = HORSE_TEXTURES_ABBR[i2];
                if (!path.startsWith(s2, pos)) continue;
                return HORSE_TEXTURES[i2];
            }
            return path;
        }
        return path;
    }

    private static IRandomEntity getRandomEntityRendered() {
        akw tileentity;
        if (RandomEntities.renderGlobal.renderedEntity != null) {
            randomEntity.setEntity(RandomEntities.renderGlobal.renderedEntity);
            return randomEntity;
        }
        if (RandomEntities.tileEntityRendererDispatcher.tileEntityRendered != null && (tileentity = RandomEntities.tileEntityRendererDispatcher.tileEntityRendered).z() != null) {
            randomTileEntity.setTileEntity(tileentity);
            return randomTileEntity;
        }
        return null;
    }

    private static RandomEntityProperties makeProperties(jy loc, boolean mcpatcher) {
        RandomEntityProperties randomentityproperties;
        String s2 = loc.a();
        jy resourcelocation = RandomEntities.getLocationProperties(loc, mcpatcher);
        if (resourcelocation != null && (randomentityproperties = RandomEntities.parseProperties(resourcelocation, loc)) != null) {
            return randomentityproperties;
        }
        jy[] aresourcelocation = RandomEntities.getLocationsVariants(loc, mcpatcher);
        return aresourcelocation == null ? null : new RandomEntityProperties(s2, aresourcelocation);
    }

    private static RandomEntityProperties parseProperties(jy propLoc, jy resLoc) {
        try {
            String s2 = propLoc.a();
            RandomEntities.dbg(resLoc.a() + ", properties: " + s2);
            InputStream inputstream = Config.getResourceStream(propLoc);
            if (inputstream == null) {
                RandomEntities.warn("Properties not found: " + s2);
                return null;
            }
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            RandomEntityProperties randomentityproperties = new RandomEntityProperties(properties, s2, resLoc);
            return !randomentityproperties.isValid(s2) ? null : randomentityproperties;
        }
        catch (FileNotFoundException var6) {
            RandomEntities.warn("File not found: " + resLoc.a());
            return null;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
            return null;
        }
    }

    private static jy getLocationProperties(jy loc, boolean mcpatcher) {
        String s1;
        String s2;
        String s3;
        jy resourcelocation = RandomEntities.getLocationRandom(loc, mcpatcher);
        if (resourcelocation == null) {
            return null;
        }
        String s4 = resourcelocation.b();
        jy resourcelocation1 = new jy(s4, s3 = (s2 = StrUtils.removeSuffix(s1 = resourcelocation.a(), SUFFIX_PNG)) + SUFFIX_PROPERTIES);
        if (Config.hasResource(resourcelocation1)) {
            return resourcelocation1;
        }
        String s42 = RandomEntities.getParentTexturePath(s2);
        if (s42 == null) {
            return null;
        }
        jy resourcelocation2 = new jy(s4, s42 + SUFFIX_PROPERTIES);
        return Config.hasResource(resourcelocation2) ? resourcelocation2 : null;
    }

    protected static jy getLocationRandom(jy loc, boolean mcpatcher) {
        String s2 = loc.b();
        String s1 = loc.a();
        String s22 = PREFIX_TEXTURES;
        String s3 = PREFIX_OPTIFINE_RANDOM;
        if (mcpatcher) {
            s22 = PREFIX_TEXTURES_ENTITY;
            s3 = PREFIX_MCPATCHER_MOB;
        }
        if (!s1.startsWith(s22)) {
            return null;
        }
        String s4 = StrUtils.replacePrefix(s1, s22, s3);
        return new jy(s2, s4);
    }

    private static String getPathBase(String pathRandom) {
        return pathRandom.startsWith(PREFIX_OPTIFINE_RANDOM) ? StrUtils.replacePrefix(pathRandom, PREFIX_OPTIFINE_RANDOM, PREFIX_TEXTURES) : (pathRandom.startsWith(PREFIX_MCPATCHER_MOB) ? StrUtils.replacePrefix(pathRandom, PREFIX_MCPATCHER_MOB, PREFIX_TEXTURES_ENTITY) : null);
    }

    protected static jy getLocationIndexed(jy loc, int index) {
        if (loc == null) {
            return null;
        }
        String s2 = loc.a();
        int i2 = s2.lastIndexOf(46);
        if (i2 < 0) {
            return null;
        }
        String s1 = s2.substring(0, i2);
        String s22 = s2.substring(i2);
        String s3 = s1 + index + s22;
        jy resourcelocation = new jy(loc.b(), s3);
        return resourcelocation;
    }

    private static String getParentTexturePath(String path) {
        for (int i2 = 0; i2 < DEPENDANT_SUFFIXES.length; ++i2) {
            String s2 = DEPENDANT_SUFFIXES[i2];
            if (!path.endsWith(s2)) continue;
            String s1 = StrUtils.removeSuffix(path, s2);
            return s1;
        }
        return null;
    }

    private static jy[] getLocationsVariants(jy loc, boolean mcpatcher) {
        ArrayList<jy> list = new ArrayList<jy>();
        list.add(loc);
        jy resourcelocation = RandomEntities.getLocationRandom(loc, mcpatcher);
        if (resourcelocation == null) {
            return null;
        }
        for (int i2 = 1; i2 < list.size() + 10; ++i2) {
            int j2 = i2 + 1;
            jy resourcelocation1 = RandomEntities.getLocationIndexed(resourcelocation, j2);
            if (!Config.hasResource(resourcelocation1)) continue;
            list.add(resourcelocation1);
        }
        if (list.size() <= 1) {
            return null;
        }
        jy[] aresourcelocation = list.toArray(new jy[list.size()]);
        RandomEntities.dbg(loc.a() + ", variants: " + aresourcelocation.length);
        return aresourcelocation;
    }

    public static void update() {
        mapProperties.clear();
        active = false;
        if (Config.isRandomEntities()) {
            RandomEntities.initialize();
        }
    }

    private static void initialize() {
        renderGlobal = Config.getRenderGlobal();
        tileEntityRendererDispatcher = bhc.a;
        String[] astring = new String[]{PREFIX_OPTIFINE_RANDOM, PREFIX_MCPATCHER_MOB};
        String[] astring1 = new String[]{SUFFIX_PNG, SUFFIX_PROPERTIES};
        String[] astring2 = ResUtils.collectFiles(astring, astring1);
        HashSet<String> set = new HashSet<String>();
        for (int i2 = 0; i2 < astring2.length; ++i2) {
            RandomEntityProperties randomentityproperties;
            String s2 = astring2[i2];
            s2 = StrUtils.removeSuffix(s2, astring1);
            s2 = StrUtils.trimTrailing(s2, "0123456789");
            String s1 = RandomEntities.getPathBase(s2 = s2 + SUFFIX_PNG);
            if (set.contains(s1)) continue;
            set.add(s1);
            jy resourcelocation = new jy(s1);
            if (!Config.hasResource(resourcelocation) || (randomentityproperties = mapProperties.get(s1)) != null) continue;
            randomentityproperties = RandomEntities.makeProperties(resourcelocation, false);
            if (randomentityproperties == null) {
                randomentityproperties = RandomEntities.makeProperties(resourcelocation, true);
            }
            if (randomentityproperties == null) continue;
            mapProperties.put(s1, randomentityproperties);
        }
        active = !mapProperties.isEmpty();
    }

    public static void dbg(String str) {
        Config.dbg("RandomEntities: " + str);
    }

    public static void warn(String str) {
        Config.warn("RandomEntities: " + str);
    }

    static {
        randomEntity = new RandomEntity();
        randomTileEntity = new RandomTileEntity();
        working = false;
        DEPENDANT_SUFFIXES = new String[]{"_armor", "_eyes", "_exploding", "_shooting", "_fur", "_eyes", "_invulnerable", "_angry", "_tame", "_collar"};
        HORSE_TEXTURES = (String[])ReflectorRaw.getFieldValue(null, tp.class, String[].class, 2);
        HORSE_TEXTURES_ABBR = (String[])ReflectorRaw.getFieldValue(null, tp.class, String[].class, 3);
    }
}

