/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.CustomItemProperties;
import net.optifine.CustomItemsComparator;
import net.optifine.config.NbtTagValue;
import net.optifine.render.Blender;
import net.optifine.shaders.Shaders;
import net.optifine.shaders.ShadersRender;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomItems {
    private static CustomItemProperties[][] itemProperties = null;
    private static CustomItemProperties[][] enchantmentProperties = null;
    private static Map mapPotionIds = null;
    private static bgp itemModelGenerator = new bgp();
    private static boolean useGlint = true;
    private static boolean renderOffHand = false;
    public static final int MASK_POTION_SPLASH = 16384;
    public static final int MASK_POTION_NAME = 63;
    public static final int MASK_POTION_EXTENDED = 64;
    public static final String KEY_TEXTURE_OVERLAY = "texture.potion_overlay";
    public static final String KEY_TEXTURE_SPLASH = "texture.potion_bottle_splash";
    public static final String KEY_TEXTURE_DRINKABLE = "texture.potion_bottle_drinkable";
    public static final String DEFAULT_TEXTURE_OVERLAY = "items/potion_overlay";
    public static final String DEFAULT_TEXTURE_SPLASH = "items/potion_bottle_splash";
    public static final String DEFAULT_TEXTURE_DRINKABLE = "items/potion_bottle_drinkable";
    private static final int[][] EMPTY_INT2_ARRAY = new int[0][];
    private static final String TYPE_POTION_NORMAL = "normal";
    private static final String TYPE_POTION_SPLASH = "splash";
    private static final String TYPE_POTION_LINGER = "linger";

    public static void update() {
        itemProperties = null;
        enchantmentProperties = null;
        useGlint = true;
        if (Config.isCustomItems()) {
            CustomItems.readCitProperties("mcpatcher/cit.properties");
            bnk[] airesourcepack = Config.getResourcePacks();
            for (int i2 = airesourcepack.length - 1; i2 >= 0; --i2) {
                bnk iresourcepack = airesourcepack[i2];
                CustomItems.update(iresourcepack);
            }
            CustomItems.update(Config.getDefaultResourcePack());
            if (itemProperties.length <= 0) {
                itemProperties = null;
            }
            if (enchantmentProperties.length <= 0) {
                enchantmentProperties = null;
            }
        }
    }

    private static void readCitProperties(String fileName) {
        try {
            jy resourcelocation = new jy(fileName);
            InputStream inputstream = Config.getResourceStream(resourcelocation);
            if (inputstream == null) {
                return;
            }
            Config.dbg("CustomItems: Loading " + fileName);
            PropertiesOrdered properties = new PropertiesOrdered();
            properties.load(inputstream);
            inputstream.close();
            useGlint = Config.parseBoolean(properties.getProperty("useGlint"), true);
        }
        catch (FileNotFoundException var4) {
            return;
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private static void update(bnk rp2) {
        Object[] astring = ResUtils.collectFiles(rp2, "mcpatcher/cit/", ".properties", (String[])null);
        Map map = CustomItems.makeAutoImageProperties(rp2);
        if (map.size() > 0) {
            Set set = map.keySet();
            Object[] astring1 = set.toArray(new String[set.size()]);
            astring = (String[])Config.addObjectsToArray(astring, astring1);
        }
        Arrays.sort(astring);
        List list = CustomItems.makePropertyList(itemProperties);
        List list1 = CustomItems.makePropertyList(enchantmentProperties);
        for (int i2 = 0; i2 < astring.length; ++i2) {
            Object s2 = astring[i2];
            Config.dbg("CustomItems: " + (String)s2);
            try {
                CustomItemProperties customitemproperties = null;
                if (map.containsKey(s2)) {
                    customitemproperties = (CustomItemProperties)map.get(s2);
                }
                if (customitemproperties == null) {
                    jy resourcelocation = new jy((String)s2);
                    InputStream inputstream = rp2.a(resourcelocation);
                    if (inputstream == null) {
                        Config.warn("CustomItems file not found: " + (String)s2);
                        continue;
                    }
                    PropertiesOrdered properties = new PropertiesOrdered();
                    properties.load(inputstream);
                    inputstream.close();
                    customitemproperties = new CustomItemProperties(properties, (String)s2);
                }
                if (!customitemproperties.isValid((String)s2)) continue;
                CustomItems.addToItemList(customitemproperties, list);
                CustomItems.addToEnchantmentList(customitemproperties, list1);
                continue;
            }
            catch (FileNotFoundException var11) {
                Config.warn("CustomItems file not found: " + (String)s2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        itemProperties = CustomItems.propertyListToArray(list);
        enchantmentProperties = CustomItems.propertyListToArray(list1);
        Comparator comparator = CustomItems.getPropertiesComparator();
        for (int j2 = 0; j2 < itemProperties.length; ++j2) {
            CustomItemProperties[] acustomitemproperties = itemProperties[j2];
            if (acustomitemproperties == null) continue;
            Arrays.sort(acustomitemproperties, comparator);
        }
        for (int k2 = 0; k2 < enchantmentProperties.length; ++k2) {
            CustomItemProperties[] acustomitemproperties1 = enchantmentProperties[k2];
            if (acustomitemproperties1 == null) continue;
            Arrays.sort(acustomitemproperties1, comparator);
        }
    }

    private static Comparator getPropertiesComparator() {
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                CustomItemProperties customitemproperties = (CustomItemProperties)o1;
                CustomItemProperties customitemproperties1 = (CustomItemProperties)o2;
                return customitemproperties.layer != customitemproperties1.layer ? customitemproperties.layer - customitemproperties1.layer : (customitemproperties.weight != customitemproperties1.weight ? customitemproperties1.weight - customitemproperties.weight : (!customitemproperties.basePath.equals(customitemproperties1.basePath) ? customitemproperties.basePath.compareTo(customitemproperties1.basePath) : customitemproperties.name.compareTo(customitemproperties1.name)));
            }
        };
        return comparator;
    }

    public static void updateIcons(bmh textureMap) {
        for (CustomItemProperties customitemproperties : CustomItems.getAllProperties()) {
            customitemproperties.updateIcons(textureMap);
        }
    }

    public static void loadModels(bot modelBakery) {
        for (CustomItemProperties customitemproperties : CustomItems.getAllProperties()) {
            customitemproperties.loadModels(modelBakery);
        }
    }

    public static void updateModels() {
        for (CustomItemProperties customitemproperties : CustomItems.getAllProperties()) {
            if (customitemproperties.type != 1) continue;
            bmh texturemap = ave.A().T();
            customitemproperties.updateModelTexture(texturemap, itemModelGenerator);
            customitemproperties.updateModelsFull();
        }
    }

    private static List<CustomItemProperties> getAllProperties() {
        ArrayList<CustomItemProperties> list = new ArrayList<CustomItemProperties>();
        CustomItems.addAll(itemProperties, list);
        CustomItems.addAll(enchantmentProperties, list);
        return list;
    }

    private static void addAll(CustomItemProperties[][] cipsArr, List<CustomItemProperties> list) {
        if (cipsArr != null) {
            for (int i2 = 0; i2 < cipsArr.length; ++i2) {
                CustomItemProperties[] acustomitemproperties = cipsArr[i2];
                if (acustomitemproperties == null) continue;
                for (int j2 = 0; j2 < acustomitemproperties.length; ++j2) {
                    CustomItemProperties customitemproperties = acustomitemproperties[j2];
                    if (customitemproperties == null) continue;
                    list.add(customitemproperties);
                }
            }
        }
    }

    private static Map makeAutoImageProperties(bnk rp2) {
        HashMap map = new HashMap();
        map.putAll(CustomItems.makePotionImageProperties(rp2, TYPE_POTION_NORMAL, zw.b(zy.bz)));
        map.putAll(CustomItems.makePotionImageProperties(rp2, TYPE_POTION_SPLASH, zw.b(zy.bz)));
        map.putAll(CustomItems.makePotionImageProperties(rp2, TYPE_POTION_LINGER, zw.b(zy.bz)));
        return map;
    }

    private static Map makePotionImageProperties(bnk rp2, String type, int itemId) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        String s2 = type + "/";
        String[] astring = new String[]{"mcpatcher/cit/potion/" + s2, "mcpatcher/cit/Potion/" + s2};
        String[] astring1 = new String[]{".png"};
        String[] astring2 = ResUtils.collectFiles(rp2, astring, astring1);
        for (int i2 = 0; i2 < astring2.length; ++i2) {
            String s1 = astring2[i2];
            String name = StrUtils.removePrefixSuffix(s1, astring, astring1);
            Properties properties = CustomItems.makePotionProperties(name, type, itemId, s1);
            if (properties == null) continue;
            String s3 = StrUtils.removeSuffix(s1, astring1) + ".properties";
            CustomItemProperties customitemproperties = new CustomItemProperties(properties, s3);
            map.put(s3, customitemproperties);
        }
        return map;
    }

    private static Properties makePotionProperties(String name, String type, int itemId, String path) {
        if (StrUtils.endsWith(name, new String[]{"_n", "_s"})) {
            return null;
        }
        if (name.equals("empty") && type.equals(TYPE_POTION_NORMAL)) {
            itemId = zw.b(zy.bA);
            PropertiesOrdered properties = new PropertiesOrdered();
            ((Properties)properties).put("type", "item");
            ((Properties)properties).put("items", "" + itemId);
            return properties;
        }
        int[] aint = (int[])CustomItems.getMapPotionIds().get(name);
        if (aint == null) {
            Config.warn("Potion not found for image: " + path);
            return null;
        }
        StringBuffer stringbuffer = new StringBuffer();
        for (int i2 = 0; i2 < aint.length; ++i2) {
            int j2 = aint[i2];
            if (type.equals(TYPE_POTION_SPLASH)) {
                j2 |= 0x4000;
            }
            if (i2 > 0) {
                stringbuffer.append(" ");
            }
            stringbuffer.append(j2);
        }
        int k2 = 16447;
        if (name.equals("water") || name.equals("mundane")) {
            k2 |= 0x40;
        }
        PropertiesOrdered properties1 = new PropertiesOrdered();
        ((Properties)properties1).put("type", "item");
        ((Properties)properties1).put("items", "" + itemId);
        ((Properties)properties1).put("damage", "" + stringbuffer.toString());
        ((Properties)properties1).put("damageMask", "" + k2);
        if (type.equals(TYPE_POTION_SPLASH)) {
            ((Properties)properties1).put(KEY_TEXTURE_SPLASH, name);
        } else {
            ((Properties)properties1).put(KEY_TEXTURE_DRINKABLE, name);
        }
        return properties1;
    }

    private static Map getMapPotionIds() {
        if (mapPotionIds == null) {
            mapPotionIds = new LinkedHashMap();
            mapPotionIds.put("water", CustomItems.getPotionId(0, 0));
            mapPotionIds.put("awkward", CustomItems.getPotionId(0, 1));
            mapPotionIds.put("thick", CustomItems.getPotionId(0, 2));
            mapPotionIds.put("potent", CustomItems.getPotionId(0, 3));
            mapPotionIds.put("regeneration", CustomItems.getPotionIds(1));
            mapPotionIds.put("movespeed", CustomItems.getPotionIds(2));
            mapPotionIds.put("fireresistance", CustomItems.getPotionIds(3));
            mapPotionIds.put("poison", CustomItems.getPotionIds(4));
            mapPotionIds.put("heal", CustomItems.getPotionIds(5));
            mapPotionIds.put("nightvision", CustomItems.getPotionIds(6));
            mapPotionIds.put("clear", CustomItems.getPotionId(7, 0));
            mapPotionIds.put("bungling", CustomItems.getPotionId(7, 1));
            mapPotionIds.put("charming", CustomItems.getPotionId(7, 2));
            mapPotionIds.put("rank", CustomItems.getPotionId(7, 3));
            mapPotionIds.put("weakness", CustomItems.getPotionIds(8));
            mapPotionIds.put("damageboost", CustomItems.getPotionIds(9));
            mapPotionIds.put("moveslowdown", CustomItems.getPotionIds(10));
            mapPotionIds.put("leaping", CustomItems.getPotionIds(11));
            mapPotionIds.put("harm", CustomItems.getPotionIds(12));
            mapPotionIds.put("waterbreathing", CustomItems.getPotionIds(13));
            mapPotionIds.put("invisibility", CustomItems.getPotionIds(14));
            mapPotionIds.put("thin", CustomItems.getPotionId(15, 0));
            mapPotionIds.put("debonair", CustomItems.getPotionId(15, 1));
            mapPotionIds.put("sparkling", CustomItems.getPotionId(15, 2));
            mapPotionIds.put("stinky", CustomItems.getPotionId(15, 3));
            mapPotionIds.put("mundane", CustomItems.getPotionId(0, 4));
            mapPotionIds.put("speed", mapPotionIds.get("movespeed"));
            mapPotionIds.put("fire_resistance", mapPotionIds.get("fireresistance"));
            mapPotionIds.put("instant_health", mapPotionIds.get("heal"));
            mapPotionIds.put("night_vision", mapPotionIds.get("nightvision"));
            mapPotionIds.put("strength", mapPotionIds.get("damageboost"));
            mapPotionIds.put("slowness", mapPotionIds.get("moveslowdown"));
            mapPotionIds.put("instant_damage", mapPotionIds.get("harm"));
            mapPotionIds.put("water_breathing", mapPotionIds.get("waterbreathing"));
        }
        return mapPotionIds;
    }

    private static int[] getPotionIds(int baseId) {
        return new int[]{baseId, baseId + 16, baseId + 32, baseId + 48};
    }

    private static int[] getPotionId(int baseId, int subId) {
        return new int[]{baseId + subId * 16};
    }

    private static int getPotionNameDamage(String name) {
        String s2 = "potion." + name;
        pe[] apotion = pe.a;
        for (int i2 = 0; i2 < apotion.length; ++i2) {
            String s1;
            pe potion = apotion[i2];
            if (potion == null || !s2.equals(s1 = potion.a())) continue;
            return potion.d();
        }
        return -1;
    }

    private static List makePropertyList(CustomItemProperties[][] propsArr) {
        ArrayList<ArrayList<CustomItemProperties>> list = new ArrayList<ArrayList<CustomItemProperties>>();
        if (propsArr != null) {
            for (int i2 = 0; i2 < propsArr.length; ++i2) {
                CustomItemProperties[] acustomitemproperties = propsArr[i2];
                ArrayList<CustomItemProperties> list1 = null;
                if (acustomitemproperties != null) {
                    list1 = new ArrayList<CustomItemProperties>(Arrays.asList(acustomitemproperties));
                }
                list.add(list1);
            }
        }
        return list;
    }

    private static CustomItemProperties[][] propertyListToArray(List<List> list) {
        CustomItemProperties[][] acustomitemproperties = new CustomItemProperties[list.size()][];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            List list2 = list.get(i2);
            if (list2 == null) continue;
            CustomItemProperties[] acustomitemproperties1 = list2.toArray(new CustomItemProperties[list2.size()]);
            Arrays.sort(acustomitemproperties1, new CustomItemsComparator());
            acustomitemproperties[i2] = acustomitemproperties1;
        }
        return acustomitemproperties;
    }

    private static void addToItemList(CustomItemProperties cp2, List itemList) {
        if (cp2.items != null) {
            for (int i2 = 0; i2 < cp2.items.length; ++i2) {
                int j2 = cp2.items[i2];
                if (j2 <= 0) {
                    Config.warn("Invalid item ID: " + j2);
                    continue;
                }
                CustomItems.addToList(cp2, itemList, j2);
            }
        }
    }

    private static void addToEnchantmentList(CustomItemProperties cp2, List enchantmentList) {
        if (cp2.type == 2 && cp2.enchantmentIds != null) {
            for (int i2 = 0; i2 < 256; ++i2) {
                if (!cp2.enchantmentIds.isInRange(i2)) continue;
                CustomItems.addToList(cp2, enchantmentList, i2);
            }
        }
    }

    private static void addToList(CustomItemProperties cp2, List<List<CustomItemProperties>> list, int id2) {
        while (id2 >= list.size()) {
            list.add(null);
        }
        List<CustomItemProperties> list2 = list.get(id2);
        if (list2 == null) {
            list2 = new ArrayList<CustomItemProperties>();
            list.set(id2, list2);
        }
        list2.add(cp2);
    }

    public static boq getCustomItemModel(zx itemStack, boq model, jy modelLocation, boolean fullModel) {
        if (!fullModel && model.c()) {
            return model;
        }
        if (itemProperties == null) {
            return model;
        }
        CustomItemProperties customitemproperties = CustomItems.getCustomItemProperties(itemStack, 1);
        if (customitemproperties == null) {
            return model;
        }
        boq ibakedmodel = customitemproperties.getBakedModel(modelLocation, fullModel);
        return ibakedmodel != null ? ibakedmodel : model;
    }

    public static boolean bindCustomArmorTexture(zx itemStack, int layer, String overlay) {
        if (itemProperties == null) {
            return false;
        }
        jy resourcelocation = CustomItems.getCustomArmorLocation(itemStack, layer, overlay);
        if (resourcelocation == null) {
            return false;
        }
        Config.getTextureManager().a(resourcelocation);
        return true;
    }

    private static jy getCustomArmorLocation(zx itemStack, int layer, String overlay) {
        String s1;
        jy resourcelocation;
        CustomItemProperties customitemproperties = CustomItems.getCustomItemProperties(itemStack, 3);
        if (customitemproperties == null) {
            return null;
        }
        if (customitemproperties.mapTextureLocations == null) {
            return customitemproperties.textureLocation;
        }
        zw item = itemStack.b();
        if (!(item instanceof yj)) {
            return null;
        }
        yj itemarmor = (yj)item;
        String s2 = itemarmor.x_().c();
        StringBuffer stringbuffer = new StringBuffer();
        stringbuffer.append("texture.");
        stringbuffer.append(s2);
        stringbuffer.append("_layer_");
        stringbuffer.append(layer);
        if (overlay != null) {
            stringbuffer.append("_");
            stringbuffer.append(overlay);
        }
        return (resourcelocation = (jy)customitemproperties.mapTextureLocations.get(s1 = stringbuffer.toString())) == null ? customitemproperties.textureLocation : resourcelocation;
    }

    private static CustomItemProperties getCustomItemProperties(zx itemStack, int type) {
        CustomItemProperties[] acustomitemproperties;
        if (itemProperties == null) {
            return null;
        }
        if (itemStack == null) {
            return null;
        }
        zw item = itemStack.b();
        int i2 = zw.b(item);
        if (i2 >= 0 && i2 < itemProperties.length && (acustomitemproperties = itemProperties[i2]) != null) {
            for (int j2 = 0; j2 < acustomitemproperties.length; ++j2) {
                CustomItemProperties customitemproperties = acustomitemproperties[j2];
                if (customitemproperties.type != type || !CustomItems.matchesProperties(customitemproperties, itemStack, null)) continue;
                return customitemproperties;
            }
        }
        return null;
    }

    private static boolean matchesProperties(CustomItemProperties cip, zx itemStack, int[][] enchantmentIdLevels) {
        zw item = itemStack.b();
        if (cip.damage != null) {
            int i2 = itemStack.h();
            if (cip.damageMask != 0) {
                i2 &= cip.damageMask;
            }
            if (cip.damagePercent) {
                int j2 = item.l();
                i2 = (int)((double)(i2 * 100) / (double)j2);
            }
            if (!cip.damage.isInRange(i2)) {
                return false;
            }
        }
        if (cip.stackSize != null && !cip.stackSize.isInRange(itemStack.b)) {
            return false;
        }
        int[][] aint = enchantmentIdLevels;
        if (cip.enchantmentIds != null) {
            if (enchantmentIdLevels == null) {
                aint = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean flag = false;
            for (int k2 = 0; k2 < aint.length; ++k2) {
                int l2 = aint[k2][0];
                if (!cip.enchantmentIds.isInRange(l2)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
        }
        if (cip.enchantmentLevels != null) {
            if (aint == null) {
                aint = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean flag1 = false;
            for (int i1 = 0; i1 < aint.length; ++i1) {
                int k1 = aint[i1][1];
                if (!cip.enchantmentLevels.isInRange(k1)) continue;
                flag1 = true;
                break;
            }
            if (!flag1) {
                return false;
            }
        }
        if (cip.nbtTagValues != null) {
            dn nbttagcompound = itemStack.o();
            for (int j1 = 0; j1 < cip.nbtTagValues.length; ++j1) {
                NbtTagValue nbttagvalue = cip.nbtTagValues[j1];
                if (nbttagvalue.matches(nbttagcompound)) continue;
                return false;
            }
        }
        if (cip.hand != 0) {
            if (cip.hand == 1 && renderOffHand) {
                return false;
            }
            if (cip.hand == 2 && !renderOffHand) {
                return false;
            }
        }
        return true;
    }

    private static int[][] getEnchantmentIdLevels(zx itemStack) {
        du nbttaglist;
        zw item = itemStack.b();
        du du2 = nbttaglist = item == zy.cd ? zy.cd.h(itemStack) : itemStack.p();
        if (nbttaglist != null && nbttaglist.c() > 0) {
            int[][] aint = new int[nbttaglist.c()][2];
            for (int i2 = 0; i2 < nbttaglist.c(); ++i2) {
                dn nbttagcompound = nbttaglist.b(i2);
                short j2 = nbttagcompound.e("id");
                short k2 = nbttagcompound.e("lvl");
                aint[i2][0] = j2;
                aint[i2][1] = k2;
            }
            return aint;
        }
        return EMPTY_INT2_ARRAY;
    }

    public static boolean renderCustomEffect(bjh renderItem, zx itemStack, boq model) {
        if (enchantmentProperties == null) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] aint = CustomItems.getEnchantmentIdLevels(itemStack);
        if (aint.length <= 0) {
            return false;
        }
        HashSet<Integer> set = null;
        boolean flag = false;
        bmj texturemanager = Config.getTextureManager();
        for (int i2 = 0; i2 < aint.length; ++i2) {
            CustomItemProperties[] acustomitemproperties;
            int j2 = aint[i2][0];
            if (j2 < 0 || j2 >= enchantmentProperties.length || (acustomitemproperties = enchantmentProperties[j2]) == null) continue;
            for (int k2 = 0; k2 < acustomitemproperties.length; ++k2) {
                CustomItemProperties customitemproperties = acustomitemproperties[k2];
                if (set == null) {
                    set = new HashSet<Integer>();
                }
                if (!set.add(j2) || !CustomItems.matchesProperties(customitemproperties, itemStack, aint) || customitemproperties.textureLocation == null) continue;
                texturemanager.a(customitemproperties.textureLocation);
                float f2 = customitemproperties.getTextureWidth(texturemanager);
                if (!flag) {
                    flag = true;
                    bfl.a(false);
                    bfl.c(514);
                    bfl.f();
                    bfl.n(5890);
                }
                Blender.setupBlend(customitemproperties.blend, 1.0f);
                bfl.E();
                bfl.a(f2 / 2.0f, f2 / 2.0f, f2 / 2.0f);
                float f1 = customitemproperties.speed * (float)(ave.J() % 3000L) / 3000.0f / 8.0f;
                bfl.b(f1, 0.0f, 0.0f);
                bfl.b(customitemproperties.rotation, 0.0f, 0.0f, 1.0f);
                renderItem.a(model, -1);
                bfl.F();
            }
        }
        if (flag) {
            bfl.d();
            bfl.l();
            bfl.b(770, 771);
            bfl.c(1.0f, 1.0f, 1.0f, 1.0f);
            bfl.n(5888);
            bfl.e();
            bfl.c(515);
            bfl.a(true);
            texturemanager.a(bmh.g);
        }
        return flag;
    }

    public static boolean renderCustomArmorEffect(pr entity, zx itemStack, bbo model, float limbSwing, float prevLimbSwing, float partialTicks, float timeLimbSwing, float yaw, float pitch, float scale) {
        if (enchantmentProperties == null) {
            return false;
        }
        if (Config.isShaders() && Shaders.isShadowPass) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] aint = CustomItems.getEnchantmentIdLevels(itemStack);
        if (aint.length <= 0) {
            return false;
        }
        HashSet<Integer> set = null;
        boolean flag = false;
        bmj texturemanager = Config.getTextureManager();
        for (int i2 = 0; i2 < aint.length; ++i2) {
            CustomItemProperties[] acustomitemproperties;
            int j2 = aint[i2][0];
            if (j2 < 0 || j2 >= enchantmentProperties.length || (acustomitemproperties = enchantmentProperties[j2]) == null) continue;
            for (int k2 = 0; k2 < acustomitemproperties.length; ++k2) {
                CustomItemProperties customitemproperties = acustomitemproperties[k2];
                if (set == null) {
                    set = new HashSet<Integer>();
                }
                if (!set.add(j2) || !CustomItems.matchesProperties(customitemproperties, itemStack, aint) || customitemproperties.textureLocation == null) continue;
                texturemanager.a(customitemproperties.textureLocation);
                float f2 = customitemproperties.getTextureWidth(texturemanager);
                if (!flag) {
                    flag = true;
                    if (Config.isShaders()) {
                        ShadersRender.renderEnchantedGlintBegin();
                    }
                    bfl.l();
                    bfl.c(514);
                    bfl.a(false);
                }
                Blender.setupBlend(customitemproperties.blend, 1.0f);
                bfl.f();
                bfl.n(5890);
                bfl.D();
                bfl.b(customitemproperties.rotation, 0.0f, 0.0f, 1.0f);
                float f1 = f2 / 8.0f;
                bfl.a(f1, f1 / 2.0f, f1);
                float f22 = customitemproperties.speed * (float)(ave.J() % 3000L) / 3000.0f / 8.0f;
                bfl.b(0.0f, f22, 0.0f);
                bfl.n(5888);
                model.a(entity, limbSwing, prevLimbSwing, timeLimbSwing, yaw, pitch, scale);
            }
        }
        if (flag) {
            bfl.d();
            bfl.l();
            bfl.b(770, 771);
            bfl.c(1.0f, 1.0f, 1.0f, 1.0f);
            bfl.n(5890);
            bfl.D();
            bfl.n(5888);
            bfl.e();
            bfl.a(true);
            bfl.c(515);
            bfl.k();
            if (Config.isShaders()) {
                ShadersRender.renderEnchantedGlintEnd();
            }
        }
        return flag;
    }

    public static boolean isUseGlint() {
        return useGlint;
    }
}

