/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.optifine.CustomGuiProperties;
import net.optifine.override.PlayerControllerOF;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomGuis {
    private static ave mc = Config.getMinecraft();
    private static PlayerControllerOF playerControllerOF = null;
    private static CustomGuiProperties[][] guiProperties = null;
    public static boolean isChristmas = CustomGuis.isChristmas();

    public static jy getTextureLocation(jy loc) {
        if (guiProperties == null) {
            return loc;
        }
        axu guiscreen = CustomGuis.mc.m;
        if (!(guiscreen instanceof ayl)) {
            return loc;
        }
        if (loc.b().equals("minecraft") && loc.a().startsWith("textures/gui/")) {
            pk entity;
            if (playerControllerOF == null) {
                return loc;
            }
            bdb iblockaccess = CustomGuis.mc.f;
            if (iblockaccess == null) {
                return loc;
            }
            if (guiscreen instanceof ayu) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CREATIVE, CustomGuis.mc.h.c(), iblockaccess, loc, guiscreen);
            }
            if (guiscreen instanceof azc) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.INVENTORY, CustomGuis.mc.h.c(), iblockaccess, loc, guiscreen);
            }
            cj blockpos = playerControllerOF.getLastClickBlockPos();
            if (blockpos != null) {
                if (guiscreen instanceof aym) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ANVIL, blockpos, iblockaccess, loc, guiscreen);
                }
                if (guiscreen instanceof ayn) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BEACON, blockpos, iblockaccess, loc, guiscreen);
                }
                if (guiscreen instanceof ayp) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BREWING_STAND, blockpos, iblockaccess, loc, guiscreen);
                }
                if (guiscreen instanceof ayr) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CHEST, blockpos, iblockaccess, loc, guiscreen);
                }
                if (guiscreen instanceof ays) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CRAFTING, blockpos, iblockaccess, loc, guiscreen);
                }
                if (guiscreen instanceof ayv) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.DISPENSER, blockpos, iblockaccess, loc, guiscreen);
                }
                if (guiscreen instanceof ayy) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ENCHANTMENT, blockpos, iblockaccess, loc, guiscreen);
                }
                if (guiscreen instanceof ayz) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.FURNACE, blockpos, iblockaccess, loc, guiscreen);
                }
                if (guiscreen instanceof aza) {
                    return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.HOPPER, blockpos, iblockaccess, loc, guiscreen);
                }
            }
            if ((entity = playerControllerOF.getLastClickEntity()) != null) {
                if (guiscreen instanceof azb) {
                    return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.HORSE, entity, iblockaccess, loc);
                }
                if (guiscreen instanceof azd) {
                    return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.VILLAGER, entity, iblockaccess, loc);
                }
            }
            return loc;
        }
        return loc;
    }

    private static jy getTexturePos(CustomGuiProperties.EnumContainer container, cj pos, adq blockAccess, jy loc, axu screen) {
        CustomGuiProperties[] acustomguiproperties = guiProperties[container.ordinal()];
        if (acustomguiproperties == null) {
            return loc;
        }
        for (int i2 = 0; i2 < acustomguiproperties.length; ++i2) {
            CustomGuiProperties customguiproperties = acustomguiproperties[i2];
            if (!customguiproperties.matchesPos(container, pos, blockAccess, screen)) continue;
            return customguiproperties.getTextureLocation(loc);
        }
        return loc;
    }

    private static jy getTextureEntity(CustomGuiProperties.EnumContainer container, pk entity, adq blockAccess, jy loc) {
        CustomGuiProperties[] acustomguiproperties = guiProperties[container.ordinal()];
        if (acustomguiproperties == null) {
            return loc;
        }
        for (int i2 = 0; i2 < acustomguiproperties.length; ++i2) {
            CustomGuiProperties customguiproperties = acustomguiproperties[i2];
            if (!customguiproperties.matchesEntity(container, entity, blockAccess)) continue;
            return customguiproperties.getTextureLocation(loc);
        }
        return loc;
    }

    public static void update() {
        guiProperties = null;
        if (Config.isCustomGuis()) {
            ArrayList<List<CustomGuiProperties>> list = new ArrayList<List<CustomGuiProperties>>();
            bnk[] airesourcepack = Config.getResourcePacks();
            for (int i2 = airesourcepack.length - 1; i2 >= 0; --i2) {
                bnk iresourcepack = airesourcepack[i2];
                CustomGuis.update(iresourcepack, list);
            }
            guiProperties = CustomGuis.propertyListToArray(list);
        }
    }

    private static CustomGuiProperties[][] propertyListToArray(List<List<CustomGuiProperties>> listProps) {
        if (listProps.isEmpty()) {
            return null;
        }
        CustomGuiProperties[][] acustomguiproperties = new CustomGuiProperties[CustomGuiProperties.EnumContainer.VALUES.length][];
        for (int i2 = 0; i2 < acustomguiproperties.length; ++i2) {
            List<CustomGuiProperties> list;
            if (listProps.size() <= i2 || (list = listProps.get(i2)) == null) continue;
            CustomGuiProperties[] acustomguiproperties1 = list.toArray(new CustomGuiProperties[list.size()]);
            acustomguiproperties[i2] = acustomguiproperties1;
        }
        return acustomguiproperties;
    }

    private static void update(bnk rp2, List<List<CustomGuiProperties>> listProps) {
        String[] astring = ResUtils.collectFiles(rp2, "optifine/gui/container/", ".properties", (String[])null);
        Arrays.sort(astring);
        for (int i2 = 0; i2 < astring.length; ++i2) {
            String s2 = astring[i2];
            Config.dbg("CustomGuis: " + s2);
            try {
                jy resourcelocation = new jy(s2);
                InputStream inputstream = rp2.a(resourcelocation);
                if (inputstream == null) {
                    Config.warn("CustomGuis file not found: " + s2);
                    continue;
                }
                PropertiesOrdered properties = new PropertiesOrdered();
                properties.load(inputstream);
                inputstream.close();
                CustomGuiProperties customguiproperties = new CustomGuiProperties(properties, s2);
                if (!customguiproperties.isValid(s2)) continue;
                CustomGuis.addToList(customguiproperties, listProps);
                continue;
            }
            catch (FileNotFoundException var9) {
                Config.warn("CustomGuis file not found: " + s2);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static void addToList(CustomGuiProperties cgp, List<List<CustomGuiProperties>> listProps) {
        if (cgp.getContainer() == null) {
            CustomGuis.warn("Invalid container: " + (Object)((Object)cgp.getContainer()));
        } else {
            int i2 = cgp.getContainer().ordinal();
            while (listProps.size() <= i2) {
                listProps.add(null);
            }
            List<CustomGuiProperties> list = listProps.get(i2);
            if (list == null) {
                list = new ArrayList<CustomGuiProperties>();
                listProps.set(i2, list);
            }
            list.add(cgp);
        }
    }

    public static PlayerControllerOF getPlayerControllerOF() {
        return playerControllerOF;
    }

    public static void setPlayerControllerOF(PlayerControllerOF playerControllerOF) {
        CustomGuis.playerControllerOF = playerControllerOF;
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }
}

