/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.optifine.CustomGuis;
import net.optifine.config.ConnectedParser;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.config.VillagerProfession;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<jy, jy> textureLocations = null;
    private NbtTagValue nbtName = null;
    private ady[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private VillagerProfession[] professions = null;
    private EnumVariant[] variants = null;
    private zd[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final zd[] COLORS_INVALID = new zd[0];
    private static final jy ANVIL_GUI_TEXTURE = new jy("textures/gui/container/anvil.png");
    private static final jy BEACON_GUI_TEXTURE = new jy("textures/gui/container/beacon.png");
    private static final jy BREWING_STAND_GUI_TEXTURE = new jy("textures/gui/container/brewing_stand.png");
    private static final jy CHEST_GUI_TEXTURE = new jy("textures/gui/container/generic_54.png");
    private static final jy CRAFTING_TABLE_GUI_TEXTURE = new jy("textures/gui/container/crafting_table.png");
    private static final jy HORSE_GUI_TEXTURE = new jy("textures/gui/container/horse.png");
    private static final jy DISPENSER_GUI_TEXTURE = new jy("textures/gui/container/dispenser.png");
    private static final jy ENCHANTMENT_TABLE_GUI_TEXTURE = new jy("textures/gui/container/enchanting_table.png");
    private static final jy FURNACE_GUI_TEXTURE = new jy("textures/gui/container/furnace.png");
    private static final jy HOPPER_GUI_TEXTURE = new jy("textures/gui/container/hopper.png");
    private static final jy INVENTORY_GUI_TEXTURE = new jy("textures/gui/container/inventory.png");
    private static final jy SHULKER_BOX_GUI_TEXTURE = new jy("textures/gui/container/shulker_box.png");
    private static final jy VILLAGER_GUI_TEXTURE = new jy("textures/gui/container/villager.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser connectedparser = new ConnectedParser("CustomGuis");
        this.fileName = connectedparser.parseName(path);
        this.basePath = connectedparser.parseBasePath(path);
        this.container = (EnumContainer)connectedparser.parseEnum(props.getProperty("container"), EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations(props, "texture", this.container, "textures/gui/", this.basePath);
        this.nbtName = connectedparser.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = connectedparser.parseBiomes(props.getProperty("biomes"));
        this.heights = connectedparser.parseRangeListInt(props.getProperty("heights"));
        this.large = connectedparser.parseBooleanObject(props.getProperty("large"));
        this.trapped = connectedparser.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = connectedparser.parseBooleanObject(props.getProperty("christmas"));
        this.ender = connectedparser.parseBooleanObject(props.getProperty("ender"));
        this.levels = connectedparser.parseRangeListInt(props.getProperty("levels"));
        this.professions = connectedparser.parseProfessions(props.getProperty("professions"));
        Enum[] acustomguiproperties$enumvariant = CustomGuiProperties.getContainerVariants(this.container);
        this.variants = (EnumVariant[])connectedparser.parseEnums(props.getProperty("variants"), acustomguiproperties$enumvariant, "variants", VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors(props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        return cont == EnumContainer.HORSE ? VARIANTS_HORSE : (cont == EnumContainer.DISPENSER ? VARIANTS_DISPENSER : new EnumVariant[]{});
    }

    private static zd[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] astring = Config.tokenize(str, " ");
        zd[] aenumdyecolor = new zd[astring.length];
        for (int i2 = 0; i2 < astring.length; ++i2) {
            String s2 = astring[i2];
            zd enumdyecolor = CustomGuiProperties.parseEnumDyeColor(s2);
            if (enumdyecolor == null) {
                CustomGuiProperties.warn("Invalid color: " + s2);
                return COLORS_INVALID;
            }
            aenumdyecolor[i2] = enumdyecolor;
        }
        return aenumdyecolor;
    }

    private static zd parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        zd[] aenumdyecolor = zd.values();
        for (int i2 = 0; i2 < aenumdyecolor.length; ++i2) {
            zd enumdyecolor = aenumdyecolor[i2];
            if (enumdyecolor.l().equals(str)) {
                return enumdyecolor;
            }
            if (!enumdyecolor.d().equals(str)) continue;
            return enumdyecolor;
        }
        return null;
    }

    private static jy parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        String s2 = TextureUtils.fixResourcePath(str = str.trim(), basePath);
        if (!s2.endsWith(".png")) {
            s2 = s2 + ".png";
        }
        return new jy(basePath + "/" + s2);
    }

    private static Map<jy, jy> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<jy, jy> map = new HashMap<jy, jy>();
        String s2 = props.getProperty(property);
        if (s2 != null) {
            jy resourcelocation = CustomGuiProperties.getGuiTextureLocation(container);
            jy resourcelocation1 = CustomGuiProperties.parseTextureLocation(s2, basePath);
            if (resourcelocation != null && resourcelocation1 != null) {
                map.put(resourcelocation, resourcelocation1);
            }
        }
        String s5 = property + ".";
        for (Object o2 : props.keySet()) {
            String s1 = (String)o2;
            if (!s1.startsWith(s5)) continue;
            String s22 = s1.substring(s5.length());
            s22 = s22.replace('\\', '/');
            s22 = StrUtils.removePrefixSuffix(s22, "/", ".png");
            String s3 = pathPrefix + s22 + ".png";
            String s4 = props.getProperty(s1);
            jy resourcelocation2 = new jy(s3);
            jy resourcelocation3 = CustomGuiProperties.parseTextureLocation(s4, basePath);
            map.put(resourcelocation2, resourcelocation3);
        }
        return map;
    }

    private static jy getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (container) {
            case ANVIL: {
                return ANVIL_GUI_TEXTURE;
            }
            case BEACON: {
                return BEACON_GUI_TEXTURE;
            }
            case BREWING_STAND: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case CHEST: {
                return CHEST_GUI_TEXTURE;
            }
            case CRAFTING: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case CREATIVE: {
                return null;
            }
            case DISPENSER: {
                return DISPENSER_GUI_TEXTURE;
            }
            case ENCHANTMENT: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case FURNACE: {
                return FURNACE_GUI_TEXTURE;
            }
            case HOPPER: {
                return HOPPER_GUI_TEXTURE;
            }
            case HORSE: {
                return HORSE_GUI_TEXTURE;
            }
            case INVENTORY: {
                return INVENTORY_GUI_TEXTURE;
            }
            case SHULKER_BOX: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case VILLAGER: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName != null && this.fileName.length() > 0) {
            if (this.basePath == null) {
                CustomGuiProperties.warn("No base path found: " + path);
                return false;
            }
            if (this.container == null) {
                CustomGuiProperties.warn("No container found: " + path);
                return false;
            }
            if (this.textureLocations.isEmpty()) {
                CustomGuiProperties.warn("No texture found: " + path);
                return false;
            }
            if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
                CustomGuiProperties.warn("Invalid professions or careers: " + path);
                return false;
            }
            if (this.variants == VARIANTS_INVALID) {
                CustomGuiProperties.warn("Invalid variants: " + path);
                return false;
            }
            if (this.colors == COLORS_INVALID) {
                CustomGuiProperties.warn("Invalid colors: " + path);
                return false;
            }
            return true;
        }
        CustomGuiProperties.warn("No name found: " + path);
        return false;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }

    private boolean matchesGeneral(EnumContainer ec2, cj pos, adq blockAccess) {
        ady biomegenbase;
        if (this.container != ec2) {
            return false;
        }
        if (this.biomes != null && !Matches.biome(biomegenbase = blockAccess.b(pos), this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.o());
    }

    public boolean matchesPos(EnumContainer ec2, cj pos, adq blockAccess, axu screen) {
        String s2;
        if (!this.matchesGeneral(ec2, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(s2 = CustomGuiProperties.getName(screen))) {
            return false;
        }
        switch (ec2) {
            case BEACON: {
                return this.matchesBeacon(pos, blockAccess);
            }
            case CHEST: {
                return this.matchesChest(pos, blockAccess);
            }
            case DISPENSER: {
                return this.matchesDispenser(pos, blockAccess);
            }
        }
        return true;
    }

    public static String getName(axu screen) {
        op iworldnameable = CustomGuiProperties.getWorldNameable(screen);
        return iworldnameable == null ? null : iworldnameable.f_().c();
    }

    private static op getWorldNameable(axu screen) {
        return screen instanceof ayn ? CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBeacon_tileBeacon) : (screen instanceof ayp ? CustomGuiProperties.getWorldNameable(screen, Reflector.GuiBrewingStand_tileBrewingStand) : (screen instanceof ayr ? CustomGuiProperties.getWorldNameable(screen, Reflector.GuiChest_lowerChestInventory) : (screen instanceof ayv ? ((ayv)screen).u : (screen instanceof ayy ? CustomGuiProperties.getWorldNameable(screen, Reflector.GuiEnchantment_nameable) : (screen instanceof ayz ? CustomGuiProperties.getWorldNameable(screen, Reflector.GuiFurnace_tileFurnace) : (screen instanceof aza ? CustomGuiProperties.getWorldNameable(screen, Reflector.GuiHopper_hopperInventory) : null))))));
    }

    private static op getWorldNameable(axu screen, ReflectorField fieldInventory) {
        Object object = Reflector.getFieldValue(screen, fieldInventory);
        return !(object instanceof op) ? null : (op)object;
    }

    private boolean matchesBeacon(cj pos, adq blockAccess) {
        akw tileentity = blockAccess.s(pos);
        if (!(tileentity instanceof akv)) {
            return false;
        }
        akv tileentitybeacon = (akv)tileentity;
        if (this.levels != null) {
            dn nbttagcompound = new dn();
            tileentitybeacon.b(nbttagcompound);
            int i2 = nbttagcompound.f("Levels");
            if (!this.levels.isInRange(i2)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(cj pos, adq blockAccess) {
        akw tileentity = blockAccess.s(pos);
        if (tileentity instanceof aky) {
            aky tileentitychest = (aky)tileentity;
            return this.matchesChest(tileentitychest, pos, blockAccess);
        }
        if (tileentity instanceof alf) {
            alf tileentityenderchest = (alf)tileentity;
            return this.matchesEnderChest(tileentityenderchest, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(aky tec, cj pos, adq blockAccess) {
        boolean flag = tec.h != null || tec.g != null || tec.f != null || tec.i != null;
        boolean flag1 = tec.n() == 1;
        boolean flag2 = CustomGuis.isChristmas;
        boolean flag3 = false;
        return this.matchesChest(flag, flag1, flag2, flag3);
    }

    private boolean matchesEnderChest(alf teec, cj pos, adq blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        return this.large != null && this.large != isLarge ? false : (this.trapped != null && this.trapped != isTrapped ? false : (this.christmas != null && this.christmas != isChristmas ? false : this.ender == null || this.ender == isEnder));
    }

    private boolean matchesDispenser(cj pos, adq blockAccess) {
        EnumVariant customguiproperties$enumvariant;
        akw tileentity = blockAccess.s(pos);
        if (!(tileentity instanceof alc)) {
            return false;
        }
        alc tileentitydispenser = (alc)tileentity;
        return this.variants == null || Config.equalsOne((Object)(customguiproperties$enumvariant = this.getDispenserVariant(tileentitydispenser)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(alc ted) {
        return ted instanceof ald ? EnumVariant.DROPPER : EnumVariant.DISPENSER;
    }

    public boolean matchesEntity(EnumContainer ec2, pk entity, adq blockAccess) {
        String s2;
        if (!this.matchesGeneral(ec2, entity.c(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(s2 = entity.e_())) {
            return false;
        }
        switch (ec2) {
            case HORSE: {
                return this.matchesHorse(entity, blockAccess);
            }
            case VILLAGER: {
                return this.matchesVillager(entity, blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(pk entity, adq blockAccess) {
        if (!(entity instanceof wi)) {
            return false;
        }
        wi entityvillager = (wi)entity;
        if (this.professions != null) {
            int i2 = entityvillager.cl();
            int j2 = Reflector.getFieldValueInt(entityvillager, Reflector.EntityVillager_careerId, -1);
            if (j2 < 0) {
                return false;
            }
            boolean flag = false;
            for (int k2 = 0; k2 < this.professions.length; ++k2) {
                VillagerProfession villagerprofession = this.professions[k2];
                if (!villagerprofession.matches(i2, j2)) continue;
                flag = true;
                break;
            }
            if (!flag) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesHorse(pk entity, adq blockAccess) {
        EnumVariant customguiproperties$enumvariant;
        if (!(entity instanceof tp)) {
            return false;
        }
        tp entityhorse = (tp)entity;
        return this.variants == null || Config.equalsOne((Object)(customguiproperties$enumvariant = this.getHorseVariant(entityhorse)), (Object[])this.variants);
    }

    private EnumVariant getHorseVariant(tp entity) {
        int i2 = entity.cl();
        switch (i2) {
            case 0: {
                return EnumVariant.HORSE;
            }
            case 1: {
                return EnumVariant.DONKEY;
            }
            case 2: {
                return EnumVariant.MULE;
            }
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public jy getTextureLocation(jy loc) {
        jy resourcelocation = this.textureLocations.get(loc);
        return resourcelocation == null ? loc : resourcelocation;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + (Object)((Object)this.container) + ", textures: " + this.textureLocations;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EnumVariant {
        HORSE,
        DONKEY,
        MULE,
        LLAMA,
        DISPENSER,
        DROPPER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumContainer {
        ANVIL,
        BEACON,
        BREWING_STAND,
        CHEST,
        CRAFTING,
        DISPENSER,
        ENCHANTMENT,
        FURNACE,
        HOPPER,
        HORSE,
        VILLAGER,
        SHULKER_BOX,
        CREATIVE,
        INVENTORY;

        public static final EnumContainer[] VALUES;

        static {
            VALUES = EnumContainer.values();
        }
    }
}

