/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaBackportUtil {
    public static int[] arrayCopyOf(int[] original, int newLength) {
        int[] copy = new int[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static <T> T[] arrayCopyOfRange(T[] original, int from, int to2) {
        return JavaBackportUtil.arrayCopyOfRange(original, from, to2, original.getClass());
    }

    public static <T, U> T[] arrayCopyOfRange(U[] original, int from, int to2, Class<? extends T[]> newType) {
        int newLength = to2 - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to2);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }

    public static byte[] getStringBytes(String string, Charset charset) {
        try {
            return string.getBytes(charset.name());
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(charset.name() + " is not on this platform!");
        }
    }

    public static String newStringFromBytes(byte[] bytes, Charset charset) {
        try {
            return new String(bytes, charset.name());
        }
        catch (UnsupportedEncodingException e2) {
            throw new RuntimeException(charset.name() + " is not on this platform!");
        }
    }

    public static boolean isAllASCII(String input) {
        boolean isASCII = true;
        for (int i2 = 0; i2 < input.length(); ++i2) {
            char c2 = input.charAt(i2);
            if (c2 <= '\u007f') continue;
            isASCII = false;
            break;
        }
        return isASCII;
    }

    public static float nextAfter(float start, double direction) {
        if (Float.isNaN(start) || Double.isNaN(direction)) {
            return start + (float)direction;
        }
        if ((double)start == direction) {
            return (float)direction;
        }
        int transducer = Float.floatToRawIntBits(start + 0.0f);
        if (direction > (double)start) {
            transducer += transducer >= 0 ? 1 : -1;
        } else {
            assert (direction < (double)start);
            transducer = transducer > 0 ? --transducer : (transducer < 0 ? ++transducer : -2147483647);
        }
        return Float.intBitsToFloat(transducer);
    }

    public static void validateInclusiveBetween(long start, long end, long value, String message) {
        if (value < start || value > end) {
            throw new IllegalArgumentException(String.format(message, new Object[0]));
        }
    }

    private JavaBackportUtil() {
    }
}

