/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.properties;

import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Type;
import java.util.Map;

public class PropertyMap
extends ForwardingMultimap {
    private final Multimap properties = LinkedHashMultimap.create();

    protected Multimap delegate() {
        return this.properties;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Serializer
    implements JsonSerializer<PropertyMap>,
    JsonDeserializer<PropertyMap> {
        /*
         * Unable to fully structure code
         */
        public PropertyMap deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            result = new PropertyMap();
            if (json instanceof JsonObject) {
                object = (JsonObject)json;
                i$ = object.entrySet().iterator();
                block0: while (true) {
                    if (!i$.hasNext()) {
                        return result;
                    }
                    entry = (Map.Entry)i$.next();
                    if (!(entry.getValue() instanceof JsonArray)) continue;
                    i$ = ((JsonArray)entry.getValue()).iterator();
                    while (true) {
                        if (i$.hasNext()) ** break;
                        continue block0;
                        element = (JsonElement)i$.next();
                        result.put(entry.getKey(), new Property((String)entry.getKey(), element.getAsString()));
                    }
                    break;
                }
            }
            if (json instanceof JsonArray) {
                for (JsonElement element : (JsonArray)json) {
                    if (!(element instanceof JsonObject)) continue;
                    object = (JsonObject)element;
                    name = object.getAsJsonPrimitive("name").getAsString();
                    value = object.getAsJsonPrimitive("value").getAsString();
                    if (object.has("signature")) {
                        result.put(name, new Property(name, value, object.getAsJsonPrimitive("signature").getAsString()));
                        continue;
                    }
                    result.put(name, new Property(name, value));
                }
            }
            return result;
        }

        public JsonElement serialize(PropertyMap src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray result = new JsonArray();
            for (Property property : src.values()) {
                JsonObject object = new JsonObject();
                object.addProperty("name", property.getName());
                object.addProperty("value", property.getValue());
                if (property.hasSignature()) {
                    object.addProperty("signature", property.getSignature());
                }
                result.add((JsonElement)object);
            }
            return result;
        }
    }
}

