/*
 * Decompiled with CFR 0.152.
 */
package optifine.json;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import optifine.json.JSONArray;
import optifine.json.JSONAware;
import optifine.json.JSONObject;
import optifine.json.JSONParser;
import optifine.json.JSONStreamAware;
import optifine.json.ParseException;

public class JSONValue {
    public static Object parse(Reader in2) {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse(in2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Object parse(String s2) {
        StringReader in2 = new StringReader(s2);
        return JSONValue.parse(in2);
    }

    public static Object parseWithException(Reader in2) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(in2);
    }

    public static Object parseWithException(String s2) throws ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(s2);
    }

    public static void writeJSONString(Object value, Writer out) throws IOException {
        if (value == null) {
            out.write("null");
            return;
        }
        if (value instanceof String) {
            out.write(34);
            out.write(JSONValue.escape((String)value));
            out.write(34);
            return;
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Number) {
            out.write(value.toString());
            return;
        }
        if (value instanceof Boolean) {
            out.write(value.toString());
            return;
        }
        if (value instanceof JSONStreamAware) {
            ((JSONStreamAware)value).writeJSONString(out);
            return;
        }
        if (value instanceof JSONAware) {
            out.write(((JSONAware)value).toJSONString());
            return;
        }
        if (value instanceof Map) {
            JSONObject.writeJSONString((Map)value, out);
            return;
        }
        if (value instanceof List) {
            JSONArray.writeJSONString((List)value, out);
            return;
        }
        out.write(value.toString());
    }

    public static String toJSONString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + JSONValue.escape((String)value) + "\"";
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof JSONAware) {
            return ((JSONAware)value).toJSONString();
        }
        if (value instanceof Map) {
            return JSONObject.toJSONString((Map)value);
        }
        if (value instanceof List) {
            return JSONArray.toJSONString((List)value);
        }
        return value.toString();
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuffer sb2 = new StringBuffer();
        JSONValue.escape(s2, sb2);
        return sb2.toString();
    }

    static void escape(String s2, StringBuffer sb2) {
        int i2 = 0;
        while (i2 < s2.length()) {
            char ch = s2.charAt(i2);
            switch (ch) {
                case '\"': {
                    sb2.append("\\\"");
                    break;
                }
                case '\\': {
                    sb2.append("\\\\");
                    break;
                }
                case '\b': {
                    sb2.append("\\b");
                    break;
                }
                case '\f': {
                    sb2.append("\\f");
                    break;
                }
                case '\n': {
                    sb2.append("\\n");
                    break;
                }
                case '\r': {
                    sb2.append("\\r");
                    break;
                }
                case '\t': {
                    sb2.append("\\t");
                    break;
                }
                default: {
                    if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                        String ss2 = Integer.toHexString(ch);
                        sb2.append("\\u");
                        int k2 = 0;
                        while (k2 < 4 - ss2.length()) {
                            sb2.append('0');
                            ++k2;
                        }
                        sb2.append(ss2.toUpperCase());
                        break;
                    }
                    sb2.append(ch);
                }
            }
            ++i2;
        }
    }
}

