/*
 * Decompiled with CFR 0.152.
 */
package optifine;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static String getHashMd5(String data) {
        return HashUtils.getHash(data, "MD5");
    }

    public static String getHashSha1(String data) {
        return HashUtils.getHash(data, "SHA-1");
    }

    public static String getHashSha256(String data) {
        return HashUtils.getHash(data, "SHA-256");
    }

    public static String getHash(String data, String digest) {
        try {
            byte[] array = HashUtils.getHash(data.getBytes("UTF-8"), digest);
            return HashUtils.toHexString(array);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage(), e2);
        }
    }

    public static String toHexString(byte[] data) {
        StringBuffer sb2 = new StringBuffer();
        int i2 = 0;
        while (i2 < data.length) {
            sb2.append(Integer.toHexString(data[i2] & 0xFF | 0x100).substring(1, 3));
            ++i2;
        }
        return sb2.toString();
    }

    public static byte[] getHashMd5(byte[] data) throws NoSuchAlgorithmException {
        return HashUtils.getHash(data, "MD5");
    }

    public static byte[] getHashSha1(byte[] data) throws NoSuchAlgorithmException {
        return HashUtils.getHash(data, "SHA-1");
    }

    public static byte[] getHashSha256(byte[] data) throws NoSuchAlgorithmException {
        return HashUtils.getHash(data, "SHA-256");
    }

    public static byte[] getHash(byte[] data, String digest) throws NoSuchAlgorithmException {
        MessageDigest md2 = MessageDigest.getInstance(digest);
        byte[] array = md2.digest(data);
        return array;
    }
}

