/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import net.optifine.util.MathUtils;

public class MathUtilsTest {
    public static void main(String[] args) throws Exception {
        OPER[] values = OPER.values();
        for (int i2 = 0; i2 < values.length; ++i2) {
            OPER oper = values[i2];
            MathUtilsTest.dbg("******** " + (Object)((Object)oper) + " ***********");
            MathUtilsTest.test(oper, false);
        }
    }

    private static void test(OPER oper, boolean fast) {
        double max;
        double min;
        ns.fastMath = fast;
        switch (oper) {
            case SIN: 
            case COS: {
                min = -ns.PI;
                max = ns.PI;
                break;
            }
            case ASIN: 
            case ACOS: {
                min = -1.0;
                max = 1.0;
                break;
            }
            default: {
                return;
            }
        }
        int count = 10;
        for (int i2 = 0; i2 <= count; ++i2) {
            float res2;
            float res1;
            double val = min + (double)i2 * (max - min) / (double)count;
            switch (oper) {
                case SIN: {
                    res1 = (float)Math.sin(val);
                    res2 = ns.a((float)val);
                    break;
                }
                case COS: {
                    res1 = (float)Math.cos(val);
                    res2 = ns.b((float)val);
                    break;
                }
                case ASIN: {
                    res1 = (float)Math.asin(val);
                    res2 = MathUtils.asin((float)val);
                    break;
                }
                case ACOS: {
                    res1 = (float)Math.acos(val);
                    res2 = MathUtils.acos((float)val);
                    break;
                }
                default: {
                    return;
                }
            }
            MathUtilsTest.dbg(String.format("%.2f, Math: %f, Helper: %f, diff: %f", val, Float.valueOf(res1), Float.valueOf(res2), Float.valueOf(Math.abs(res1 - res2))));
        }
    }

    public static void dbg(String str) {
        System.out.println(str);
    }

    private static enum OPER {
        SIN,
        COS,
        ASIN,
        ACOS;

    }
}

