/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.optifine.CustomSkyLayer;
import net.optifine.render.Blender;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.TextureUtils;

public class CustomSky {
    private static CustomSkyLayer[][] worldSkyLayers = null;

    public static void reset() {
        worldSkyLayers = null;
    }

    public static void update() {
        CustomSky.reset();
        if (!Config.isCustomSky()) {
            return;
        }
        worldSkyLayers = CustomSky.readCustomSkies();
    }

    private static CustomSkyLayer[][] readCustomSkies() {
        CustomSkyLayer[][] wsls = new CustomSkyLayer[10][0];
        String prefix = "mcpatcher/sky/world";
        int lastWorldId = -1;
        for (int w2 = 0; w2 < wsls.length; ++w2) {
            String worldPrefix = prefix + w2 + "/sky";
            ArrayList<CustomSkyLayer> listSkyLayers = new ArrayList<CustomSkyLayer>();
            for (int i2 = 1; i2 < 1000; ++i2) {
                String path = worldPrefix + i2 + ".properties";
                try {
                    jy locPath = new jy(path);
                    InputStream in2 = Config.getResourceStream(locPath);
                    if (in2 == null) break;
                    PropertiesOrdered props = new PropertiesOrdered();
                    props.load(in2);
                    in2.close();
                    Config.dbg("CustomSky properties: " + path);
                    String defSource = worldPrefix + i2 + ".png";
                    CustomSkyLayer sl2 = new CustomSkyLayer(props, defSource);
                    if (!sl2.isValid(path)) continue;
                    jy locSource = new jy(sl2.source);
                    bmk tex = TextureUtils.getTexture(locSource);
                    if (tex == null) {
                        Config.log("CustomSky: Texture not found: " + locSource);
                        continue;
                    }
                    sl2.textureId = tex.b();
                    listSkyLayers.add(sl2);
                    in2.close();
                    continue;
                }
                catch (FileNotFoundException e2) {
                    break;
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
            if (listSkyLayers.size() <= 0) continue;
            CustomSkyLayer[] sls = listSkyLayers.toArray(new CustomSkyLayer[listSkyLayers.size()]);
            wsls[w2] = sls;
            lastWorldId = w2;
        }
        if (lastWorldId < 0) {
            return null;
        }
        int worldCount = lastWorldId + 1;
        CustomSkyLayer[][] wslsTrim = new CustomSkyLayer[worldCount][0];
        for (int i3 = 0; i3 < wslsTrim.length; ++i3) {
            wslsTrim[i3] = wsls[i3];
        }
        return wslsTrim;
    }

    public static void renderSky(adm world, bmj re2, float partialTicks) {
        if (worldSkyLayers == null) {
            return;
        }
        int dimId = world.t.q();
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return;
        }
        long time = world.L();
        int timeOfDay = (int)(time % 24000L);
        float celestialAngle = world.c(partialTicks);
        float rainStrength = world.j(partialTicks);
        float thunderStrength = world.h(partialTicks);
        if (rainStrength > 0.0f) {
            thunderStrength /= rainStrength;
        }
        for (int i2 = 0; i2 < sls.length; ++i2) {
            CustomSkyLayer sl2 = sls[i2];
            if (!sl2.isActive(world, timeOfDay)) continue;
            sl2.render(world, timeOfDay, celestialAngle, rainStrength, thunderStrength);
        }
        float rainBrightness = 1.0f - rainStrength;
        Blender.clearBlend(rainBrightness);
    }

    public static boolean hasSkyLayers(adm world) {
        if (worldSkyLayers == null) {
            return false;
        }
        int dimId = world.t.q();
        if (dimId < 0 || dimId >= worldSkyLayers.length) {
            return false;
        }
        CustomSkyLayer[] sls = worldSkyLayers[dimId];
        if (sls == null) {
            return false;
        }
        return sls.length > 0;
    }
}

