/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.optifine.BlockPosM;
import net.optifine.CustomColors;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchBlock;
import net.optifine.config.Matches;
import net.optifine.util.TextureUtils;

public class CustomColormap
implements CustomColors.IColorizer {
    public String name = null;
    public String basePath = null;
    private int format = -1;
    private MatchBlock[] matchBlocks = null;
    private String source = null;
    private int color = -1;
    private int yVariance = 0;
    private int yOffset = 0;
    private int width = 0;
    private int height = 0;
    private int[] colors = null;
    private float[][] colorsRgb = null;
    private static final int FORMAT_UNKNOWN = -1;
    private static final int FORMAT_VANILLA = 0;
    private static final int FORMAT_GRID = 1;
    private static final int FORMAT_FIXED = 2;
    public static final String FORMAT_VANILLA_STRING = "vanilla";
    public static final String FORMAT_GRID_STRING = "grid";
    public static final String FORMAT_FIXED_STRING = "fixed";
    public static final String[] FORMAT_STRINGS = new String[]{"vanilla", "grid", "fixed"};
    public static final String KEY_FORMAT = "format";
    public static final String KEY_BLOCKS = "blocks";
    public static final String KEY_SOURCE = "source";
    public static final String KEY_COLOR = "color";
    public static final String KEY_Y_VARIANCE = "yVariance";
    public static final String KEY_Y_OFFSET = "yOffset";

    public CustomColormap(Properties props, String path, int width, int height, String formatDefault) {
        ConnectedParser cp2 = new ConnectedParser("Colormap");
        this.name = cp2.parseName(path);
        this.basePath = cp2.parseBasePath(path);
        this.format = this.parseFormat(props.getProperty(KEY_FORMAT, formatDefault));
        this.matchBlocks = cp2.parseMatchBlocks(props.getProperty(KEY_BLOCKS));
        this.source = CustomColormap.parseTexture(props.getProperty(KEY_SOURCE), path, this.basePath);
        this.color = ConnectedParser.parseColor(props.getProperty(KEY_COLOR), -1);
        this.yVariance = cp2.parseInt(props.getProperty(KEY_Y_VARIANCE), 0);
        this.yOffset = cp2.parseInt(props.getProperty(KEY_Y_OFFSET), 0);
        this.width = width;
        this.height = height;
    }

    private int parseFormat(String str) {
        if (str == null) {
            return 0;
        }
        if ((str = str.trim()).equals(FORMAT_VANILLA_STRING)) {
            return 0;
        }
        if (str.equals(FORMAT_GRID_STRING)) {
            return 1;
        }
        if (str.equals(FORMAT_FIXED_STRING)) {
            return 2;
        }
        CustomColormap.warn("Unknown format: " + str);
        return -1;
    }

    public boolean isValid(String path) {
        if (this.format == 0 || this.format == 1) {
            if (this.source == null) {
                CustomColormap.warn("Source not defined: " + path);
                return false;
            }
            this.readColors();
            if (this.colors == null) {
                return false;
            }
            if (this.color < 0) {
                if (this.format == 0) {
                    this.color = this.getColor(127, 127);
                }
                if (this.format == 1) {
                    this.color = this.getColorGrid(ady.q, new cj(0, 64, 0));
                }
            }
        } else if (this.format == 2) {
            if (this.color < 0) {
                this.color = 0xFFFFFF;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean isValidMatchBlocks(String path) {
        if (this.matchBlocks == null) {
            this.matchBlocks = this.detectMatchBlocks();
            if (this.matchBlocks == null) {
                CustomColormap.warn("Match blocks not defined: " + path);
                return false;
            }
        }
        return true;
    }

    private MatchBlock[] detectMatchBlocks() {
        String idStr;
        int id2;
        afh block = afh.b(this.name);
        if (block != null) {
            return new MatchBlock[]{new MatchBlock(afh.a(block))};
        }
        Pattern p2 = Pattern.compile("^block([0-9]+).*$");
        Matcher m2 = p2.matcher(this.name);
        if (m2.matches() && (id2 = Config.parseInt(idStr = m2.group(1), -1)) >= 0) {
            return new MatchBlock[]{new MatchBlock(id2)};
        }
        ConnectedParser cp2 = new ConnectedParser("Colormap");
        MatchBlock[] mbs = cp2.parseMatchBlock(this.name);
        if (mbs != null) {
            return mbs;
        }
        return null;
    }

    private void readColors() {
        try {
            boolean heightOk;
            this.colors = null;
            if (this.source == null) {
                return;
            }
            String imagePath = this.source + ".png";
            jy loc = new jy(imagePath);
            InputStream is2 = Config.getResourceStream(loc);
            if (is2 == null) {
                return;
            }
            BufferedImage img = bml.a(is2);
            if (img == null) {
                return;
            }
            int imgWidth = img.getWidth();
            int imgHeight = img.getHeight();
            boolean widthOk = this.width < 0 || this.width == imgWidth;
            boolean bl2 = heightOk = this.height < 0 || this.height == imgHeight;
            if (!widthOk || !heightOk) {
                CustomColormap.dbg("Non-standard palette size: " + imgWidth + "x" + imgHeight + ", should be: " + this.width + "x" + this.height + ", path: " + imagePath);
            }
            this.width = imgWidth;
            this.height = imgHeight;
            if (this.width <= 0 || this.height <= 0) {
                CustomColormap.warn("Invalid palette size: " + imgWidth + "x" + imgHeight + ", path: " + imagePath);
                return;
            }
            this.colors = new int[imgWidth * imgHeight];
            img.getRGB(0, 0, imgWidth, imgHeight, this.colors, 0, imgWidth);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    private static void dbg(String str) {
        Config.dbg("CustomColors: " + str);
    }

    private static void warn(String str) {
        Config.warn("CustomColors: " + str);
    }

    private static String parseTexture(String texStr, String path, String basePath) {
        int pos2;
        if (texStr != null) {
            String png;
            if ((texStr = texStr.trim()).endsWith(png = ".png")) {
                texStr = texStr.substring(0, texStr.length() - png.length());
            }
            texStr = CustomColormap.fixTextureName(texStr, basePath);
            return texStr;
        }
        String str = path;
        int pos = str.lastIndexOf(47);
        if (pos >= 0) {
            str = str.substring(pos + 1);
        }
        if ((pos2 = str.lastIndexOf(46)) >= 0) {
            str = str.substring(0, pos2);
        }
        str = CustomColormap.fixTextureName(str, basePath);
        return str;
    }

    private static String fixTextureName(String iconName, String basePath) {
        String pathBlocks;
        if (!((iconName = TextureUtils.fixResourcePath(iconName, basePath)).startsWith(basePath) || iconName.startsWith("textures/") || iconName.startsWith("mcpatcher/"))) {
            iconName = basePath + "/" + iconName;
        }
        if (iconName.endsWith(".png")) {
            iconName = iconName.substring(0, iconName.length() - 4);
        }
        if (iconName.startsWith(pathBlocks = "textures/blocks/")) {
            iconName = iconName.substring(pathBlocks.length());
        }
        if (iconName.startsWith("/")) {
            iconName = iconName.substring(1);
        }
        return iconName;
    }

    public boolean matchesBlock(aly blockState) {
        return Matches.block(blockState, this.matchBlocks);
    }

    public int getColorRandom() {
        if (this.format == 2) {
            return this.color;
        }
        int index = CustomColors.random.nextInt(this.colors.length);
        return this.colors[index];
    }

    public int getColor(int index) {
        index = Config.limit(index, 0, this.colors.length - 1);
        return this.colors[index] & 0xFFFFFF;
    }

    public int getColor(int cx2, int cy2) {
        cx2 = Config.limit(cx2, 0, this.width - 1);
        cy2 = Config.limit(cy2, 0, this.height - 1);
        return this.colors[cy2 * this.width + cx2] & 0xFFFFFF;
    }

    public float[][] getColorsRgb() {
        if (this.colorsRgb == null) {
            this.colorsRgb = CustomColormap.toRgb(this.colors);
        }
        return this.colorsRgb;
    }

    @Override
    public int getColor(alz blockState, adq blockAccess, cj blockPos) {
        return this.getColor(blockAccess, blockPos);
    }

    public int getColor(adq blockAccess, cj blockPos) {
        ady biome = CustomColors.getColorBiome(blockAccess, blockPos);
        return this.getColor(biome, blockPos);
    }

    @Override
    public boolean isColorConstant() {
        return this.format == 2;
    }

    public int getColor(ady biome, cj blockPos) {
        if (this.format == 0) {
            return this.getColorVanilla(biome, blockPos);
        }
        if (this.format == 1) {
            return this.getColorGrid(biome, blockPos);
        }
        return this.color;
    }

    public int getColorSmooth(adq blockAccess, double x2, double y2, double z2, int radius) {
        if (this.format == 2) {
            return this.color;
        }
        int x0 = ns.c(x2);
        int y0 = ns.c(y2);
        int z0 = ns.c(z2);
        int sumRed = 0;
        int sumGreen = 0;
        int sumBlue = 0;
        int count = 0;
        BlockPosM blockPosM = new BlockPosM(0, 0, 0);
        for (int ix2 = x0 - radius; ix2 <= x0 + radius; ++ix2) {
            for (int iz2 = z0 - radius; iz2 <= z0 + radius; ++iz2) {
                blockPosM.setXyz(ix2, y0, iz2);
                int col = this.getColor(blockAccess, (cj)blockPosM);
                sumRed += col >> 16 & 0xFF;
                sumGreen += col >> 8 & 0xFF;
                sumBlue += col & 0xFF;
                ++count;
            }
        }
        int r2 = sumRed / count;
        int g2 = sumGreen / count;
        int b2 = sumBlue / count;
        return r2 << 16 | g2 << 8 | b2;
    }

    private int getColorVanilla(ady biome, cj blockPos) {
        double temperature = ns.a(biome.a(blockPos), 0.0f, 1.0f);
        double rainfall = ns.a(biome.i(), 0.0f, 1.0f);
        int cx2 = (int)((1.0 - temperature) * (double)(this.width - 1));
        int cy2 = (int)((1.0 - (rainfall *= temperature)) * (double)(this.height - 1));
        return this.getColor(cx2, cy2);
    }

    private int getColorGrid(ady biome, cj blockPos) {
        int cx2 = biome.az;
        int cy2 = blockPos.o() - this.yOffset;
        if (this.yVariance > 0) {
            int seed = blockPos.n() << 16 + blockPos.p();
            int rand = Config.intHash(seed);
            int range = this.yVariance * 2 + 1;
            int diff = (rand & 0xFF) % range - this.yVariance;
            cy2 += diff;
        }
        return this.getColor(cx2, cy2);
    }

    public int getLength() {
        if (this.format == 2) {
            return 1;
        }
        return this.colors.length;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    private static float[][] toRgb(int[] cols) {
        float[][] colsRgb = new float[cols.length][3];
        for (int i2 = 0; i2 < cols.length; ++i2) {
            int col = cols[i2];
            float rf2 = (float)(col >> 16 & 0xFF) / 255.0f;
            float gf2 = (float)(col >> 8 & 0xFF) / 255.0f;
            float bf2 = (float)(col & 0xFF) / 255.0f;
            float[] colRgb = colsRgb[i2];
            colRgb[0] = rf2;
            colRgb[1] = gf2;
            colRgb[2] = bf2;
        }
        return colsRgb;
    }

    public void addMatchBlock(MatchBlock mb2) {
        if (this.matchBlocks == null) {
            this.matchBlocks = new MatchBlock[0];
        }
        this.matchBlocks = (MatchBlock[])Config.addObjectToArray(this.matchBlocks, mb2);
    }

    public void addMatchBlock(int blockId, int metadata) {
        MatchBlock mb2 = this.getMatchBlock(blockId);
        if (mb2 != null) {
            if (metadata >= 0) {
                mb2.addMetadata(metadata);
            }
            return;
        }
        this.addMatchBlock(new MatchBlock(blockId, metadata));
    }

    private MatchBlock getMatchBlock(int blockId) {
        if (this.matchBlocks == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.matchBlocks.length; ++i2) {
            MatchBlock mb2 = this.matchBlocks[i2];
            if (mb2.getBlockId() != blockId) continue;
            return mb2;
        }
        return null;
    }

    public int[] getMatchBlockIds() {
        if (this.matchBlocks == null) {
            return null;
        }
        HashSet<Integer> setIds = new HashSet<Integer>();
        for (int i2 = 0; i2 < this.matchBlocks.length; ++i2) {
            MatchBlock mb2 = this.matchBlocks[i2];
            if (mb2.getBlockId() < 0) continue;
            setIds.add(mb2.getBlockId());
        }
        Integer[] ints = setIds.toArray(new Integer[setIds.size()]);
        int[] ids = new int[ints.length];
        for (int i3 = 0; i3 < ints.length; ++i3) {
            ids[i3] = ints[i3];
        }
        return ids;
    }

    public String toString() {
        return "" + this.basePath + "/" + this.name + ", blocks: " + Config.arrayToString(this.matchBlocks) + ", source: " + this.source;
    }
}

