{
	File:		Perf.p

	Copyright:	 1983-1993 by Apple Computer, Inc.
				All rights reserved.

	Version:	System 7.1 for ETO #11
	Created:	Tuesday, March 30, 1993 18:00

}

{$IFC UNDEFINED UsingIncludes}
{$SETC UsingIncludes := 0}
{$ENDC}

{$IFC NOT UsingIncludes}
	UNIT Perf;
	INTERFACE
{$ENDC}

{$IFC UNDEFINED UsingPerf}
{$SETC UsingPerf := 1}

{$I+}
{$SETC PerfIncludes := UsingIncludes}
{$SETC UsingIncludes := 1}
{$IFC UNDEFINED UsingTypes}
{$I $$Shell(PInterfaces)Types.p}
{$ENDC}
{$SETC UsingIncludes := PerfIncludes}

TYPE

PLongs = ^ALongs;
ALongs = ARRAY [1..8000] OF LONGINT;

PInts = ^AInts;
HInts = ^PInts;

AInts = ARRAY [1..8000] OF INTEGER;

{ PerfGlobals are declared as a record, so main program can allocate
as globals, desk accessory can add to globals allocated via pointer,
print driver can allocate via low memory, etc. }


TP2PerfGlobals = ^TPerfGlobals;
TPerfGlobals = RECORD
	startROM: LONGINT;			{ROM Base}
	romHits: LONGINT;			{used if MeasureROM is false}
	misses: LONGINT;			{count of PC values outside measured memory}
	segArray: PLongs;			{array of segment handles}
	sizeArray: PLongs;			{array of segment sizes}
	idArray: HInts; 			{array of segment rsrc IDs}
	baseArray: PLongs;			{array of offsets to counters for each segment}
	samples: PLongs;			{samples buffer}
	buffSize: LONGINT;			{size of samples buffer in bytes}
	timeInterval: INTEGER;		{number of clock intervals between interrupts}
	bucketSize: INTEGER;		{size of buckets power of 2}
	log2buckSize: INTEGER;		{used in CvtPC}
	pcOffset: INTEGER;			{offset to the user PC at interrupt time.}
	numMeasure: INTEGER;		{# Code segments (w/o jump table)- ROM etc.}
	firstCode: INTEGER; 		{index of first Code segment}
	takingSamples: BOOLEAN; 	{true if sampling is enabled}
	measureROM: BOOLEAN;
	measureCode: BOOLEAN;
	ramSeg: INTEGER;			{index of "segment" record to cover RAM > 0 if RAM (misses) are to be bucketed.}
	ramBase: LONGINT;			{beginning of RAM being measured.}
	measureRAMbucketSize: INTEGER;
	measureRAMlog2buckSize: INTEGER;
	romVersion: INTEGER;
	vRefNum: INTEGER;			{Volume where the report file is to be created}
	volumeSelected: BOOLEAN;	{True if user selects the report file name}
	rptFileName: Str255;		{Report file name}
	rptFileCreator: Str255; 	{Report File Creator}
	rptFileType: Str255;		{Report File type}
	getResType: ResType;		{Resource type}
	END;



FUNCTION InitPerf(VAR thePerfGlobals: TP2PerfGlobals;timerCount: INTEGER;
	codeAndROMBucketSize: INTEGER;doROM: BOOLEAN;doAppCode: BOOLEAN;appCodeType: Str255;
	romID: INTEGER;romName: Str255;doRAM: BOOLEAN;ramLow: LONGINT;ramHigh: LONGINT;
	ramBucketSize: INTEGER): BOOLEAN;
{ called once to setup Performance monitoring
 }

PROCEDURE TermPerf(thePerfGlobals: TP2PerfGlobals);
{ if InitPerf succeeds then TermPerf must be called before terminating program.
 }

FUNCTION PerfControl(thePerfGlobals: TP2PerfGlobals;turnOn: BOOLEAN): BOOLEAN;
{ Call this to turn off/on measuring.
 Returns previous state.
 }

FUNCTION PerfDump(thePerfGlobals: TP2PerfGlobals;reportFile: Str255;doHistogram: BOOLEAN;
	rptFileColumns: INTEGER): INTEGER;
{ Call this to dump the statistics into a file. }


{$ENDC}    { UsingPerf }

{$IFC NOT UsingIncludes}
	END.
{$ENDC}

