REM What is an engineering sample (ES) processor? https://www.intel.com/content/www/us/en/support/articles/000056190/processors.html
@echo off
setlocal enabledelayedexpansion 
cd %~dp0
for /f "tokens=*" %%i in ( 'dir /b /a:d^|findstr /i forQS' ) do set IntcOEDFolder=%%i
pnputil /delete-driver ".\SynaAPO\AudioService.inf" /uninstall >nul 2>nul
powershell "Get-PnpDevice -FriendlyName '*audio*'|Select-Object -Property HardwareID">[senary_temp].txt
echo. >[inf_list].txt
echo List of inf files installed:>>[inf_list].txt

rem search for  SSID
type [senary_temp].txt|findstr /i "17AA385A 17AA385B 17AA3841 17AA3846 17AA3847 17AA513E 17AA513F 17AA3890 17AA388F 17AA3841 17AA383B 17AA513B 17AA513C 17AA3830 17AA3847 17AA50F9 17AA50FA 17AA50F3 17AA50F5 17AA5134 17AA5135 17AA515D 17AA515E 17AA3819 17AA3818 17AA3816 17AA3817 17AA380C 17AA380D 17AA382A 17AA3829 17AA50E2 17AA50E1 17AA50E6 17AA50E5 17AA384D 17AA384C 17AA384B 17AA384A 17AA3808 17AA3825 17AA509E 17AA3986 17AA50C7 17AA50C8 17AA50C9 17AA50CA 17AA50BD 17AA50BE 17AA50D3 17AA50D1 17AA50D2 17AA3803 17AA3804 17AA381E 17AA381D"
if !errorlevel!==0 (echo pnputil /add-driver ".\%IntcOEDFolder%\IntcOED_OemLibPath.inf" /install
					echo pnputil /add-driver ".\%IntcOEDFolder%\IntcOED_OemLibPath.inf" /install >> [inf_list].txt
					pnputil /add-driver ".\%IntcOEDFolder%\IntcOED_OemLibPath.inf" /install)
rem with Intel dmic inf
type [senary_temp].txt|findstr /i "17AA383E 17AA3840"
if !errorlevel!==0 (echo pnputil /add-driver ".\IntcDMicExt_Senary\IntcDMicExt_Senary.inf" /install
					echo pnputil /add-driver ".\IntcDMicExt_Senary\IntcDMicExt_Senary.inf" /install >> [inf_list].txt
					pnputil /add-driver ".\IntcDMicExt_Senary\IntcDMicExt_Senary.inf" /install)

rem base, ext, support pushbutton
type [senary_temp].txt|findstr /i "17AA385A 17AA385B 17AA3841 17AA3846 17AA3847 17AA383E 17AA3840 17AA3851 17AA3852 17AA384E 17AA384F 17AA3814 17AA3813 17AA3811 17AA380F 17AA3826 17AA3824 17AA383A 17AA383C 17AA3830 17AA3816 17AA3817"
if !errorlevel!==0 goto Install-pushbutton

rem without UWP,without SenaryAPO
type [senary_temp].txt|findstr /i "17AA383B 17AA3840 17AA383E 17AA350B 17AA350E 17AA380E"
if !errorlevel!==0 goto Install-withoutUWP

rem with UWP and SenaryAPO
type [senary_temp].txt|findstr /i "17AA5142 17AA5143 17AA3849 17AA3850 17AA3843 17AA3845 17AA513B 17AA513C 17AA3819 17AA3818 17AA5130 17AA5131 17AA50F9 17AA50FA 17AA50F3 17AA50F5 17AA5132 17AA5133 17AA5134 17AA5135 17AA515D 17AA515E"
if !errorlevel!==0 goto Install-withUWP-SenaryAPO

rem without UWP, with SenaryAPO, support pushbutton
type [senary_temp].txt|findstr /i "17AA3890 17AA388F"
if !errorlevel!==0 goto Install-withoutUWP-SenaryAPO-pushbutton

rem without UWP and SenaryAPO
type [senary_temp].txt|findstr /i "17AA3512 17AA3828"
if !errorlevel!==0 goto Install-withoutUWP-SenaryAPO

rem For other models
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver ".\SynaAPO\cisstrtU-component-OEM.inf" /install
echo pnputil /add-driver ".\SynaAPO\cisstrtU-component-OEM.inf" /install >> [inf_list].txt
pnputil /add-driver ".\SynaAPO\cisstrtU-component-OEM.inf" /install
echo pnputil /add-driver ".\SynaAPO\AudioService.inf" /install
echo pnputil /add-driver ".\SynaAPO\AudioService.inf" /install >> [inf_list].txt
pnputil /add-driver ".\SynaAPO\AudioService.inf" /install
goto end

:Install-pushbutton
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
REM echo pnputil /add-driver "cisstrtU-ext-OEM.inf" /install
REM echo pnputil /add-driver "cisstrtU-ext-OEM.inf" /install >> [inf_list].txt
REM pnputil /add-driver "cisstrtU-ext-OEM.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver ".\SynaAPO\AudioService.inf" /install
echo pnputil /add-driver ".\SynaAPO\AudioService.inf" /install >> [inf_list].txt
pnputil /add-driver ".\SynaAPO\AudioService.inf" /install
goto end

:Install-withoutUWP
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-base.inf" /install
goto end

:Install-withoutUWP-SenaryAPO-pushbutton
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver SenaryAPO/SenaryAPO.inf /install
echo pnputil /add-driver SenaryAPO/SenaryAPO.inf /install >> [inf_list].txt
pnputil /add-driver SenaryAPO/SenaryAPO.inf /install
echo pnputil /add-driver ".\SynaAPO\AudioService.inf" /install
echo pnputil /add-driver ".\SynaAPO\AudioService.inf" /install >> [inf_list].txt
pnputil /add-driver ".\SynaAPO\AudioService.inf" /install

goto end

:Install-withoutUWP-SenaryAPO
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver SenaryAPO/SenaryAPO.inf /install
echo pnputil /add-driver SenaryAPO/SenaryAPO.inf /install >> [inf_list].txt
pnputil /add-driver SenaryAPO/SenaryAPO.inf /install
goto end

:Install-withUWP-SenaryAPO
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-ext-OEM-Lenovo.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver "cisstrtU-base.inf" /install >> [inf_list].txt
pnputil /add-driver "cisstrtU-base.inf" /install
echo pnputil /add-driver ".\SynaAPO\cisstrtU-component-OEM.inf" /install
echo pnputil /add-driver ".\SynaAPO\cisstrtU-component-OEM.inf" /install >> [inf_list].txt
pnputil /add-driver ".\SynaAPO\cisstrtU-component-OEM.inf" /install
echo pnputil /add-driver ".\SynaAPO\AudioService.inf" /install
echo pnputil /add-driver ".\SynaAPO\AudioService.inf" /install >> [inf_list].txt
pnputil /add-driver ".\SynaAPO\AudioService.inf" /install
echo pnputil /add-driver SenaryAPO/SenaryAPO.inf /install
echo pnputil /add-driver SenaryAPO/SenaryAPO.inf /install >> [inf_list].txt
pnputil /add-driver SenaryAPO/SenaryAPO.inf /install

:end
echo. >>[inf_list].txt
type [inf_list].txt
if exist [senary_temp].txt del [senary_temp].txt
if exist [inf_list].txt del [inf_list].txt

REM restart two services
net.exe stop "audioendpointbuilder" /y
net.exe start "audioendpointbuilder"
net stop audiosrv /y
net start audiosrv

