@echo off

REM ********************************************************************
REM * This is a sample batch file to demonstrate manually installing
REM * or removing the PLX PCI/PCIe Service driver.  It utilizes the
REM * Microsoft SC.EXE utility to access the Service Control Manager.
REM * This should work in Windows 2000 & higher.
REM *
REM * Refer to the Usage for additional details.
REM ********************************************************************



REM Verify Admin priviledges
REM  Use FsUtil.exe (returns 1=error 0=ok) to test privileges
FSUTIL >NUL
IF ERRORLEVEL 1 goto _Error_NoAdmin


REM Clear any existing variables
SET _PLX_OS=
SET _PLX_SVC_DIR=
SET _PLX_REG_PARAM=
SET _PLX_PRES_STATE_STOPPED=


REM Determine if Windows XP/2000 vs Vista/7
SET _PLX_OS=WinXP
ver | findstr "5." > NUL
IF ERRORLEVEL 1 SET _PLX_OS=Win7


REM Verify command-line
If /i "%1" == "Preserve" goto _Preserve
If /i "%1" == "Install"  goto _Install
If /i "%1" == "Remove"   goto _Remove
If /i "%1" == "Restore"  goto _Restore
goto _ShowUsage


:_ShowUsage
echo.
echo PlxSvcCtrl - Script to install or remove the PLX PCI Service Driver
echo.
echo   Usage:  PlxSvcCtrl install ^| remove ^| preserve ^| restore
echo.
echo   Where:  install  - Installs the PLX Service driver.
echo                        - Copies PlxSvc.sys to Windows driver folder
echo                        - Creates the PlxSvc service
echo                        - Starts the driver
echo.
echo           remove   - Removes the PLX Service driver.
echo                        - Stops the driver
echo                        - Delete the PlxSvc service
echo                        - Delete the PlxSvc.sys from Windows driver folder
echo.
echo           preserve - Preserves the currently installed PLX Service if exists
echo                        - Stops the driver
echo                        - Delete the PlxSvc service
echo                        - Backup ^& delete PlxSvc.sys from Windows driver folder
echo.
echo           restore  - Restores a previously preserved PLX Service
echo                        - Move backup of PlxSvc.sys to Windows driver folder
echo                        - Creates the PlxSvc service
echo                        - Starts the driver
echo.
echo   Notes:
echo     This script requires administrator priviledges to execute or will fail.
echo.
echo     This script uses the Windows SC.EXE utility to make calls to the
echo     Service Control Manager (SCM), which is responsible for managing
echo     system services. SC allows creation, delete, control, etc. of services.
echo.
echo     For 'install' option, the script expects 2 versions of PlxSvc.sys located
echo     in the following subdirectories from the script file:
echo.
echo      Driver_PlxSvc\i386\PlxSvc.sys  - PLX Service driver for 32-bit Windows
echo      Driver_PlxSvc\Amd64\PlxSvc.sys - PLX Service driver for 64-bit Windows
echo.
echo     Preserve/Restore are there to support a temporary installation of the PLX
echo     Service driver. A system may already have the driver installed, but it may
echo     be an incompatible version. Sample batch that should work in all cases:
echo.
echo         CALL PlxSvcCtrl preserve
echo         CALL PlxSvcCtrl install
echo         REM ** Access device (eg program EEPROM with PlxEEp) **
echo         PlxEep -l MyEeprom.bin -p 8624 -d 0
echo         CALL PlxSvcCtrl remove
echo         CALL PlxSvcCtrl restore
goto _Exit



:_Install
echo.
echo Install the PLX service driver
echo ======================================

REM Determine if 32-bit or 64-bit Windows
SET _PLX_SVC_DIR=Driver_PlxSvc\i386
SET _REG_KEY=HKLM\Hardware\Description\System\CentralProcessor\0
REG QUERY %_REG_KEY% /v Identifier | find /i "x86" > NUL
IF ERRORLEVEL 1 SET _PLX_SVC_DIR=Driver_PlxSvc\amd64
SET _REG_KEY=

REM Verify Service is not installed already (1060=Service not installed)
SC QUERYEX PlxSvc | findstr 1060 > NUL
IF ERRORLEVEL 1 goto _Error_SvcInstalledAlready

REM Verify driver doesn't already exist
IF EXIST %systemRoot%\System32\Drivers\PlxSvc.sys goto _Error_DriverExists

REM Verify correct version of PlxSvs.sys exists
IF NOT EXIST %_PLX_SVC_DIR%\PlxSvc.sys goto _Error_DriverNotFound

echo - Copy %_PLX_SVC_DIR%\PlxSvc.sys --^> %systemRoot%\System32\Drivers...
Copy %_PLX_SVC_DIR%\PlxSvc.sys %systemRoot%\System32\Drivers > NUL

echo - Request SCM to create the service...
SC CREATE PlxSvc binPath= System32\Drivers\PlxSvc.sys type= kernel ^
          start= auto error= ignore DisplayName= "PLX PCI/PCIe Service Driver" > NUL
IF ERRORLEVEL 1073 goto _Error_SvcInstalledAlready
IF ERRORLEVEL 1 goto _Error_SCM

echo - Add the Common Buffer Size option to registry...
REG ADD "HKLM\System\CurrentControlSet\services\PlxSvc" ^
    /v CommonBufferSize /t REG_DWORD /d 8192 > NUL
IF ERRORLEVEL 1 goto _Error_REG

echo - Start the service...
SC START PlxSvc >NUL
IF ERRORLEVEL 1056 goto _Error_SvcAlreadyRunning
IF ERRORLEVEL 1 goto _Error_SCM

echo.
echo   -- PLX PCI/PCIe Service driver installed successfully --
goto _Exit



:_Remove
echo.
echo Remove the PLX service driver
echo ======================================

REM Verify Service is installed already (1060=Service not installed)
SC QUERYEX PlxSvc | findstr 1060 > NUL
IF %ERRORLEVEL% LEQ 0 goto _Error_SvcNotInstalled

echo - Stop the service...
SC STOP PlxSvc >NUL
IF ERRORLEVEL 1062 ECHO    - SCM reports service already stopped

echo - Request SCM to delete the service...
SC DELETE PlxSvc > NUL
IF ERRORLEVEL 1060 goto _Error_SvcNotInstalled
IF ERRORLEVEL 1 goto _Error_SCM

echo - Delete %systemRoot%\System32\Drivers\PlxSvc.sys...
IF EXIST %systemRoot%\System32\Drivers\PlxSvc.sys Del %systemRoot%\System32\Drivers\PlxSvc.sys > NUL

echo.
echo   -- PLX PCI/PCIe Service driver removed successfully --
goto _Exit



:_Preserve
echo.
echo Preserve existing PLX service driver
echo ========================================

REM Verify Service is installed already (1060=Service not installed)
SC QUERYEX PlxSvc | findstr 1060 > NUL
IF %ERRORLEVEL% LEQ 0 echo The SCM reports PLX Service not installed, nothing to preserve
IF %ERRORLEVEL% LEQ 0 goto _Exit
:_SkipCheckPreserve

REM Delete existing state file if exists
IF EXIST .\_Pres_PlxState.bat Del .\_Pres_PlxState.bat > NUL

echo - Stop the service...
SC STOP PlxSvc >NUL
IF ERRORLEVEL 1062 ECHO    - SCM reports service already stopped, saving state
IF ERRORLEVEL 1062 ECHO SET _PLX_PRES_STATE_STOPPED=1>> .\_Pres_PlxState.bat

echo - Backup registry settings...
IF NOT "%_PLX_OS%" == "WinXP" SET _PLX_REG_PARAM=/y
REG SAVE "HKLM\System\CurrentControlSet\services\PlxSvc" .\_Pres_PlxReg.hiv %_PLX_REG_PARAM% > NUL
IF ERRORLEVEL 1 goto _Error_REG

echo - Request SCM to delete the service...
SC DELETE PlxSvc > NUL
IF ERRORLEVEL 1060 goto _Error_SvcNotInstalled
IF ERRORLEVEL 1 goto _Error_SCM

echo - Backup ^& Delete %systemRoot%\System32\Drivers\PlxSvc.sys...
Copy %systemRoot%\System32\Drivers\PlxSvc.sys .\_Pres_PlxSvc.sys > NUL
Del %systemRoot%\System32\Drivers\PlxSvc.sys > NUL

echo.
echo   -- PLX PCI/PCIe Service driver preserved ^& removed successfully --
goto _Exit



:_Restore
echo.
echo Restore previously preserved PLX service driver
echo =================================================

REM Verify Service is not installed already (1060=Service not installed)
SC QUERYEX PlxSvc | findstr 1060 > NUL
IF ERRORLEVEL 1 goto _Error_SvcInstalledAlready
:_SkipCheckRestore

REM Verify driver doesn't already exist
IF EXIST %systemRoot%\System32\Drivers\PlxSvc.sys goto _Error_DriverExists

REM Verify preserved backup of PlxSvs.sys exists
IF NOT EXIST .\_Pres_PlxSvc.sys goto _Error_PreservedDriverNotFound

REM Get previous driver stopped state
IF EXIST .\_Pres_PlxState.bat SET _PLX_PRES_STATE_STOPPED=1

echo - Copy backup of PlxSvc.sys --^> %systemRoot%\System32\Drivers...
Copy .\_Pres_PlxSvc.sys %systemRoot%\System32\Drivers\PlxSvc.sys > NUL

echo - Request SCM to create the service...
SC CREATE PlxSvc binPath= System32\Drivers\PlxSvc.sys type= kernel ^
          start= auto error= ignore DisplayName= "PLX PCI/PCIe Service Driver" > NUL
IF ERRORLEVEL 1073 goto _Error_SvcInstalledAlready
IF ERRORLEVEL 1 goto _Error_SCM

IF NOT EXIST .\_Pres_PlxReg.hiv goto _Skip_RegRestore
echo - Restore registry settings...
REG RESTORE "HKLM\System\CurrentControlSet\services\PlxSvc" .\_Pres_PlxReg.hiv > NUL
IF ERRORLEVEL 1 goto _Error_REG
:_Skip_RegRestore

echo - Start the service...
IF "%_PLX_PRES_STATE_STOPPED%" == "1" echo    - Preserved service was in STOPPED state, skipping START...
IF "%_PLX_PRES_STATE_STOPPED%" == "1" goto _End_StartService
SC START PlxSvc >NUL
IF ERRORLEVEL 1056 goto _Error_SvcAlreadyRunning
IF ERRORLEVEL 1 goto _Error_SCM

:_End_StartService
IF EXIST .\_Pres_PlxState.bat Del .\_Pres_PlxState.bat > NUL
Del .\_Pres_PlxReg.hiv > NUL
Del .\_Pres_PlxSvc.sys > NUL

echo.
echo   -- PLX PCI/PCIe Service restored successfully --
goto _Exit



REM *******************************************************
REM * Error Handlers
REM *******************************************************
:_Error_NoAdmin
echo ERROR: This script must be executed with Administrator priviledges.
goto _Exit


:_Error_DriverExists
echo ERROR: PlxSvc.sys already exists in %systemRoot%\System32\Drivers
echo        Please delete this file and re-run the scipt.
goto _Exit


:_Error_DriverNotFound
echo ERROR: PlxSvc.sys not found in %_PLX_SVC_DIR%
goto _Exit


:_Error_PreservedDriverNotFound
echo ERROR: _Pres_PlxSvc.sys not found in current dir (%CD%)
goto _Exit


:_Error_SvcInstalledAlready
echo ERROR: The SCM reports the PLX Service is already installed
goto _Exit


:_Error_SvcNotInstalled
echo ERROR: The SCM reports the PLX Service is not installed
goto _Exit


:_Error_SvcAlreadyRunning
echo ERROR: The SCM reports the PLX Service is already running
goto _Exit


:_Error_SCM
echo ERROR: The SCM reported error code %ERRORLEVEL%
goto _Exit


:_Error_REG
echo ERROR: The Registry operation resulted in error code %ERRORLEVEL%
goto _Exit


:_Exit
SET _PLX_OS=
SET _PLX_SVC_DIR=
SET _PLX_REG_PARAM=
SET _PLX_PRES_STATE_STOPPED=
