/*
 * Intel ACPI Component Architecture
 * AML Disassembler version 20080926
 *
 * Disassembly of ./dsdt.dat, Thu Apr 23 00:46:43 2009
 *
 *
 * Original Table Header:
 *     Signature        "DSDT"
 *     Length           0x00007F81 (32641)
 *     Revision         0x01 **** ACPI 1.0, no 64-bit math support
 *     Checksum         0xCB
 *     OEM ID           "361A0"
 *     OEM Table ID     "361A0F11"
 *     OEM Revision     0x00000F11 (3857)
 *     Compiler ID      "INTL"
 *     Compiler Version 0x20060317 (537264919)
 */
DefinitionBlock ("./dsdt.aml", "DSDT", 1, "361A0", "361A0F11", 0x00000F11)
{
    Scope (_PR)
    {
        Processor (P001, 0x01, 0x00000810, 0x06) {}
        Alias (P001, CPU1)
    }

    Scope (_PR)
    {
        Processor (P002, 0x02, 0x00000810, 0x06) {}
        Alias (P002, CPU2)
    }

    Name (DP80, 0x80)
    Name (DP90, 0x90)
    Name (APIC, One)
    Name (PMBS, 0x0800)
    Name (PMLN, 0x80)
    Name (GPBS, 0x0480)
    Name (GPLN, 0x40)
    Name (SMBS, Zero)
    Name (SMBL, Zero)
    Name (PM30, 0x0830)
    Name (SUSW, 0xFF)
    Name (SMIR, 0xB2)
    Name (TPBA, 0xFED40000)
    Name (TPBL, Zero)
    Name (SMIP, 0xB2)
    Name (PCIB, 0xE0000000)
    Name (PCIL, 0x04000000)
    OperationRegion (BIOS, SystemMemory, 0x7F7BE064, 0x0200)
    Field (BIOS, ByteAcc, NoLock, Preserve)
    {
        SS1,    1, 
        SS2,    1, 
        SS3,    1, 
        SS4,    1, 
                Offset (0x01), 
        IOST,   16, 
        TOPM,   32, 
        ROMS,   32, 
        MG1B,   32, 
        MG1L,   32, 
        MG2B,   32, 
        MG2L,   32, 
                Offset (0x1C), 
        DMAX,   8, 
        HPTA,   32, 
        CPB0,   32, 
        CPB1,   32, 
        CPB2,   32, 
        CPB3,   32, 
        ASSB,   8, 
        AOTB,   8, 
        AAXB,   32, 
        SMIF,   8, 
        DTSE,   8, 
        DTS1,   8, 
        DTS2,   8, 
        MPEN,   8, 
        TPMF,   8, 
        MG3B,   32, 
        MG3L,   32, 
        MH1B,   32, 
        MH1L,   32, 
            ,   5, 
        ECAR,   3, 
        EWAT,   1, 
        EGAT,   1
    }

    Name (CARR, Zero)
    Name (CWAT, Zero)
    Name (CGAT, Zero)
    Method (RRIO, 4, NotSerialized)
    {
        Store ("RRIO", Debug)
    }

    Method (RDMA, 3, NotSerialized)
    {
        Store ("rDMA", Debug)
    }

    Name (PICM, Zero)
    Method (_PIC, 1, NotSerialized)
    {
        If (Arg0)
        {
            Store (0xAA, DBG8)
        }
        Else
        {
            Store (0xAC, DBG8)
        }

        Store (Arg0, PICM)
    }

    Name (HOTP, Zero)
    Name (OSVR, Ones)
    Method (OSFL, 0, NotSerialized)
    {
        If (LNotEqual (OSVR, Ones))
        {
            Return (OSVR)
        }

        If (LEqual (PICM, Zero))
        {
            Store (0xAC, DBG8)
        }

        Store (One, OSVR)
        If (MCTH (_OS, "Symphony"))
        {
            Store (Zero, OSVR)
            If (CondRefOf (_OSI, Local1))
            {
                If (_OSI ("ethernet_hotplug"))
                {
                    Store (One, HOTP)
                }

                If (_OSI ("video_repost"))
                {
                    Store (0x03, OSVR)
                }
            }

            Return (OSVR)
        }

        If (MCTH (_OS, "Linux"))
        {
            Store (0x03, OSVR)
            Return (OSVR)
        }

        If (CondRefOf (_OSI, Local1))
        {
            If (_OSI ("Windows 2000"))
            {
                Store (0x04, OSVR)
            }

            If (_OSI ("Windows 2001"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2001 SP1"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2001 SP2"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2001 SP3"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2001.1"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2001.1 SP1"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Windows 2006"))
            {
                Store (Zero, OSVR)
            }

            If (_OSI ("Symphony")) {}
            If (_OSI ("Linux")) {}
            If (LEqual (OSVR, Zero))
            {
                Store (One, HOTP)
            }
        }
        Else
        {
            If (MCTH (_OS, "Microsoft Windows NT"))
            {
                Store (0x04, OSVR)
            }
            Else
            {
                If (MCTH (_OS, "Microsoft WindowsME: Millennium Edition"))
                {
                    Store (0x02, OSVR)
                }

                If (MCTH (_OS, "Linux"))
                {
                    Store (0x03, OSVR)
                }
            }
        }

        Return (OSVR)
    }

    Method (MCTH, 2, NotSerialized)
    {
        If (LLess (SizeOf (Arg0), SizeOf (Arg1)))
        {
            Return (Zero)
        }

        Add (SizeOf (Arg0), One, Local0)
        Name (BUF0, Buffer (Local0) {})
        Name (BUF1, Buffer (Local0) {})
        Store (Arg0, BUF0)
        Store (Arg1, BUF1)
        While (Local0)
        {
            Decrement (Local0)
            If (LNotEqual (DerefOf (Index (BUF0, Local0)), DerefOf (Index (
                BUF1, Local0))))
            {
                Return (Zero)
            }
        }

        Return (One)
    }

    Name (PRWP, Package (0x02)
    {
        Zero, 
        Zero
    })
    Method (GPRW, 2, NotSerialized)
    {
        Store (Arg0, Index (PRWP, Zero))
        Store (ShiftLeft (SS1, One), Local0)
        Or (Local0, ShiftLeft (SS2, 0x02), Local0)
        Or (Local0, ShiftLeft (SS3, 0x03), Local0)
        Or (Local0, ShiftLeft (SS4, 0x04), Local0)
        If (And (ShiftLeft (One, Arg1), Local0))
        {
            Store (Arg1, Index (PRWP, One))
        }
        Else
        {
            ShiftRight (Local0, One, Local0)
            If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
            {
                FindSetLeftBit (Local0, Index (PRWP, One))
            }
            Else
            {
                FindSetRightBit (Local0, Index (PRWP, One))
            }
        }

        Return (PRWP)
    }

    Name (WAKP, Package (0x02)
    {
        Zero, 
        Zero
    })
    OperationRegion (DE72, SystemIO, 0x72, 0x02)
    Field (DE72, ByteAcc, NoLock, Preserve)
    {
        PO72,   8, 
        PO73,   8
    }

    OperationRegion (DEB0, SystemIO, DP80, One)
    Field (DEB0, ByteAcc, NoLock, Preserve)
    {
        DBG8,   8
    }

    OperationRegion (DEB1, SystemIO, DP90, 0x02)
    Field (DEB1, WordAcc, NoLock, Preserve)
    {
        DBG9,   16
    }

    Scope (_SB)
    {
        Name (PR00, Package (0x12)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x03, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001EFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x001EFFFF, 
                One, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKA, 
                Zero
            }
        })
        Name (AR00, Package (0x12)
        {
            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001FFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                Zero, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001DFFFF, 
                0x03, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001EFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x001EFFFF, 
                One, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x001BFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x001CFFFF, 
                0x03, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x10
            }
        })
        Name (PR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR05, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKB, 
                Zero
            }
        })
        Name (AR06, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x11
            }
        })
        Name (PR07, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKC, 
                Zero
            }
        })
        Name (AR07, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x12
            }
        })
        Name (PR08, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKD, 
                Zero
            }
        })
        Name (AR08, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x13
            }
        })
        Name (PR09, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKA, 
                Zero
            }
        })
        Name (AR09, Package (0x04)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x10
            }
        })
        Name (PR01, Package (0x18)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                One, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x02, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x03, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                LNKD, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x03, 
                LNKG, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                Zero, 
                LNKC, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                One, 
                LNKH, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x02, 
                LNKA, 
                Zero
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x03, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                Zero, 
                LNKB, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                One, 
                LNKE, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x02, 
                LNKF, 
                Zero
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x03, 
                LNKG, 
                Zero
            }
        })
        Name (AR01, Package (0x18)
        {
            Package (0x04)
            {
                0xFFFF, 
                Zero, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0xFFFF, 
                One, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x02, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0xFFFF, 
                0x03, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                Zero, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                One, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x02, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0001FFFF, 
                0x03, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                One, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x02, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0002FFFF, 
                0x03, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                Zero, 
                Zero, 
                0x13
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                One, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x02, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x0003FFFF, 
                0x03, 
                Zero, 
                0x16
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                Zero, 
                Zero, 
                0x12
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                One, 
                Zero, 
                0x17
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x02, 
                Zero, 
                0x10
            }, 

            Package (0x04)
            {
                0x0004FFFF, 
                0x03, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                Zero, 
                Zero, 
                0x11
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                One, 
                Zero, 
                0x14
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x02, 
                Zero, 
                0x15
            }, 

            Package (0x04)
            {
                0x0005FFFF, 
                0x03, 
                Zero, 
                0x16
            }
        })
        Name (PRSA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {3,4,5,6,7,10,11,12,14,15}
        })
        Alias (PRSA, PRSB)
        Alias (PRSA, PRSC)
        Alias (PRSA, PRSD)
        Alias (PRSA, PRSE)
        Alias (PRSA, PRSF)
        Alias (PRSA, PRSG)
        Alias (PRSA, PRSH)
        Device (PCI0)
        {
            Name (_HID, EisaId ("PNP0A08"))
            Name (_ADR, Zero)
            Method (^BN00, 0, NotSerialized)
            {
                Return (Zero)
            }

            Method (_BBN, 0, NotSerialized)
            {
                Return (BN00 ())
            }

            Name (_UID, Zero)
            Method (_PRT, 0, NotSerialized)
            {
                If (PICM)
                {
                    Return (AR00)
                }

                Return (PR00)
            }

            Method (_S3D, 0, NotSerialized)
            {
                If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                {
                    Return (0x02)
                }
                Else
                {
                    Return (0x03)
                }
            }

            Name (_CID, EisaId ("PNP0A03"))
            Device (MCH)
            {
                Name (_HID, EisaId ("PNP0C01"))
                Name (_UID, 0x0A)
                Name (_CRS, ResourceTemplate ()
                {
                    Memory32Fixed (ReadWrite,
                        0xFED13000,         // Address Base
                        0x00007000,         // Address Length
                        )
                })
            }

            Method (NPTS, 1, NotSerialized)
            {
            }

            Method (NWAK, 1, NotSerialized)
            {
            }

            Device (P0P2)
            {
                Name (_ADR, 0x00010000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
            }

            Device (P0P1)
            {
                Name (_ADR, 0x001E0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0B, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR01)
                    }

                    Return (PR01)
                }
            }

            Device (SBRG)
            {
                Name (_ADR, 0x001F0000)
                Device (IELK)
                {
                    Name (_HID, "AWY0001")
                    OperationRegion (RXA0, PCI_Config, 0xA0, 0x20)
                    Field (RXA0, ByteAcc, NoLock, Preserve)
                    {
                            ,   9, 
                        PBLV,   1, 
                                Offset (0x10), 
                            ,   1, 
                        PBMS,   1, 
                            ,   1, 
                        PMCS,   1, 
                        ECNS,   1, 
                                Offset (0x11), 
                        ECT1,   16, 
                        ELEN,   1, 
                                Offset (0x14)
                    }

                    Method (\_GPE._L0A, 0, NotSerialized)
                    {
                        Notify (\_SB.PCI0.SBRG.IELK, 0x81)
                        Store (One, \_SB.PCI0.SBRG.IELK.PMCS)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (ELEN)
                        {
                            Return (0x0F)
                        }
                        Else
                        {
                            Return (Zero)
                        }
                    }

                    Method (SMOD, 1, NotSerialized)
                    {
                    }

                    Method (GPBS, 0, NotSerialized)
                    {
                        Return (XOr (PBLV, One))
                    }
                }

                Method (SPTS, 1, NotSerialized)
                {
                    Store (One, PS1S)
                    Store (One, PS1E)
                    Store (One, SLPS)
                }

                Method (SWAK, 1, NotSerialized)
                {
                    Store (Zero, SLPS)
                    Store (Zero, PS1E)
                }

                OperationRegion (APMP, SystemIO, SMIR, 0x02)
                Field (APMP, ByteAcc, NoLock, Preserve)
                {
                    APMC,   8, 
                    APMS,   8
                }

                OperationRegion (PMS0, SystemIO, PMBS, 0x12)
                Field (PMS0, ByteAcc, NoLock, Preserve)
                {
                        ,   10, 
                    RTCS,   1, 
                        ,   4, 
                    WAKS,   1, 
                            Offset (0x03), 
                    PWBT,   1, 
                            Offset (0x04), 
                            Offset (0x10), 
                        ,   1, 
                    THTD,   3, 
                    THTE,   1
                }

                OperationRegion (SMIE, SystemIO, PM30, 0x08)
                Field (SMIE, ByteAcc, NoLock, Preserve)
                {
                        ,   4, 
                    PS1E,   1, 
                        ,   31, 
                    PS1S,   1, 
                            Offset (0x08)
                }

                Scope (\_SB)
                {
                    Name (SLPS, Zero)
                    OperationRegion (GPFD, SystemIO, 0x0480, 0x3B)
                    Field (GPFD, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x0D), 
                            ,   1, 
                        BTDN,   1, 
                        LANR,   1, 
                                Offset (0x0F), 
                            ,   2, 
                        WAND,   1, 
                        WLAD,   1, 
                        LANL,   1
                    }

                    OperationRegion (SSMI, SystemIO, SMIP, One)
                    Field (SSMI, ByteAcc, NoLock, Preserve)
                    {
                        SMIC,   8
                    }

                    Device (SLPB)
                    {
                        Name (_HID, EisaId ("PNP0C0E"))
                    }
                }

                Device (PIC)
                {
                    Name (_HID, EisaId ("PNP0000"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0020,             // Range Minimum
                            0x0020,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x00A0,             // Range Minimum
                            0x00A0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {2}
                    })
                }

                Device (DMAD)
                {
                    Name (_HID, EisaId ("PNP0200"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        DMA (Compatibility, BusMaster, Transfer8, )
                            {4}
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0081,             // Range Minimum
                            0x0081,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0087,             // Range Minimum
                            0x0087,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0089,             // Range Minimum
                            0x0089,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x008F,             // Range Minimum
                            0x008F,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x00C0,             // Range Minimum
                            0x00C0,             // Range Maximum
                            0x00,               // Alignment
                            0x20,               // Length
                            )
                    })
                }

                Device (TMR)
                {
                    Name (_HID, EisaId ("PNP0100"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0040,             // Range Minimum
                            0x0040,             // Range Maximum
                            0x00,               // Alignment
                            0x04,               // Length
                            )
                        IRQNoFlags ()
                            {0}
                    })
                }

                Device (RTC0)
                {
                    Name (_HID, EisaId ("PNP0B00"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0070,             // Range Minimum
                            0x0070,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IRQNoFlags ()
                            {8}
                    })
                }

                Device (PS2K)
                {
                    Name (_HID, EisaId ("PNP0303"))
                    Name (_CID, EisaId ("PNP030B"))
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0A, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0060,             // Range Minimum
                            0x0060,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0064,             // Range Minimum
                            0x0064,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IRQNoFlags ()
                            {1}
                    })
                }

                Device (PS2M)
                {
                    Name (_HID, EisaId ("SYN1E02"))
                    Name (_CID, Package (0x03)
                    {
                        EisaId ("SYN1E00"), 
                        EisaId ("SYN0002"), 
                        EisaId ("PNP0F13")
                    })
                    Method (_STA, 0, NotSerialized)
                    {
                        ShiftLeft (One, 0x0C, Local0)
                        If (And (IOST, Local0))
                        {
                            Return (0x0F)
                        }

                        Return (Zero)
                    }

                    Name (_CRS, ResourceTemplate ()
                    {
                        IRQNoFlags ()
                            {12}
                    })
                }

                Device (SPKR)
                {
                    Name (_HID, EisaId ("PNP0800"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0061,             // Range Minimum
                            0x0061,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                    })
                }

                Device (COPR)
                {
                    Name (_HID, EisaId ("PNP0C04"))
                    Name (_CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x00F0,             // Range Minimum
                            0x00F0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IRQNoFlags ()
                            {13}
                    })
                }

                Device (RMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x10)
                    Name (CRS, ResourceTemplate ()
                    {
                        IO (Decode16,
                            0x0010,             // Range Minimum
                            0x0010,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x0022,             // Range Minimum
                            0x0022,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x0044,             // Range Minimum
                            0x0044,             // Range Maximum
                            0x00,               // Alignment
                            0x1C,               // Length
                            )
                        IO (Decode16,
                            0x0063,             // Range Minimum
                            0x0063,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0065,             // Range Minimum
                            0x0065,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0067,             // Range Minimum
                            0x0067,             // Range Maximum
                            0x00,               // Alignment
                            0x09,               // Length
                            )
                        IO (Decode16,
                            0x0072,             // Range Minimum
                            0x0072,             // Range Maximum
                            0x00,               // Alignment
                            0x0E,               // Length
                            )
                        IO (Decode16,
                            0x0080,             // Range Minimum
                            0x0080,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x0084,             // Range Minimum
                            0x0084,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0088,             // Range Minimum
                            0x0088,             // Range Maximum
                            0x00,               // Alignment
                            0x01,               // Length
                            )
                        IO (Decode16,
                            0x008C,             // Range Minimum
                            0x008C,             // Range Maximum
                            0x00,               // Alignment
                            0x03,               // Length
                            )
                        IO (Decode16,
                            0x0090,             // Range Minimum
                            0x0090,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x00A2,             // Range Minimum
                            0x00A2,             // Range Maximum
                            0x00,               // Alignment
                            0x1E,               // Length
                            )
                        IO (Decode16,
                            0x00E0,             // Range Minimum
                            0x00E0,             // Range Maximum
                            0x00,               // Alignment
                            0x10,               // Length
                            )
                        IO (Decode16,
                            0x04D0,             // Range Minimum
                            0x04D0,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0500,             // Range Minimum
                            0x0500,             // Range Maximum
                            0x00,               // Alignment
                            0x02,               // Length
                            )
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y00)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y01)
                        IO (Decode16,
                            0x0000,             // Range Minimum
                            0x0000,             // Range Maximum
                            0x00,               // Alignment
                            0x00,               // Length
                            _Y02)
                        Memory32Fixed (ReadWrite,
                            0xFED1C000,         // Address Base
                            0x00004000,         // Address Length
                            )
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y03)
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y04)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._MIN, GP00)
                        CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._MAX, GP01)
                        CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y00._LEN, GP0L)
                        Store (PMBS, GP00)
                        Store (PMBS, GP01)
                        Store (PMLN, GP0L)
                        If (SMBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._MIN, GP10)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._MAX, GP11)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y01._LEN, GP1L)
                            Store (SMBS, GP10)
                            Store (SMBS, GP11)
                            Store (SMBL, GP1L)
                        }

                        If (GPBS)
                        {
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._MIN, GP20)
                            CreateWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._MAX, GP21)
                            CreateByteField (CRS, \_SB.PCI0.SBRG.RMSC._Y02._LEN, GP2L)
                            Store (GPBS, GP20)
                            Store (GPBS, GP21)
                            Store (GPLN, GP2L)
                        }

                        CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y03._LEN, TML1)
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y03._BAS, TMB1)
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y04._LEN, TML2)
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.RMSC._Y04._BAS, TMB2)
                        Store (0xFED20000, TMB1)
                        Subtract (TPBA, 0xFED20000, TML1)
                        If (TPMF)
                        {
                            Add (TPBA, TPBL, TMB2)
                        }
                        Else
                        {
                            Add (TPBA, Zero, TMB2)
                        }

                        Subtract (0xFED90000, TMB2, TML2)
                        Return (CRS)
                    }
                }

                Device (HPET)
                {
                    Name (_HID, EisaId ("PNP0103"))
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xFED00000,         // Address Base
                            0x00000400,         // Address Length
                            _Y05)
                    })
                    OperationRegion (^LPCR, SystemMemory, 0xFED1F404, 0x04)
                    Field (LPCR, AnyAcc, NoLock, Preserve)
                    {
                        HPTS,   2, 
                            ,   5, 
                        HPTE,   1, 
                                Offset (0x04)
                    }

                    Method (_STA, 0, NotSerialized)
                    {
                        If (LEqual (OSFL (), Zero))
                        {
                            If (HPTE)
                            {
                                Return (0x0F)
                            }
                        }
                        Else
                        {
                            If (HPTE)
                            {
                                Return (0x0B)
                            }
                        }

                        Return (Zero)
                    }

                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.SBRG.HPET._Y05._BAS, HPT)
                        Multiply (HPTS, 0x1000, Local0)
                        Add (Local0, 0xFED00000, HPT)
                        Return (CRS)
                    }
                }

                OperationRegion (RX80, PCI_Config, Zero, 0xFF)
                Field (RX80, ByteAcc, NoLock, Preserve)
                {
                            Offset (0x80), 
                    LPCD,   16, 
                    LPCE,   16
                }

                Name (DBPT, Package (0x04)
                {
                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 

                    Package (0x08)
                    {
                        0x03F8, 
                        0x02F8, 
                        0x0220, 
                        0x0228, 
                        0x0238, 
                        0x02E8, 
                        0x0338, 
                        0x03E8
                    }, 

                    Package (0x03)
                    {
                        0x0378, 
                        0x0278, 
                        0x03BC
                    }, 

                    Package (0x02)
                    {
                        0x03F0, 
                        0x0370
                    }
                })
                Name (DDLT, Package (0x04)
                {
                    Package (0x02)
                    {
                        Zero, 
                        0xFFF8
                    }, 

                    Package (0x02)
                    {
                        0x04, 
                        0xFF8F
                    }, 

                    Package (0x02)
                    {
                        0x08, 
                        0xFCFF
                    }, 

                    Package (0x02)
                    {
                        0x0C, 
                        0xEFFF
                    }
                })
                Method (RRIO, 4, NotSerialized)
                {
                    If (LAnd (LLessEqual (Arg0, 0x03), LGreaterEqual (Arg0, Zero)))
                    {
                        Store (Match (DerefOf (Index (DBPT, Arg0)), MEQ, Arg2, MTR, 
                            Zero, Zero), Local0)
                        If (LNotEqual (Local0, Ones))
                        {
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), Zero)), 
                                Local1)
                            Store (DerefOf (Index (DerefOf (Index (DDLT, Arg0)), One)), 
                                Local2)
                            ShiftLeft (Local0, Local1, Local0)
                            And (LPCD, Local2, LPCD)
                            Or (LPCD, Local0, LPCD)
                            WX82 (Arg0, Arg1)
                        }
                    }

                    If (LEqual (Arg0, 0x08))
                    {
                        If (LEqual (Arg2, 0x0200))
                        {
                            WX82 (0x08, Arg0)
                        }
                        Else
                        {
                            If (LEqual (Arg2, 0x0208))
                            {
                                WX82 (0x09, Arg0)
                            }
                        }
                    }

                    If (LAnd (LLessEqual (Arg0, 0x0D), LGreaterEqual (Arg0, 0x0A)))
                    {
                        WX82 (Arg0, Arg1)
                    }
                }

                Method (WX82, 2, NotSerialized)
                {
                    ShiftLeft (One, Arg0, Local0)
                    If (Arg1)
                    {
                        Or (LPCE, Local0, LPCE)
                    }
                    Else
                    {
                        Not (Local0, Local0)
                        And (LPCE, Local0, LPCE)
                    }
                }

                Method (RDMA, 3, NotSerialized)
                {
                }

                Device (^PCIE)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, 0x11)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0xE0000000,         // Address Base
                            0x10000000,         // Address Length
                            _Y06)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y06._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.PCI0.PCIE._Y06._LEN, LEN1)
                        Store (PCIB, BAS1)
                        Store (PCIL, LEN1)
                        Return (CRS)
                    }
                }

                Device (OMSC)
                {
                    Name (_HID, EisaId ("PNP0C02"))
                    Name (_UID, Zero)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y07)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y08)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        If (APIC)
                        {
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y07._LEN, ML01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y07._BAS, MB01)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y08._LEN, ML02)
                            CreateDWordField (CRS, \_SB.PCI0.SBRG.OMSC._Y08._BAS, MB02)
                            Store (0xFEC00000, MB01)
                            Store (0x1000, ML01)
                            Store (0xFEE00000, MB02)
                            Store (0x1000, ML02)
                        }

                        Return (CRS)
                    }
                }

                Device (^^RMEM)
                {
                    Name (_HID, EisaId ("PNP0C01"))
                    Name (_UID, One)
                    Name (CRS, ResourceTemplate ()
                    {
                        Memory32Fixed (ReadWrite,
                            0x00000000,         // Address Base
                            0x000A0000,         // Address Length
                            )
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y09)
                        Memory32Fixed (ReadOnly,
                            0x000E0000,         // Address Base
                            0x00020000,         // Address Length
                            _Y0A)
                        Memory32Fixed (ReadWrite,
                            0x00100000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0B)
                        Memory32Fixed (ReadOnly,
                            0x00000000,         // Address Base
                            0x00000000,         // Address Length
                            _Y0C)
                    })
                    Method (_CRS, 0, NotSerialized)
                    {
                        CreateDWordField (CRS, \_SB.RMEM._Y09._BAS, BAS1)
                        CreateDWordField (CRS, \_SB.RMEM._Y09._LEN, LEN1)
                        CreateDWordField (CRS, \_SB.RMEM._Y0A._BAS, BAS2)
                        CreateDWordField (CRS, \_SB.RMEM._Y0A._LEN, LEN2)
                        CreateDWordField (CRS, \_SB.RMEM._Y0B._LEN, LEN3)
                        CreateDWordField (CRS, \_SB.RMEM._Y0C._BAS, BAS4)
                        CreateDWordField (CRS, \_SB.RMEM._Y0C._LEN, LEN4)
                        If (OSFL ()) {}
                        Else
                        {
                            If (MG1B)
                            {
                                If (LGreater (MG1B, 0x000C0000))
                                {
                                    Store (0x000C0000, BAS1)
                                    Subtract (MG1B, BAS1, LEN1)
                                }
                            }
                            Else
                            {
                                Store (0x000C0000, BAS1)
                                Store (0x00020000, LEN1)
                            }

                            If (Add (MG1B, MG1L, Local0))
                            {
                                Store (Local0, BAS2)
                                Subtract (0x00100000, BAS2, LEN2)
                            }
                        }

                        Subtract (MG2B, 0x00100000, LEN3)
                        Store (MH1B, BAS4)
                        Subtract (Zero, BAS4, LEN4)
                        Return (CRS)
                    }
                }

                Name (PM4C, 0x084C)
                Scope (\_SB)
                {
                    Field (BIOS, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x100), 
                        OSIG,   32, 
                        AEAX,   32, 
                        AEBX,   32, 
                        AECX,   32, 
                        AEDX,   32, 
                        AREF,   32, 
                        WBUF,   1024
                    }

                    Name (ETYP, Buffer (One) {})
                    Device (WMID)
                    {
                        Name (WCDS, Package (0x11)
                        {
                            0x04, 
                            0x04, 
                            0x04, 
                            Zero, 
                            0x04, 
                            0x04, 
                            Zero, 
                            Zero, 
                            0x04, 
                            0x04, 
                            0x0C, 
                            Zero, 
                            Zero, 
                            Zero, 
                            Zero, 
                            0x05, 
                            Zero
                        })
                        Name (ZOBF, Buffer (0x0128) {})
                        Method (WHCM, 2, NotSerialized)
                        {
                            CreateDWordField (Arg1, Zero, SNIN)
                            CreateDWordField (Arg1, 0x04, COMD)
                            CreateDWordField (Arg1, 0x08, CMTP)
                            CreateDWordField (Arg1, 0x0C, DASI)
                            If (LEqual (Arg0, One))
                            {
                                Store (Zero, Local0)
                            }

                            If (LEqual (Arg0, 0x02))
                            {
                                Store (0x04, Local0)
                            }

                            If (LEqual (Arg0, 0x03))
                            {
                                Store (0x80, Local0)
                            }

                            If (LEqual (Arg0, 0x04))
                            {
                                Store (0x0400, Local0)
                            }

                            If (LEqual (Arg0, 0x05))
                            {
                                Store (0x1000, Local0)
                            }

                            Store (Buffer (Add (0x08, Local0)) {}, Local1)
                            CreateDWordField (Local1, Zero, SNOU)
                            CreateDWordField (Local1, 0x04, RTCD)
                            Store (0x4C494146, SNOU)
                            If (LGreater (DASI, 0x2000))
                            {
                                Store (0x05, RTCD)
                                Return (Local1)
                            }

                            Store (DASI, Local5)
                            CreateField (Arg1, Zero, Multiply (Add (Local5, 0x10), 0x08), 
                                DAIN)
                            Store (DAIN, WBUF)
                            Store (0x02, RTCD)
                            If (LEqual (SNIN, 0x55434553))
                            {
                                Store (0x03, RTCD)
                                Store (0x66, DBG8)
                                Sleep (0x32)
                                Store (COMD, DBG8)
                                Sleep (0x32)
                                Store (CMTP, DBG8)
                                Sleep (0x32)
                                Store (0x99, DBG8)
                                Sleep (0x32)
                                If (LEqual (COMD, One))
                                {
                                    Store (0x04, RTCD)
                                    If (LEqual (CMTP, One))
                                    {
                                        Store (WGDD (), Local2)
                                        Store (Zero, RTCD)
                                    }

                                    If (LEqual (CMTP, 0x05))
                                    {
                                        Store (WGWS (), Local2)
                                        Store (Zero, RTCD)
                                    }

                                    If (LEqual (CMTP, 0x07))
                                    {
                                        If (DASI)
                                        {
                                            Store (DerefOf (Index (Arg1, 0x10)), Local3)
                                            Store (WGBI (Local3), Local2)
                                            Store (Zero, RTCD)
                                        }
                                        Else
                                        {
                                            Store (0x05, RTCD)
                                        }
                                    }

                                    If (LEqual (CMTP, 0x0A))
                                    {
                                        Store (GHKF (), Local2)
                                        Store (Zero, RTCD)
                                    }

                                    If (LEqual (CMTP, 0x0E))
                                    {
                                        Store (GWID (), Local2)
                                        Store (Zero, RTCD)
                                    }
                                }

                                If (LEqual (COMD, 0x02))
                                {
                                    Store (0x04, RTCD)
                                    If (LAnd (LGreater (CMTP, Zero), LLessEqual (CMTP, 0x11)))
                                    {
                                        If (LLess (DASI, DerefOf (Index (WCDS, Subtract (CMTP, One)
                                            ))))
                                        {
                                            Store (0x05, RTCD)
                                        }
                                        Else
                                        {
                                            CreateDWordField (Arg1, 0x10, DDWD)
                                            If (LEqual (CMTP, 0x05))
                                            {
                                                Store (WSWS (DDWD), Local2)
                                                Store (Zero, RTCD)
                                                WGWE (0x05, Zero)
                                            }

                                            If (LEqual (CMTP, 0x10))
                                            {
                                                Store (SSID (DDWD), Local2)
                                                Store (Zero, RTCD)
                                            }
                                        }
                                    }
                                }

                                If (LEqual (COMD, 0x03)) {}
                                If (LEqual (COMD, 0x00020000)) {}
                                If (LEqual (COMD, 0x00020001)) {}
                                If (LEqual (COMD, 0x00020002)) {}
                            }

                            If (LEqual (RTCD, Zero))
                            {
                                Store (DerefOf (Index (Local2, Zero)), RTCD)
                                If (LEqual (RTCD, Zero))
                                {
                                    If (LLessEqual (DerefOf (Index (Local2, One)), Local0))
                                    {
                                        Store (Zero, Local0)
                                        While (LLess (Local0, DerefOf (Index (Local2, One))))
                                        {
                                            Store (DerefOf (Index (DerefOf (Index (Local2, 0x02)), Local0)), 
                                                Index (Local1, Add (Local0, 0x08)))
                                            Increment (Local0)
                                        }

                                        Store (0x53534150, SNOU)
                                    }
                                    Else
                                    {
                                        Store (0x05, RTCD)
                                    }
                                }
                            }

                            Store (ZOBF, WBUF)
                            Return (Local1)
                        }

                        Method (WFDA, 0, NotSerialized)
                        {
                            If (LOr (LEqual (AECX, Zero), LNotEqual (AEBX, Zero)))
                            {
                                Store (Package (0x02)
                                    {
                                        Zero, 
                                        Zero
                                    }, Local0)
                            }
                            Else
                            {
                                Store (AECX, Local1)
                                Store (Package (0x03)
                                    {
                                        Zero, 
                                        Zero, 
                                        Buffer (Local1) {}
                                    }, Local0)
                            }

                            Store (AEBX, Index (Local0, Zero))
                            If (LEqual (AEBX, Zero))
                            {
                                Store (AECX, Index (Local0, One))
                                If (LNotEqual (AECX, Zero))
                                {
                                    Store (WBUF, Local1)
                                    Store (Zero, Local2)
                                    While (LLess (Local2, AECX))
                                    {
                                        Store (DerefOf (Index (Local1, Local2)), Index (DerefOf (Index (Local0, 
                                            0x02)), Local2))
                                        Increment (Local2)
                                    }
                                }
                            }

                            Return (Local0)
                        }

                        Method (WGWE, 2, NotSerialized)
                        {
                            If (LEqual (WEI1, Zero))
                            {
                                Store (Arg0, WEI1)
                                Store (Arg1, WED1)
                            }
                            Else
                            {
                                Store (Arg0, WEI2)
                                Store (Arg1, WED2)
                            }

                            Notify (WMID, 0x80)
                        }

                        Name (_HID, EisaId ("PNP0C14"))
                        Name (_UID, Zero)
                        Name (WEI1, Zero)
                        Name (WED1, Zero)
                        Name (WEI2, Zero)
                        Name (WED2, Zero)
                        Name (WEVT, Zero)
                        Name (_WDG, Buffer (0xF0)
                        {
                            /* 0000 */    0x34, 0xF0, 0xB7, 0x5F, 0x63, 0x2C, 0xE9, 0x45, 
                            /* 0008 */    0xBE, 0x91, 0x3D, 0x44, 0xE2, 0xC7, 0x07, 0xE4, 
                            /* 0010 */    0x41, 0x41, 0x01, 0x02, 0x79, 0x42, 0xF2, 0x95, 
                            /* 0018 */    0x7B, 0x4D, 0x34, 0x43, 0x93, 0x87, 0xAC, 0xCD, 
                            /* 0020 */    0xC6, 0x7E, 0xF6, 0x1C, 0x80, 0x00, 0x01, 0x08, 
                            /* 0028 */    0x18, 0x43, 0x81, 0x2B, 0xE8, 0x4B, 0x07, 0x47, 
                            /* 0030 */    0x9D, 0x84, 0xA1, 0x90, 0xA8, 0x59, 0xB5, 0xD0, 
                            /* 0038 */    0xA0, 0x00, 0x01, 0x08, 0x21, 0x12, 0x90, 0x05, 
                            /* 0040 */    0x66, 0xD5, 0xD1, 0x11, 0xB2, 0xF0, 0x00, 0xA0, 
                            /* 0048 */    0xC9, 0x06, 0x29, 0x10, 0x41, 0x42, 0x01, 0x00, 
                            /* 0050 */    0xEB, 0x91, 0x4C, 0x1F, 0x5C, 0xDC, 0x0B, 0x46, 
                            /* 0058 */    0x95, 0x1D, 0xC7, 0xCB, 0x9B, 0x4B, 0x8D, 0x5E, 
                            /* 0060 */    0x42, 0x41, 0x01, 0x02, 0x49, 0x4B, 0x11, 0x2D, 
                            /* 0068 */    0xFB, 0x2D, 0x30, 0x41, 0xB8, 0xFE, 0x4A, 0x3C, 
                            /* 0070 */    0x09, 0xE7, 0x51, 0x33, 0x42, 0x43, 0x35, 0x00, 
                            /* 0078 */    0xE3, 0x08, 0x8D, 0x98, 0xF4, 0x68, 0x35, 0x4C, 
                            /* 0080 */    0xAF, 0x3E, 0x6A, 0x1B, 0x81, 0x06, 0xF8, 0x3C, 
                            /* 0088 */    0x42, 0x44, 0x14, 0x00, 0x46, 0x97, 0xEA, 0x14, 
                            /* 0090 */    0x1F, 0xCE, 0x98, 0x40, 0xA0, 0xE0, 0x70, 0x45, 
                            /* 0098 */    0xCB, 0x4D, 0xA7, 0x45, 0x42, 0x45, 0x01, 0x00, 
                            /* 00A0 */    0x28, 0x20, 0x2F, 0x32, 0x84, 0x0F, 0x01, 0x49, 
                            /* 00A8 */    0x98, 0x8E, 0x01, 0x51, 0x76, 0x04, 0x9E, 0x2D, 
                            /* 00B0 */    0x42, 0x46, 0x02, 0x00, 0x3D, 0xDE, 0x32, 0x82, 
                            /* 00B8 */    0x3D, 0x66, 0x27, 0x43, 0xA8, 0xF4, 0xE2, 0x93, 
                            /* 00C0 */    0xAD, 0xB9, 0xBF, 0x05, 0x42, 0x47, 0x00, 0x00, 
                            /* 00C8 */    0x36, 0x64, 0x1F, 0x8F, 0x42, 0x9F, 0xC8, 0x42, 
                            /* 00D0 */    0xBA, 0xDC, 0x0E, 0x94, 0x24, 0xF2, 0x0C, 0x9A, 
                            /* 00D8 */    0x42, 0x48, 0x00, 0x00, 0x35, 0x64, 0x1F, 0x8F, 
                            /* 00E0 */    0x42, 0x9F, 0xC8, 0x42, 0xBA, 0xDC, 0x0E, 0x94, 
                            /* 00E8 */    0x24, 0xF2, 0x0C, 0x9A, 0x42, 0x49, 0x00, 0x00
                        })
                        Method (WMAA, 3, Serialized)
                        {
                            Return (WHCM (Arg1, Arg2))
                        }

                        Method (GSID, 0, NotSerialized)
                        {
                            SWSI (0xEA75, One, 0x10, 0x574D4953, Zero)
                            Return (WFDA ())
                        }

                        Method (WGDD, 0, NotSerialized)
                        {
                            Store (Package (0x03)
                                {
                                    Zero, 
                                    0x04, 
                                    Buffer (0x04) {}
                                }, Local0)
                            Store (0x02, Local1)
                            Store (Local1, Index (DerefOf (Index (Local0, 0x02)), Zero))
                            Store (One, Index (DerefOf (Index (Local0, 0x02)), One))
                            Store (Zero, Index (DerefOf (Index (Local0, 0x02)), 0x02))
                            Return (Local0)
                        }

                        Method (WGWS, 0, NotSerialized)
                        {
                            Store (0x60, DBG8)
                            Sleep (One)
                            Store (Package (0x03)
                                {
                                    Zero, 
                                    0x04, 
                                    Buffer (0x04) {}
                                }, Local0)
                            Store (0x23, Local1)
                            Store (Zero, Local2)
                            Store (Zero, Local3)
                            Store (Zero, Local4)
                            If (EWAT)
                            {
                                Or (Local1, 0x40, Local1)
                            }

                            If (EGAT)
                            {
                                Or (Local1, 0x80, Local1)
                            }

                            Store (ECAR, CARR)
                            Store (EWAT, CWAT)
                            Store (EGAT, CGAT)
                            Or (Local4, Multiply (ECAR, 0x20), Local4)
                            If (^^PCI0.SBRG.EC0.WPST)
                            {
                                Or (Local1, One, Local1)
                            }
                            Else
                            {
                                And (Local1, 0xFE, Local1)
                            }

                            If (^^PCI0.SBRG.EC0.WANP)
                            {
                                Or (Local1, 0x02, Local1)
                            }
                            Else
                            {
                                And (Local1, 0xFD, Local1)
                            }

                            If (^^PCI0.SBRG.EC0.WWST)
                            {
                                Or (Local1, 0x04, Local1)
                            }
                            Else
                            {
                                And (Local1, 0xFB, Local1)
                            }

                            If (^^PCI0.SBRG.EC0.WLAN)
                            {
                                Or (Local2, One, Local2)
                            }
                            Else
                            {
                                And (Local2, 0xFE, Local2)
                            }

                            If (^^PCI0.SBRG.EC0.LWWL)
                            {
                                Or (Local2, 0x02, Local2)
                            }
                            Else
                            {
                                And (Local2, 0xFD, Local2)
                            }

                            If (^^PCI0.SBRG.EC0.F10W)
                            {
                                Or (Local2, 0x04, Local2)
                            }
                            Else
                            {
                                And (Local2, 0xFB, Local2)
                            }

                            If (^^PCI0.SBRG.EC0.WSTS)
                            {
                                Or (Local2, 0x08, Local2)
                            }
                            Else
                            {
                                And (Local2, 0xF7, Local2)
                            }

                            If (^^PCI0.SBRG.EC0.BLUE)
                            {
                                Or (Local3, One, Local3)
                            }
                            Else
                            {
                                And (Local3, 0xFE, Local3)
                            }

                            If (^^PCI0.SBRG.EC0.LWBU)
                            {
                                Or (Local3, 0x02, Local3)
                            }
                            Else
                            {
                                And (Local3, 0xFD, Local3)
                            }

                            If (^^PCI0.SBRG.EC0.F10B)
                            {
                                Or (Local3, 0x04, Local3)
                            }
                            Else
                            {
                                And (Local3, 0xFB, Local3)
                            }

                            If (^^PCI0.SBRG.EC0.WSTS)
                            {
                                Or (Local3, 0x08, Local3)
                            }
                            Else
                            {
                                And (Local3, 0xF7, Local3)
                            }

                            If (^^PCI0.SBRG.EC0.WWAN)
                            {
                                Or (Local4, One, Local4)
                            }
                            Else
                            {
                                And (Local4, 0xFE, Local4)
                            }

                            If (^^PCI0.SBRG.EC0.LWAN)
                            {
                                Or (Local4, 0x02, Local4)
                            }
                            Else
                            {
                                And (Local4, 0xFD, Local4)
                            }

                            If (^^PCI0.SBRG.EC0.F10A)
                            {
                                Or (Local4, 0x04, Local4)
                            }
                            Else
                            {
                                And (Local4, 0xFB, Local4)
                            }

                            If (^^PCI0.SBRG.EC0.WSTS)
                            {
                                Or (Local4, 0x08, Local4)
                            }
                            Else
                            {
                                And (Local4, 0xF7, Local4)
                            }

                            If (^^PCI0.SBRG.EC0.BTIN)
                            {
                                And (Local4, 0xEF, Local4)
                            }
                            Else
                            {
                                Or (Local4, 0x10, Local4)
                            }

                            Store (Local1, Index (DerefOf (Index (Local0, 0x02)), Zero))
                            Store (Local2, Index (DerefOf (Index (Local0, 0x02)), One))
                            Store (Local3, Index (DerefOf (Index (Local0, 0x02)), 0x02))
                            Store (Local4, Index (DerefOf (Index (Local0, 0x02)), 0x03))
                            Return (Local0)
                        }

                        Method (WSWS, 1, NotSerialized)
                        {
                            Store (0x61, DBG8)
                            Sleep (One)
                            If (And (Arg0, 0x0800))
                            {
                                If (And (Arg0, 0x08))
                                {
                                    If (^^PCI0.SBRG.EC0.WPST)
                                    {
                                        Store (One, ^^PCI0.SBRG.EC0.WLAN)
                                    }
                                    Else
                                    {
                                        Store (Zero, ^^PCI0.SBRG.EC0.WLAN)
                                    }

                                    If (^^PCI0.SBRG.EC0.WANP)
                                    {
                                        Store (One, ^^PCI0.SBRG.EC0.BLUE)
                                    }
                                    Else
                                    {
                                        Store (Zero, ^^PCI0.SBRG.EC0.BLUE)
                                    }

                                    If (^^PCI0.SBRG.EC0.WWST)
                                    {
                                        Store (One, ^^PCI0.SBRG.EC0.WWAN)
                                    }
                                    Else
                                    {
                                        Store (Zero, ^^PCI0.SBRG.EC0.WWAN)
                                    }

                                    Store (One, ^^PCI0.SBRG.EC0.LWWL)
                                    Store (One, ^^PCI0.SBRG.EC0.LWBU)
                                    Store (One, ^^PCI0.SBRG.EC0.LWAN)
                                }
                                Else
                                {
                                    Store (Zero, ^^PCI0.SBRG.EC0.WLAN)
                                    Store (Zero, ^^PCI0.SBRG.EC0.BLUE)
                                    Store (Zero, ^^PCI0.SBRG.EC0.WWAN)
                                    Store (Zero, ^^PCI0.SBRG.EC0.LWWL)
                                    Store (Zero, ^^PCI0.SBRG.EC0.LWBU)
                                    Store (Zero, ^^PCI0.SBRG.EC0.LWAN)
                                }
                            }
                            Else
                            {
                                If (And (Arg0, 0x0400))
                                {
                                    If (And (Arg0, 0x04))
                                    {
                                        If (^^PCI0.SBRG.EC0.WWST)
                                        {
                                            Store (One, ^^PCI0.SBRG.EC0.WWAN)
                                        }
                                        Else
                                        {
                                            Store (Zero, ^^PCI0.SBRG.EC0.WWAN)
                                        }

                                        Store (One, ^^PCI0.SBRG.EC0.LWAN)
                                    }
                                    Else
                                    {
                                        Store (Zero, ^^PCI0.SBRG.EC0.WWAN)
                                        Store (Zero, ^^PCI0.SBRG.EC0.LWAN)
                                    }
                                }
                                Else
                                {
                                    If (And (Arg0, 0x0200))
                                    {
                                        If (And (Arg0, 0x02))
                                        {
                                            If (^^PCI0.SBRG.EC0.WANP)
                                            {
                                                Store (One, ^^PCI0.SBRG.EC0.BLUE)
                                            }
                                            Else
                                            {
                                                Store (Zero, ^^PCI0.SBRG.EC0.BLUE)
                                            }

                                            Store (One, ^^PCI0.SBRG.EC0.LWBU)
                                        }
                                        Else
                                        {
                                            Store (Zero, ^^PCI0.SBRG.EC0.BLUE)
                                            Store (Zero, ^^PCI0.SBRG.EC0.LWBU)
                                        }
                                    }
                                    Else
                                    {
                                        If (And (Arg0, 0x0100))
                                        {
                                            If (And (Arg0, One))
                                            {
                                                If (^^PCI0.SBRG.EC0.WPST)
                                                {
                                                    Store (One, ^^PCI0.SBRG.EC0.WLAN)
                                                }
                                                Else
                                                {
                                                    Store (Zero, ^^PCI0.SBRG.EC0.WLAN)
                                                }

                                                Store (One, ^^PCI0.SBRG.EC0.LWWL)
                                            }
                                            Else
                                            {
                                                Store (Zero, ^^PCI0.SBRG.EC0.WLAN)
                                                Store (Zero, ^^PCI0.SBRG.EC0.LWWL)
                                            }
                                        }
                                    }
                                }
                            }

                            If (^^PCI0.SBRG.EC0.BLUE)
                            {
                                Store (Zero, BTDN)
                            }
                            Else
                            {
                                Store (One, BTDN)
                            }

                            If (^^PCI0.SBRG.EC0.WLAN)
                            {
                                Store (One, WLAD)
                            }
                            Else
                            {
                                Store (Zero, WLAD)
                            }

                            If (And (LEqual (^^PCI0.SBRG.EC0.BTIN, One), LEqual (^^PCI0.SBRG.EC0.BUST, One)))
                            {
                                If (^^PCI0.SBRG.EC0.WWAN)
                                {
                                    Store (One, WAND)
                                }
                                Else
                                {
                                    Store (Zero, WAND)
                                }
                            }
                            Else
                            {
                                Store (Zero, WAND)
                            }

                            Store (Package (0x02)
                                {
                                    Zero, 
                                    Zero
                                }, Local0)
                            Store (Zero, Index (Local0, Zero))
                            Store (Zero, Index (Local0, One))
                            Return (Local0)
                        }

                        Method (WGBI, 1, NotSerialized)
                        {
                            If (LLess (Arg0, SizeOf (^^PCI0.SBRG.BAT1.PAK1)))
                            {
                                Return (^^PCI0.SBRG.BAT1.GBTI (Arg0))
                            }
                            Else
                            {
                                Return (Package (0x02)
                                {
                                    0x04, 
                                    Zero
                                })
                            }
                        }

                        Method (WGBN, 0, NotSerialized)
                        {
                            Store (0x0E, Local0)
                            Store (Buffer (0x08)
                                {
                                    /* 0000 */    0x31, 0x01, 0xAE, 0x01, 0xB6, 0x01, 0xB7, 0x01
                                }, Local1)
                            Concatenate (Local1, Buffer (0x06)
                                {
                                    0xFF, 0xFF, 0x3B, 0x21, 0x00, 0x00
                                }, Local2)
                            Store (Package (0x03) {}, Local3)
                            Store (Zero, Index (Local3, Zero))
                            Store (Local0, Index (Local3, One))
                            Store (Local2, Index (Local3, 0x02))
                            Return (Local3)
                        }

                        Method (GHKS, 0, NotSerialized)
                        {
                            Store (Package (0x03)
                                {
                                    Zero, 
                                    0x04, 
                                    Buffer (0x04) {}
                                }, Local0)
                            Store (0x6E, Index (DerefOf (Index (Local0, 0x02)), Zero))
                            Return (Local0)
                        }

                        Method (SHKS, 1, NotSerialized)
                        {
                            ^^PCI0.SBRG.EC0.SSHK (Arg0)
                            Return (Package (0x02)
                            {
                                Zero, 
                                Zero
                            })
                        }

                        Method (HKFR, 0, NotSerialized)
                        {
                            Store (Package (0x03)
                                {
                                    Zero, 
                                    0x04, 
                                    Buffer (0x04) {}
                                }, Local0)
                            Store (HKNO, Local1)
                            If (LEqual (Local1, 0x0D))
                            {
                                Store (0x31, Index (DerefOf (Index (Local0, 0x02)), Zero))
                                Store (One, Index (DerefOf (Index (Local0, 0x02)), One))
                            }

                            If (LEqual (Local1, 0x04)) {}
                            If (LEqual (Local1, 0x08)) {}
                            If (LEqual (Local1, 0x07))
                            {
                                Store (0xF3, DBG8)
                                Sleep (0x012C)
                                Store ("Fn+F3 Pressed", Debug)
                                Store (0xB6, Index (DerefOf (Index (Local0, 0x02)), Zero))
                                Store (One, Index (DerefOf (Index (Local0, 0x02)), One))
                                Store (^^PCI0.SBRG.EC0.BCCL, Local3)
                                Store (^^PCI0.IGD.CSTE, Index (DerefOf (Index (Local0, 0x02)), 0x02))
                                Store (0xFF, Index (DerefOf (Index (Local0, 0x02)), 0x03))
                                Store (Local3, DBG8)
                            }

                            If (LEqual (Local1, 0x08))
                            {
                                Store (0xF4, DBG8)
                                Sleep (0x012C)
                                Store ("Fn+F4 Pressed", Debug)
                                Store (0xB7, Index (DerefOf (Index (Local0, 0x02)), Zero))
                                Store (One, Index (DerefOf (Index (Local0, 0x02)), One))
                                Store (^^PCI0.SBRG.EC0.BCCL, Local3)
                                Store (^^PCI0.IGD.CSTE, Index (DerefOf (Index (Local0, 0x02)), 0x02))
                                Store (0xFF, Index (DerefOf (Index (Local0, 0x02)), 0x03))
                                Store (Local3, DBG8)
                            }

                            Return (Local0)
                        }

                        Method (GHKF, 0, NotSerialized)
                        {
                            Store (0x11, DBG8)
                            Return (HKFR ())
                        }

                        Method (SHKF, 1, NotSerialized)
                        {
                            If (LEqual (Arg0, 0x01AE))
                            {
                                Store (0x04, HKNO)
                            }
                            Else
                            {
                                If (LEqual (Arg0, 0x0131))
                                {
                                    Store (0x0D, HKNO)
                                }
                                Else
                                {
                                    If (LEqual (Arg0, 0x01B6))
                                    {
                                        Store (0x07, HKNO)
                                    }
                                    Else
                                    {
                                        If (LEqual (Arg0, 0x01B7))
                                        {
                                            Store (0x08, HKNO)
                                        }
                                        Else
                                        {
                                            Store (Zero, HKNO)
                                        }
                                    }
                                }
                            }

                            Return (HKFR ())
                        }

                        Method (GWID, 0, NotSerialized)
                        {
                            Store (Zero, Local0)
                            If (LEqual (^^PCI0.SBRG.EC0.WANP, One))
                            {
                                Store (Buffer (0x06)
                                    {
                                        0x02, 0x02, 0x00, 0x00, 0x00, 0x00
                                    }, Local1)
                                Store (0xD3, Index (Local1, 0x02))
                                Store (0x13, Index (Local1, 0x03))
                                Store (0x49, Index (Local1, 0x04))
                                Store (0x32, Index (Local1, 0x05))
                                Add (Local0, 0x06, Local0)
                            }

                            OperationRegion (WLAN, SystemMemory, 0xE0100000, 0x40)
                            Field (WLAN, AnyAcc, NoLock, Preserve)
                            {
                                VIDL,   8, 
                                VIDH,   8, 
                                DIDL,   8, 
                                DIDH,   8, 
                                        Offset (0x2C), 
                                SVDL,   8, 
                                SVDH,   8, 
                                SSDL,   8, 
                                SSDH,   8
                            }

                            If (LNotEqual (VIDL, 0xFF))
                            {
                                Store (Buffer (0x0A)
                                    {
                                        /* 0000 */    0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
                                        /* 0008 */    0x00, 0x00
                                    }, Local2)
                                Store (VIDL, Index (Local2, 0x02))
                                Store (VIDH, Index (Local2, 0x03))
                                Store (DIDL, Index (Local2, 0x04))
                                Store (DIDH, Index (Local2, 0x05))
                                Store (SVDL, Index (Local2, 0x06))
                                Store (SVDH, Index (Local2, 0x07))
                                Store (SSDL, Index (Local2, 0x08))
                                Store (SSDH, Index (Local2, 0x09))
                                If (LEqual (Local0, Zero))
                                {
                                    Store (Local2, Local1)
                                }
                                Else
                                {
                                    Concatenate (Local1, Local2, Local3)
                                    Store (Local3, Local1)
                                }

                                Add (Local0, 0x0A, Local0)
                            }

                            Store (Buffer (0x06)
                                {
                                    0x02, 0x03, 0x00, 0x00, 0x00, 0x00
                                }, Local2)
                            If (LEqual (^^PCI0.SBRG.EC0.WWST, One))
                            {
                                If (LEqual (^^PCI0.SBRG.EC0.HWWD, One))
                                {
                                    Store (0xF0, Index (Local2, 0x02))
                                    Store (0x03, Index (Local2, 0x03))
                                    Store (0x1D, Index (Local2, 0x04))
                                    Store (0x1F, Index (Local2, 0x05))
                                }

                                If (LEqual (^^PCI0.SBRG.EC0.HWWD, 0x02))
                                {
                                    Store (0xB7, Index (Local2, 0x02))
                                    Store (0x1A, Index (Local2, 0x03))
                                    Store (0x30, Index (Local2, 0x04))
                                    Store (0x57, Index (Local2, 0x05))
                                }

                                If (LEqual (Local0, Zero))
                                {
                                    Store (Local2, Local1)
                                }
                                Else
                                {
                                    Concatenate (Local1, Local2, Local3)
                                    Store (Local3, Local1)
                                }

                                Add (Local0, 0x06, Local0)
                            }

                            Store (Package (0x03) {}, Local2)
                            Store (Zero, Index (Local2, Zero))
                            Store (Local0, Index (Local2, One))
                            Store (Local1, Index (Local2, 0x02))
                            Return (Local2)
                        }

                        Method (GSRV, 0, NotSerialized)
                        {
                            Return (WFDA ())
                        }

                        Method (SSID, 1, NotSerialized)
                        {
                            SWSI (0xEA75, 0x02, 0x10, 0x574D4953, Zero)
                            Return (WFDA ())
                        }

                        Name (EVNT, Package (0x03)
                        {
                            Package (0x05)
                            {
                                "BIOS Configuration Change", 
                                "BIOS Settings", 
                                0x04, 
                                0x05, 
                                0x02
                            }, 

                            Package (0x05)
                            {
                                "BIOS Configuration Security", 
                                "An attempt has been made to Access BIOS features unsuccessfully", 
                                0x04, 
                                0x0A, 
                                0x06
                            }, 

                            Package (0x05)
                            {
                                "Unknown Event", 
                                "Unknown event type", 
                                Zero, 
                                Zero, 
                                Zero
                            }
                        })
                        Method (_WED, 1, NotSerialized)
                        {
                            If (LEqual (Arg0, 0xA0))
                            {
                                If (LEqual (DerefOf (Index (ETYP, Zero)), Zero))
                                {
                                    Store (S001, BF2S)
                                    Store (BF2S, Index (DerefOf (Index (EVNT, Zero)), One))
                                    Return (DerefOf (Index (EVNT, Zero)))
                                }

                                If (LEqual (DerefOf (Index (ETYP, Zero)), One))
                                {
                                    Return (DerefOf (Index (EVNT, One)))
                                }
                                Else
                                {
                                    Return (DerefOf (Index (EVNT, 0x02)))
                                }
                            }
                            Else
                            {
                                Concatenate (WEI1, WED1, Local0)
                                If (LNotEqual (WEI2, Zero))
                                {
                                    Store (WEI2, WEI1)
                                    Store (WEI2, WED1)
                                    Store (Zero, WEI2)
                                    Store (Zero, WED2)
                                    If (LEqual (WEVT, Zero))
                                    {
                                        Store (One, WEVT)
                                        Notify (WMID, 0x80)
                                    }
                                }
                                Else
                                {
                                    Store (Zero, WEI1)
                                    Store (Zero, WED1)
                                }

                                Return (Local0)
                            }
                        }

                        Name (S001, Buffer (0x32) {})
                        Name (S002, Buffer (0x8C) {})
                        Name (S003, Buffer (0x8C) {})
                        Name (S014, Buffer (0x32) {})
                        Name (BF01, Buffer (0x32) {})
                        Name (BF02, Buffer (0x32) {})
                        Name (BF03, Buffer (0x96) {})
                        Name (TMP0, Buffer (0x32) {})
                        Name (TMP1, Buffer (0x1E) {})
                        Name (TMP2, Buffer (0x1E) {})
                        Name (S004, "serial port")
                        Name (S010, "Parallel Port")
                        Name (S015, "My asset tag")
                        Name (S006, "Enable")
                        Name (S007, "Disable")
                        Name (S008, " Disable, *Enable")
                        Name (S009, "*Disable,  Enable")
                        Name (S020, Buffer (0x1F) {})
                        Name (S019, " 0, 5, 10, 15, 20, 25, 30, 35")
                        Name (BF3C, "   ")
                        Name (BF2S, "                                                                                             ")
                        Name (BSTR, "                                                                                             ")
                        Method (WMBH, 1, NotSerialized)
                        {
                            Return (Zero)
                        }

                        Method (WMBA, 3, NotSerialized)
                        {
                            Return (One)
                        }

                        Method (WQBC, 1, NotSerialized)
                        {
                            Return (One)
                        }

                        Method (WQBD, 1, NotSerialized)
                        {
                            Return (One)
                        }

                        Method (WQBE, 1, NotSerialized)
                        {
                            Return (One)
                        }

                        Method (WQBF, 1, NotSerialized)
                        {
                            Return (One)
                        }

                        Method (WQBG, 0, NotSerialized)
                        {
                        }

                        Method (WQBH, 0, NotSerialized)
                        {
                        }

                        Method (WQBI, 0, NotSerialized)
                        {
                        }

                        Name (WQAB, Buffer (0x1BA1)
                        {
                            /* 0000 */    0x46, 0x4F, 0x4D, 0x42, 0x01, 0x00, 0x00, 0x00, 
                            /* 0008 */    0x91, 0x1B, 0x00, 0x00, 0x0A, 0xB2, 0x00, 0x00, 
                            /* 0010 */    0x44, 0x53, 0x00, 0x01, 0x1A, 0x7D, 0xDA, 0x54, 
                            /* 0018 */    0xA8, 0x25, 0x95, 0x00, 0x01, 0x06, 0x18, 0x42, 
                            /* 0020 */    0x10, 0x47, 0x10, 0x92, 0x46, 0x62, 0x02, 0x89, 
                            /* 0028 */    0x80, 0x90, 0x18, 0x18, 0x14, 0x81, 0x85, 0x00, 
                            /* 0030 */    0x49, 0x02, 0x88, 0xC4, 0x41, 0xE1, 0x20, 0xD4, 
                            /* 0038 */    0x9F, 0x40, 0x7E, 0x05, 0x20, 0x74, 0x28, 0x40, 
                            /* 0040 */    0xA6, 0x00, 0x83, 0x02, 0x9C, 0x22, 0x88, 0xA0, 
                            /* 0048 */    0x57, 0x01, 0x36, 0x05, 0x98, 0x14, 0x60, 0x51, 
                            /* 0050 */    0x80, 0x76, 0x01, 0x96, 0x05, 0xE8, 0x16, 0x20, 
                            /* 0058 */    0x1D, 0x96, 0x88, 0x04, 0x47, 0x89, 0x01, 0x47, 
                            /* 0060 */    0xE9, 0xC4, 0x16, 0x6E, 0xD8, 0xE0, 0x85, 0xA2, 
                            /* 0068 */    0x68, 0x06, 0x51, 0x12, 0x94, 0x8B, 0x20, 0x5D, 
                            /* 0070 */    0x10, 0x52, 0x2E, 0xC0, 0x37, 0x82, 0x06, 0x10, 
                            /* 0078 */    0xA5, 0x77, 0x01, 0xB6, 0x05, 0x98, 0x86, 0x27, 
                            /* 0080 */    0xD2, 0x20, 0xE4, 0x60, 0x08, 0x54, 0xCE, 0x80, 
                            /* 0088 */    0x20, 0x69, 0x44, 0x21, 0x1E, 0xA7, 0x44, 0x08, 
                            /* 0090 */    0x0A, 0x84, 0x90, 0xD4, 0xF1, 0xA0, 0xA0, 0x71, 
                            /* 0098 */    0x88, 0xAD, 0xCE, 0x46, 0x93, 0xA9, 0x74, 0x7E, 
                            /* 00A0 */    0x48, 0x82, 0x70, 0xC6, 0x2A, 0x7E, 0x3A, 0x9A, 
                            /* 00A8 */    0xD0, 0xD9, 0x9C, 0x60, 0xE7, 0x18, 0x72, 0x3C, 
                            /* 00B0 */    0x48, 0xF4, 0x20, 0xB8, 0x00, 0x0F, 0x1C, 0x2C, 
                            /* 00B8 */    0x34, 0x84, 0x22, 0x6B, 0x80, 0xC1, 0x8C, 0xDD, 
                            /* 00C0 */    0x63, 0xB1, 0x0B, 0x4E, 0x0A, 0xEC, 0x61, 0xB3, 
                            /* 00C8 */    0x01, 0x19, 0xA2, 0x24, 0x38, 0xD4, 0x11, 0xC0, 
                            /* 00D0 */    0x12, 0x05, 0x98, 0x1F, 0x87, 0x0C, 0x0F, 0x95, 
                            /* 00D8 */    0x8C, 0x25, 0x24, 0x1B, 0xAB, 0x87, 0xC2, 0xA5, 
                            /* 00E0 */    0x40, 0x68, 0x6C, 0x27, 0xED, 0x19, 0x45, 0x2C, 
                            /* 00E8 */    0x79, 0x4A, 0x82, 0x49, 0xE0, 0x51, 0x44, 0x36, 
                            /* 00F0 */    0x1A, 0x27, 0x28, 0x1B, 0x1A, 0x25, 0x03, 0x42, 
                            /* 00F8 */    0x9E, 0x05, 0x58, 0x07, 0x26, 0x04, 0x76, 0x2F, 
                            /* 0100 */    0xC0, 0x9A, 0x00, 0x73, 0xB3, 0x90, 0xB1, 0xB9, 
                            /* 0108 */    0xE8, 0xFF, 0x0F, 0x71, 0xB0, 0x31, 0xDA, 0x9A, 
                            /* 0110 */    0xAE, 0x90, 0xC2, 0xC4, 0x88, 0x12, 0x2C, 0x5E, 
                            /* 0118 */    0xC5, 0xC3, 0x10, 0xCA, 0x93, 0x42, 0xA8, 0x48, 
                            /* 0120 */    0x95, 0xA1, 0x68, 0xB4, 0x51, 0x2A, 0x14, 0xE0, 
                            /* 0128 */    0x4C, 0x80, 0x30, 0x5C, 0x1D, 0x03, 0x82, 0x46, 
                            /* 0130 */    0x88, 0x15, 0x29, 0x56, 0xFB, 0x83, 0x20, 0xF1, 
                            /* 0138 */    0x2D, 0x40, 0x54, 0x01, 0xA2, 0x48, 0xA3, 0x41, 
                            /* 0140 */    0x9D, 0x03, 0x3C, 0x5C, 0x0F, 0xF5, 0xF0, 0x3D, 
                            /* 0148 */    0xF6, 0x93, 0x0C, 0x72, 0x90, 0x67, 0xF1, 0xA8, 
                            /* 0150 */    0x70, 0x9C, 0x06, 0x49, 0xE0, 0x0B, 0x80, 0x4F, 
                            /* 0158 */    0x08, 0x1E, 0x38, 0xDE, 0x35, 0xA0, 0x66, 0x7C, 
                            /* 0160 */    0xBC, 0x4C, 0x10, 0x1C, 0x6A, 0x88, 0x1E, 0x68, 
                            /* 0168 */    0xB8, 0x13, 0x38, 0x44, 0x06, 0xE8, 0x49, 0x3D, 
                            /* 0170 */    0x52, 0x60, 0x07, 0x77, 0x32, 0xEF, 0x01, 0xAF, 
                            /* 0178 */    0x0A, 0xCD, 0x5E, 0x12, 0x08, 0xC1, 0xF1, 0xF8, 
                            /* 0180 */    0x7E, 0xC0, 0x26, 0x9C, 0xC0, 0xF2, 0x07, 0x81, 
                            /* 0188 */    0x1A, 0x99, 0xA1, 0x3D, 0xCA, 0xD3, 0x8A, 0x19, 
                            /* 0190 */    0xF2, 0x31, 0xC1, 0x04, 0x16, 0x0B, 0x21, 0x05, 
                            /* 0198 */    0x10, 0x1A, 0x0F, 0xF8, 0x6F, 0x00, 0x8F, 0x17, 
                            /* 01A0 */    0xBE, 0x12, 0xC4, 0xF6, 0x80, 0x12, 0x0C, 0x0B, 
                            /* 01A8 */    0x21, 0x23, 0xAB, 0xF0, 0x78, 0xE8, 0x28, 0x7C, 
                            /* 01B0 */    0x95, 0x38, 0x9C, 0xD3, 0x8A, 0x67, 0x82, 0xE1, 
                            /* 01B8 */    0x20, 0xF4, 0x05, 0x90, 0x00, 0x51, 0xE7, 0x0C, 
                            /* 01C0 */    0xD4, 0x61, 0xC1, 0xE7, 0x04, 0x76, 0x33, 0x38, 
                            /* 01C8 */    0x83, 0x47, 0x00, 0x8F, 0xE4, 0x84, 0xFC, 0x2B, 
                            /* 01D0 */    0xF1, 0xC0, 0xE0, 0x03, 0xE2, 0xEF, 0x1F, 0xA7, 
                            /* 01D8 */    0xEC, 0x11, 0x9C, 0xA9, 0x01, 0x7D, 0x1C, 0xF0, 
                            /* 01E0 */    0xFF, 0x7F, 0x28, 0x7C, 0x88, 0x1E, 0xDF, 0x29, 
                            /* 01E8 */    0x1F, 0xAF, 0x4F, 0x17, 0x96, 0x35, 0x4E, 0xE8, 
                            /* 01F0 */    0x77, 0x08, 0x9F, 0x38, 0x7C, 0x64, 0x71, 0x44, 
                            /* 01F8 */    0x08, 0x39, 0x39, 0x05, 0xA0, 0x81, 0x4F, 0xF7, 
                            /* 0200 */    0xEC, 0x22, 0x9C, 0xAE, 0x27, 0xE5, 0x40, 0xC3, 
                            /* 0208 */    0xA0, 0xE3, 0x04, 0xC7, 0x79, 0x00, 0x1C, 0xE3, 
                            /* 0210 */    0x84, 0x7F, 0x2E, 0x80, 0x3F, 0x40, 0x7E, 0xCA, 
                            /* 0218 */    0x78, 0xC5, 0x48, 0xE0, 0x98, 0x23, 0x44, 0x9F, 
                            /* 0220 */    0x6B, 0x3C, 0x42, 0x2C, 0xFC, 0x53, 0x45, 0xE1, 
                            /* 0228 */    0x03, 0x21, 0x63, 0x04, 0x17, 0xA0, 0xC7, 0x08, 
                            /* 0230 */    0x7C, 0x03, 0x8E, 0x11, 0x7D, 0x94, 0xE0, 0xEA, 
                            /* 0238 */    0x0F, 0x1A, 0x74, 0x80, 0xB8, 0xFF, 0xFF, 0x00, 
                            /* 0240 */    0xE1, 0x83, 0x7A, 0x80, 0xC0, 0x37, 0xFA, 0xD1, 
                            /* 0248 */    0x03, 0x3D, 0x2E, 0x8B, 0x3E, 0x0F, 0xC8, 0xF8, 
                            /* 0250 */    0x89, 0x46, 0xF3, 0xE2, 0xA7, 0x03, 0x7E, 0xF8, 
                            /* 0258 */    0x00, 0x0F, 0xA8, 0x87, 0x84, 0x03, 0xC5, 0x4C, 
                            /* 0260 */    0x9B, 0x83, 0x3E, 0xBB, 0x1C, 0x3A, 0x76, 0xB8, 
                            /* 0268 */    0xE0, 0x3F, 0x81, 0x80, 0x4B, 0xDE, 0x21, 0x0C, 
                            /* 0270 */    0x14, 0x23, 0xC6, 0x9F, 0x83, 0x7C, 0x0A, 0x03, 
                            /* 0278 */    0xFF, 0xFF, 0xFF, 0x14, 0x06, 0xFE, 0xE1, 0xF0, 
                            /* 0280 */    0x20, 0x4F, 0x07, 0x9F, 0xB6, 0xA8, 0x74, 0x18, 
                            /* 0288 */    0xD4, 0x81, 0x0B, 0xB0, 0x32, 0x89, 0x08, 0xCF, 
                            /* 0290 */    0x12, 0xB5, 0x41, 0xE8, 0xD4, 0xF0, 0x36, 0xF1, 
                            /* 0298 */    0xB6, 0xE5, 0x5B, 0x40, 0x9C, 0xD3, 0xEC, 0xED, 
                            /* 02A0 */    0xC0, 0x45, 0x30, 0x22, 0xD4, 0x0C, 0x45, 0x4E, 
                            /* 02A8 */    0x5A, 0x11, 0x63, 0x44, 0x79, 0xDC, 0x32, 0xCA, 
                            /* 02B0 */    0xDB, 0xD6, 0x0B, 0x40, 0xBC, 0x13, 0x7B, 0xDE, 
                            /* 02B8 */    0x32, 0x46, 0xF0, 0xC8, 0x0F, 0x5C, 0x2C, 0xC6, 
                            /* 02C0 */    0xEA, 0xF5, 0x5F, 0xF3, 0x81, 0x0B, 0x70, 0xF6, 
                            /* 02C8 */    0xFF, 0x3F, 0x70, 0x01, 0x1C, 0x0A, 0x7A, 0x18, 
                            /* 02D0 */    0x42, 0x0F, 0xC3, 0x53, 0x39, 0x97, 0x87, 0xC8, 
                            /* 02D8 */    0x53, 0x89, 0x18, 0x35, 0x4C, 0xD4, 0x67, 0x28, 
                            /* 02E0 */    0xDF, 0x2D, 0x7C, 0x20, 0x02, 0xDF, 0x99, 0x0B, 
                            /* 02E8 */    0xF8, 0xFD, 0xFF, 0x0F, 0x44, 0x70, 0x8E, 0x29, 
                            /* 02F0 */    0xB8, 0x33, 0x0D, 0x78, 0x7C, 0xCE, 0x40, 0x20, 
                            /* 02F8 */    0xA7, 0xE2, 0x43, 0x0D, 0x60, 0x41, 0xF4, 0x13, 
                            /* 0300 */    0xC2, 0x27, 0x1A, 0x2A, 0x13, 0x06, 0x75, 0xA8, 
                            /* 0308 */    0x01, 0xAC, 0x5C, 0x61, 0x9E, 0x46, 0xCF, 0xF9, 
                            /* 0310 */    0x59, 0xC6, 0xA7, 0x1A, 0x1F, 0x4A, 0x8D, 0x63, 
                            /* 0318 */    0x88, 0x97, 0x99, 0x87, 0x1A, 0x1F, 0x0B, 0x5E, 
                            /* 0320 */    0x49, 0x7D, 0xA8, 0x31, 0x54, 0x9C, 0x87, 0x1A, 
                            /* 0328 */    0x0F, 0x37, 0x50, 0xD4, 0x37, 0x9B, 0x67, 0x1B, 
                            /* 0330 */    0xA3, 0xC7, 0xF7, 0x0D, 0xD5, 0x10, 0x0F, 0x35, 
                            /* 0338 */    0x4C, 0xF2, 0x4A, 0x35, 0x16, 0x1F, 0x6A, 0xC0, 
                            /* 0340 */    0xF1, 0xFF, 0x3F, 0xD4, 0x00, 0xFC, 0xFF, 0xFF, 
                            /* 0348 */    0x1F, 0x6A, 0x00, 0x47, 0x47, 0x03, 0x38, 0x47, 
                            /* 0350 */    0x46, 0xDC, 0xD1, 0x00, 0x5C, 0x87, 0x52, 0xE0, 
                            /* 0358 */    0x70, 0x34, 0x00, 0x1E, 0x47, 0x21, 0x30, 0x5F, 
                            /* 0360 */    0x68, 0x7C, 0x14, 0x02, 0x16, 0xFF, 0xFF, 0xA3, 
                            /* 0368 */    0x10, 0xF8, 0x65, 0x9F, 0x83, 0x50, 0x42, 0x8F, 
                            /* 0370 */    0x42, 0x80, 0xA0, 0xDB, 0xCF, 0x53, 0xC4, 0xB3, 
                            /* 0378 */    0x8F, 0x2F, 0x3F, 0x0F, 0x04, 0x11, 0x5E, 0xF3, 
                            /* 0380 */    0x7D, 0x0A, 0xF2, 0x21, 0xDF, 0x47, 0x21, 0x06, 
                            /* 0388 */    0x63, 0x28, 0x5F, 0x83, 0x7C, 0x14, 0x62, 0x50, 
                            /* 0390 */    0xAF, 0x41, 0xBE, 0xEF, 0x1B, 0xE4, 0xF1, 0x22, 
                            /* 0398 */    0x48, 0xEC, 0x67, 0x02, 0x1F, 0x85, 0x98, 0xE8, 
                            /* 03A0 */    0xA3, 0x10, 0xA0, 0xF0, 0xFF, 0x7F, 0x14, 0x02, 
                            /* 03A8 */    0xF8, 0xFF, 0xFF, 0x3F, 0x0A, 0x01, 0xCE, 0x02, 
                            /* 03B0 */    0x1C, 0x0D, 0x40, 0x37, 0xAD, 0x47, 0x21, 0xF0, 
                            /* 03B8 */    0xDE, 0x59, 0x4E, 0xFB, 0x04, 0x7C, 0x16, 0x02, 
                            /* 03C0 */    0xCC, 0xFE, 0xFF, 0xCF, 0x42, 0xC0, 0xEC, 0x28, 
                            /* 03C8 */    0x74, 0x14, 0x67, 0xF9, 0x2A, 0xF4, 0x04, 0xF0, 
                            /* 03D0 */    0x02, 0x10, 0x23, 0xCC, 0x3B, 0xD0, 0x4B, 0x26, 
                            /* 03D8 */    0xBB, 0x8B, 0x1B, 0xE7, 0xC9, 0xE5, 0x2C, 0x9E, 
                            /* 03E0 */    0xC4, 0x7D, 0x09, 0xF2, 0x81, 0xE2, 0x59, 0xC8, 
                            /* 03E8 */    0x50, 0xA7, 0x1B, 0xF4, 0x8D, 0xDC, 0x03, 0x8B, 
                            /* 03F0 */    0x19, 0x3F, 0xC4, 0xF3, 0x90, 0x21, 0x9E, 0x85, 
                            /* 03F8 */    0x00, 0x76, 0xFD, 0xFF, 0xCF, 0x42, 0x00, 0xFF, 
                            /* 0400 */    0xFF, 0xFF, 0x47, 0x03, 0xF8, 0x2F, 0x00, 0x9F, 
                            /* 0408 */    0x85, 0x80, 0xE7, 0x09, 0xE0, 0x41, 0xDB, 0x67, 
                            /* 0410 */    0x21, 0x80, 0x33, 0x87, 0xCB, 0xF3, 0x7F, 0x05, 
                            /* 0418 */    0x3A, 0x96, 0xF7, 0x08, 0xCF, 0xFA, 0x24, 0x5F, 
                            /* 0420 */    0x2F, 0x3D, 0xD3, 0x87, 0x82, 0x67, 0x21, 0x86, 
                            /* 0428 */    0x75, 0x18, 0x3E, 0x0B, 0x31, 0x88, 0x17, 0x4D, 
                            /* 0430 */    0x43, 0xBC, 0x70, 0xFA, 0x30, 0xE0, 0xFF, 0x3F, 
                            /* 0438 */    0x5E, 0xE0, 0x57, 0x4E, 0x03, 0x05, 0x09, 0xF4, 
                            /* 0440 */    0x2C, 0x04, 0x30, 0xFE, 0xFF, 0x7F, 0x16, 0x02, 
                            /* 0448 */    0xC8, 0xB8, 0x46, 0x9D, 0x85, 0x80, 0xE5, 0x6D, 
                            /* 0450 */    0xE5, 0x19, 0xDB, 0xA7, 0x95, 0x04, 0xFF, 0xFF, 
                            /* 0458 */    0x67, 0x21, 0xC0, 0x41, 0x2E, 0x23, 0x07, 0x21, 
                            /* 0460 */    0x4C, 0xC4, 0x87, 0x83, 0x8F, 0x99, 0x80, 0x9E, 
                            /* 0468 */    0x29, 0xBE, 0xB8, 0x1B, 0xE3, 0x09, 0xE0, 0x45, 
                            /* 0470 */    0xE2, 0x31, 0x93, 0x1D, 0x35, 0x0D, 0xF3, 0x2C, 
                            /* 0478 */    0x64, 0xBC, 0xB3, 0x78, 0x0D, 0x78, 0x82, 0xF7, 
                            /* 0480 */    0xE4, 0x9F, 0x85, 0x18, 0xD8, 0x61, 0x05, 0x7B, 
                            /* 0488 */    0x14, 0x32, 0xA8, 0xC1, 0x63, 0x87, 0x08, 0x13, 
                            /* 0490 */    0xE8, 0x59, 0x88, 0xC5, 0x7D, 0xAE, 0xE8, 0x3C, 
                            /* 0498 */    0xE1, 0xB3, 0x10, 0xF0, 0xFE, 0xFF, 0x9F, 0x25, 
                            /* 04A0 */    0xE0, 0x5E, 0x0D, 0x9E, 0x85, 0x00, 0x13, 0x87, 
                            /* 04A8 */    0x0D, 0x9F, 0x35, 0xC0, 0x33, 0x7C, 0x8F, 0xEA, 
                            /* 04B0 */    0x1C, 0x1E, 0x8F, 0x81, 0x7F, 0x56, 0x1D, 0xE7, 
                            /* 04B8 */    0x04, 0x96, 0x7B, 0xD1, 0xB2, 0x71, 0xA0, 0xA1, 
                            /* 04C0 */    0x23, 0xB2, 0x3A, 0x20, 0x8D, 0x0D, 0x73, 0x29, 
                            /* 04C8 */    0x89, 0x7C, 0x72, 0x6C, 0xD4, 0x56, 0x04, 0xA7, 
                            /* 04D0 */    0x33, 0x93, 0x4F, 0x00, 0xD6, 0x42, 0x21, 0x05, 
                            /* 04D8 */    0x34, 0x1A, 0x8B, 0xE1, 0x9D, 0xF9, 0xE8, 0x44, 
                            /* 04E0 */    0x41, 0x0C, 0xE8, 0xE3, 0x90, 0x6D, 0x1C, 0x0A, 
                            /* 04E8 */    0x50, 0x7B, 0xD1, 0x14, 0xC8, 0x39, 0x07, 0xA3, 
                            /* 04F0 */    0x7F, 0x76, 0x74, 0x36, 0xBE, 0x13, 0x70, 0x0D, 
                            /* 04F8 */    0x10, 0x3A, 0x25, 0x18, 0xDA, 0x6A, 0x04, 0xFC, 
                            /* 0500 */    0xFF, 0x67, 0x89, 0x01, 0x33, 0xFE, 0x53, 0x8C, 
                            /* 0508 */    0x09, 0x7C, 0x8E, 0xC1, 0x1F, 0x0C, 0xF0, 0x03, 
                            /* 0510 */    0x7F, 0x31, 0xA8, 0xFA, 0x5E, 0xA0, 0xFB, 0x82, 
                            /* 0518 */    0xD5, 0xDD, 0x64, 0x20, 0xCC, 0xC8, 0x04, 0xF5, 
                            /* 0520 */    0x9D, 0x0E, 0x40, 0x01, 0xE4, 0x0B, 0x81, 0xCF, 
                            /* 0528 */    0x51, 0x0F, 0x05, 0x6C, 0x22, 0x21, 0xC2, 0x44, 
                            /* 0530 */    0x33, 0x3A, 0x62, 0xC2, 0xA8, 0xE8, 0x13, 0xA6, 
                            /* 0538 */    0x20, 0x9E, 0xB0, 0x63, 0x4D, 0x18, 0x3D, 0x13, 
                            /* 0540 */    0x5F, 0x74, 0xD8, 0x88, 0x31, 0x21, 0xAE, 0x1E, 
                            /* 0548 */    0xD0, 0x26, 0x18, 0xD4, 0x97, 0x22, 0x58, 0x43, 
                            /* 0550 */    0xE6, 0x63, 0xF1, 0x05, 0x02, 0x37, 0x65, 0x30, 
                            /* 0558 */    0xCE, 0x89, 0x5D, 0x13, 0x7C, 0xD9, 0xC1, 0xCD, 
                            /* 0560 */    0x19, 0x8C, 0xF0, 0x98, 0xBB, 0x18, 0xBF, 0x3A, 
                            /* 0568 */    0x79, 0x74, 0xFC, 0xA0, 0xE0, 0x1B, 0x0E, 0xC3, 
                            /* 0570 */    0x7E, 0x32, 0xF3, 0x8C, 0xDE, 0xCB, 0x7C, 0x8D, 
                            /* 0578 */    0xC3, 0xC0, 0x7A, 0xBC, 0x1C, 0xD6, 0x68, 0x61, 
                            /* 0580 */    0x0F, 0xED, 0x3D, 0xC4, 0xFF, 0xFF, 0x43, 0x8C, 
                            /* 0588 */    0xCF, 0x13, 0xC6, 0x08, 0xEB, 0xDB, 0x0B, 0x38, 
                            /* 0590 */    0xEE, 0x59, 0xF0, 0xEF, 0x1A, 0xE0, 0xB9, 0x84, 
                            /* 0598 */    0xF8, 0xAE, 0x01, 0x30, 0xF0, 0xFF, 0x7F, 0xD7, 
                            /* 05A0 */    0x00, 0x4E, 0xD7, 0x04, 0xDF, 0x35, 0x80, 0xF7, 
                            /* 05A8 */    0xD0, 0x7D, 0xD7, 0x00, 0xAE, 0xD9, 0xEF, 0x1A, 
                            /* 05B0 */    0xA8, 0x63, 0x80, 0x15, 0xDE, 0x35, 0xA0, 0x5D, 
                            /* 05B8 */    0xD9, 0xDE, 0xD7, 0x9E, 0xB0, 0xAC, 0xE9, 0xB2, 
                            /* 05C0 */    0x81, 0x52, 0x73, 0xD9, 0x00, 0x14, 0xFC, 0xFF, 
                            /* 05C8 */    0x2F, 0x1B, 0x80, 0x01, 0x29, 0x13, 0x46, 0x85, 
                            /* 05D0 */    0x9F, 0x30, 0x05, 0xF1, 0x84, 0x1D, 0xEC, 0xB2, 
                            /* 05D8 */    0x01, 0x8A, 0x18, 0x97, 0x0D, 0xD0, 0x8F, 0xED, 
                            /* 05E0 */    0x65, 0x03, 0x18, 0xDC, 0x13, 0xF8, 0x6D, 0x03, 
                            /* 05E8 */    0x78, 0x43, 0xFA, 0xB6, 0x01, 0xD6, 0xFF, 0xFF, 
                            /* 05F0 */    0x6D, 0x03, 0xAC, 0xF9, 0x6F, 0x1B, 0x28, 0x0E, 
                            /* 05F8 */    0xAB, 0xBC, 0x6D, 0x40, 0x3C, 0xC9, 0x33, 0x02, 
                            /* 0600 */    0xAB, 0xBA, 0x6E, 0xA0, 0xF4, 0x5C, 0x37, 0x00, 
                            /* 0608 */    0x12, 0x88, 0x99, 0x30, 0x2A, 0xFE, 0x84, 0x29, 
                            /* 0610 */    0x88, 0x27, 0xEC, 0x68, 0xD7, 0x0D, 0x50, 0x04, 
                            /* 0618 */    0xB9, 0x6E, 0x80, 0x7E, 0x5E, 0x09, 0xFE, 0xFF, 
                            /* 0620 */    0xAF, 0x1B, 0xC0, 0xE0, 0xA2, 0x80, 0xB9, 0x6F, 
                            /* 0628 */    0x00, 0x6F, 0x58, 0x7E, 0xDF, 0x00, 0x7C, 0xDC, 
                            /* 0630 */    0xC4, 0x31, 0xF7, 0x0D, 0xC0, 0xCC, 0xFF, 0xFF, 
                            /* 0638 */    0xBE, 0x01, 0xB0, 0xE7, 0xA2, 0x80, 0xBB, 0x6F, 
                            /* 0640 */    0x00, 0xEF, 0x8B, 0xB4, 0xEF, 0x1B, 0x60, 0xFE, 
                            /* 0648 */    0xFF, 0xDF, 0x37, 0xC0, 0x28, 0x6D, 0xFD, 0x1E, 
                            /* 0650 */    0x1C, 0x3D, 0x21, 0x78, 0x7C, 0xB8, 0xFB, 0xA5, 
                            /* 0658 */    0xC7, 0xE7, 0xBB, 0x39, 0x38, 0x06, 0x79, 0x8C, 
                            /* 0660 */    0x87, 0x76, 0xC0, 0xAF, 0xEF, 0x9E, 0x98, 0xEF, 
                            /* 0668 */    0xE6, 0xC0, 0xFF, 0x4C, 0x70, 0x3C, 0x18, 0x68, 
                            /* 0670 */    0x1C, 0x62, 0xAB, 0x97, 0x06, 0x72, 0x34, 0x38, 
                            /* 0678 */    0x3F, 0xDC, 0x19, 0x81, 0x61, 0x15, 0x7F, 0xF2, 
                            /* 0680 */    0x47, 0x38, 0xC7, 0xD0, 0xD9, 0xE1, 0x20, 0xB1, 
                            /* 0688 */    0x83, 0xE0, 0xC1, 0x56, 0x6D, 0x02, 0x85, 0x86, 
                            /* 0690 */    0x50, 0x14, 0x18, 0x14, 0x8B, 0x0F, 0x18, 0xF8, 
                            /* 0698 */    0x61, 0xB3, 0xB3, 0x00, 0x93, 0x04, 0x87, 0x3A, 
                            /* 06A0 */    0x02, 0xF8, 0x3E, 0xD1, 0xFC, 0x38, 0x74, 0x37, 
                            /* 06A8 */    0x38, 0x54, 0x8F, 0xE5, 0xA1, 0x80, 0x9E, 0x01, 
                            /* 06B0 */    0x71, 0xC7, 0x0C, 0x32, 0x69, 0xCF, 0x28, 0xE2, 
                            /* 06B8 */    0x53, 0xC2, 0x29, 0x85, 0x49, 0xE0, 0xF3, 0x03, 
                            /* 06C0 */    0x43, 0xE3, 0x04, 0xAF, 0x0D, 0xA1, 0xF9, 0xFF, 
                            /* 06C8 */    0xFF, 0xA4, 0xC0, 0x3C, 0xDF, 0x31, 0x04, 0x6C, 
                            /* 06D0 */    0x02, 0xBB, 0xBF, 0x64, 0xC8, 0xDA, 0xC0, 0x75, 
                            /* 06D8 */    0x4B, 0x32, 0x44, 0x6F, 0x38, 0xB2, 0x85, 0xA2, 
                            /* 06E0 */    0xE9, 0x44, 0x79, 0xDF, 0x88, 0x62, 0x67, 0x08, 
                            /* 06E8 */    0xC2, 0x88, 0x12, 0x2C, 0xC8, 0xA3, 0x42, 0xAC, 
                            /* 06F0 */    0x28, 0x2F, 0x05, 0x46, 0x88, 0x18, 0xE2, 0x95, 
                            /* 06F8 */    0x23, 0xD0, 0x09, 0x87, 0x0F, 0xF2, 0xD8, 0x14, 
                            /* 0700 */    0xA7, 0xFD, 0x41, 0x90, 0x58, 0x4F, 0x02, 0x8D, 
                            /* 0708 */    0xC5, 0x91, 0x46, 0x83, 0x3A, 0x07, 0x78, 0xB8, 
                            /* 0710 */    0x3E, 0xC4, 0x78, 0xF8, 0x0F, 0x21, 0x06, 0x39, 
                            /* 0718 */    0xC8, 0x73, 0x7B, 0x54, 0x38, 0x4E, 0x5F, 0x25, 
                            /* 0720 */    0x4C, 0xF0, 0x02, 0xE0, 0x83, 0x0A, 0x1C, 0xD7, 
                            /* 0728 */    0x80, 0x9A, 0xF1, 0x33, 0x06, 0x58, 0x8E, 0xE3, 
                            /* 0730 */    0x3E, 0xA9, 0xC0, 0x1D, 0x8F, 0xEF, 0x07, 0x6C, 
                            /* 0738 */    0xC2, 0x09, 0x2C, 0x7F, 0x10, 0xA8, 0xE3, 0x0C, 
                            /* 0740 */    0x9F, 0xE7, 0x0B, 0x8B, 0x21, 0x1F, 0x13, 0x4C, 
                            /* 0748 */    0x60, 0xB1, 0x27, 0x1B, 0x3A, 0x1E, 0xF0, 0xDF, 
                            /* 0750 */    0x63, 0x1E, 0x2F, 0x7C, 0x32, 0xF1, 0x7C, 0x4D, 
                            /* 0758 */    0x30, 0x22, 0x84, 0x9C, 0x8C, 0x07, 0x7D, 0x87, 
                            /* 0760 */    0xC0, 0x5C, 0x6F, 0xD8, 0xB9, 0x85, 0x8B, 0x3A, 
                            /* 0768 */    0x68, 0xA0, 0x4E, 0x0B, 0x3E, 0x28, 0xB0, 0x9B, 
                            /* 0770 */    0x11, 0xE6, 0xB8, 0xCE, 0xCF, 0x2A, 0x60, 0xF8, 
                            /* 0778 */    0xFF, 0x9F, 0x55, 0x60, 0x8F, 0x10, 0xFE, 0xED, 
                            /* 0780 */    0xC1, 0xF3, 0xF2, 0x95, 0xE1, 0xD5, 0x21, 0x81, 
                            /* 0788 */    0x43, 0x8E, 0x10, 0x3D, 0x2E, 0x8F, 0x10, 0x73, 
                            /* 0790 */    0x3E, 0xC2, 0x0C, 0x11, 0x5C, 0x67, 0x01, 0x70, 
                            /* 0798 */    0x0C, 0x11, 0xF8, 0x1C, 0x70, 0xC0, 0x71, 0x69, 
                            /* 07A0 */    0xE2, 0x03, 0xF5, 0x01, 0x07, 0x70, 0x70, 0x4D, 
                            /* 07A8 */    0xC3, 0x1D, 0x70, 0xC0, 0x71, 0x16, 0x60, 0xFF, 
                            /* 07B0 */    0xFF, 0xC3, 0x0D, 0x2C, 0x49, 0x26, 0x0E, 0x23, 
                            /* 07B8 */    0x18, 0x11, 0x30, 0x28, 0x02, 0x02, 0xA4, 0xB3, 
                            /* 07C0 */    0x80, 0x0F, 0x29, 0x00, 0x1F, 0xAE, 0x0C, 0x0F, 
                            /* 07C8 */    0x29, 0xD8, 0x93, 0x86, 0x07, 0x8E, 0x1B, 0x85, 
                            /* 07D0 */    0x07, 0x8D, 0x0B, 0x30, 0x68, 0x7A, 0xE2, 0x80, 
                            /* 07D8 */    0x7F, 0x4C, 0xF0, 0x19, 0x05, 0x1C, 0xE3, 0x06, 
                            /* 07E0 */    0xDF, 0x2A, 0x0C, 0xFC, 0xFF, 0x3F, 0x30, 0xCC, 
                            /* 07E8 */    0xE1, 0xC2, 0x63, 0x39, 0x8A, 0xA0, 0x07, 0x1E, 
                            /* 07F0 */    0xD4, 0xF7, 0x8C, 0x33, 0xF7, 0x24, 0x8F, 0xD1, 
                            /* 07F8 */    0x51, 0x0F, 0x27, 0xF4, 0xE4, 0x85, 0x3B, 0x57, 
                            /* 0800 */    0xF9, 0x0A, 0x71, 0x14, 0x18, 0xB8, 0x77, 0x29, 
                            /* 0808 */    0x8F, 0xCF, 0x17, 0x2B, 0xC3, 0x63, 0x46, 0xFB, 
                            /* 0810 */    0x1E, 0x72, 0xD6, 0x11, 0x02, 0xE2, 0x2F, 0x75, 
                            /* 0818 */    0x6C, 0xC0, 0x60, 0x39, 0x18, 0x00, 0x87, 0x01, 
                            /* 0820 */    0xE3, 0x13, 0x0D, 0x58, 0x67, 0x1B, 0x3C, 0xF4, 
                            /* 0828 */    0x69, 0x31, 0xC4, 0xE3, 0x0B, 0xFB, 0x56, 0x61, 
                            /* 0830 */    0x82, 0xEA, 0x41, 0x75, 0x12, 0xF4, 0xD0, 0xC0, 
                            /* 0838 */    0x01, 0xE8, 0xA1, 0xC1, 0x3F, 0xB9, 0x90, 0xFB, 
                            /* 0840 */    0x2B, 0x1D, 0x82, 0xB5, 0xE2, 0x69, 0xDE, 0x47, 
                            /* 0848 */    0x1E, 0xF3, 0xDC, 0xA2, 0xBC, 0x0D, 0x3C, 0x07, 
                            /* 0850 */    0xF0, 0xD3, 0x82, 0x87, 0xE3, 0x63, 0x81, 0xC7, 
                            /* 0858 */    0xE9, 0x4B, 0x58, 0x82, 0xF7, 0x1A, 0x9F, 0x6C, 
                            /* 0860 */    0x1E, 0x5C, 0x58, 0xB2, 0x21, 0xA0, 0x06, 0xEB, 
                            /* 0868 */    0x21, 0x60, 0xA6, 0x9A, 0xC0, 0x49, 0x46, 0x80, 
                            /* 0870 */    0xCA, 0x00, 0xA1, 0x1B, 0xCB, 0xE9, 0x3E, 0x8B, 
                            /* 0878 */    0x84, 0x38, 0xCD, 0x47, 0x99, 0xC7, 0x02, 0x8F, 
                            /* 0880 */    0xF5, 0xC1, 0xC0, 0xFF, 0x7F, 0xCD, 0x23, 0xD4, 
                            /* 0888 */    0x7D, 0xCD, 0x33, 0x7B, 0x3A, 0xC0, 0xAC, 0x22, 
                            /* 0890 */    0xDC, 0x7B, 0xCE, 0x1B, 0x86, 0xD1, 0x9E, 0x2D, 
                            /* 0898 */    0x7C, 0xCD, 0x78, 0xD6, 0x34, 0x42, 0x38, 0x76, 
                            /* 08A0 */    0x83, 0xF3, 0x48, 0x8C, 0xF0, 0x82, 0xC0, 0x4E, 
                            /* 08A8 */    0x0C, 0x0F, 0x30, 0xC6, 0x39, 0x79, 0xC3, 0xFA, 
                            /* 08B0 */    0xC2, 0xCB, 0x40, 0x83, 0x19, 0xDB, 0x97, 0x01, 
                            /* 08B8 */    0x36, 0x2A, 0xDF, 0x88, 0xC0, 0x97, 0xFC, 0x62, 
                            /* 08C0 */    0x00, 0x65, 0x16, 0xBE, 0x9E, 0xF8, 0xA0, 0xC4, 
                            /* 08C8 */    0x2E, 0x06, 0x2C, 0xE5, 0xC5, 0x00, 0x54, 0x37, 
                            /* 08D0 */    0x0C, 0x5F, 0x0C, 0xE0, 0x5F, 0x89, 0x5E, 0x0C, 
                            /* 08D8 */    0xC0, 0x70, 0x71, 0xF2, 0x3D, 0xC0, 0x1E, 0xEE, 
                            /* 08E0 */    0xA3, 0x74, 0x9C, 0xBE, 0xFD, 0xBD, 0x19, 0xF8, 
                            /* 08E8 */    0x6C, 0xC0, 0x60, 0x3C, 0xC3, 0x30, 0xC6, 0x08, 
                            /* 08F0 */    0xE3, 0x51, 0x86, 0x31, 0xC1, 0xDC, 0xB7, 0x03, 
                            /* 08F8 */    0xE8, 0x39, 0x87, 0x81, 0x4A, 0x78, 0x3B, 0x80, 
                            /* 0900 */    0x72, 0x0E, 0xE8, 0xF2, 0x68, 0x42, 0x4F, 0x01, 
                            /* 0908 */    0x4F, 0x07, 0x3E, 0x29, 0x1A, 0xA2, 0xAF, 0xB1, 
                            /* 0910 */    0x0A, 0x26, 0x50, 0xC4, 0x07, 0x0D, 0x3E, 0xB5, 
                            /* 0918 */    0x28, 0x3E, 0x15, 0x78, 0x2D, 0xCF, 0x4E, 0xE1, 
                            /* 0920 */    0xE2, 0x9C, 0x89, 0xA7, 0x6A, 0x38, 0x03, 0xBD, 
                            /* 0928 */    0xE6, 0x86, 0x63, 0xFF, 0x7F, 0x38, 0xFC, 0xA9, 
                            /* 0930 */    0xE0, 0x35, 0x80, 0x1D, 0x24, 0x3D, 0x2D, 0x23, 
                            /* 0938 */    0xC2, 0x38, 0xA4, 0x3C, 0x32, 0xF8, 0xB6, 0x18, 
                            /* 0940 */    0xC7, 0x90, 0x0F, 0x91, 0xBE, 0x13, 0x18, 0xF2, 
                            /* 0948 */    0x21, 0xEF, 0x79, 0xC7, 0xC0, 0xAF, 0x08, 0x71, 
                            /* 0950 */    0x9E, 0xB2, 0x7C, 0x67, 0xF0, 0x65, 0x01, 0x7C, 
                            /* 0958 */    0x91, 0x2E, 0x0B, 0x68, 0x68, 0x9F, 0x64, 0x7C, 
                            /* 0960 */    0x41, 0x30, 0xEC, 0x89, 0xB3, 0x00, 0x77, 0x05, 
                            /* 0968 */    0x50, 0x81, 0xFA, 0xAE, 0x00, 0xFF, 0x42, 0xF0, 
                            /* 0970 */    0xAE, 0x00, 0x86, 0x79, 0xF9, 0x56, 0xC0, 0x35, 
                            /* 0978 */    0x1D, 0x4A, 0xD0, 0x67, 0x12, 0x5F, 0x17, 0x70, 
                            /* 0980 */    0x53, 0x64, 0xA9, 0x8E, 0x0A, 0xD0, 0x53, 0x4C, 
                            /* 0988 */    0x02, 0x75, 0x47, 0xF7, 0x51, 0x01, 0xC6, 0x4D, 
                            /* 0990 */    0xD9, 0x07, 0x54, 0x76, 0x5A, 0x60, 0x67, 0x21, 
                            /* 0998 */    0x76, 0x1D, 0xC1, 0x5D, 0x49, 0x18, 0xCA, 0xB3, 
                            /* 09A0 */    0x81, 0x2F, 0x59, 0xFC, 0x70, 0x00, 0x03, 0xDC, 
                            /* 09A8 */    0xB3, 0x38, 0xC4, 0x08, 0xB1, 0xD9, 0x81, 0xEB, 
                            /* 09B0 */    0x75, 0xD2, 0x70, 0x2F, 0x44, 0xEC, 0xFF, 0x7F, 
                            /* 09B8 */    0x32, 0x00, 0xE3, 0x51, 0x1B, 0x1C, 0x27, 0x9D, 
                            /* 09C0 */    0xF0, 0x91, 0x9E, 0x59, 0xF8, 0x49, 0x19, 0x30, 
                            /* 09C8 */    0x71, 0xF2, 0x03, 0xE3, 0xC9, 0x1A, 0xC6, 0x00, 
                            /* 09D0 */    0xB8, 0xBC, 0x57, 0x95, 0x81, 0xFC, 0x43, 0x90, 
                            /* 09D8 */    0x20, 0x18, 0xD4, 0x29, 0x19, 0x38, 0x1C, 0xC5, 
                            /* 09E0 */    0x70, 0xA7, 0x64, 0x78, 0x50, 0xF8, 0xC3, 0x00, 
                            /* 09E8 */    0xE6, 0x46, 0xE8, 0x7B, 0x82, 0xA1, 0xDE, 0x93, 
                            /* 09F0 */    0x0E, 0xE3, 0x91, 0xD0, 0x04, 0x3E, 0x2D, 0xC3, 
                            /* 09F8 */    0xFA, 0xFF, 0x9F, 0x96, 0xF9, 0x39, 0x21, 0xFE, 
                            /* 0A00 */    0x53, 0xCE, 0xFB, 0xC5, 0x83, 0xB2, 0x31, 0xA2, 
                            /* 0A08 */    0xBC, 0x2A, 0xFB, 0x9C, 0x69, 0x14, 0x76, 0x4B, 
                            /* 0A10 */    0x7E, 0x73, 0x78, 0x55, 0xF6, 0x69, 0xF9, 0xDC, 
                            /* 0A18 */    0x22, 0xBD, 0x2F, 0x7B, 0xE4, 0x31, 0xE3, 0xC4, 
                            /* 0A20 */    0x0A, 0x12, 0xE8, 0x7D, 0x23, 0x4A, 0xD8, 0x18, 
                            /* 0A28 */    0xE1, 0x02, 0x3D, 0x2D, 0xB3, 0x63, 0xBB, 0x87, 
                            /* 0A30 */    0xEC, 0xB3, 0x02, 0xEE, 0xEC, 0x00, 0x77, 0x7A, 
                            /* 0A38 */    0xFC, 0xF4, 0x00, 0x38, 0x01, 0x7A, 0x7A, 0x00, 
                            /* 0A40 */    0xDB, 0x79, 0x03, 0xEE, 0x81, 0x00, 0x71, 0xFC, 
                            /* 0A48 */    0x47, 0x05, 0xBF, 0xB2, 0x50, 0x38, 0x7E, 0x6C, 
                            /* 0A50 */    0xE7, 0xC7, 0x12, 0xDC, 0xE1, 0xC0, 0x47, 0x06, 
                            /* 0A58 */    0x1F, 0x20, 0x71, 0x43, 0xF1, 0xA1, 0x02, 0x79, 
                            /* 0A60 */    0x16, 0x00, 0xC5, 0xE8, 0xD9, 0x08, 0xD8, 0x0D, 
                            /* 0A68 */    0xE6, 0xA5, 0x25, 0xCA, 0xFF, 0xFF, 0xBD, 0x81, 
                            /* 0A70 */    0x9D, 0x52, 0x70, 0x07, 0x01, 0xF0, 0x1D, 0x03, 
                            /* 0A78 */    0xC0, 0x3B, 0x18, 0x2E, 0x6B, 0xCC, 0x28, 0x21, 
                            /* 0A80 */    0x30, 0x1A, 0x33, 0xEE, 0x10, 0xC2, 0x4F, 0x04, 
                            /* 0A88 */    0xB8, 0x31, 0x7B, 0xDC, 0x1E, 0x33, 0xEE, 0x38, 
                            /* 0A90 */    0xCB, 0x47, 0xF5, 0x94, 0x11, 0xCA, 0x07, 0x0E, 
                            /* 0A98 */    0x76, 0xCE, 0x78, 0x23, 0xE0, 0x43, 0x07, 0x1E, 
                            /* 0AA0 */    0x07, 0x18, 0xDC, 0x91, 0x02, 0x8C, 0x97, 0x03, 
                            /* 0AA8 */    0x36, 0x76, 0x70, 0x07, 0x21, 0xA7, 0x40, 0x96, 
                            /* 0AB0 */    0x0E, 0xA3, 0xB1, 0xE3, 0x64, 0x03, 0xE9, 0x18, 
                            /* 0AB8 */    0xE3, 0x43, 0xAE, 0xC7, 0x8E, 0x1B, 0xAC, 0xC7, 
                            /* 0AC0 */    0x8E, 0x3B, 0xBE, 0x60, 0xFF, 0xFF, 0xC7, 0x17, 
                            /* 0AC8 */    0x30, 0x8C, 0x81, 0x8B, 0x1F, 0x06, 0xFA, 0xE6, 
                            /* 0AD0 */    0xE7, 0xD1, 0x19, 0xDC, 0xC3, 0xF6, 0x09, 0x26, 
                            /* 0AD8 */    0xC6, 0x1B, 0x4C, 0x88, 0x47, 0x96, 0x97, 0x96, 
                            /* 0AE0 */    0x08, 0x0F, 0x2D, 0xBE, 0xB9, 0xBC, 0xB4, 0xF8, 
                            /* 0AE8 */    0x16, 0x63, 0x94, 0x10, 0x11, 0x0E, 0x26, 0xCE, 
                            /* 0AF0 */    0x13, 0x8C, 0x11, 0x0E, 0x3C, 0x8A, 0x21, 0x22, 
                            /* 0AF8 */    0x9C, 0x40, 0x88, 0x93, 0x3E, 0xD9, 0x20, 0xE1, 
                            /* 0B00 */    0x63, 0x84, 0x8D, 0x16, 0xE5, 0x09, 0x86, 0x8D, 
                            /* 0B08 */    0x85, 0x9F, 0x57, 0x3C, 0x78, 0x7E, 0x5A, 0xF3, 
                            /* 0B10 */    0x5D, 0xD0, 0x93, 0x39, 0xC7, 0x87, 0x2C, 0x4F, 
                            /* 0B18 */    0xED, 0x71, 0xD2, 0x87, 0x59, 0xDC, 0xA0, 0x1E, 
                            /* 0B20 */    0x1C, 0xD9, 0x5D, 0xC7, 0xC7, 0x6B, 0xEC, 0x29, 
                            /* 0B28 */    0xC8, 0x43, 0xE0, 0x27, 0x02, 0x5F, 0x10, 0x3D, 
                            /* 0B30 */    0x59, 0xDF, 0xF5, 0xD8, 0xBD, 0xCC, 0x18, 0xD5, 
                            /* 0B38 */    0x4F, 0x01, 0x75, 0x4C, 0x39, 0x83, 0x57, 0x08, 
                            /* 0B40 */    0x76, 0xCF, 0xF3, 0x21, 0xDB, 0x77, 0x49, 0x36, 
                            /* 0B48 */    0x0A, 0xDC, 0x21, 0xC1, 0x67, 0x24, 0x7E, 0xAA, 
                            /* 0B50 */    0xF0, 0x30, 0x3C, 0x0A, 0x18, 0x33, 0x78, 0x47, 
                            /* 0B58 */    0x38, 0xB4, 0x10, 0x07, 0xFC, 0xBE, 0xCB, 0x86, 
                            /* 0B60 */    0x1A, 0xE3, 0xF4, 0x7C, 0xFE, 0x60, 0x83, 0x80, 
                            /* 0B68 */    0x0F, 0x75, 0xA8, 0x1E, 0xE6, 0x51, 0xBD, 0x14, 
                            /* 0B70 */    0x32, 0x9C, 0xB3, 0x83, 0x3B, 0x08, 0xEC, 0xF1, 
                            /* 0B78 */    0xC3, 0x83, 0xE0, 0x37, 0x4B, 0x3E, 0x08, 0x76, 
                            /* 0B80 */    0xBE, 0x79, 0x83, 0x33, 0xC8, 0xFF, 0xFF, 0x18, 
                            /* 0B88 */    0x60, 0x9F, 0xA9, 0x7C, 0x34, 0x41, 0x1C, 0x01, 
                            /* 0B90 */    0xD1, 0xE7, 0x0F, 0x8F, 0xE1, 0x4D, 0x8E, 0x0F, 
                            /* 0B98 */    0x07, 0x7B, 0xF4, 0xC0, 0x9D, 0x44, 0xE0, 0x1E, 
                            /* 0BA0 */    0xBB, 0x0E, 0xDA, 0xD7, 0x38, 0x5F, 0xB4, 0x60, 
                            /* 0BA8 */    0xDC, 0xF7, 0x9E, 0x45, 0xC0, 0x8F, 0xF1, 0xD8, 
                            /* 0BB0 */    0x02, 0x8E, 0x43, 0x09, 0xB8, 0x83, 0x1D, 0xD7, 
                            /* 0BB8 */    0x38, 0x84, 0xA2, 0xC0, 0xE8, 0x50, 0x82, 0x8B, 
                            /* 0BC0 */    0x01, 0x24, 0x18, 0xC7, 0x38, 0xA3, 0xA1, 0x2F, 
                            /* 0BC8 */    0x91, 0x3E, 0xA4, 0xC1, 0x19, 0x34, 0xEC, 0x79, 
                            /* 0BD0 */    0x3E, 0xA1, 0x70, 0x7B, 0x02, 0x14, 0x9D, 0x50, 
                            /* 0BD8 */    0x40, 0x86, 0xFB, 0x0C, 0x82, 0x3D, 0x21, 0xF0, 
                            /* 0BE0 */    0x33, 0x08, 0xFB, 0xFF, 0x1F, 0x1C, 0x3D, 0xEE, 
                            /* 0BE8 */    0xF7, 0x46, 0x9F, 0x1A, 0xD9, 0xDC, 0x1F, 0x02, 
                            /* 0BF0 */    0x4E, 0xE0, 0xDC, 0xD9, 0xA9, 0x19, 0x77, 0x66, 
                            /* 0BF8 */    0xC0, 0x9E, 0x3F, 0x3C, 0x04, 0x7E, 0x2E, 0xF0, 
                            /* 0C00 */    0xF0, 0x3D, 0x04, 0xFC, 0xE0, 0x1F, 0x98, 0x0D, 
                            /* 0C08 */    0x0E, 0xC6, 0x53, 0x84, 0xAF, 0x1D, 0x1C, 0x9C, 
                            /* 0C10 */    0x9F, 0x06, 0x0C, 0xCE, 0x5F, 0xA1, 0x3E, 0xCF, 
                            /* 0C18 */    0x33, 0x70, 0xEC, 0xA9, 0xD7, 0xF7, 0x0E, 0xCF, 
                            /* 0C20 */    0xD7, 0x87, 0x0A, 0xFC, 0x4D, 0xCF, 0x87, 0x0A, 
                            /* 0C28 */    0x70, 0x1C, 0x1E, 0xF8, 0x61, 0x85, 0x0D, 0xE1, 
                            /* 0C30 */    0x51, 0x00, 0x7F, 0x6A, 0xF1, 0xF1, 0x2F, 0xCE, 
                            /* 0C38 */    0x53, 0x04, 0xBB, 0x8D, 0x60, 0x0F, 0x17, 0x80, 
                            /* 0C40 */    0xA3, 0x68, 0x67, 0x31, 0x54, 0x98, 0xB3, 0x18, 
                            /* 0C48 */    0xF9, 0xFF, 0x9F, 0xA3, 0x50, 0x67, 0x31, 0x7A, 
                            /* 0C50 */    0xB8, 0x00, 0x5C, 0x08, 0x3E, 0x1E, 0x80, 0xE6, 
                            /* 0C58 */    0x20, 0xF0, 0xB8, 0xE0, 0x0B, 0xC1, 0x91, 0x1C, 
                            /* 0C60 */    0xC8, 0xD3, 0x01, 0xE0, 0x33, 0xC6, 0xC7, 0xD9, 
                            /* 0C68 */    0xE7, 0x23, 0x2A, 0x1C, 0x06, 0x75, 0x3E, 0xF0, 
                            /* 0C70 */    0x09, 0xC5, 0xC7, 0x0E, 0x7E, 0x36, 0xF0, 0x8D, 
                            /* 0C78 */    0xDC, 0x43, 0xE5, 0xA7, 0x66, 0x9F, 0xB4, 0xB9, 
                            /* 0C80 */    0x40, 0x70, 0x9D, 0x8E, 0x1C, 0x68, 0x18, 0xA8, 
                            /* 0C88 */    0x11, 0x19, 0xEA, 0xFF, 0xFF, 0xDC, 0x86, 0x0D, 
                            /* 0C90 */    0x30, 0x34, 0x7A, 0x0E, 0x87, 0x71, 0xC0, 0xF5, 
                            /* 0C98 */    0x39, 0x1C, 0x3B, 0x20, 0x9F, 0xC3, 0xE1, 0x9F, 
                            /* 0CA0 */    0xA3, 0xE1, 0x8F, 0x8D, 0x9D, 0xEE, 0xF9, 0xC0, 
                            /* 0CA8 */    0x60, 0x5D, 0xBF, 0x31, 0x03, 0x03, 0xDB, 0xB7, 
                            /* 0CB0 */    0xC8, 0x03, 0x03, 0x8E, 0xA8, 0x67, 0xE3, 0x2B, 
                            /* 0CB8 */    0x84, 0x07, 0x06, 0x36, 0x40, 0x0F, 0x0C, 0xF8, 
                            /* 0CC0 */    0xC4, 0x82, 0x90, 0x93, 0x81, 0xA1, 0x4E, 0x19, 
                            /* 0CC8 */    0x46, 0x8E, 0xF9, 0xC4, 0xE1, 0x61, 0xF8, 0x50, 
                            /* 0CD0 */    0x11, 0xF5, 0x19, 0xE0, 0x11, 0x8F, 0x8D, 0x8D, 
                            /* 0CD8 */    0xFD, 0xFF, 0xC7, 0x06, 0x96, 0x63, 0x8B, 0xC7, 
                            /* 0CE0 */    0x06, 0xFE, 0x23, 0x3C, 0x7E, 0x6C, 0x70, 0xC6, 
                            /* 0CE8 */    0xF2, 0x68, 0xE2, 0xCB, 0xCC, 0x91, 0x9D, 0xC6, 
                            /* 0CF0 */    0x99, 0xBD, 0x86, 0xF8, 0x68, 0xF7, 0xF8, 0xED, 
                            /* 0CF8 */    0xB1, 0x81, 0xCB, 0xC2, 0xD8, 0x80, 0x52, 0xC8, 
                            /* 0D00 */    0xB1, 0xA1, 0x0F, 0x29, 0x3E, 0x05, 0xD8, 0x38, 
                            /* 0D08 */    0x2A, 0x99, 0x87, 0x8F, 0x57, 0x3E, 0x31, 0x1C, 
                            /* 0D10 */    0x5D, 0x90, 0x37, 0x74, 0x5F, 0x2E, 0x7C, 0xA4, 
                            /* 0D18 */    0x31, 0x98, 0x2F, 0x2D, 0x3E, 0x83, 0xF2, 0x21, 
                            /* 0D20 */    0x82, 0x4B, 0xC3, 0x10, 0x81, 0x52, 0xA8, 0x21, 
                            /* 0D28 */    0xA2, 0xC7, 0xF3, 0xFF, 0x7F, 0x04, 0xF3, 0x10, 
                            /* 0D30 */    0xD9, 0xD0, 0xC0, 0xFB, 0xA9, 0xF1, 0xD0, 0x80, 
                            /* 0D38 */    0x4F, 0xB8, 0xA1, 0xA1, 0x0F, 0x6B, 0x3E, 0x04, 
                            /* 0D40 */    0x30, 0x08, 0xDF, 0x06, 0xD8, 0x55, 0xC0, 0x57, 
                            /* 0D48 */    0x21, 0x0F, 0xF0, 0x49, 0x94, 0x0D, 0x0F, 0x7C, 
                            /* 0D50 */    0x83, 0xF2, 0xF0, 0x80, 0x4F, 0x78, 0x60, 0xAF, 
                            /* 0D58 */    0xC2, 0xC3, 0xA3, 0x67, 0x25, 0x0F, 0x0F, 0x1E, 
                            /* 0D60 */    0xC8, 0x63, 0x04, 0x3B, 0x87, 0x78, 0x70, 0xE0, 
                            /* 0D68 */    0x30, 0x31, 0x38, 0x50, 0x1C, 0xFD, 0x71, 0x43, 
                            /* 0D70 */    0x60, 0x97, 0x59, 0x4F, 0x9C, 0x5F, 0x59, 0x3C, 
                            /* 0D78 */    0x28, 0xFC, 0xFF, 0xFF, 0x08, 0x00, 0xEB, 0x38, 
                            /* 0D80 */    0x03, 0xBE, 0xC3, 0x2A, 0x38, 0x8E, 0xFD, 0xD8, 
                            /* 0D88 */    0xDB, 0x84, 0x47, 0xF0, 0x4C, 0xE6, 0x11, 0xF0, 
                            /* 0D90 */    0x33, 0x19, 0xE0, 0x28, 0xE8, 0x61, 0x95, 0x0E, 
                            /* 0D98 */    0xDC, 0xD1, 0x60, 0x50, 0x67, 0x32, 0x70, 0x45, 
                            /* 0DA0 */    0x00, 0xD7, 0x39, 0xC5, 0x67, 0x12, 0x38, 0x43, 
                            /* 0DA8 */    0x3D, 0x68, 0x9F, 0xB0, 0x3D, 0x6B, 0xDF, 0xA2, 
                            /* 0DB0 */    0xD8, 0x29, 0x03, 0x5C, 0x2A, 0x4E, 0x19, 0x20, 
                            /* 0DB8 */    0xFC, 0xFF, 0x9F, 0x5E, 0xC0, 0x0A, 0x7C, 0x12, 
                            /* 0DC0 */    0x0F, 0xED, 0x87, 0x06, 0xE6, 0x81, 0x79, 0x68, 
                            /* 0DC8 */    0xC0, 0xE7, 0x68, 0x80, 0x3B, 0x51, 0x80, 0xE7, 
                            /* 0DD0 */    0x86, 0x81, 0x3B, 0x50, 0x00, 0x6E, 0x8E, 0xED, 
                            /* 0DD8 */    0x1E, 0x17, 0x87, 0xC6, 0x21, 0x3E, 0x78, 0x9D, 
                            /* 0DE0 */    0xB3, 0xCF, 0x54, 0x67, 0x8A, 0x3B, 0x8B, 0x80, 
                            /* 0DE8 */    0xE1, 0x94, 0x8E, 0xB0, 0xF0, 0xFF, 0x3F, 0xB4, 
                            /* 0DF0 */    0xD2, 0x07, 0x86, 0x84, 0xC0, 0xA0, 0x4E, 0x35, 
                            /* 0DF8 */    0x1E, 0x8A, 0x0F, 0x06, 0x1C, 0xD8, 0x47, 0x04, 
                            /* 0E00 */    0x76, 0x2E, 0x60, 0x87, 0x22, 0xC3, 0xF1, 0xB3, 
                            /* 0E08 */    0x80, 0x4F, 0x09, 0xAF, 0x5B, 0xC7, 0xF1, 0x08, 
                            /* 0E10 */    0xE9, 0xFB, 0x96, 0x21, 0xD9, 0xD5, 0xE0, 0x99, 
                            /* 0E18 */    0x06, 0x7B, 0x82, 0x85, 0x73, 0x6C, 0x05, 0x17, 
                            /* 0E20 */    0x81, 0x6F, 0x61, 0x47, 0x81, 0x39, 0x3D, 0x78, 
                            /* 0E28 */    0x8E, 0x6F, 0x0C, 0x3E, 0x3D, 0x30, 0xF7, 0x02, 
                            /* 0E30 */    0xCC, 0x1D, 0xA4, 0x85, 0x70, 0x4C, 0xAF, 0x0F, 
                            /* 0E38 */    0x31, 0x8E, 0xFA, 0xB1, 0xA1, 0x2D, 0x01, 0xDA, 
                            /* 0E40 */    0x50, 0x74, 0x07, 0x78, 0x19, 0x88, 0x12, 0xE2, 
                            /* 0E48 */    0x08, 0x22, 0xB5, 0x86, 0xA2, 0x99, 0x47, 0x8A, 
                            /* 0E50 */    0x12, 0x30, 0x9E, 0x61, 0x1A, 0x9B, 0x8C, 0x20, 
                            /* 0E58 */    0x63, 0x84, 0x8E, 0x13, 0x2C, 0x4A, 0xB4, 0x57, 
                            /* 0E60 */    0x80, 0xF6, 0x47, 0xCB, 0x56, 0xAC, 0xB1, 0x38, 
                            /* 0E68 */    0xD2, 0x69, 0x11, 0x3D, 0x6C, 0x1F, 0x9D, 0xF1, 
                            /* 0E70 */    0x27, 0x50, 0xDC, 0x55, 0xC5, 0x07, 0x05, 0x1F, 
                            /* 0E78 */    0x00, 0xF0, 0x2E, 0x01, 0x75, 0x1D, 0xF4, 0xB8, 
                            /* 0E80 */    0x7D, 0xDE, 0x00, 0xFF, 0xF5, 0x02, 0x4B, 0x50, 
                            /* 0E88 */    0xFE, 0x20, 0x50, 0x23, 0x33, 0xB4, 0xC7, 0xF9, 
                            /* 0E90 */    0x36, 0x63, 0xC8, 0xF7, 0x80, 0xC3, 0x62, 0x62, 
                            /* 0E98 */    0x4F, 0x9D, 0x90, 0xFE, 0xFF, 0xE3, 0x01, 0xE3, 
                            /* 0EA0 */    0xE0, 0x9F, 0x36, 0x7C, 0x15, 0xF7, 0x7C, 0x7D, 
                            /* 0EA8 */    0x36, 0x03, 0x18, 0x3B, 0x1C, 0x1C, 0xF0, 0xFF, 
                            /* 0EB0 */    0xFF, 0xD1, 0x07, 0xE6, 0x95, 0x84, 0x1F, 0x7E, 
                            /* 0EB8 */    0x00, 0x67, 0x40, 0x0F, 0x3F, 0x60, 0x1F, 0x2A, 
                            /* 0EC0 */    0x6E, 0x08, 0x5C, 0xEE, 0x8A, 0x28, 0x90, 0x05, 
                            /* 0EC8 */    0xC2, 0xA0, 0x08, 0x2C, 0x0E, 0x48, 0x47, 0x4E, 
                            /* 0ED0 */    0x9F, 0x72, 0xE1, 0x0C, 0xE5, 0x64, 0x7B, 0xBF, 
                            /* 0ED8 */    0x21, 0x90, 0xEB, 0x87, 0x87, 0x7A, 0x16, 0x4F, 
                            /* 0EE0 */    0x0C, 0xEC, 0x98, 0x06, 0xFC, 0xC7, 0xC6, 0xFE, 
                            /* 0EE8 */    0xFF, 0x63, 0xC3, 0xCE, 0xFB, 0x79, 0x38, 0xC2, 
                            /* 0EF0 */    0xB1, 0x81, 0xFD, 0x9C, 0x06, 0x9C, 0x4E, 0x74, 
                            /* 0EF8 */    0x70, 0x2E, 0x4E, 0xEC, 0xDE, 0x8E, 0x1B, 0x1A, 
                            /* 0F00 */    0xD8, 0x86, 0xE5, 0xA1, 0x01, 0x9F, 0x23, 0x27, 
                            /* 0F08 */    0x18, 0x8F, 0x5A, 0xFC, 0x2A, 0xF1, 0xD4, 0xC5, 
                            /* 0F10 */    0x8F, 0x21, 0xC0, 0xF6, 0xFF, 0x7F, 0xA4, 0x03, 
                            /* 0F18 */    0x2C, 0x48, 0x7B, 0x06, 0xF9, 0x3C, 0x47, 0xC5, 
                            /* 0F20 */    0xC0, 0xA0, 0x8E, 0x74, 0x80, 0xB5, 0x1B, 0xDC, 
                            /* 0F28 */    0x3B, 0xC3, 0x4B, 0x83, 0xE7, 0xF4, 0x46, 0x67, 
                            /* 0F30 */    0x8C, 0x57, 0x39, 0x23, 0x44, 0x61, 0xB7, 0x81, 
                            /* 0F38 */    0x68, 0xF6, 0x76, 0xA4, 0x23, 0xE7, 0x3A, 0x8E, 
                            /* 0F40 */    0x19, 0xE9, 0xF9, 0x2E, 0x58, 0xA4, 0x88, 0x87, 
                            /* 0F48 */    0x13, 0x25, 0x44, 0xB0, 0xD7, 0x89, 0x67, 0xBB, 
                            /* 0F50 */    0x47, 0x3A, 0x26, 0xE4, 0x1C, 0x43, 0x8F, 0x74, 
                            /* 0F58 */    0xC0, 0xC3, 0xF5, 0x91, 0x0E, 0xF9, 0xFF, 0x3F, 
                            /* 0F60 */    0x70, 0x80, 0xFD, 0x1C, 0x85, 0x3F, 0xD2, 0x01, 
                            /* 0F68 */    0xF7, 0x60, 0x87, 0x34, 0xD0, 0x9D, 0x5D, 0xC0, 
                            /* 0F70 */    0x75, 0x48, 0x03, 0xC7, 0xD8, 0xC1, 0x77, 0xB2, 
                            /* 0F78 */    0xC2, 0x1D, 0xC9, 0xC0, 0x76, 0x7A, 0x01, 0x2E, 
                            /* 0F80 */    0xFF, 0xFF, 0xD3, 0x0B, 0xE0, 0x67, 0xAC, 0x30, 
                            /* 0F88 */    0xC6, 0xC0, 0xA3, 0x9D, 0xC8, 0x50, 0x61, 0x0E, 
                            /* 0F90 */    0x65, 0xE8, 0x20, 0xA7, 0x0F, 0x7A, 0x6A, 0x20, 
                            /* 0F98 */    0xA7, 0x0F, 0xF4, 0x5C, 0x0E, 0xF4, 0x14, 0xDE, 
                            /* 0FA0 */    0x0F, 0x7C, 0x80, 0x02, 0xFB, 0xA9, 0x0C, 0x38, 
                            /* 0FA8 */    0x9C, 0x1A, 0xF0, 0x81, 0x8E, 0x5A, 0xE8, 0x51, 
                            /* 0FB0 */    0xF8, 0xF4, 0x09, 0xDE, 0x23, 0x19, 0x58, 0xFE, 
                            /* 0FB8 */    0xFF, 0x07, 0x2D, 0xB0, 0x3D, 0xF5, 0x7D, 0x12, 
                            /* 0FC0 */    0xC1, 0xB1, 0x18, 0xF5, 0x0D, 0xE2, 0x10, 0x5F, 
                            /* 0FC8 */    0x43, 0x7C, 0xD8, 0x7F, 0x27, 0xF1, 0x25, 0x00, 
                            /* 0FD0 */    0x73, 0x13, 0x31, 0xC1, 0x98, 0x10, 0xFA, 0x46, 
                            /* 0FD8 */    0xFB, 0x54, 0x06, 0x9C, 0x8E, 0x9F, 0xF0, 0x46, 
                            /* 0FE0 */    0x8F, 0x3B, 0x2D, 0x78, 0x38, 0x1C, 0xDC, 0xB3, 
                            /* 0FE8 */    0x79, 0x96, 0x78, 0xA2, 0xF1, 0x38, 0x7C, 0x3A, 
                            /* 0FF0 */    0x01, 0x5E, 0x07, 0x0C, 0xCC, 0x0C, 0xC2, 0x3F, 
                            /* 0FF8 */    0x84, 0xB0, 0x21, 0x9C, 0xAA, 0xC7, 0x70, 0xEE, 
                            /* 1000 */    0xEF, 0x36, 0x3E, 0x9D, 0x00, 0x1E, 0xFE, 0xFF, 
                            /* 1008 */    0x47, 0x35, 0x60, 0x2B, 0x51, 0xC3, 0x39, 0x0D, 
                            /* 1010 */    0x23, 0x0A, 0x06, 0x75, 0x54, 0x03, 0xAC, 0x5D, 
                            /* 1018 */    0xD4, 0x7C, 0x7D, 0x8F, 0xF0, 0x22, 0x70, 0x06, 
                            /* 1020 */    0x21, 0x1E, 0xCF, 0x5E, 0xD1, 0x22, 0xF9, 0x0E, 
                            /* 1028 */    0x10, 0xE7, 0x51, 0xCD, 0x60, 0x6F, 0x1F, 0x0F, 
                            /* 1030 */    0x12, 0x51, 0x1E, 0xE4, 0x0D, 0xF5, 0x30, 0x6F, 
                            /* 1038 */    0xA8, 0x93, 0x7F, 0x90, 0x37, 0x56, 0xD8, 0x40, 
                            /* 1040 */    0x4F, 0x6C, 0x2F, 0x6A, 0x21, 0x8D, 0xF0, 0xA8, 
                            /* 1048 */    0xC6, 0x04, 0xBD, 0x3C, 0x74, 0x94, 0xF2, 0x51, 
                            /* 1050 */    0x0D, 0xD8, 0xFE, 0xFF, 0x8F, 0x6A, 0x80, 0xB1, 
                            /* 1058 */    0xC3, 0x3C, 0xC0, 0xA6, 0xFF, 0xFF, 0x61, 0x1E, 
                            /* 1060 */    0x18, 0x9E, 0x9E, 0x00, 0xFF, 0xC7, 0x1A, 0xDC, 
                            /* 1068 */    0x51, 0x11, 0x6C, 0xE7, 0x27, 0xE0, 0xF8, 0xFF, 
                            /* 1070 */    0x3F, 0x3F, 0x01, 0xA3, 0xA1, 0xFB, 0xFC, 0x04, 
                            /* 1078 */    0xE6, 0xD1, 0xC2, 0x3C, 0x20, 0x20, 0xCE, 0x8A, 
                            /* 1080 */    0xA8, 0xF0, 0x0F, 0x19, 0xC3, 0xA1, 0x82, 0x03, 
                            /* 1088 */    0xE9, 0x17, 0xE5, 0x23, 0x20, 0x70, 0x39, 0x2A, 
                            /* 1090 */    0x02, 0x87, 0x33, 0x0B, 0x5E, 0xC8, 0xA9, 0x03, 
                            /* 1098 */    0x3D, 0x1E, 0x83, 0xBE, 0x72, 0xF8, 0x4A, 0xC0, 
                            /* 10A0 */    0x8F, 0x1C, 0x2C, 0xF4, 0x91, 0x03, 0x54, 0x87, 
                            /* 10A8 */    0x45, 0xF0, 0x0D, 0x81, 0xFD, 0xFF, 0x8F, 0x1C, 
                            /* 10B0 */    0xB0, 0xAF, 0x57, 0x81, 0xB1, 0xB7, 0x83, 0xD7, 
                            /* 10B8 */    0x4F, 0x4F, 0xE2, 0x31, 0xEA, 0x38, 0x43, 0x14, 
                            /* 10C0 */    0x8E, 0x49, 0x0E, 0x06, 0x91, 0xDE, 0xC1, 0xD8, 
                            /* 10C8 */    0x00, 0x5F, 0x5E, 0x7C, 0xA8, 0xF2, 0x31, 0x10, 
                            /* 10D0 */    0x18, 0x42, 0x9C, 0x0D, 0x3F, 0x5D, 0x18, 0xF3, 
                            /* 10D8 */    0x74, 0xF8, 0x31, 0x10, 0xB0, 0x2E, 0xF5, 0x0C, 
                            /* 10E0 */    0x88, 0x12, 0x77, 0x0C, 0x04, 0xD9, 0xFF, 0xFF, 
                            /* 10E8 */    0x18, 0x08, 0x38, 0xB9, 0x04, 0x7A, 0xCC, 0x67, 
                            /* 10F0 */    0xFC, 0xE6, 0xF7, 0xE4, 0x17, 0xE5, 0xF5, 0xFF, 
                            /* 10F8 */    0xF5, 0xEF, 0xDD, 0xC0, 0x58, 0x0F, 0x01, 0x4F, 
                            /* 1100 */    0x80, 0xBE, 0xFF, 0xF9, 0x58, 0x11, 0x25, 0x60, 
                            /* 1108 */    0x94, 0x58, 0x2F, 0x82, 0xC6, 0x8C, 0x11, 0xEC, 
                            /* 1110 */    0x1D, 0x30, 0xE6, 0x23, 0xA1, 0x47, 0x18, 0x2D, 
                            /* 1118 */    0xB8, 0x81, 0x1E, 0x03, 0x99, 0xB0, 0x63, 0x20, 
                            /* 1120 */    0x40, 0x8E, 0xFF, 0xFF, 0x31, 0x10, 0x60, 0xEE, 
                            /* 1128 */    0x09, 0x0A, 0x58, 0xFC, 0xFF, 0x4F, 0x50, 0x80, 
                            /* 1130 */    0xC9, 0xA3, 0x20, 0x98, 0xCF, 0x50, 0x80, 0xB5, 
                            /* 1138 */    0xA3, 0x20, 0xD8, 0x47, 0xCB, 0xFF, 0xFF, 0xA3, 
                            /* 1140 */    0x85, 0x31, 0x0A, 0x2E, 0xE8, 0xE5, 0x61, 0x20, 
                            /* 1148 */    0x2A, 0x01, 0x06, 0x45, 0xE0, 0xF8, 0x6B, 0x13, 
                            /* 1150 */    0x8C, 0x43, 0x9D, 0x5E, 0xD0, 0x07, 0x05, 0x0F, 
                            /* 1158 */    0xFB, 0xA9, 0xC0, 0x93, 0x38, 0x55, 0x5F, 0x0B, 
                            /* 1160 */    0x8E, 0xE2, 0x09, 0xC0, 0x87, 0x41, 0xE0, 0x3F, 
                            /* 1168 */    0x34, 0x58, 0x93, 0x28, 0x7E, 0x68, 0xA0, 0x3E, 
                            /* 1170 */    0x7B, 0x80, 0x6F, 0x68, 0xE0, 0x88, 0x7A, 0xC6, 
                            /* 1178 */    0x41, 0x9F, 0x88, 0x7C, 0x36, 0x88, 0xF9, 0xE6, 
                            /* 1180 */    0x11, 0xE1, 0xC9, 0xC3, 0xD7, 0x07, 0x76, 0xF2, 
                            /* 1188 */    0xF4, 0xA9, 0x29, 0x50, 0x94, 0xF7, 0x0D, 0x1E, 
                            /* 1190 */    0xE7, 0x94, 0x03, 0xAA, 0xC3, 0x2F, 0xF6, 0xFF, 
                            /* 1198 */    0x3F, 0x3C, 0x58, 0x07, 0x5E, 0x78, 0xC7, 0x29, 
                            /* 11A0 */    0x1F, 0x4B, 0xC0, 0x77, 0x26, 0x85, 0x73, 0x73, 
                            /* 11A8 */    0xF1, 0x1D, 0x8F, 0x9D, 0x06, 0xC0, 0x66, 0xE3, 
                            /* 11B0 */    0x34, 0x00, 0x94, 0x8E, 0x55, 0xFC, 0x3C, 0x09, 
                            /* 11B8 */    0x26, 0x98, 0x83, 0x79, 0xBF, 0xB6, 0xF7, 0xE3, 
                            /* 11C0 */    0x0D, 0x3D, 0x4D, 0x02, 0xEE, 0xFE, 0xFF, 0xA7, 
                            /* 11C8 */    0x49, 0x30, 0x8B, 0x38, 0x4A, 0xA2, 0x62, 0x3F, 
                            /* 11D0 */    0xA4, 0x7C, 0x9A, 0x04, 0xE4, 0xDD, 0x19, 0x8C, 
                            /* 11D8 */    0x70, 0xFE, 0x21, 0x1E, 0x20, 0x42, 0x3C, 0x48, 
                            /* 11E0 */    0x1A, 0x24, 0x4E, 0x90, 0x97, 0x81, 0xA7, 0x49, 
                            /* 11E8 */    0x5F, 0x26, 0xE3, 0x3C, 0x50, 0x46, 0x79, 0x9D, 
                            /* 11F0 */    0x34, 0xC2, 0xD1, 0xC7, 0x33, 0xD0, 0x8B, 0x64, 
                            /* 11F8 */    0x88, 0x57, 0xC9, 0x07, 0xCB, 0xF7, 0x49, 0xA3, 
                            /* 1200 */    0xC5, 0x0A, 0x7E, 0x8C, 0x4F, 0x93, 0x2C, 0xF2, 
                            /* 1208 */    0x8A, 0x75, 0x9A, 0x04, 0x2C, 0xFD, 0xFF, 0x4F, 
                            /* 1210 */    0x93, 0x00, 0xFF, 0xFF, 0xFF, 0x67, 0x07, 0xB0, 
                            /* 1218 */    0x1D, 0xAC, 0x00, 0xA7, 0xE7, 0x79, 0xF0, 0x1C, 
                            /* 1220 */    0x1F, 0x61, 0x1C, 0x99, 0x00, 0x87, 0xFF, 0xFF, 
                            /* 1228 */    0x23, 0x13, 0x78, 0xC6, 0x0A, 0x63, 0x0C, 0x3C, 
                            /* 1230 */    0xF5, 0xE3, 0xD0, 0xC7, 0x01, 0x2A, 0xEA, 0xC0, 
                            /* 1238 */    0x24, 0x18, 0xCE, 0xE2, 0xC3, 0x82, 0x8F, 0x08, 
                            /* 1240 */    0xFC, 0xB0, 0xE0, 0x11, 0x54, 0x3C, 0x4E, 0x7A, 
                            /* 1248 */    0x2C, 0xF2, 0x61, 0x92, 0x1D, 0x12, 0x7C, 0x08, 
                            /* 1250 */    0xF1, 0x20, 0x7D, 0x42, 0x05, 0xCF, 0xC1, 0x0A, 
                            /* 1258 */    0xDE, 0x75, 0x09, 0xCE, 0xA9, 0x00, 0x70, 0x93, 
                            /* 1260 */    0xEB, 0xAD, 0xA2, 0xD3, 0x85, 0x03, 0x1C, 0xC0, 
                            /* 1268 */    0x64, 0xE3, 0x18, 0x42, 0x39, 0x1C, 0xF3, 0xED, 
                            /* 1270 */    0xA1, 0x69, 0xB2, 0x23, 0x19, 0xCC, 0x58, 0x90, 
                            /* 1278 */    0x3A, 0x09, 0x78, 0x00, 0x0E, 0x04, 0x23, 0xED, 
                            /* 1280 */    0x24, 0x1A, 0x8D, 0xE1, 0xAC, 0x16, 0x46, 0x70, 
                            /* 1288 */    0x06, 0xF1, 0x71, 0xC4, 0xB9, 0x8E, 0x54, 0xE8, 
                            /* 1290 */    0xCF, 0x81, 0x8F, 0x53, 0xEC, 0xFF, 0x3F, 0x71, 
                            /* 1298 */    0x07, 0xB9, 0x97, 0xD0, 0x79, 0xFB, 0x6E, 0xC0, 
                            /* 12A0 */    0xDF, 0x69, 0x1E, 0x8B, 0x81, 0x7D, 0x3B, 0x01, 
                            /* 12A8 */    0xC7, 0x5C, 0xAC, 0x06, 0x14, 0x35, 0x00, 0xA3, 
                            /* 12B0 */    0x61, 0x4E, 0x01, 0x4F, 0x25, 0xE0, 0x0A, 0x36, 
                            /* 12B8 */    0x37, 0xF4, 0x85, 0xC5, 0x5A, 0xA7, 0xA2, 0xE3, 
                            /* 12C0 */    0xD3, 0xFB, 0xC0, 0xC1, 0x01, 0x8F, 0xD9, 0x7B, 
                            /* 12C8 */    0x70, 0xB0, 0xD0, 0x3C, 0x38, 0xB0, 0x65, 0x1B, 
                            /* 12D0 */    0x1C, 0x5A, 0xC9, 0x5D, 0x84, 0x1C, 0x3E, 0xF0, 
                            /* 12D8 */    0xB3, 0x03, 0x0E, 0x80, 0x9E, 0x1D, 0x2C, 0x24, 
                            /* 12E0 */    0xCF, 0x0E, 0x6C, 0xFA, 0x70, 0xC9, 0xFF, 0xFF, 
                            /* 12E8 */    0x2C, 0x02, 0x1B, 0xC8, 0xF7, 0x0E, 0x9F, 0x5B, 
                            /* 12F0 */    0x9E, 0x3D, 0xD8, 0x18, 0x1E, 0x5D, 0x8C, 0x66, 
                            /* 12F8 */    0x74, 0xAE, 0xE9, 0x36, 0x81, 0x52, 0x71, 0x9B, 
                            /* 1300 */    0xA0, 0x20, 0xBE, 0x01, 0x38, 0x21, 0x8D, 0xEE, 
                            /* 1308 */    0x69, 0xB8, 0x99, 0x18, 0xFF, 0x11, 0xC3, 0x47, 
                            /* 1310 */    0x84, 0x43, 0x3A, 0x5B, 0x13, 0xCC, 0x03, 0xA9, 
                            /* 1318 */    0xF7, 0xA3, 0x2F, 0x7B, 0xF8, 0xD9, 0x87, 0x7C, 
                            /* 1320 */    0x70, 0xF1, 0x34, 0x7C, 0xBD, 0x21, 0xF7, 0x0E, 
                            /* 1328 */    0x3A, 0x6D, 0x9F, 0x19, 0x30, 0x27, 0x64, 0x5F, 
                            /* 1330 */    0xA7, 0x12, 0x58, 0xD6, 0x55, 0x82, 0x7A, 0xB8, 
                            /* 1338 */    0x80, 0xD0, 0x0B, 0x8D, 0xEF, 0x85, 0x09, 0x1E, 
                            /* 1340 */    0xCE, 0x7C, 0x3B, 0x7B, 0x2F, 0x61, 0x87, 0xC3, 
                            /* 1348 */    0x04, 0xEF, 0x86, 0x09, 0xE6, 0x1D, 0x04, 0x6A, 
                            /* 1350 */    0x54, 0x1E, 0x04, 0xE6, 0xF2, 0xCF, 0xF2, 0x8D, 
                            /* 1358 */    0x01, 0x95, 0xEC, 0xA2, 0x45, 0xCF, 0x30, 0xEF, 
                            /* 1360 */    0x30, 0xBE, 0x24, 0xF8, 0xFA, 0xE1, 0x73, 0x8B, 
                            /* 1368 */    0x17, 0xF0, 0xBA, 0x05, 0x83, 0xE0, 0x19, 0xE8, 
                            /* 1370 */    0xD5, 0xC5, 0xB7, 0x7C, 0x03, 0xBF, 0x0A, 0xBC, 
                            /* 1378 */    0xD1, 0x84, 0x08, 0x66, 0xD8, 0xC3, 0x7F, 0xDB, 
                            /* 1380 */    0x37, 0xAA, 0x6F, 0x3A, 0xC6, 0x7A, 0x1D, 0xF1, 
                            /* 1388 */    0x48, 0xF9, 0xB1, 0xE5, 0x80, 0x22, 0xBD, 0xF5, 
                            /* 1390 */    0x79, 0x02, 0x3E, 0xCB, 0xF8, 0x38, 0x78, 0x52, 
                            /* 1398 */    0xBE, 0x57, 0x1A, 0xFD, 0x15, 0xC2, 0x87, 0x1F, 
                            /* 13A0 */    0x23, 0xFB, 0x9C, 0xC3, 0x0E, 0x86, 0x6C, 0x50, 
                            /* 13A8 */    0x1C, 0xF1, 0x81, 0xE1, 0xA5, 0xC6, 0x53, 0x61, 
                            /* 13B0 */    0xE7, 0x2E, 0x18, 0x07, 0x07, 0x76, 0x2C, 0xC2, 
                            /* 13B8 */    0x5C, 0x1C, 0xB0, 0xFF, 0xFF, 0xA3, 0x1E, 0xEC, 
                            /* 13C0 */    0x93, 0x8D, 0x4F, 0x0E, 0x60, 0x86, 0xC7, 0x9C, 
                            /* 13C8 */    0x98, 0x7D, 0xDE, 0xF0, 0xCD, 0xC0, 0xE3, 0xE2, 
                            /* 13D0 */    0x47, 0x0E, 0x1F, 0xEF, 0x18, 0xF6, 0x69, 0xFA, 
                            /* 13D8 */    0x68, 0xF4, 0xF2, 0xE6, 0xD3, 0x0B, 0x06, 0xD6, 
                            /* 13E0 */    0x97, 0x06, 0x0E, 0x6B, 0xB4, 0xB0, 0x8F, 0x01, 
                            /* 13E8 */    0x67, 0xEE, 0x0B, 0x11, 0xEE, 0xD4, 0x09, 0x16, 
                            /* 13F0 */    0x40, 0xFC, 0xAD, 0xE4, 0x91, 0xC3, 0x13, 0x30, 
                            /* 13F8 */    0x20, 0xD3, 0xB4, 0x2E, 0x1D, 0x88, 0xF8, 0x29, 
                            /* 1400 */    0xCF, 0xCA, 0x57, 0xA6, 0xCB, 0x10, 0xC3, 0x78, 
                            /* 1408 */    0x1C, 0x7D, 0xFC, 0xF0, 0x6C, 0x7C, 0x14, 0xF0, 
                            /* 1410 */    0x31, 0xCA, 0x33, 0x3F, 0xA3, 0x48, 0xAF, 0x0C, 
                            /* 1418 */    0x04, 0x54, 0x27, 0x22, 0xAE, 0x10, 0x46, 0x62, 
                            /* 1420 */    0x68, 0x74, 0xE7, 0xE0, 0xF1, 0x87, 0x48, 0x41, 
                            /* 1428 */    0x0C, 0xE8, 0x9B, 0x0B, 0x30, 0x3D, 0x13, 0x81, 
                            /* 1430 */    0xEB, 0xFF, 0x7F, 0x73, 0x01, 0xF8, 0xFF, 0xFF, 
                            /* 1438 */    0xBF, 0xB9, 0x00, 0xEE, 0xEE, 0x0F, 0xBE, 0xB9, 
                            /* 1440 */    0x00, 0xD7, 0x48, 0xAB, 0xA2, 0x37, 0x7D, 0x87, 
                            /* 1448 */    0x80, 0x41, 0x5D, 0xF6, 0x01, 0x6B, 0xC7, 0x8D, 
                            /* 1450 */    0x97, 0x88, 0x87, 0x8D, 0xFF, 0xFF, 0x93, 0xC1, 
                            /* 1458 */    0xEB, 0x7D, 0x94, 0x67, 0x82, 0x53, 0x78, 0xCA, 
                            /* 1460 */    0x3F, 0xAC, 0x38, 0xEF, 0x1B, 0x21, 0x5E, 0xF6, 
                            /* 1468 */    0x7D, 0xCB, 0xF7, 0xD9, 0xF4, 0x65, 0xDF, 0x37, 
                            /* 1470 */    0x7D, 0xA3, 0x45, 0x09, 0xF6, 0xAC, 0x1F, 0x22, 
                            /* 1478 */    0x68, 0xA4, 0x10, 0x01, 0x43, 0x3C, 0xF2, 0xC7, 
                            /* 1480 */    0x0A, 0x17, 0xFD, 0x65, 0x9F, 0x05, 0x78, 0x13, 
                            /* 1488 */    0xE8, 0x28, 0xE3, 0xCB, 0x3E, 0xC0, 0x8F, 0x33, 
                            /* 1490 */    0xEC, 0xBB, 0x34, 0x78, 0xAF, 0xBA, 0xC0, 0xEA, 
                            /* 1498 */    0xFF, 0x7F, 0xD5, 0x05, 0x9E, 0x82, 0xEF, 0xD3, 
                            /* 14A0 */    0x20, 0x1F, 0x2F, 0x18, 0xC6, 0xC1, 0x95, 0x93, 
                            /* 14A8 */    0xD0, 0x63, 0x81, 0xB5, 0xC2, 0xA0, 0xEE, 0xD4, 
                            /* 14B0 */    0xE0, 0xD2, 0x04, 0xAE, 0x8B, 0xAF, 0x0F, 0x35, 
                            /* 14B8 */    0x3E, 0xD2, 0xE2, 0xCF, 0x17, 0xB8, 0x00, 0x43, 
                            /* 14C0 */    0xA6, 0xA7, 0x32, 0x18, 0xD7, 0x14, 0x9F, 0xCA, 
                            /* 14C8 */    0x30, 0x77, 0x07, 0x0F, 0xC8, 0x47, 0x0C, 0xE0, 
                            /* 14D0 */    0xB3, 0x0A, 0x0F, 0x0C, 0x77, 0x5A, 0xF0, 0x4D, 
                            /* 14D8 */    0xC9, 0xA0, 0xE7, 0x18, 0xD4, 0x47, 0x9E, 0x93, 
                            /* 14E0 */    0xF7, 0x3D, 0xE1, 0x71, 0xC2, 0x51, 0xCF, 0x41, 
                            /* 14E8 */    0x74, 0x6C, 0xF8, 0xFF, 0xFF, 0xD8, 0xE0, 0x1C, 
                            /* 14F0 */    0x37, 0xC0, 0x71, 0xB8, 0xC1, 0x1D, 0x74, 0x7C, 
                            /* 14F8 */    0x31, 0x38, 0x2E, 0x0C, 0xDC, 0x73, 0x81, 0x87, 
                            /* 1500 */    0xE1, 0x9B, 0x8E, 0x47, 0x84, 0x19, 0xFF, 0xEB, 
                            /* 1508 */    0x9F, 0x11, 0x02, 0xE2, 0x2F, 0x46, 0x6C, 0xC0, 
                            /* 1510 */    0x60, 0xBC, 0xB5, 0xF9, 0xFA, 0x86, 0x1B, 0xB0, 
                            /* 1518 */    0xAF, 0x0E, 0xBE, 0x60, 0xF8, 0x04, 0x66, 0xF4, 
                            /* 1520 */    0x17, 0x98, 0x27, 0x31, 0x1F, 0x1B, 0xC8, 0x05, 
                            /* 1528 */    0x8E, 0x0E, 0x18, 0x1C, 0x80, 0x1E, 0x30, 0xFC, 
                            /* 1530 */    0xC3, 0xC5, 0xBB, 0x1C, 0x18, 0xAE, 0x82, 0x3E, 
                            /* 1538 */    0x2E, 0xF8, 0xD8, 0x63, 0x45, 0x77, 0x39, 0xF4, 
                            /* 1540 */    0x4D, 0xCE, 0x30, 0x71, 0x0C, 0xF1, 0x06, 0xC6, 
                            /* 1548 */    0xEE, 0x12, 0xE4, 0x30, 0x07, 0xF5, 0x2E, 0xE1, 
                            /* 1550 */    0x39, 0xF0, 0xB3, 0x85, 0x4F, 0x70, 0xBE, 0xF9, 
                            /* 1558 */    0x84, 0x38, 0xD5, 0x47, 0xAB, 0xF7, 0x00, 0x1F, 
                            /* 1560 */    0x3D, 0xDE, 0xBB, 0x7C, 0x76, 0x62, 0x17, 0x01, 
                            /* 1568 */    0x1F, 0xB9, 0x8C, 0xE3, 0x69, 0xFA, 0x0A, 0xE8, 
                            /* 1570 */    0x21, 0x1B, 0xEC, 0x55, 0xC3, 0x27, 0x30, 0x1F, 
                            /* 1578 */    0xDD, 0xF8, 0xFF, 0x1F, 0xD7, 0xC7, 0x28, 0xCF, 
                            /* 1580 */    0xC4, 0xD3, 0xF7, 0x1D, 0x84, 0x1D, 0x49, 0x8E, 
                            /* 1588 */    0x3A, 0xD4, 0x35, 0x3D, 0xA2, 0x9C, 0xD0, 0x81, 
                            /* 1590 */    0xF8, 0xD6, 0x06, 0xCE, 0x68, 0xF7, 0x0F, 0xF4, 
                            /* 1598 */    0x36, 0x3D, 0x32, 0xCC, 0xD1, 0x00, 0xD6, 0x25, 
                            /* 15A0 */    0x04, 0x5C, 0x77, 0x0C, 0x5F, 0x42, 0x80, 0x4F, 
                            /* 15A8 */    0xD0, 0x4B, 0x04, 0xFA, 0x9A, 0xE1, 0xD1, 0x3D, 
                            /* 15B0 */    0x02, 0x60, 0xAE, 0x18, 0xEC, 0x58, 0xE0, 0xC3, 
                            /* 15B8 */    0x86, 0xAF, 0x01, 0xEC, 0x5E, 0xE0, 0x30, 0xF7, 
                            /* 15C0 */    0x08, 0x50, 0x81, 0x7A, 0x78, 0xF0, 0xD5, 0xDE, 
                            /* 15C8 */    0x23, 0x40, 0x71, 0xB2, 0xF4, 0xA1, 0xC1, 0x03, 
                            /* 15D0 */    0xB5, 0xAA, 0x33, 0x26, 0x94, 0x23, 0x26, 0x87, 
                            /* 15D8 */    0x8A, 0xC6, 0x6E, 0x05, 0xEC, 0x76, 0xE9, 0x9B, 
                            /* 15E0 */    0x04, 0xEE, 0xFF, 0x7F, 0x93, 0xC0, 0xE7, 0x99, 
                            /* 15E8 */    0x05, 0x2A, 0xC9, 0x4D, 0x02, 0x3A, 0x4C, 0x97, 
                            /* 15F0 */    0x97, 0x19, 0x3A, 0xFF, 0x03, 0xF7, 0xAD, 0xCE, 
                            /* 15F8 */    0x23, 0xF4, 0x21, 0x82, 0xA1, 0xBC, 0xE7, 0xF9, 
                            /* 1600 */    0x14, 0xC6, 0xCF, 0x10, 0x3E, 0x60, 0xB2, 0x33, 
                            /* 1608 */    0x05, 0x3F, 0x6B, 0xE2, 0xEE, 0x00, 0x46, 0x79, 
                            /* 1610 */    0xF3, 0xF4, 0x04, 0xD8, 0xF9, 0xD3, 0xC8, 0xEF, 
                            /* 1618 */    0x06, 0xEF, 0x02, 0x9E, 0xBE, 0xEF, 0x45, 0xFC, 
                            /* 1620 */    0x44, 0x01, 0xBE, 0x60, 0x77, 0x3A, 0x28, 0xD0, 
                            /* 1628 */    0x27, 0xE4, 0x11, 0x19, 0xD5, 0x47, 0x04, 0x7E, 
                            /* 1630 */    0x49, 0x02, 0xE3, 0x91, 0xC4, 0x07, 0x0A, 0x20, 
                            /* 1638 */    0x74, 0x2F, 0x40, 0x9D, 0x3E, 0x38, 0xEA, 0x19, 
                            /* 1640 */    0xBF, 0xA0, 0x1A, 0xF3, 0xDD, 0xEA, 0x11, 0xCE, 
                            /* 1648 */    0x93, 0xC3, 0x5C, 0x0E, 0x58, 0x9C, 0x6B, 0x12, 
                            /* 1650 */    0xA8, 0x8E, 0xBB, 0x7C, 0x74, 0x98, 0xFF, 0xFF, 
                            /* 1658 */    0xE8, 0x60, 0x5C, 0x5B, 0xF1, 0x83, 0x7B, 0x67, 
                            /* 1660 */    0x79, 0xE7, 0x33, 0x94, 0x07, 0x09, 0xBE, 0x6B, 
                            /* 1668 */    0x2B, 0x38, 0xAE, 0x6A, 0x30, 0x8E, 0x2D, 0xFC, 
                            /* 1670 */    0x92, 0x07, 0xD8, 0x19, 0x16, 0x17, 0xFC, 0xF7, 
                            /* 1678 */    0x30, 0x10, 0x95, 0x08, 0x83, 0x22, 0xB0, 0xBC, 
                            /* 1680 */    0x7B, 0x2B, 0x85, 0x3F, 0x64, 0x30, 0xDE, 0x14, 
                            /* 1688 */    0xF8, 0xA4, 0xB1, 0xA3, 0x06, 0x3E, 0xFF, 0xFF, 
                            /* 1690 */    0x51, 0x03, 0x9B, 0xA1, 0xE2, 0x6E, 0x8A, 0x60, 
                            /* 1698 */    0x9D, 0x2A, 0x66, 0x08, 0x3C, 0xD8, 0x03, 0xC0, 
                            /* 16A0 */    0xE7, 0x2B, 0x9F, 0x01, 0x14, 0x05, 0x06, 0x75, 
                            /* 16A8 */    0x68, 0x87, 0x73, 0x1B, 0x06, 0x1C, 0x8C, 0x18, 
                            /* 16B0 */    0x77, 0x29, 0x84, 0x3B, 0xE5, 0x77, 0x94, 0xD8, 
                            /* 16B8 */    0xCF, 0xE5, 0x6C, 0xBA, 0xB8, 0xAB, 0xB9, 0x4F, 
                            /* 16C0 */    0x27, 0xEC, 0x82, 0x0C, 0xE3, 0x2C, 0xF0, 0x08, 
                            /* 16C8 */    0xF0, 0x6A, 0xCE, 0x2F, 0xC8, 0x2F, 0xC4, 0x2F, 
                            /* 16D0 */    0x04, 0x6F, 0xC8, 0xBE, 0x29, 0x3D, 0x1B, 0xBC, 
                            /* 16D8 */    0xEC, 0xC4, 0x78, 0x37, 0xF6, 0x29, 0xD9, 0xE7, 
                            /* 16E0 */    0x9D, 0x17, 0x64, 0x63, 0x1C, 0x4D, 0xC4, 0x28, 
                            /* 16E8 */    0xE7, 0xF6, 0x30, 0xF0, 0x9A, 0x6C, 0x94, 0xF7, 
                            /* 16F0 */    0x93, 0x17, 0x82, 0x88, 0xD1, 0x0C, 0x11, 0x34, 
                            /* 16F8 */    0x46, 0xA0, 0x58, 0xFF, 0xFF, 0x40, 0xF1, 0x5E, 
                            /* 1700 */    0x90, 0x99, 0xC0, 0xB7, 0x82, 0x0E, 0x2E, 0xBE, 
                            /* 1708 */    0x20, 0x03, 0xFC, 0x38, 0x19, 0x01, 0x36, 0xFF, 
                            /* 1710 */    0xFF, 0x27, 0x0E, 0xEC, 0xA5, 0x1A, 0x7C, 0x27, 
                            /* 1718 */    0x1B, 0xC0, 0xD9, 0xD0, 0x7D, 0xB2, 0x01, 0xF7, 
                            /* 1720 */    0x68, 0xE1, 0x1D, 0x4D, 0x10, 0x27, 0x1B, 0x0A, 
                            /* 1728 */    0xE4, 0xE0, 0xEB, 0xA2, 0x70, 0x3C, 0xF4, 0x49, 
                            /* 1730 */    0x84, 0x1E, 0x9D, 0x7C, 0x94, 0xC4, 0x9D, 0x19, 
                            /* 1738 */    0x3C, 0x91, 0x77, 0x16, 0x8F, 0xE2, 0x65, 0xD0, 
                            /* 1740 */    0xF7, 0x82, 0x13, 0x79, 0x7D, 0xB0, 0x9C, 0x63, 
                            /* 1748 */    0x24, 0xA8, 0x46, 0xE2, 0xE3, 0x03, 0xFC, 0xEB, 
                            /* 1750 */    0x8B, 0x8F, 0x91, 0xD8, 0xFF, 0xFF, 0x31, 0x12, 
                            /* 1758 */    0x06, 0x9F, 0x7F, 0x58, 0x1E, 0x8C, 0x21, 0x7D, 
                            /* 1760 */    0x8A, 0xE4, 0x20, 0xCF, 0x2E, 0x8F, 0x21, 0xFC, 
                            /* 1768 */    0x02, 0x09, 0xF7, 0x34, 0x73, 0x00, 0x18, 0x59, 
                            /* 1770 */    0x97, 0x47, 0xF4, 0xD9, 0x91, 0x63, 0xC4, 0xF5, 
                            /* 1778 */    0x45, 0xD1, 0x57, 0x60, 0x1F, 0x04, 0xCE, 0xE7, 
                            /* 1780 */    0x39, 0x11, 0xAC, 0xA3, 0xE6, 0x47, 0x1B, 0x3E, 
                            /* 1788 */    0x7E, 0x0E, 0xFE, 0x56, 0xF0, 0x40, 0xE9, 0x63, 
                            /* 1790 */    0x51, 0x88, 0x47, 0x24, 0x7E, 0x4E, 0x04, 0x97, 
                            /* 1798 */    0x89, 0x73, 0x22, 0x90, 0x38, 0xF4, 0xC2, 0x38, 
                            /* 17A0 */    0x2D, 0xE0, 0x06, 0xE2, 0x33, 0x25, 0x76, 0xCA, 
                            /* 17A8 */    0x27, 0xC2, 0xCE, 0x25, 0x98, 0xD1, 0x81, 0xEB, 
                            /* 17B0 */    0x72, 0xEF, 0xD1, 0x81, 0xF1, 0xFF, 0x7F, 0x12, 
                            /* 17B8 */    0x80, 0x8D, 0xF5, 0x78, 0x07, 0xBE, 0x93, 0xBA, 
                            /* 17C0 */    0xEF, 0x26, 0xBE, 0xC8, 0xF8, 0x50, 0xF4, 0x7C, 
                            /* 17C8 */    0x07, 0xF8, 0x0F, 0x77, 0xB8, 0x43, 0xC5, 0x39, 
                            /* 17D0 */    0xDF, 0x01, 0x52, 0xFE, 0xFF, 0xE7, 0x3B, 0xC0, 
                            /* 17D8 */    0xC2, 0xD9, 0xFA, 0xF9, 0x0E, 0xEC, 0x22, 0xCF, 
                            /* 17E0 */    0x77, 0x00, 0x71, 0xFE, 0xFF, 0xE7, 0x3B, 0xC0, 
                            /* 17E8 */    0xDE, 0x19, 0x0D, 0x77, 0xBE, 0x03, 0xDB, 0xD1, 
                            /* 17F0 */    0x06, 0x30, 0x37, 0x8D, 0x47, 0x1B, 0x70, 0x0F, 
                            /* 17F8 */    0x17, 0xFF, 0xFF, 0x3F, 0xE1, 0xC1, 0x52, 0x68, 
                            /* 1800 */    0xD3, 0xA7, 0x46, 0xA3, 0x56, 0x0D, 0xCA, 0xD4, 
                            /* 1808 */    0x28, 0xD3, 0xA0, 0x56, 0x9F, 0x4A, 0x8D, 0x19, 
                            /* 1810 */    0x8B, 0x0F, 0xA5, 0x80, 0x8F, 0x0A, 0x8D, 0xCD, 
                            /* 1818 */    0xF2, 0x28, 0x04, 0x62, 0x31, 0xAF, 0x06, 0x81, 
                            /* 1820 */    0x38, 0x2C, 0x08, 0x8D, 0xF4, 0xCA, 0x11, 0x88, 
                            /* 1828 */    0x25, 0x3F, 0xFB, 0x05, 0x62, 0xB9, 0x6F, 0x06, 
                            /* 1830 */    0x81, 0x38, 0xE0, 0x1B, 0x4C, 0xE0, 0xE4, 0x61, 
                            /* 1838 */    0x25, 0x70, 0xF2, 0x6E, 0x10, 0x88, 0x23, 0x83, 
                            /* 1840 */    0x50, 0xA1, 0x3A, 0x40, 0x58, 0x4C, 0x10, 0x1A, 
                            /* 1848 */    0xCA, 0x07, 0x08, 0x93, 0xFE, 0x48, 0x10, 0x20, 
                            /* 1850 */    0x31, 0x02, 0xC2, 0xC2, 0xBD, 0xBF, 0x04, 0x62, 
                            /* 1858 */    0x69, 0xEF, 0x09, 0x81, 0x58, 0x88, 0x15, 0x10, 
                            /* 1860 */    0x16, 0x17, 0x84, 0x86, 0xD3, 0x02, 0xC2, 0x24, 
                            /* 1868 */    0x99, 0x01, 0x61, 0x81, 0x40, 0xA8, 0x7C, 0x35, 
                            /* 1870 */    0x20, 0x4C, 0xA4, 0x1B, 0x40, 0xBA, 0x7A, 0x81, 
                            /* 1878 */    0x38, 0x88, 0x1E, 0x10, 0x26, 0xC3, 0x0F, 0x08, 
                            /* 1880 */    0x0B, 0x0D, 0x42, 0xA3, 0x3D, 0x30, 0x04, 0x48, 
                            /* 1888 */    0x0C, 0x81, 0xB0, 0xF8, 0x8E, 0x40, 0x98, 0xF8, 
                            /* 1890 */    0x57, 0x91, 0x40, 0x9C, 0xDF, 0x12, 0xC4, 0x4D, 
                            /* 1898 */    0x69, 0x88, 0x35, 0x01, 0x31, 0x0D, 0x9E, 0x80, 
                            /* 18A0 */    0x98, 0x22, 0x10, 0x01, 0x39, 0xF6, 0xD3, 0x43, 
                            /* 18A8 */    0x40, 0xD6, 0x60, 0x0A, 0x88, 0x45, 0x07, 0x11, 
                            /* 18B0 */    0x90, 0x85, 0xA8, 0x02, 0x62, 0x79, 0x5D, 0x01, 
                            /* 18B8 */    0xB1, 0xF0, 0x20, 0x02, 0x72, 0xE6, 0x97, 0x9F, 
                            /* 18C0 */    0x80, 0xAC, 0xE0, 0xA5, 0xF3, 0x10, 0xC0, 0xDE, 
                            /* 18C8 */    0x10, 0x81, 0x48, 0x72, 0x10, 0x01, 0x39, 0xB0, 
                            /* 18D0 */    0x2F, 0x20, 0x16, 0x1F, 0x44, 0x40, 0xCE, 0xFA, 
                            /* 18D8 */    0x28, 0x14, 0x90, 0x83, 0x83, 0x68, 0x10, 0xE4, 
                            /* 18E0 */    0x6B, 0x26, 0x20, 0xA7, 0x07, 0x11, 0x10, 0xF9, 
                            /* 18E8 */    0x04, 0x05, 0x21, 0x6A, 0xBD, 0x81, 0x30, 0x3D, 
                            /* 18F0 */    0x8F, 0x42, 0x0D, 0x85, 0x80, 0x50, 0xE5, 0xEA, 
                            /* 18F8 */    0xCE, 0x31, 0x2C, 0x07, 0x08, 0xF9, 0xFF, 0x13, 
                            /* 1900 */    0xCC, 0x05, 0x22, 0x30, 0xAB, 0x70, 0x07, 0xC4, 
                            /* 1908 */    0x54, 0x81, 0x08, 0xC8, 0x09, 0x80, 0x68, 0x2A, 
                            /* 1910 */    0x10, 0x9A, 0x12, 0x8C, 0xEA, 0x92, 0x07, 0xC4, 
                            /* 1918 */    0x12, 0x80, 0xD0, 0x54, 0x20, 0x34, 0x25, 0x88, 
                            /* 1920 */    0x00, 0xAD, 0xCA, 0x1E, 0x10, 0x53, 0x0A, 0x42, 
                            /* 1928 */    0x95, 0x83, 0xD0, 0x74, 0x20, 0x54, 0xB6, 0xBE, 
                            /* 1930 */    0xC3, 0x02, 0x05, 0x11, 0x90, 0xA3, 0x83, 0x50, 
                            /* 1938 */    0xE1, 0xFE, 0x40, 0x98, 0xDE, 0x97, 0x86, 0x00, 
                            /* 1940 */    0x9D, 0x0E, 0x44, 0x40, 0x4E, 0x0C, 0x42, 0x15, 
                            /* 1948 */    0x7C, 0x32, 0x82, 0x10, 0xB1, 0x20, 0x54, 0xC1, 
                            /* 1950 */    0x27, 0x23, 0x28, 0xD1, 0xF2, 0xB2, 0x13, 0x90, 
                            /* 1958 */    0xF5, 0x81, 0x50, 0xBD, 0x20, 0x02, 0x73, 0x36, 
                            /* 1960 */    0x20, 0x9A, 0x17, 0x84, 0xE6, 0x07, 0xA3, 0x5A, 
                            /* 1968 */    0x8D, 0x02, 0x31, 0xFD, 0x20, 0x34, 0x0F, 0x88, 
                            /* 1970 */    0xC0, 0xAC, 0xE0, 0xF9, 0x71, 0xC0, 0x0C, 0x84, 
                            /* 1978 */    0xAA, 0x04, 0x11, 0x98, 0x73, 0x01, 0xD1, 0xAC, 
                            /* 1980 */    0x20, 0x34, 0x3B, 0x18, 0xD5, 0xFE, 0x0F, 0xD1, 
                            /* 1988 */    0x00, 0x08, 0x08, 0xCD, 0x07, 0xA2, 0xC3, 0x00, 
                            /* 1990 */    0x79, 0x96, 0x09, 0xC8, 0x1A, 0x41, 0xA8, 0x66, 
                            /* 1998 */    0x10, 0x1D, 0x0F, 0x08, 0x10, 0xCD, 0x0F, 0x42, 
                            /* 19A0 */    0xF5, 0xFC, 0x4D, 0x82, 0x91, 0x0C, 0x20, 0x02, 
                            /* 19A8 */    0xB2, 0x96, 0x27, 0x68, 0x20, 0x92, 0xEA, 0x19, 
                            /* 19B0 */    0x14, 0x88, 0x24, 0x05, 0xA1, 0xC9, 0x41, 0x04, 
                            /* 19B8 */    0x66, 0xA5, 0x6F, 0x1D, 0x01, 0x59, 0x3D, 0x08, 
                            /* 19C0 */    0x4D, 0x03, 0x22, 0x30, 0x67, 0x71, 0x0B, 0xC2, 
                            /* 19C8 */    0x94, 0x3C, 0x5B, 0x04, 0xE2, 0x94, 0x20, 0x34, 
                            /* 19D0 */    0xA1, 0xDD, 0x23, 0x02, 0x7D, 0xAF, 0x3C, 0x1A, 
                            /* 19D8 */    0x30, 0x10, 0x9A, 0x12, 0x44, 0x47, 0x04, 0x22, 
                            /* 19E0 */    0x18, 0xC8, 0xFF, 0xFF, 0x41, 0x0B, 0x84, 0x6A, 
                            /* 19E8 */    0x07, 0xD1, 0xD0, 0x08, 0x10, 0xCD, 0x0F, 0x42, 
                            /* 19F0 */    0xF5, 0xBC, 0xD1, 0x34, 0x4C, 0xF2, 0x41, 0x12, 
                            /* 19F8 */    0x88, 0xD3, 0x80, 0x50, 0x95, 0x5F, 0x2B, 0x1D, 
                            /* 1A00 */    0x08, 0xC8, 0x97, 0x48, 0x07, 0x02, 0x02, 0x42, 
                            /* 1A08 */    0xF5, 0x82, 0xE8, 0x40, 0x40, 0x80, 0x68, 0x5E, 
                            /* 1A10 */    0x10, 0x9A, 0x1F, 0x8C, 0xE6, 0x7F, 0x07, 0xE9, 
                            /* 1A18 */    0xF8, 0x41, 0x1E, 0x6E, 0x1A, 0x18, 0x01, 0xA1, 
                            /* 1A20 */    0xEA, 0x7E, 0x35, 0x41, 0x88, 0xB2, 0xA7, 0x95, 
                            /* 1A28 */    0x40, 0xC8, 0xAB, 0x26, 0x30, 0xFB, 0xD5, 0x6A, 
                            /* 1A30 */    0x00, 0xD6, 0x64, 0xFC, 0x18, 0x40, 0x41, 0x04, 
                            /* 1A38 */    0xE6, 0x4C, 0x40, 0x34, 0x27, 0x08, 0xCD, 0x0D, 
                            /* 1A40 */    0x42, 0xF5, 0x7C, 0x71, 0x34, 0x4C, 0x02, 0x22, 
                            /* 1A48 */    0x50, 0xEB, 0x7D, 0xEC, 0x04, 0x21, 0x69, 0x41, 
                            /* 1A50 */    0x68, 0x92, 0x97, 0x58, 0x10, 0x92, 0xC2, 0xFB, 
                            /* 1A58 */    0x20, 0xA9, 0x78, 0x10, 0xA6, 0x5B, 0x3D, 0x38, 
                            /* 1A60 */    0xCB, 0x02, 0x42, 0xB3, 0x81, 0x68, 0xA0, 0xE4, 
                            /* 1A68 */    0x6D, 0x77, 0xA0, 0x0C, 0x84, 0xEA, 0x05, 0x11, 
                            /* 1A70 */    0x98, 0x73, 0x02, 0xD1, 0xEC, 0x20, 0x54, 0xD9, 
                            /* 1A78 */    0x33, 0x4D, 0xC3, 0x20, 0x20, 0x02, 0x72, 0x32, 
                            /* 1A80 */    0x10, 0x9A, 0x14, 0x8C, 0x26, 0xF5, 0x0F, 0xC2, 
                            /* 1A88 */    0x74, 0xBE, 0x52, 0x35, 0x60, 0x52, 0x60, 0xA0, 
                            /* 1A90 */    0x14, 0x84, 0x26, 0x4D, 0x70, 0xA8, 0xA1, 0x19, 
                            /* 1A98 */    0xC0, 0x99, 0x24, 0x10, 0x2A, 0x13, 0x44, 0x07, 
                            /* 1AA0 */    0x15, 0x6B, 0x06, 0x11, 0xA0, 0xE3, 0x81, 0xD1, 
                            /* 1AA8 */    0xA8, 0x20, 0x34, 0x3E, 0x20, 0xD5, 0xD2, 0xE1, 
                            /* 1AB0 */    0xA0, 0x42, 0x41, 0x04, 0xE6, 0x14, 0x20, 0x34, 
                            /* 1AB8 */    0x19, 0x88, 0x00, 0x1D, 0x13, 0x90, 0x86, 0x08, 
                            /* 1AC0 */    0x01, 0xC6, 0x22, 0x81, 0x90, 0xFF, 0xFF, 0x81, 
                            /* 1AC8 */    0x44, 0x20, 0x34, 0x69, 0x09, 0x50, 0x96, 0x1B, 
                            /* 1AD0 */    0x44, 0x83, 0x26, 0x29, 0x8E, 0x12, 0x14, 0x84, 
                            /* 1AD8 */    0x66, 0x04, 0xA1, 0x99, 0x41, 0x68, 0x98, 0x16, 
                            /* 1AE0 */    0x20, 0x2C, 0x18, 0x08, 0x0D, 0x0B, 0xA2, 0xE3, 
                            /* 1AE8 */    0x0D, 0x01, 0xD1, 0xF1, 0x83, 0xC4, 0x38, 0x4C, 
                            /* 1AF0 */    0x50, 0x10, 0xAA, 0xA6, 0x06, 0x08, 0x0B, 0x0F, 
                            /* 1AF8 */    0x22, 0x50, 0x4B, 0xC9, 0x01, 0xCA, 0xA2, 0x80, 
                            /* 1B00 */    0x08, 0xCC, 0x01, 0x41, 0x68, 0x6C, 0x10, 0x2A, 
                            /* 1B08 */    0xA3, 0x07, 0x08, 0x8B, 0x18, 0x04, 0x94, 0x09, 
                            /* 1B10 */    0x2C, 0x02, 0xC2, 0x24, 0x36, 0x39, 0xC2, 0x50, 
                            /* 1B18 */    0x10, 0x1A, 0x03, 0x44, 0x60, 0x0E, 0x0E, 0x44, 
                            /* 1B20 */    0xC5, 0x44, 0x01, 0x61, 0xE2, 0x40, 0x68, 0x0C, 
                            /* 1B28 */    0x10, 0x01, 0x12, 0x20, 0x2A, 0xA6, 0x0A, 0x20, 
                            /* 1B30 */    0x05, 0xA1, 0x29, 0x40, 0xA8, 0xAA, 0x2C, 0x87, 
                            /* 1B38 */    0x10, 0x0A, 0xA2, 0x43, 0x0A, 0x01, 0xA1, 0x79, 
                            /* 1B40 */    0xC1, 0xA8, 0xCE, 0x2E, 0x47, 0x0F, 0x0A, 0x42, 
                            /* 1B48 */    0xB3, 0x80, 0xD0, 0xE0, 0x20, 0x34, 0x57, 0x98, 
                            /* 1B50 */    0xC3, 0x03, 0x2D, 0x73, 0x78, 0xA0, 0x20, 0x54, 
                            /* 1B58 */    0x2F, 0x88, 0x8E, 0x25, 0x04, 0x88, 0x26, 0x07, 
                            /* 1B60 */    0xA1, 0xBA, 0xD2, 0x1C, 0x58, 0x68, 0x9E, 0x03, 
                            /* 1B68 */    0x0D, 0xED, 0x73, 0x64, 0xA0, 0x20, 0x34, 0x53, 
                            /* 1B70 */    0xA1, 0x83, 0x06, 0x05, 0xA1, 0xB9, 0x41, 0xA8, 
                            /* 1B78 */    0xB2, 0x44, 0xC3, 0xA3, 0x20, 0x02, 0x75, 0x72, 
                            /* 1B80 */    0x20, 0xAA, 0xA6, 0x11, 0x08, 0x53, 0x07, 0xA2, 
                            /* 1B88 */    0x01, 0x10, 0x20, 0x9A, 0x13, 0x84, 0xE6, 0x06, 
                            /* 1B90 */    0xA3, 0x0A, 0x3B, 0x81, 0xB0, 0x7C, 0x20, 0xE4, 
                            /* 1B98 */    0xFF, 0x7F, 0x64, 0x52, 0x28, 0x10, 0xF6, 0xFF, 
                            /* 1BA0 */    0x07
                        })
                    }

                    Mutex (MUTS, 0x00)
                    Method (SWSI, 5, NotSerialized)
                    {
                        Acquire (MUTS, 0xFFFF)
                        If (Arg4)
                        {
                            Acquire (_GL, 0xFFFF)
                        }

                        ShiftLeft (Arg0, 0x10, AEAX)
                        Store (Arg1, AEBX)
                        Store (Arg2, AECX)
                        Store (Arg3, AEDX)
                        Store (Zero, AREF)
                        GSMI (Arg0)
                        Store (AREF, Local0)
                        If (Arg4)
                        {
                            Release (_GL)
                        }

                        Release (MUTS)
                        Return (Local0)
                    }

                    Method (GSMI, 1, NotSerialized)
                    {
                        Store (0x5F, ^PCI0.SBRG.APMC)
                    }
                }
            }

            Device (IDE0)
            {
                Name (_ADR, 0x001F0001)
                Name (^NATA, Package (0x01)
                {
                    0x001F0001
                })
                Name (REGF, One)
                Method (_REG, 2, NotSerialized)
                {
                    If (LEqual (Arg0, 0x02))
                    {
                        Store (Arg1, REGF)
                    }
                }

                Name (TIM0, Package (0x08)
                {
                    Package (0x04)
                    {
                        0x78, 
                        0xB4, 
                        0xF0, 
                        0x0384
                    }, 

                    Package (0x04)
                    {
                        0x23, 
                        0x21, 
                        0x10, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x0B, 
                        0x09, 
                        0x04, 
                        Zero
                    }, 

                    Package (0x06)
                    {
                        0x78, 
                        0x5A, 
                        0x3C, 
                        0x28, 
                        0x1E, 
                        0x14
                    }, 

                    Package (0x06)
                    {
                        Zero, 
                        One, 
                        0x02, 
                        One, 
                        0x02, 
                        One
                    }, 

                    Package (0x06)
                    {
                        Zero, 
                        Zero, 
                        Zero, 
                        One, 
                        One, 
                        One
                    }, 

                    Package (0x04)
                    {
                        0x04, 
                        0x03, 
                        0x02, 
                        Zero
                    }, 

                    Package (0x04)
                    {
                        0x02, 
                        One, 
                        Zero, 
                        Zero
                    }
                })
                Name (TMD0, Buffer (0x14) {})
                CreateDWordField (TMD0, Zero, PIO0)
                CreateDWordField (TMD0, 0x04, DMA0)
                CreateDWordField (TMD0, 0x08, PIO1)
                CreateDWordField (TMD0, 0x0C, DMA1)
                CreateDWordField (TMD0, 0x10, CHNF)
                OperationRegion (CFG2, PCI_Config, 0x40, 0x20)
                Field (CFG2, DWordAcc, NoLock, Preserve)
                {
                    PMPT,   4, 
                    PSPT,   4, 
                    PMRI,   6, 
                            Offset (0x02), 
                    SMPT,   4, 
                    SSPT,   4, 
                    SMRI,   6, 
                            Offset (0x04), 
                    PSRI,   4, 
                    SSRI,   4, 
                            Offset (0x08), 
                    PM3E,   1, 
                    PS3E,   1, 
                    SM3E,   1, 
                    SS3E,   1, 
                            Offset (0x0A), 
                    PMUT,   2, 
                        ,   2, 
                    PSUT,   2, 
                            Offset (0x0B), 
                    SMUT,   2, 
                        ,   2, 
                    SSUT,   2, 
                            Offset (0x0C), 
                            Offset (0x14), 
                    PM6E,   1, 
                    PS6E,   1, 
                    SM6E,   1, 
                    SS6E,   1, 
                    PMCR,   1, 
                    PSCR,   1, 
                    SMCR,   1, 
                    SSCR,   1, 
                        ,   4, 
                    PMAE,   1, 
                    PSAE,   1, 
                    SMAE,   1, 
                    SSAE,   1
                }

                Name (GMPT, Zero)
                Name (GMUE, Zero)
                Name (GMUT, Zero)
                Name (GMCR, Zero)
                Name (GSPT, Zero)
                Name (GSUE, Zero)
                Name (GSUT, Zero)
                Name (GSCR, Zero)
                Device (CHN0)
                {
                    Name (_ADR, Zero)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (PSCR, One, Local1)
                        Or (PMCR, Local1, Local0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local1)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local2)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (PMRI, Local1, PMUT, PSRI, Local2, PSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (PMAE, 0x02, Local3)
                        ShiftLeft (PM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PM3E, Local3, Local0)
                        ShiftLeft (PMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (PSAE, 0x02, Local3)
                        ShiftLeft (PS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (PS3E, Local3, Local1)
                        ShiftLeft (PSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (PMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (PMUT, GMUT)
                        Store (PMCR, GMCR)
                        Store (PSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (PSUT, GSUT)
                        Store (PSCR, GSCR)
                        STM ()
                        Store (GMPT, PMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, PMUT)
                        Store (GMCR, PMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, PSUT)
                        Store (GSCR, PSCR)
                        If (And (Local0, One))
                        {
                            Store (One, PM3E)
                        }
                        Else
                        {
                            Store (Zero, PM3E)
                        }

                        If (And (Local0, 0x02))
                        {
                            Store (One, PM6E)
                        }
                        Else
                        {
                            Store (Zero, PM6E)
                        }

                        If (And (Local0, 0x04))
                        {
                            Store (One, PMAE)
                        }
                        Else
                        {
                            Store (Zero, PMAE)
                        }

                        If (And (Local1, One))
                        {
                            Store (One, PS3E)
                        }
                        Else
                        {
                            Store (Zero, PS3E)
                        }

                        If (And (Local1, 0x02))
                        {
                            Store (One, PS6E)
                        }
                        Else
                        {
                            Store (Zero, PS6E)
                        }

                        If (And (Local1, 0x04))
                        {
                            Store (One, PSAE)
                        }
                        Else
                        {
                            Store (Zero, PSAE)
                        }

                        Store (GTF (Zero, Arg1), ATA0)
                        Store (GTF (One, Arg2), ATA1)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA0))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA1))
                        }
                    }
                }

                Device (CHN1)
                {
                    Name (_ADR, One)
                    Method (_GTM, 0, NotSerialized)
                    {
                        ShiftLeft (SSCR, One, Local1)
                        Or (SMCR, Local1, Local0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local1)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local2)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local2, Local3, Local2)
                        Return (GTM (SMRI, Local1, SMUT, SSRI, Local2, SSUT, Local0))
                    }

                    Method (_STM, 3, NotSerialized)
                    {
                        Store (Arg0, Debug)
                        Store (Arg0, TMD0)
                        ShiftLeft (SMAE, 0x02, Local3)
                        ShiftLeft (SM6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SM3E, Local3, Local0)
                        ShiftLeft (SMPT, 0x04, Local3)
                        Or (Local0, Local3, Local0)
                        ShiftLeft (SSAE, 0x02, Local3)
                        ShiftLeft (SS6E, One, Local4)
                        Or (Local3, Local4, Local3)
                        Or (SS3E, Local3, Local1)
                        ShiftLeft (SSPT, 0x04, Local3)
                        Or (Local1, Local3, Local1)
                        Store (SMRI, GMPT)
                        Store (Local0, GMUE)
                        Store (SMUT, GMUT)
                        Store (SMCR, GMCR)
                        Store (SSRI, GSPT)
                        Store (Local1, GSUE)
                        Store (SSUT, GSUT)
                        Store (SSCR, GSCR)
                        STM ()
                        Store (GMPT, SMRI)
                        Store (GMUE, Local0)
                        Store (GMUT, SMUT)
                        Store (GMCR, SMCR)
                        Store (GSUE, Local1)
                        Store (GSUT, SSUT)
                        Store (GSCR, SSCR)
                        If (And (Local0, One))
                        {
                            Store (One, SM3E)
                        }
                        Else
                        {
                            Store (Zero, SM3E)
                        }

                        If (And (Local0, 0x02))
                        {
                            Store (One, SM6E)
                        }
                        Else
                        {
                            Store (Zero, SM6E)
                        }

                        If (And (Local0, 0x04))
                        {
                            Store (One, SMAE)
                        }
                        Else
                        {
                            Store (Zero, SMAE)
                        }

                        If (And (Local1, One))
                        {
                            Store (One, SS3E)
                        }
                        Else
                        {
                            Store (Zero, SS3E)
                        }

                        If (And (Local1, 0x02))
                        {
                            Store (One, SS6E)
                        }
                        Else
                        {
                            Store (Zero, SS6E)
                        }

                        If (And (Local1, 0x04))
                        {
                            Store (One, SSAE)
                        }
                        Else
                        {
                            Store (Zero, SSAE)
                        }

                        Store (GTF (Zero, Arg1), ATA2)
                        Store (GTF (One, Arg2), ATA3)
                    }

                    Device (DRV0)
                    {
                        Name (_ADR, Zero)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA2))
                        }
                    }

                    Device (DRV1)
                    {
                        Name (_ADR, One)
                        Method (_GTF, 0, NotSerialized)
                        {
                            Return (RATA (ATA3))
                        }
                    }
                }

                Method (GTM, 7, Serialized)
                {
                    Store (Ones, PIO0)
                    Store (Ones, PIO1)
                    Store (Ones, DMA0)
                    Store (Ones, DMA1)
                    Store (0x10, CHNF)
                    If (REGF) {}
                    Else
                    {
                        Return (TMD0)
                    }

                    If (And (Arg1, 0x20))
                    {
                        Or (CHNF, 0x02, CHNF)
                    }

                    Store (Match (DerefOf (Index (TIM0, One)), MEQ, Arg0, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA0)
                    Store (Local7, PIO0)
                    If (And (Arg4, 0x20))
                    {
                        Or (CHNF, 0x08, CHNF)
                    }

                    Store (Match (DerefOf (Index (TIM0, 0x02)), MEQ, Arg3, MTR, 
                        Zero, Zero), Local6)
                    Store (DerefOf (Index (DerefOf (Index (TIM0, Zero)), Local6)), 
                        Local7)
                    Store (Local7, DMA1)
                    Store (Local7, PIO1)
                    If (And (Arg1, 0x07))
                    {
                        Store (Arg2, Local5)
                        If (And (Arg1, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }

                        If (And (Arg1, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA0)
                        Or (CHNF, One, CHNF)
                    }

                    If (And (Arg4, 0x07))
                    {
                        Store (Arg5, Local5)
                        If (And (Arg4, 0x02))
                        {
                            Add (Local5, 0x02, Local5)
                        }

                        If (And (Arg4, 0x04))
                        {
                            Add (Local5, 0x04, Local5)
                        }

                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x03)), Local5)), 
                            DMA1)
                        Or (CHNF, 0x04, CHNF)
                    }

                    Store (TMD0, Debug)
                    Return (TMD0)
                }

                Method (STM, 0, Serialized)
                {
                    If (REGF) {}
                    Else
                    {
                        Store (Zero, GMUE)
                        Store (Zero, GMUT)
                        Store (Zero, GSUE)
                        Store (Zero, GSUT)
                        If (And (CHNF, One))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA0, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GMUT)
                            Or (GMUE, One, GMUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GMUE, 0x02, GMUE)
                            }

                            If (LGreater (Local0, 0x04))
                            {
                                And (GMUE, 0xFD, GMUE)
                                Or (GMUE, 0x04, GMUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO0, Ones), LEqual (PIO0, Zero)))
                            {
                                If (And (LLess (DMA0, Ones), LGreater (DMA0, Zero)))
                                {
                                    Store (DMA0, PIO0)
                                    Or (GMUE, 0x80, GMUE)
                                }
                            }
                        }

                        If (And (CHNF, 0x04))
                        {
                            Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMA1, MTR, 
                                Zero, Zero), Local0)
                            If (LGreater (Local0, 0x05))
                            {
                                Store (0x05, Local0)
                            }

                            Store (DerefOf (Index (DerefOf (Index (TIM0, 0x04)), Local0)), 
                                GSUT)
                            Or (GSUE, One, GSUE)
                            If (LGreater (Local0, 0x02))
                            {
                                Or (GSUE, 0x02, GSUE)
                            }

                            If (LGreater (Local0, 0x04))
                            {
                                And (GSUE, 0xFD, GSUE)
                                Or (GSUE, 0x04, GSUE)
                            }
                        }
                        Else
                        {
                            If (Or (LEqual (PIO1, Ones), LEqual (PIO1, Zero)))
                            {
                                If (And (LLess (DMA1, Ones), LGreater (DMA1, Zero)))
                                {
                                    Store (DMA1, PIO1)
                                    Or (GSUE, 0x80, GSUE)
                                }
                            }
                        }

                        If (And (CHNF, 0x02))
                        {
                            Or (GMUE, 0x20, GMUE)
                        }

                        If (And (CHNF, 0x08))
                        {
                            Or (GSUE, 0x20, GSUE)
                        }

                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO0, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, One)), Local0)), 
                            Local1)
                        Store (Local1, GMPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GMUE, 0x50, GMUE)
                        }

                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIO1, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Store (DerefOf (Index (DerefOf (Index (TIM0, 0x02)), Local0)), 
                            Local1)
                        Store (Local1, GSPT)
                        If (LLess (Local0, 0x03))
                        {
                            Or (GSUE, 0x50, GSUE)
                        }
                    }
                }

                Name (AT01, Buffer (0x07)
                {
                    0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEF
                })
                Name (AT02, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90
                })
                Name (AT03, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC6
                })
                Name (AT04, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x91
                })
                Name (ATA0, Buffer (0x1D) {})
                Name (ATA1, Buffer (0x1D) {})
                Name (ATA2, Buffer (0x1D) {})
                Name (ATA3, Buffer (0x1D) {})
                Name (ATAB, Buffer (0x1D) {})
                CreateByteField (ATAB, Zero, CMDC)
                Method (GTFB, 3, Serialized)
                {
                    Multiply (CMDC, 0x38, Local0)
                    Add (Local0, 0x08, Local1)
                    CreateField (ATAB, Local1, 0x38, CMDX)
                    Multiply (CMDC, 0x07, Local0)
                    CreateByteField (ATAB, Add (Local0, 0x02), A001)
                    CreateByteField (ATAB, Add (Local0, 0x06), A005)
                    Store (Arg0, CMDX)
                    Store (Arg1, A001)
                    Store (Arg2, A005)
                    Increment (CMDC)
                }

                Method (GTF, 2, Serialized)
                {
                    Store (Arg1, Debug)
                    Store (Zero, CMDC)
                    Name (ID49, 0x0C00)
                    Name (ID59, Zero)
                    Name (ID53, 0x04)
                    Name (ID63, 0x0F00)
                    Name (ID88, 0x0F00)
                    Name (IRDY, One)
                    Name (PIOT, Zero)
                    Name (DMAT, Zero)
                    If (LEqual (SizeOf (Arg1), 0x0200))
                    {
                        CreateWordField (Arg1, 0x62, IW49)
                        Store (IW49, ID49)
                        CreateWordField (Arg1, 0x6A, IW53)
                        Store (IW53, ID53)
                        CreateWordField (Arg1, 0x7E, IW63)
                        Store (IW63, ID63)
                        CreateWordField (Arg1, 0x76, IW59)
                        Store (IW59, ID59)
                        CreateWordField (Arg1, 0xB0, IW88)
                        Store (IW88, ID88)
                    }

                    Store (0xA0, Local7)
                    If (Arg0)
                    {
                        Store (0xB0, Local7)
                        And (CHNF, 0x08, IRDY)
                        If (And (CHNF, 0x10))
                        {
                            Store (PIO1, PIOT)
                        }
                        Else
                        {
                            Store (PIO0, PIOT)
                        }

                        If (And (CHNF, 0x04))
                        {
                            If (And (CHNF, 0x10))
                            {
                                Store (DMA1, DMAT)
                            }
                            Else
                            {
                                Store (DMA0, DMAT)
                            }
                        }
                    }
                    Else
                    {
                        And (CHNF, 0x02, IRDY)
                        Store (PIO0, PIOT)
                        If (And (CHNF, One))
                        {
                            Store (DMA0, DMAT)
                        }
                    }

                    If (LAnd (LAnd (And (ID53, 0x04), And (ID88, 0xFF00
                        )), DMAT))
                    {
                        Store (Match (DerefOf (Index (TIM0, 0x03)), MLE, DMAT, MTR, 
                            Zero, Zero), Local1)
                        If (LGreater (Local1, 0x05))
                        {
                            Store (0x05, Local1)
                        }

                        GTFB (AT01, Or (0x40, Local1), Local7)
                    }
                    Else
                    {
                        If (LAnd (And (ID63, 0xFF00), PIOT))
                        {
                            And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                                Zero, Zero), 0x03, Local0)
                            Or (0x20, DerefOf (Index (DerefOf (Index (TIM0, 0x07)), Local0
                                )), Local1)
                            GTFB (AT01, Local1, Local7)
                        }
                    }

                    If (IRDY)
                    {
                        And (Match (DerefOf (Index (TIM0, Zero)), MGE, PIOT, MTR, 
                            Zero, Zero), 0x07, Local0)
                        Or (0x08, DerefOf (Index (DerefOf (Index (TIM0, 0x06)), Local0
                            )), Local1)
                        GTFB (AT01, Local1, Local7)
                    }
                    Else
                    {
                        If (And (ID49, 0x0400))
                        {
                            GTFB (AT01, One, Local7)
                        }
                    }

                    If (LAnd (And (ID59, 0x0100), And (ID59, 0xFF)))
                    {
                        GTFB (AT03, And (ID59, 0xFF), Local7)
                    }

                    Store (ATAB, Debug)
                    Return (ATAB)
                }

                Method (RATA, 1, NotSerialized)
                {
                    CreateByteField (Arg0, Zero, CMDN)
                    Multiply (CMDN, 0x38, Local0)
                    CreateField (Arg0, 0x08, Local0, RETB)
                    Store (RETB, Debug)
                    Concatenate (RETB, FZTF, RETB)
                    Return (RETB)
                }

                Name (FZTF, Buffer (0x07)
                {
                    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF5
                })
            }

            Device (IDE1)
            {
                Name (_ADR, 0x001F0002)
            }

            Device (USB0)
            {
                Name (_ADR, 0x001D0000)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x03, 0x04))
                }
            }

            Device (USB1)
            {
                Name (_ADR, 0x001D0001)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x04, 0x04))
                }
            }

            Device (USB2)
            {
                Name (_ADR, 0x001D0002)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0C, 0x04))
                }
            }

            Device (USB3)
            {
                Name (_ADR, 0x001D0003)
                OperationRegion (BAR0, PCI_Config, 0xC4, One)
                Field (BAR0, ByteAcc, NoLock, Preserve)
                {
                    USBW,   2, 
                            Offset (0x01)
                }

                Method (_S3D, 0, NotSerialized)
                {
                    If (LOr (LEqual (OSFL (), One), LEqual (OSFL (), 0x02)))
                    {
                        Return (0x02)
                    }
                    Else
                    {
                        Return (0x03)
                    }
                }

                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0E, 0x04))
                }
            }

            Device (EUSB)
            {
                Name (_ADR, 0x001D0007)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x0D, 0x04))
                }
            }

            Device (MC97)
            {
                Name (_ADR, 0x001E0003)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x05, 0x04))
                }
            }

            Device (P0P4)
            {
                Name (_ADR, 0x001C0000)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }
            }

            Device (P0P5)
            {
                Name (_ADR, 0x001C0001)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR05)
                    }

                    Return (PR05)
                }
            }

            Device (P0P6)
            {
                Name (_ADR, 0x001C0002)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR06)
                    }

                    Return (PR06)
                }
            }

            Device (P0P7)
            {
                Name (_ADR, 0x001C0003)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR07)
                    }

                    Return (PR07)
                }
            }

            Device (P0P8)
            {
                Name (_ADR, 0x001C0004)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR08)
                    }

                    Return (PR08)
                }
            }

            Device (P0P9)
            {
                Name (_ADR, 0x001C0005)
                Method (_PRW, 0, NotSerialized)
                {
                    Return (GPRW (0x09, 0x04))
                }

                Method (_PRT, 0, NotSerialized)
                {
                    If (PICM)
                    {
                        Return (AR09)
                    }

                    Return (PR09)
                }
            }

            Device (IGD)
            {
                Name (_ADR, 0x00020000)
                Event (BEVT)
                OperationRegion (IGD2, PCI_Config, 0xF4, 0x04)
                Field (IGD2, ByteAcc, NoLock, Preserve)
                {
                    CSTE,   16, 
                    NSTE,   16
                }

                Name (SWIT, One)
                Name (GDGS, Zero)
                Name (GDSL, One)
                Method (_DOS, 1, NotSerialized)
                {
                    Store (And (Arg0, 0x03), SWIT)
                    Store (SWIT, DBG8)
                }

                Name (_DOD, Package (0x02)
                {
                    0x00010110, 
                    0x00010100
                })
                Device (LCD)
                {
                    Name (_ADR, 0x0110)
                    Name (_DCS, 0x1F)
                    Name (_DGS, One)
                    Method (_DSS, 1, NotSerialized)
                    {
                        And (GDGS, 0x02, GDGS)
                        If (And (Arg0, One))
                        {
                            Or (GDGS, One, GDGS)
                        }

                        If (And (Arg0, 0xC0000000))
                        {
                            If (LEqual (And (Arg0, 0x40000000), Zero))
                            {
                                SDCS ()
                            }
                        }
                    }

                    Name (BCL1, Package (0x0D)
                    {
                        0x5A, 
                        0x41, 
                        0x1C, 
                        0x22, 
                        0x27, 
                        0x2D, 
                        0x32, 
                        0x37, 
                        0x41, 
                        0x46, 
                        0x50, 
                        0x5A, 
                        0x64
                    })
                }

                Device (CRT)
                {
                    Name (_ADR, 0x0100)
                    Name (_DCS, 0x1F)
                    Name (_DGS, One)
                    Method (_DSS, 1, NotSerialized)
                    {
                        And (GDGS, One, GDGS)
                        If (And (Arg0, One))
                        {
                            Or (GDGS, 0x02, GDGS)
                        }

                        If (And (Arg0, 0xC0000000))
                        {
                            If (LEqual (And (Arg0, 0x40000000), Zero)) {}
                        }
                    }
                }

                Method (SDCS, 0, NotSerialized)
                {
                    Store (GDGS, Local0)
                    And (GDGS, One, Local0)
                    ShiftLeft (Local0, One, Local0)
                    Store (^LCD._DCS, Local1)
                    And (Local1, 0xFD, Local1)
                    Or (Local1, Local0, Local1)
                    Store (Local1, ^LCD._DCS)
                    And (GDGS, 0x02, Local0)
                    Store (^CRT._DCS, Local1)
                    And (Local1, 0xFD, Local1)
                    Or (Local1, Local0, Local1)
                    Store (Local1, ^CRT._DCS)
                }

                Method (DCHG, 0, NotSerialized)
                {
                    If (LEqual (SWIT, Zero))
                    {
                        Store (Zero, Local3)
                        Store (0x78, ^^SBRG.APMC)
                        If (LEqual (DDAD, 0x08))
                        {
                            Store (Zero, Local3)
                            Store (One, GDGS)
                            Acquire (ECMX, 0xFFFF)
                            Store (GDGS, ^^SBRG.EC0.IDGS)
                            Release (ECMX)
                            Sleep (0x14)
                        }
                        Else
                        {
                            Store (One, Local3)
                        }

                        If (Local3)
                        {
                            Acquire (ECMX, 0xFFFF)
                            Store (^^SBRG.EC0.IDGS, GDGS)
                            Release (ECMX)
                            Sleep (0x14)
                            Add (GDGS, One, GDGS)
                            Divide (GDGS, 0x04, Local0, Local1)
                            If (LEqual (Local0, Zero))
                            {
                                Store (One, GDGS)
                            }

                            If (LEqual (GDGS, One))
                            {
                                Store (One, ^LCD._DGS)
                                Store (Zero, ^CRT._DGS)
                                Store (One, GDSL)
                            }

                            If (LEqual (GDGS, 0x02))
                            {
                                Store (Zero, ^LCD._DGS)
                                Store (One, ^CRT._DGS)
                                Store (0x02, GDSL)
                            }

                            If (LEqual (GDGS, 0x03))
                            {
                                Store (One, ^LCD._DGS)
                                Store (One, ^CRT._DGS)
                                Store (One, GDSL)
                            }

                            Acquire (ECMX, 0xFFFF)
                            Store (GDGS, ^^SBRG.EC0.IDGS)
                            Release (ECMX)
                            Sleep (0x14)
                            Notify (IGD, 0x80)
                            Sleep (0x32)
                        }
                    }
                }

                Method (VGDD, 1, Serialized)
                {
                    Store (0x91, SSMI)
                    Return (WDST)
                }

                Method (VSDD, 1, Serialized)
                {
                    Store (Arg0, Local0)
                    If (LEqual (And (Local0, One), One))
                    {
                        Store (One, ^LCD._DGS)
                    }
                    Else
                    {
                        Store (Zero, ^LCD._DGS)
                    }

                    If (LEqual (And (Local0, 0x02), 0x02))
                    {
                        Store (One, ^CRT._DGS)
                    }
                    Else
                    {
                        Store (Zero, ^CRT._DGS)
                    }

                    Notify (IGD, 0x80)
                }

                Method (VBRE, 1, Serialized)
                {
                    If (And (Arg0, 0x80))
                    {
                        Notify (LCD, Arg0)
                    }
                }

                Scope (\)
                {
                    Field (BIOS, ByteAcc, NoLock, Preserve)
                    {
                                Offset (0x89), 
                        DDAD,   8
                    }
                }
            }
        }

        Scope (\_GPE)
        {
            Method (_L09, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.P0P2, 0x02)
                Notify (\_SB.PCI0.P0P4, 0x02)
                Notify (\_SB.PCI0.P0P5, 0x02)
                Notify (\_SB.PCI0.P0P6, 0x02)
                Notify (\_SB.PCI0.P0P7, 0x02)
                Notify (\_SB.PCI0.P0P8, 0x02)
                Notify (\_SB.PCI0.P0P9, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0B, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.P0P1, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L03, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB0, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L04, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB1, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0C, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB2, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0E, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.USB3, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L0D, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.EUSB, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }

            Method (_L05, 0, NotSerialized)
            {
                Notify (\_SB.PCI0.MC97, 0x02)
                Notify (\_SB.PWRB, 0x02)
            }
        }

        Device (PWRB)
        {
            Name (_HID, EisaId ("PNP0C0C"))
            Name (_UID, 0xAA)
            Name (_STA, 0x0B)
        }
    }

    OperationRegion (_SB.PCI0.SBRG.PIX0, PCI_Config, 0x60, 0x0C)
    Field (\_SB.PCI0.SBRG.PIX0, ByteAcc, NoLock, Preserve)
    {
        PIRA,   8, 
        PIRB,   8, 
        PIRC,   8, 
        PIRD,   8, 
                Offset (0x08), 
        PIRE,   8, 
        PIRF,   8, 
        PIRG,   8, 
        PIRH,   8
    }

    Scope (_SB)
    {
        Name (BUFA, ResourceTemplate ()
        {
            IRQ (Level, ActiveLow, Shared, )
                {15}
        })
        CreateWordField (BUFA, One, IRA0)
        Device (LNKA)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, One)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRA, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSA)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRA, 0x80, PIRA)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRA, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRA)
            }
        }

        Device (LNKB)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x02)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRB, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSB)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRB, 0x80, PIRB)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRB, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRB)
            }
        }

        Device (LNKC)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x03)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRC, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSC)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRC, 0x80, PIRC)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRC, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRC)
            }
        }

        Device (LNKD)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x04)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRD, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSD)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRD, 0x80, PIRD)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRD, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRD)
            }
        }

        Device (LNKE)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x05)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRE, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSE)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRE, 0x80, PIRE)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRE, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRE)
            }
        }

        Device (LNKF)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x06)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRF, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSF)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRF, 0x80, PIRF)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRF, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRF)
            }
        }

        Device (LNKG)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x07)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRG, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSG)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRG, 0x80, PIRG)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRG, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRG)
            }
        }

        Device (LNKH)
        {
            Name (_HID, EisaId ("PNP0C0F"))
            Name (_UID, 0x08)
            Method (_STA, 0, NotSerialized)
            {
                And (PIRH, 0x80, Local0)
                If (Local0)
                {
                    Return (0x09)
                }
                Else
                {
                    Return (0x0B)
                }
            }

            Method (_PRS, 0, NotSerialized)
            {
                Return (PRSH)
            }

            Method (_DIS, 0, NotSerialized)
            {
                Or (PIRH, 0x80, PIRH)
            }

            Method (_CRS, 0, NotSerialized)
            {
                And (PIRH, 0x0F, Local0)
                ShiftLeft (One, Local0, IRA0)
                Return (BUFA)
            }

            Method (_SRS, 1, NotSerialized)
            {
                CreateWordField (Arg0, One, IRA)
                FindSetRightBit (IRA, Local0)
                Decrement (Local0)
                Store (Local0, PIRH)
            }
        }
    }

    Scope (_SB)
    {
        Name (XCPD, Zero)
        Name (XNPT, One)
        Name (XCAP, 0x02)
        Name (XDCP, 0x04)
        Name (XDCT, 0x08)
        Name (XDST, 0x0A)
        Name (XLCP, 0x0C)
        Name (XLCT, 0x10)
        Name (XLST, 0x12)
        Name (XSCP, 0x14)
        Name (XSCT, 0x18)
        Name (XSST, 0x1A)
        Name (XRCT, 0x1C)
        Mutex (MUTE, 0x00)
        Method (RBPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RWPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (RDPE, 1, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Release (MUTE)
            Return (XCFG)
        }

        Method (WBPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x0FFF)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, One)
            Field (PCFG, ByteAcc, NoLock, Preserve)
            {
                XCFG,   8
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WWPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFE, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x02)
            Field (PCFG, WordAcc, NoLock, Preserve)
            {
                XCFG,   16
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (WDPE, 2, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            Store (Arg1, XCFG)
            Release (MUTE)
        }

        Method (RWDP, 3, NotSerialized)
        {
            Acquire (MUTE, 0x03E8)
            And (Arg0, 0xFFFFFFFC, Arg0)
            Add (Arg0, PCIB, Local0)
            OperationRegion (PCFG, SystemMemory, Local0, 0x04)
            Field (PCFG, DWordAcc, NoLock, Preserve)
            {
                XCFG,   32
            }

            And (XCFG, Arg2, Local1)
            Or (Local1, Arg1, XCFG)
            Release (MUTE)
        }

        Method (RPME, 1, NotSerialized)
        {
            Add (Arg0, 0x84, Local0)
            Store (RDPE (Local0), Local1)
            If (LEqual (Local1, Ones))
            {
                Return (Zero)
            }
            Else
            {
                If (LAnd (Local1, 0x00010000))
                {
                    WDPE (Local0, And (Local1, 0x00010000))
                    Return (One)
                }

                Return (Zero)
            }
        }
    }

    Scope (\)
    {
        Name (ECRG, Zero)
        Name (OSEC, Zero)
        Name (THPP, Zero)
        Name (ACST, Zero)
        Name (SMAR, Zero)
        Mutex (ECMX, 0x00)
        Name (PWWS, Zero)
        Name (BRTS, Zero)
        OperationRegion (PMSP, SystemIO, SMIP, One)
        Field (PMSP, ByteAcc, NoLock, Preserve)
        {
            SSMI,   8
        }
    }

    Scope (_SB.PCI0.SBRG)
    {
        Device (EC0)
        {
            Name (_HID, EisaId ("PNP0C09"))
            Name (_CRS, ResourceTemplate ()
            {
                IO (Decode16,
                    0x0062,             // Range Minimum
                    0x0062,             // Range Maximum
                    0x00,               // Alignment
                    0x01,               // Length
                    )
                IO (Decode16,
                    0x0066,             // Range Minimum
                    0x0066,             // Range Maximum
                    0x00,               // Alignment
                    0x01,               // Length
                    )
            })
            Name (_GPE, 0x17)
            Name (WPST, One)
            Method (_REG, 2, NotSerialized)
            {
                If (LEqual (Arg0, 0x03))
                {
                    Store (Arg1, ECRG)
                    _Q41 ()
                    Sleep (0x64)
                    ^^^^WMID.WGWE (0x05, Zero)
                    UWLS ()
                    Sleep (0x64)
                    Store (ADP, Local0)
                    If (Local0)
                    {
                        Store (Zero, BCCL)
                    }
                    Else
                    {
                        Store (0x05, BCCL)
                    }

                    Store (ADP, PWWS)
                    Store (BCCL, BRTS)
                    UPBN ()
                    Notify (AC0, 0x80)
                    Notify (BAT1, 0x80)
                    Notify (BAT1, 0x81)
                    Notify (\_TZ.THRM, 0x81)
                    Notify (WMID, 0x80)
                }
            }

            OperationRegion (ECXP, EmbeddedControl, Zero, 0xFF)
            Field (ECXP, ByteAcc, NoLock, Preserve)
            {
                        Offset (0x02), 
                        Offset (0x04), 
                        Offset (0x06), 
                        Offset (0x08), 
                        Offset (0x0A), 
                        Offset (0x0C), 
                        Offset (0x0E), 
                        Offset (0x10), 
                        Offset (0x12), 
                        Offset (0x14), 
                        Offset (0x16), 
                        Offset (0x18), 
                        Offset (0x1A), 
                        Offset (0x1C), 
                        Offset (0x1E), 
                        Offset (0x20), 
                        Offset (0x22), 
                        Offset (0x24), 
                        Offset (0x26), 
                        Offset (0x28), 
                        Offset (0x2A), 
                        Offset (0x2C), 
                        Offset (0x2E), 
                        Offset (0x30), 
                        Offset (0x32), 
                        Offset (0x34), 
                        Offset (0x36), 
                        Offset (0x38), 
                        Offset (0x3A), 
                        Offset (0x3C), 
                        Offset (0x3E), 
                        Offset (0x40), 
                        Offset (0x42), 
                        Offset (0x44), 
                        Offset (0x46), 
                        Offset (0x48), 
                        Offset (0x4A), 
                        Offset (0x4C), 
                        Offset (0x4E), 
                        Offset (0x50), 
                        Offset (0x52), 
                        Offset (0x54), 
                        Offset (0x56), 
                        Offset (0x58), 
                        Offset (0x5A), 
                        Offset (0x5C), 
                        Offset (0x5E), 
                        Offset (0x60), 
                        Offset (0x62), 
                        Offset (0x64), 
                        Offset (0x66), 
                        Offset (0x68), 
                        Offset (0x6A), 
                        Offset (0x6C), 
                        Offset (0x6E), 
                        Offset (0x70), 
                        Offset (0x72), 
                        Offset (0x74), 
                        Offset (0x76), 
                        Offset (0x78), 
                        Offset (0x7A), 
                        Offset (0x7C), 
                        Offset (0x7E), 
                        Offset (0x80), 
                NMSG,   8, 
                SLPT,   4, 
                        Offset (0x82), 
                    ,   2, 
                ACPI,   1, 
                        Offset (0x83), 
                ELID,   1, 
                WWAN,   1, 
                BLUE,   1, 
                WLAN,   1, 
                BUST,   1, 
                LWBU,   1, 
                LWWL,   1, 
                LWAN,   1, 
                ADP,    1, 
                ADID,   2, 
                    ,   1, 
                BTIN,   4, 
                BPU0,   8, 
                BPU1,   8, 
                        Offset (0x88), 
                        Offset (0x89), 
                BDC0,   16, 
                BDC1,   16, 
                BFC0,   16, 
                BFC1,   16, 
                BTC0,   16, 
                BTC1,   16, 
                BDV0,   16, 
                BCV1,   16, 
                BST0,   8, 
                        Offset (0x9B), 
                BST1,   8, 
                        Offset (0x9D), 
                BPR0,   16, 
                BPR1,   16, 
                BRC0,   16, 
                BCC0,   16, 
                BPV0,   16, 
                BCV2,   16, 
                BCV3,   16, 
                BCV4,   16, 
                BCW0,   16, 
                BCW1,   16, 
                BCL0,   16, 
                BCL1,   16, 
                BG10,   16, 
                BSTS,   16, 
                BG20,   16, 
                        Offset (0xBD), 
                        Offset (0xBF), 
                        Offset (0xC1), 
                        Offset (0xC9), 
                BSN,    16, 
                BDAT,   16, 
                        Offset (0xCF), 
                        Offset (0xD0), 
                        Offset (0xD1), 
                        Offset (0xD5), 
                        Offset (0xD9), 
                CBT,    16, 
                        Offset (0xDD), 
                CRTT,   8, 
                PSVT,   8, 
                CTPM,   8, 
                TPM1,   8, 
                TTPM,   8, 
                        Offset (0xE3), 
                        Offset (0xE4), 
                BMF,    8, 
                    ,   4, 
                    ,   1, 
                TABR,   1, 
                        Offset (0xE6), 
                SHK,    8, 
                ADON,   1, 
                        Offset (0xE9), 
                        Offset (0xF0), 
                BCCL,   4, 
                PANT,   4, 
                    ,   4, 
                LANS,   1, 
                        Offset (0xF2), 
                IDGS,   8, 
                    ,   1, 
                RTCW,   1, 
                        Offset (0xF4), 
                BSEL,   4, 
                        Offset (0xF6), 
                BME0,   16, 
                THTL,   8, 
                F10A,   1, 
                WSTS,   1, 
                F10B,   1, 
                F10W,   1, 
                WWST,   1, 
                HWWD,   2, 
                        Offset (0xFA), 
                        Offset (0xFC), 
                WANP,   8, 
                        Offset (0xFE)
            }

            Method (SSTA, 1, Serialized)
            {
                Store (Zero, Local0)
                Store (Arg0, ADON)
                Store (One, Local0)
                Return (Local0)
            }

            Method (GSHK, 0, Serialized)
            {
                Store (SHK, Local0)
                Return (Local0)
            }

            Method (SSHK, 1, Serialized)
            {
                Store (Arg0, SHK)
            }

            Method (GACS, 0, Serialized)
            {
                ^^BAT1.UPAD ()
                Return (^^BAT1.ACST)
            }
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Name (THOT, Zero)
        Method (_Q0A, 0, NotSerialized)
        {
            Store (0x0A, DBG8)
            If (ELID)
            {
                Store (One, ^^^IGD.LCD._DGS)
                Store (Zero, ^^^IGD.CRT._DGS)
                Sleep (0x14)
                Notify (IGD, 0x80)
                Sleep (0x32)
                Store (One, LIDS)
                Notify (LID, 0x80)
            }
            Else
            {
                Store (Zero, ^^^IGD.LCD._DGS)
                Store (One, ^^^IGD.CRT._DGS)
                Sleep (0x14)
                Notify (IGD, 0x80)
                Sleep (0x32)
                Store (Zero, LIDS)
                Notify (LID, 0x80)
            }
        }

        Method (_Q0B, 0, NotSerialized)
        {
            Store (0x1E, DBG8)
        }

        Method (_Q0D, 0, NotSerialized)
        {
            Store (0xE1, DBG8)
        }

        Method (_Q10, 0, NotSerialized)
        {
            Store (0xF5, DBG8)
        }

        Method (_Q12, 0, NotSerialized)
        {
            Store (0x12, DBG8)
            ^^^IGD.DCHG ()
        }

        Name (BNTB, Package (0x05)
        {
            Package (0x0B)
            {
                0xFF, 
                0xAC, 
                0x8F, 
                0x74, 
                0x57, 
                0x4E, 
                0x44, 
                0x3C, 
                0x33, 
                0x2A, 
                0x1D
            }, 

            Package (0x0B)
            {
                0xFF, 
                0xB4, 
                0x91, 
                0x6F, 
                0x4E, 
                0x3E, 
                0x38, 
                0x2D, 
                0x22, 
                0x17, 
                0x12
            }, 

            Package (0x0B)
            {
                0xFF, 
                0x9A, 
                0x7C, 
                0x5F, 
                0x42, 
                0x38, 
                0x2F, 
                0x26, 
                0x1D, 
                0x13, 
                0x10
            }, 

            Package (0x0B)
            {
                0xFF, 
                0xAF, 
                0x8E, 
                0x6C, 
                0x4B, 
                0x40, 
                0x35, 
                0x2A, 
                0x20, 
                0x15, 
                0x11
            }, 

            Package (0x0B)
            {
                0xFF, 
                0xB7, 
                0x93, 
                0x70, 
                0x4D, 
                0x41, 
                0x36, 
                0x2B, 
                0x20, 
                0x14, 
                0x10
            }
        })
        Method (UPBN, 0, NotSerialized)
        {
            Acquire (ECMX, 0xFFFF)
            If (ECRG)
            {
                Store (BCCL, Local0)
                Store (PANT, Local1)
            }
            Else
            {
                Store (Zero, Local0)
                Store (Zero, Local1)
            }

            Release (ECMX)
            Store (DerefOf (Index (DerefOf (Index (BNTB, Local1)), Local0)), 
                ^^^IGD.CSTE)
        }

        Method (_Q13, 0, NotSerialized)
        {
            Store (BCCL, Local0)
            If (LLess (Local0, 0x0A))
            {
                Add (Local0, One, Local0)
            }

            Store (Local0, BCCL)
            Store (BCCL, BRTS)
            UPBN ()
        }

        Method (_Q14, 0, NotSerialized)
        {
            Store (BCCL, Local0)
            If (LGreater (Local0, Zero))
            {
                Subtract (Local0, One, Local0)
            }

            Store (Local0, BCCL)
            Store (BCCL, BRTS)
            UPBN ()
        }

        Method (_Q1E, 0, NotSerialized)
        {
        }

        Method (_Q3F, 0, NotSerialized)
        {
            Store (0x3F, DBG8)
            Store (Zero, THOT)
            Notify (\_PR.CPU1, 0x80)
        }

        Method (_Q33, 0, NotSerialized)
        {
            Store (0x33, DBG8)
            Store (One, THOT)
            Notify (\_PR.CPU1, 0x80)
        }

        Method (_Q04, 0, NotSerialized)
        {
            Store (0x04, DBG8)
        }

        Method (_Q20, 0, NotSerialized)
        {
            XOr (BUST, One, BUST)
            If (LEqual (OSFL (), 0x03))
            {
                If (BUST)
                {
                    Store (One, WAND)
                    Store (One, WLAD)
                    Store (Zero, BTDN)
                }
                Else
                {
                    Store (Zero, WAND)
                    Store (Zero, WLAD)
                    Store (One, BTDN)
                }
            }
            Else
            {
                UWLS ()
            }
        }

        Method (UWLS, 0, NotSerialized)
        {
            Store (0x20, DBG8)
            If (BUST)
            {
                If (LWAN)
                {
                    Store (One, WWAN)
                }
                Else
                {
                    Store (Zero, WWAN)
                }

                If (LWWL)
                {
                    Store (One, WLAN)
                }
                Else
                {
                    Store (Zero, WLAN)
                }

                If (LWBU)
                {
                    Store (One, BLUE)
                }
                Else
                {
                    Store (Zero, BLUE)
                }

                Store (One, WSTS)
            }
            Else
            {
                Store (Zero, WWAN)
                Store (Zero, WLAN)
                Store (Zero, BLUE)
                Store (Zero, WSTS)
            }

            If (BLUE)
            {
                Store (Zero, BTDN)
            }
            Else
            {
                Store (One, BTDN)
            }

            If (WLAN)
            {
                Store (One, WLAD)
            }
            Else
            {
                Store (Zero, WLAD)
            }

            If (And (LEqual (BTIN, One), LEqual (BUST, One)))
            {
                If (WWAN)
                {
                    Store (One, WAND)
                }
                Else
                {
                    Store (Zero, WAND)
                }
            }
            Else
            {
                Store (Zero, WAND)
            }

            ^^^^WMID.WGWE (0x05, Zero)
        }

        Method (_Q41, 0, NotSerialized)
        {
            OSFL ()
            If (LEqual (HOTP, Zero))
            {
                Store (0x03, DBG8)
                Return (Zero)
            }

            If (LEqual (ADP, Zero))
            {
                Store (LANS, Local0)
                If (Local0)
                {
                    Store (One, LANL)
                    Sleep (0x96)
                    Store (Zero, LANR)
                    Sleep (0x14)
                    Store (One, LANR)
                    Notify (P0P5, Zero)
                    Sleep (0x64)
                    Notify (P0P5, One)
                    Sleep (0x64)
                }
                Else
                {
                    Store (Zero, LANL)
                    Notify (P0P5, Zero)
                    Sleep (0x64)
                    Notify (P0P5, One)
                    Sleep (0x64)
                }
            }
            Else
            {
                If (LEqual (ADP, One))
                {
                    Store (LANL, Local0)
                    If (Local0)
                    {
                        Store (One, DBG8)
                    }
                    Else
                    {
                        Store (One, LANL)
                        Sleep (0x96)
                        Store (Zero, LANR)
                        Sleep (0x14)
                        Store (One, LANR)
                        Notify (P0P5, Zero)
                        Sleep (0x64)
                        Notify (P0P5, One)
                        Sleep (0x64)
                    }
                }
            }

            Store (0x04, DBG8)
            Return (Zero)
        }

        Method (_Q53, 0, NotSerialized)
        {
            Notify (SLPB, 0x80)
        }

        Method (_Q70, 0, NotSerialized)
        {
            Store (THTL, Local0)
            If (LEqual (Local0, One))
            {
                Store (0x07, THTD)
            }
            Else
            {
                If (LEqual (Local0, 0x02))
                {
                    Store (0x06, THTD)
                }
                Else
                {
                    If (LEqual (Local0, 0x03))
                    {
                        Store (0x04, THTD)
                    }
                    Else
                    {
                        If (LEqual (Local0, 0x04))
                        {
                            Store (0x02, THTD)
                        }
                    }
                }
            }

            If (LEqual (Local0, Zero))
            {
                Store (One, THTE)
            }
            Else
            {
                Store (Zero, THTE)
            }
        }
    }

    Scope (\)
    {
        Name (B1MN, "Primary")
        Name (B1SN, " ")
        Name (B1BT, "LION")
        Name (B1OI, "Hewlett-Packard")
        Name (B2MN, "Primary")
        Name (B2SN, " ")
        Name (B2BT, "LION")
        Name (B2OI, "Hewlett-Packard")
        Field (BIOS, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x85), 
            CTB,    32
        }

        Field (BIOS, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x82), 
            WDST,   8, 
                    Offset (0x84), 
            CTCP,   8, 
            CTB0,   8, 
            CTB1,   8, 
            CTB2,   8, 
            CTB3,   8, 
                    Offset (0xA3), 
            EAX,    32, 
            EBX,    32, 
            ECX,    32, 
            EDX,    32, 
            REFS,   32, 
            WLID,   32, 
            WSID,   32, 
            DIST,   160, 
                    Offset (0xD4), 
            DCAP,   8, 
            CNTD,   8, 
            BRVL,   88, 
            HDBF,   48, 
            MBBF,   48
        }

        OperationRegion (MAIL, SystemIO, 0x0500, 0x02)
        Field (MAIL, ByteAcc, NoLock, Preserve)
        {
            MIDX,   8, 
            MDTA,   8
        }

        IndexField (MIDX, MDTA, ByteAcc, NoLock, Preserve)
        {
                    Offset (0x0F), 
            HKNO,   8, 
                    Offset (0x20), 
            QWOL,   1, 
            CWST,   1, 
            CBLU,   1, 
            CWLN,   1, 
            BLUG,   1, 
            WLAG,   1, 
            BF10,   1, 
            WF10,   1, 
            MDG1,   8, 
            MDG2,   8, 
            MDG3,   8, 
            MDG4,   8
        }

        Name (ISTR, Package (0x10)
        {
            "0", 
            "1", 
            "2", 
            "3", 
            "4", 
            "5", 
            "6", 
            "7", 
            "8", 
            "9", 
            "A", 
            "B", 
            "C", 
            "D", 
            "E", 
            "F"
        })
        Method (I2SR, 2, NotSerialized)
        {
            Store (Arg0, Local0)
            Store ("", Local7)
            Store (Arg1, Local4)
            While (LGreater (Local4, Zero))
            {
                And (Local0, 0x0F, Local1)
                Store (DerefOf (Index (ISTR, Local1)), Local2)
                Concatenate (Local2, Local7, Local3)
                Store (Local3, Local7)
                ShiftRight (Local0, 0x04, Local0)
                Decrement (Local4)
            }

            Return (Local7)
        }
    }

    Scope (_SB.PCI0)
    {
    }

    Scope (_SB.PCI0.SBRG)
    {
        OperationRegion (GPIX, SystemIO, 0x0848, One)
        Field (GPIX, ByteAcc, NoLock, Preserve)
        {
            GPI0,   1, 
            GPI1,   1
        }

        OperationRegion (GIB2, SystemIO, 0x084A, One)
        Field (GIB2, ByteAcc, NoLock, Preserve)
        {
                ,   3, 
            GI19,   1, 
                    Offset (0x01)
        }

        OperationRegion (GPOV, SystemIO, PM4C, 0x04)
        Field (GPOV, ByteAcc, NoLock, Preserve)
        {
                ,   1, 
            GPO1,   1, 
                ,   2, 
            GPO4,   1, 
                ,   17, 
            GO22,   1
        }

        OperationRegion (G89E, SystemIO, 0x082D, One)
        Field (G89E, ByteAcc, NoLock, Preserve)
        {
                ,   5, 
            G18E,   1, 
            G19E,   1
        }

        OperationRegion (SMA1, SystemIO, SMBS, 0x10)
        Field (SMA1, ByteAcc, NoLock, Preserve)
        {
            HSTS,   8, 
                    Offset (0x02), 
            HCNT,   8, 
            HCMD,   8, 
            SMA0,   8, 
            SMD0,   8
        }
    }

    Scope (_SB.PCI0.SBRG)
    {
        Device (BAT1)
        {
            Name (_HID, EisaId ("PNP0C0A"))
            Name (_UID, One)
            Name (_PCL, Package (0x01)
            {
                _SB
            })
            Name (NGBF, 0xFF)
            Name (NGBT, 0xFF)
            Name (GACP, 0x07)
            Name (ACST, One)
            Name (SMAR, Zero)
            Name (NBAP, Zero)
            Name (NNBO, One)
            Name (NDCB, Zero)
            Name (NLB1, 0x05)
            Name (NLB2, One)
            Mutex (BTMX, 0x00)
            Name (PAK1, Package (0x0D)
            {
                One, 
                Ones, 
                Ones, 
                One, 
                Ones, 
                Zero, 
                Zero, 
                0x64, 
                0x64, 
                "Primary", 
                "100000", 
                "LIon", 
                "Hewlett-Packard"
            })
            Method (_BIF, 0, NotSerialized)
            {
                Acquire (ECMX, 0xFFFF)
                If (ECRG)
                {
                    Store (^^EC0.BPU0, Index (PAK1, Zero))
                    Store (^^EC0.BDC0, Index (PAK1, One))
                    Store (^^EC0.BFC0, Local0)
                    Store (Local0, Index (PAK1, 0x02))
                    Store (^^EC0.BTC0, Index (PAK1, 0x03))
                    Store (^^EC0.BDV0, Index (PAK1, 0x04))
                    Store (^^EC0.BG10, Index (PAK1, 0x07))
                }

                Release (ECMX)
                Store (B1MN, Index (PAK1, 0x09))
                Store (B1SN, Index (PAK1, 0x0A))
                Store (B1BT, Index (PAK1, 0x0B))
                Store (B1OI, Index (PAK1, 0x0C))
                Return (PAK1)
            }

            Name (BFB1, Package (0x04)
            {
                Zero, 
                Ones, 
                0xA034, 
                0x2A30
            })
            Method (_BST, 0, NotSerialized)
            {
                Acquire (ECMX, 0xFFFF)
                If (ECRG)
                {
                    Store (^^EC0.BST0, Index (BFB1, Zero))
                    Store (^^EC0.BRC0, Index (BFB1, 0x02))
                    Store (^^EC0.BPV0, Index (BFB1, 0x03))
                }

                Release (ECMX)
                Return (BFB1)
            }

            Method (_STA, 0, NotSerialized)
            {
                If (LEqual (ECRG, Zero))
                {
                    Store (Zero, Local0)
                }
                Else
                {
                    Acquire (ECMX, 0xFFFF)
                    If (ECRG)
                    {
                        Store (^^EC0.BTIN, Local0)
                    }

                    Release (ECMX)
                }

                If (Local0)
                {
                    Return (0x1F)
                }
                Else
                {
                    Return (0x0F)
                }
            }

            Method (GBTI, 1, NotSerialized)
            {
                Acquire (ECMX, 0xFFFF)
                If (ECRG)
                {
                    If (And (^^EC0.BTIN, ShiftLeft (One, Arg0)))
                    {
                        Store (Arg0, ^^EC0.BSEL)
                        Store (Package (0x03)
                            {
                                Zero, 
                                0x3E, 
                                Buffer (0x3E) {}
                            }, Local0)
                        Store (^^EC0.BDC0, Index (DerefOf (Index (Local0, 0x02)), Zero))
                        Store (ShiftRight (^^EC0.BDC0, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), One))
                        Store (^^EC0.BFC0, Index (DerefOf (Index (Local0, 0x02)), 0x02))
                        Store (ShiftRight (^^EC0.BFC0, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x03))
                        Store (^^EC0.BRC0, Index (DerefOf (Index (Local0, 0x02)), 0x04))
                        Store (ShiftRight (^^EC0.BRC0, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x05))
                        Store (^^EC0.BME0, Index (DerefOf (Index (Local0, 0x02)), 0x06))
                        Store (ShiftRight (^^EC0.BME0, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x07))
                        Store (^^EC0.BCC0, Index (DerefOf (Index (Local0, 0x02)), 0x08))
                        Store (ShiftRight (^^EC0.BCC0, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x09))
                        Store (^^EC0.CBT, Local1)
                        Subtract (Local1, 0x0AAC, Local1)
                        Divide (Local1, 0x0A, Local2, Local3)
                        Store (Local3, Index (DerefOf (Index (Local0, 0x02)), 0x0A))
                        Store (ShiftRight (Local3, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x0B))
                        Store (^^EC0.BPV0, Index (DerefOf (Index (Local0, 0x02)), 0x0C))
                        Store (ShiftRight (^^EC0.BPV0, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x0D))
                        Store (^^EC0.BPR0, Local1)
                        If (Local1)
                        {
                            If (And (^^EC0.BSTS, 0x40))
                            {
                                Add (Not (Local1), One, Local1)
                                And (Local1, 0xFFFF, Local1)
                            }
                        }

                        Store (Local1, Index (DerefOf (Index (Local0, 0x02)), 0x0E))
                        Store (ShiftRight (Local1, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x0F))
                        Store (^^EC0.BDV0, Index (DerefOf (Index (Local0, 0x02)), 0x10))
                        Store (ShiftRight (^^EC0.BDV0, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x11))
                        Store (^^EC0.BSTS, Index (DerefOf (Index (Local0, 0x02)), 0x12))
                        Store (ShiftRight (^^EC0.BSTS, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x13))
                        Store (^^EC0.BCV1, Index (DerefOf (Index (Local0, 0x02)), 0x14))
                        Store (ShiftRight (^^EC0.BCV1, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x15))
                        Store (^^EC0.BCV2, Index (DerefOf (Index (Local0, 0x02)), 0x16))
                        Store (ShiftRight (^^EC0.BCV2, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x17))
                        Store (^^EC0.BCV3, Index (DerefOf (Index (Local0, 0x02)), 0x18))
                        Store (ShiftRight (^^EC0.BCV3, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x19))
                        Store (^^EC0.BCV4, Index (DerefOf (Index (Local0, 0x02)), 0x1A))
                        Store (ShiftRight (^^EC0.BCV4, 0x08), Index (DerefOf (Index (Local0, 0x02
                            )), 0x1B))
                        CreateField (DerefOf (Index (Local0, 0x02)), 0xE0, 0x80, BSNO)
                        Store (GBSS (^^EC0.BSN, ^^EC0.BDAT), BSNO)
                        Store ("Hewlett-Packard", Local1)
                        CreateField (DerefOf (Index (Local0, 0x02)), 0x0160, Multiply (SizeOf (Local1), 
                            0x08), BMAN)
                        Store (Local1, BMAN)
                    }
                    Else
                    {
                        Store (0xFF, DBG8)
                        Store (Package (0x02)
                            {
                                0x06, 
                                Zero
                            }, Local0)
                    }
                }
                Else
                {
                    Store (Package (0x02)
                        {
                            0x0D, 
                            Zero
                        }, Local0)
                }

                Release (ECMX)
                Return (Local0)
            }

            Method (GPID, 0, Serialized)
            {
                UPAD ()
                Return (SMAR)
            }

            Method (UPAD, 0, Serialized)
            {
                If (LEqual (ECRG, Zero))
                {
                    Store (One, ACST)
                    Store (Zero, SMAR)
                }
                Else
                {
                    Acquire (BTMX, 0xFFFF)
                    If (And (GACP, One))
                    {
                        And (GACP, 0x06, GACP)
                        Release (BTMX)
                        Store (One, Local0)
                        Store (Zero, Local1)
                        Acquire (ECMX, 0xFFFF)
                        If (ECRG)
                        {
                            Store (^^EC0.ADP, Local0)
                            Store (^^EC0.ADID, Local1)
                        }

                        Release (ECMX)
                        Store (Local0, ACST)
                        Store (Local1, SMAR)
                    }
                    Else
                    {
                        Release (BTMX)
                    }
                }
            }

            Method (GBAP, 0, Serialized)
            {
                Acquire (BTMX, 0xFFFF)
                If (And (GACP, 0x02))
                {
                    And (GACP, 0x05, GACP)
                    Release (BTMX)
                    Acquire (ECMX, 0xFFFF)
                    If (ECRG)
                    {
                        Store (^^EC0.BTIN, NBAP)
                    }

                    Release (ECMX)
                }
                Else
                {
                    Release (BTMX)
                }

                Return (NBAP)
            }

            Method (PWUP, 2, Serialized)
            {
                Store (Zero, Local0)
                Acquire (BTMX, 0xFFFF)
                Or (Arg0, GACP, Local1)
                And (Local1, 0x07, GACP)
                If (And (GACP, 0x02))
                {
                    Or (NGBF, Arg1, NGBF)
                }

                If (And (GACP, 0x04))
                {
                    If (LNotEqual (NGBT, 0xFF))
                    {
                        Store (One, Local0)
                    }

                    Or (NGBT, Arg1, NGBT)
                }

                Release (BTMX)
                Return (Local0)
            }

            Method (BTDR, 1, Serialized)
            {
                If (LEqual (Arg0, One))
                {
                    Store (One, NNBO)
                }
                Else
                {
                    If (LEqual (Arg0, Zero))
                    {
                        Store (Zero, NNBO)
                    }
                }

                Return (NNBO)
            }

            Method (BSTA, 1, Serialized)
            {
                BTDR (One)
                Store (GBAP (), Local0)
                Store (0x0F, Local1)
                If (And (Local0, Arg0))
                {
                    Store (0x1F, Local1)
                }

                Return (Local1)
            }

            Method (GBSS, 2, Serialized)
            {
                ToBCD (Arg0, Local0)
                Store (I2SR (Local0, 0x05), Local3)
                Concatenate (Local3, " ", Local4)
                ShiftRight (Arg1, 0x09, Local0)
                Add (Local0, 0x07BC, Local1)
                ToBCD (Local1, Local0)
                Store (I2SR (Local0, 0x04), Local2)
                Concatenate (Local4, Local2, Local3)
                Concatenate (Local3, "/", Local4)
                ShiftRight (Arg1, 0x05, Local0)
                And (Local0, 0x0F, Local1)
                ToBCD (Local1, Local0)
                Store (I2SR (Local0, 0x02), Local2)
                Concatenate (Local4, Local2, Local3)
                Concatenate (Local3, "/", Local4)
                And (Arg1, 0x1F, Local1)
                ToBCD (Local1, Local0)
                Store (I2SR (Local0, 0x02), Local2)
                Concatenate (Local4, Local2, Local3)
                Return (Local3)
            }

            Method (SBTN, 2, Serialized)
            {
                If (And (Arg0, One))
                {
                    Notify (BAT1, Arg1)
                }
            }

            Method (_Q83, 0, NotSerialized)
            {
                Store (0x83, DBG8)
                Acquire (BTMX, 0xFFFF)
                Store (NDCB, Local0)
                Release (BTMX)
                PWUP (0x04, Local0)
                SBTN (Local0, 0x80)
            }

            Method (_Q8A, 0, NotSerialized)
            {
                Store (0x8A, DBG8)
            }
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Method (_Q08, 0, NotSerialized)
        {
            If (LEqual (BTIN, Zero))
            {
                Store (Zero, WWAN)
                Store (Zero, WAND)
            }
            Else
            {
                UWLS ()
            }

            ^^^^WMID.WGWE (0x05, Zero)
            Store (0x08, DBG8)
            Notify (\_PR.CPU1, 0x80)
            ^^BAT1.PWUP (0x06, One)
            Store (^^BAT1.GBAP (), Local0)
            If (LNotEqual (Local0, 0x02))
            {
                ^^BAT1.PWUP (0x04, 0x02)
                If (^^BAT1.BTDR (0x02))
                {
                    Notify (BAT1, 0x80)
                }
            }

            If (^^BAT1.BTDR (0x02))
            {
                Notify (BAT1, 0x81)
            }
        }
    }

    Scope (_SB.PCI0.SBRG)
    {
        Device (AC0)
        {
            Name (_HID, "ACPI0003")
            Name (_PCL, Package (0x01)
            {
                _SB
            })
            Method (_PSR, 0, NotSerialized)
            {
                Store (^^EC0.GACS (), Local0)
                Store (^^BAT1.GPID (), Local1)
                If (XOr (Local0, ACST)) {}
                If (LOr (LAnd (Local0, LNot (ACST)), LAnd (Local1, LNot (SMAR))))
                {
                    ^^^^WMID.WGWE (0x03, Zero)
                }

                Store (Local0, ACST)
                Store (Local1, SMAR)
                Return (Local0)
            }
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Method (_Q06, 0, NotSerialized)
        {
            If (LEqual (LANS, Zero))
            {
                _Q41 ()
            }

            If (LEqual (PWWS, ADP))
            {
                Store (BRTS, BCCL)
            }
            Else
            {
                Store (ADP, Local0)
                If (Local0)
                {
                    Store (Zero, BCCL)
                }
                Else
                {
                    Store (0x05, BCCL)
                }

                Store (BCCL, BRTS)
            }

            Store (ADP, PWWS)
            UPBN ()
            Store (0x06, DBG8)
            Notify (\_PR.CPU1, 0x80)
            ^^BAT1.PWUP (0x05, 0x03)
            If (^^BAT1.BTDR (0x02))
            {
                Notify (AC0, 0x80)
            }
        }
    }

    Scope (_SB.PCI0)
    {
        Name (\LIDS, One)
        Device (LID)
        {
            Name (_HID, EisaId ("PNP0C0D"))
            Method (_LID, 0, NotSerialized)
            {
                Acquire (ECMX, 0xFFFF)
                If (ECRG)
                {
                    Store (^^SBRG.EC0.ELID, LIDS)
                }
                Else
                {
                    Store (One, LIDS)
                }

                Release (ECMX)
                Return (LIDS)
            }
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
        Method (_Q19, 0, NotSerialized)
        {
        }
    }

    Scope (_TZ)
    {
        ThermalZone (THRM)
        {
            Method (KELV, 1, NotSerialized)
            {
                And (Arg0, 0xFF, Local0)
                Multiply (Local0, 0x0A, Local0)
                Add (Local0, 0x0AAC, Local0)
                Return (Local0)
            }

            Name (PLCY, Zero)
            Name (TMIN, 0x23)
            Name (TMAX, 0x2D)
            Name (THOT, 0x3C)
            Name (_TSP, 0x0A)
            Name (_TC1, 0x02)
            Name (_TC2, 0x0A)
            Method (_TMP, 0, NotSerialized)
            {
                If (LEqual (THPP, 0x69))
                {
                    Store (Zero, THPP)
                    Return (KELV (0x69))
                }

                If (LEqual (ECRG, Zero))
                {
                    Store (0x41, Local0)
                }
                Else
                {
                    Acquire (ECMX, 0xFFFF)
                    Store (\_SB.PCI0.SBRG.EC0.CTPM, Local0)
                    Release (ECMX)
                }

                Return (KELV (Local0))
            }

            Method (_CRT, 0, NotSerialized)
            {
                Acquire (ECMX, 0xFFFF)
                If (ECRG)
                {
                    Store (\_SB.PCI0.SBRG.EC0.CRTT, Local0)
                }
                Else
                {
                    Store (0x5F, Local0)
                }

                Release (ECMX)
                Return (KELV (Local0))
            }

            Name (_PSL, Package (0x02)
            {
                \_PR.P001, 
                \_PR.P002
            })
            Method (_PSV, 0, NotSerialized)
            {
                Acquire (ECMX, 0xFFFF)
                If (ECRG)
                {
                    Store (\_SB.PCI0.SBRG.EC0.PSVT, Local0)
                }
                Else
                {
                    Store (0x55, Local0)
                }

                Release (ECMX)
                Return (KELV (Local0))
            }
        }
    }

    Scope (_SB.PCI0.SBRG.EC0)
    {
    }

    Scope (_SB)
    {
        Scope (PCI0)
        {
            Name (CRS, ResourceTemplate ()
            {
                WordBusNumber (ResourceProducer, MinFixed, MaxFixed, PosDecode,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x00FF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0100,             // Length
                    ,, )
                IO (Decode16,
                    0x0CF8,             // Range Minimum
                    0x0CF8,             // Range Maximum
                    0x01,               // Alignment
                    0x08,               // Length
                    )
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0000,             // Range Minimum
                    0x0CF7,             // Range Maximum
                    0x0000,             // Translation Offset
                    0x0CF8,             // Length
                    ,, , TypeStatic)
                WordIO (ResourceProducer, MinFixed, MaxFixed, PosDecode, EntireRange,
                    0x0000,             // Granularity
                    0x0D00,             // Range Minimum
                    0xFFFF,             // Range Maximum
                    0x0000,             // Translation Offset
                    0xF300,             // Length
                    ,, , TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000A0000,         // Range Minimum
                    0x000BFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, , AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x000C0000,         // Range Minimum
                    0x000DFFFF,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00020000,         // Length
                    ,, _Y0D, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y0E, AddressRangeMemory, TypeStatic)
                DWordMemory (ResourceProducer, PosDecode, MinFixed, MaxFixed, Cacheable, ReadWrite,
                    0x00000000,         // Granularity
                    0x00000000,         // Range Minimum
                    0x00000000,         // Range Maximum
                    0x00000000,         // Translation Offset
                    0x00000000,         // Length
                    ,, _Y0F, AddressRangeMemory, TypeStatic)
            })
            CreateDWordField (CRS, \_SB.PCI0._Y0D._MIN, MIN5)
            CreateDWordField (CRS, \_SB.PCI0._Y0D._MAX, MAX5)
            CreateDWordField (CRS, \_SB.PCI0._Y0D._LEN, LEN5)
            CreateDWordField (CRS, \_SB.PCI0._Y0E._MIN, MIN6)
            CreateDWordField (CRS, \_SB.PCI0._Y0E._MAX, MAX6)
            CreateDWordField (CRS, \_SB.PCI0._Y0E._LEN, LEN6)
            CreateDWordField (CRS, \_SB.PCI0._Y0F._MIN, MIN7)
            CreateDWordField (CRS, \_SB.PCI0._Y0F._MAX, MAX7)
            CreateDWordField (CRS, \_SB.PCI0._Y0F._LEN, LEN7)
            Method (_CRS, 0, NotSerialized)
            {
                Store (MG1L, Local0)
                If (Local0)
                {
                    Store (MG1B, MIN5)
                    Store (MG1L, LEN5)
                    Add (MIN5, Decrement (Local0), MAX5)
                }

                Store (MG2B, MIN6)
                Store (MG2L, LEN6)
                Store (MG2L, Local0)
                Add (MIN6, Decrement (Local0), MAX6)
                Store (MG3B, MIN7)
                Store (MG3L, LEN7)
                Store (MG3L, Local0)
                Add (MIN7, Decrement (Local0), MAX7)
                Return (CRS)
            }
        }
    }

    Name (WOTB, Zero)
    Name (WSSB, Zero)
    Name (WAXB, Zero)
    Name (BTSS, Zero)
    Name (WLSS, Zero)
    Name (WASS, Zero)
    Method (_PTS, 1, NotSerialized)
    {
        Store (\_SB.BTDN, BTSS)
        Store (\_SB.WLAD, WLSS)
        Store (\_SB.WAND, WASS)
        If (LEqual (Arg0, 0x03))
        {
            Store (One, \_SB.BTDN)
            Store (Zero, \_SB.WLAD)
            Store (Zero, \_SB.WAND)
            Sleep (0x64)
        }

        Store (Arg0, DBG8)
        PTS (Arg0)
        Store (Zero, Index (WAKP, Zero))
        Store (Zero, Index (WAKP, One))
        If (LAnd (LEqual (Arg0, 0x04), LEqual (OSFL (), 0x02)))
        {
            Sleep (0x0BB8)
        }

        Store (ASSB, WSSB)
        Store (AOTB, WOTB)
        Store (AAXB, WAXB)
        Store (Arg0, ASSB)
        Store (OSFL (), AOTB)
        Store (Zero, AAXB)
    }

    Name (SLID, One)
    Method (_WAK, 1, NotSerialized)
    {
        If (LEqual (Arg0, 0x04))
        {
            \_SB.PCI0.SBRG.EC0.UWLS ()
            Store (One, \_SB.LANL)
            Sleep (0x96)
            Store (Zero, \_SB.LANR)
            Sleep (0x14)
            Store (One, \_SB.LANR)
            Notify (\_SB.PCI0.P0P5, Zero)
            Sleep (0x64)
            Notify (\_SB.PCI0.P0P5, One)
            Sleep (0x64)
        }

        \_SB.PCI0.SBRG.EC0._Q41 ()
        \_SB.PCI0.SBRG.EC0._Q06 ()
        \_SB.WMID.WGWE (0x05, Zero)
        ShiftLeft (Arg0, 0x04, DBG8)
        Store (One, SLID)
        WAK (Arg0)
        If (LOr (LEqual (Arg0, 0x04), LEqual (Arg0, 0x03)))
        {
            Store (BTSS, \_SB.BTDN)
            Store (WLSS, \_SB.WLAD)
            Store (WASS, \_SB.WAND)
        }

        If (ASSB)
        {
            Store (WSSB, ASSB)
            Store (WOTB, AOTB)
            Store (WAXB, AAXB)
        }

        If (DerefOf (Index (WAKP, Zero)))
        {
            Store (Zero, Index (WAKP, One))
        }
        Else
        {
            Store (Arg0, Index (WAKP, One))
        }

        If (LEqual (Arg0, 0x04))
        {
            Notify (\_SB.PWRB, 0x02)
        }

        Return (WAKP)
    }

    Name (_S0, Package (0x04)
    {
        Zero, 
        Zero, 
        Zero, 
        Zero
    })
    If (SS3)
    {
        Name (_S3, Package (0x04)
        {
            0x05, 
            Zero, 
            Zero, 
            Zero
        })
    }

    If (SS4)
    {
        Name (_S4, Package (0x04)
        {
            0x06, 
            Zero, 
            Zero, 
            Zero
        })
    }

    Name (_S5, Package (0x04)
    {
        0x07, 
        Zero, 
        Zero, 
        Zero
    })
    Method (PTS, 1, NotSerialized)
    {
        If (Arg0)
        {
            \_SB.PCI0.NPTS (Arg0)
            \_SB.PCI0.SBRG.SPTS (Arg0)
        }
    }

    Method (WAK, 1, NotSerialized)
    {
        \_SB.PCI0.NWAK (Arg0)
        \_SB.PCI0.SBRG.SWAK (Arg0)
    }
}

