unit Hda; 
interface
uses pci,misc,dialogs,sysutils,winprocs,inifiles,classes,mmsystem,tintlist;

var HDAinterface:byte;

var wait1:longint;         
var wait2:longint;

var lst2:array[0..259] of longint;
var corbactive:boolean;
{var url:string;}
{var wind:pchar;}
var windir:string;
var clouturl:string;
var clinurl:string;

var lastsend:longint;
var newget:longint;

var loaded:boolean;
var drvenabled:boolean;

var strlst:tstringlist;
var str:string;
var strlston:boolean;
var si:tinifile;

var infstr:string;
var getlst:tstringlist;


const bsize=$800;{7000 works}
const format44=$4011;
const format48=$0011;
var setkhz:longint;

const nil16=$FF;
{settings}
{const OCnvNUM=$02;{output converter $02}
   var OCnvNUM:byte;
const strID=$1;{stream ID}
const convID=$1;{converter ID}
const convchan=0;
const strnumber=0;{stream number}
const stroffset=(strnumber)*$20;{base+(number*$20)}

var volumewidget:byte;
var sleepingwidget:byte;

{offset}
const drvoff=$04000000;
const drvohi=$0400;drvolo=$0000;


const
BIT0=1;
BIT1=2;
BIT2=4;
BIT3=8;
BIT4=$10;
BIT5=$20;
BIT6=$40;
BIT7=$80;
BIT8=$100;
BIT9=$200;
BIT10=$400;
BIT11=$800;
BIT12=$1000;
BIT13=$2000;
BIT14=$4000;
BIT15=$8000;
BIT16=$10000;
BIT17=$20000;
BIT18=$40000;
BIT19=$80000;
BIT20=$100000;
BIT21=$200000;
BIT22=$400000;
BIT23=$800000;
BIT24=$1000000;
BIT25=$2000000;
BIT26=$4000000;
BIT27=$8000000;
BIT28=$10000000;
BIT29=$20000000;
BIT30=$40000000;
BIT31=$80000000;


{PCI card data to acquire}
var pciBUS:byte; {The PCI BUS}
var pciFunc:byte;{The PCI BUS index}
var pcivend,pcidid:word;
var subsysteminfo:longint;

var CardDetected:boolean;
var cardmemregistersLO:word;
var cardmemregistersHI:word;
var CardsPhysical:pointer;
var linear:pointer;
var length:pointer;


var HDA_PCIbaseoffset:word;
const HDA_Default_PCIbase_offset=0;{No offset}
const HDA_ICH_PCIbase_offset=4;{Sabertooth x58 ICH10 HDA memory address is 4bytes off}



const defMyPCI=$04100000+drvoff;{Wave data address}
const defMyPCIhi=$0410+drvohi;
const defMyPCILo=$0000+drvolo;

{const WaveData=$03000000+drvoff;}
var MyPCI:longint;{Wave data address}
var MyPCIhi:word;
var MyPCILo:word;
const MyPCI2=$04018000+drvoff;
const MyPCI3=$0401C000+drvoff;
var MyLinear:pointer;
var MyLength:pointer;
var myphysical1:pointer;

const defaPCI=$04000000+drvoff;{BDL}
const defaPCIHi=$0400+drvohi;
const defaPCILo=$0000+drvolo;
var aPCI:longint;{BDL}
var aPCIHi:word;
var aPCILo:word;

const aPCI2=$03108000+drvoff;
var aLinear:pointer;
var aLength:pointer;
var aphysical1:pointer;



const
	AC_WID_AUD_OUT=$00;                  {/* Audio Out */}
	AC_WID_AUD_IN=$01;                   {/* Audio In */}
	AC_WID_AUD_MIX=$02;                  {/* Audio Mixer */}
	AC_WID_AUD_SEL=$03;                  {/* Audio Selector */}
	AC_WID_PIN=$04;                  {/* Pin Complex */}
	AC_WID_POWER=$05;                  {/* Power */}
	AC_WID_VOL_KNB=$06;                  {/* Volume Knob */}
	AC_WID_BEEP=$07;                  {/* Beep Generator */}
	AC_WID_RESERVED=$08;                  {/* Beep Generator */}
	AC_WID_VENDOR = $0f;                    {/* Vendor specific */}



type DWORD=longint;

type unsignedshort=word;
type unsignedchar=byte;



type VERB=longint;
{31:28 Codec address}
{27:20 Node ID}
{19:0 payload}


type SolicitedResponse=longint;{31:0 response}


{HDA Buffer Descriptor Entry}
type HDABDLentry=record
ADDRLo32:pointer;{64-bit address}
ADDRHi32:pointer;
leng:longint;
IOC:longint;
end;
{HDA Buffer Descriptor List (BDL)}
Type BDLtable = ^THDABDLentrytable;{BDL table}
THDABDLentrytable = Record
entry:array[0..256] of HDABDLentry;
end;



Type CORBtable = ^TCORBtable;{CORB table}
TCORBtable = array[0..16000] of VERB;


{RIRB entry}
type RIRBentry=record
response:dword;
flags:dword;{Response Extended}
end;

Type RIRBtable = ^TRIRBtable;{RIRB table}
TRIRBtable = Record
entry:array[0..$1000] of RIRBentry;
end;

Type amem = ^Tatable;{RIRB table}
tatable = Record
BDL:THDABDLentrytable;
rirb:TRIRBtable;
end;



{DMA position entry}
type dmaposentry=record
DW0:pointer;
DW1:pointer;
end;
Type DMAposstr = ^TDMAposstr;{DMA table}
TDMAposstr = Record
test:array[0..1024] of dmaposentry;
end;



const
AC_GRP_AUDIO_FUNCTION = $01;
AC_GRP_MODEM_FUNCTION = $02;






{CODEC information to acquire}
var HDACodecVendor:word;
var HDACodecDevice:word;



{64 bit Physical PCI address}



{/*****************************************************************************
 * General PCI static defines
 ******************************************************************************/}
{
const PCI_CLASS_MULTIMEDIA_AUDIO  =$0401;
const PCI_CLASS_MULTIMEDIA_OTHER  =$0480;
const PCI_VENDER_ID         =$00;
const PCI_REVISION_ID       =$08;
const PCI_COMMAND           =$04;
const PCI_DEVICE_ID         =$02;
const PCI_INTERRUPT_LINE    =$3c;
const PCI_INT_LINE          =$3d;

const PCI_MEM_BASE_ADDRESS_0=$10;}
const PCI_MEM_BASE_ADDRESS_1=$14; {
const PCI_MEM_BASE_ADDRESS_2=$18;
const PCI_MEM_BASE_ADDRESS_3=$1c;

const PCI_BASE_ADDRESS_0    =$10;
const PCI_BASE_ADDRESS_1    =$14;
const PCI_BASE_ADDRESS_2    =$18;
const PCI_BASE_ADDRESS_3    =$1c;
const PCI_BASE_ADDRESS_4    =$20;
const PCI_BASE_ADDRESS_5    =$24;

const PCI_COMMAND_IO        =$01;
const PCI_COMMAND_MEMORY    =$02;
const PCI_COMMAND_MASTER    =$04;
const PCI_COMMAND_PARITY    =$40;
const PCI_ICH4_CFG_REG      =$41;
const PCI_COMMAND_SERR      =$100;

const PCI_STATUS              =$06;
const PCI_SUBSYSTEM_VENDER_ID =$2c;
const PCI_SUBSYSTEM_ID        =$2e;
}
{/* Ac97 general defines */}
const CTL_BASE                =0; {/* addressing controller regs */}
const MIXER_BASE              =1; {/* addressing mixer regs */}

{/*****************************************************************************
 * PCI space extended defines HDA specific
 ******************************************************************************/}

 {/* PCI space */}
const HDA_PCIREG_TCSEL              =$44;

{ Defines for Intel SCH HDA snoop control }
const INTEL_SCH_HDA_DEVC           =$78;
const INTEL_SCH_HDA_DEVC_NOSNOOP   =($1 shl 11);


{/* Defines for ATI HD Audio support in SB450 south bridge */}
const ATI_SB450_HDAUDIO_MISC_CNTR2_ADDR  =$42;
const ATI_SB450_HDAUDIO_ENABLE_SNOOP=$02;

{/* Defines for Nvidia HDA support */}
const NVIDIA_HDA_TRANSREG_ADDR      =$4e;
const NVIDIA_HDA_ENABLE_COHBITS     =$0f;

{/* HDA general defines */}
const HDA_MAX_DEV                        =16;
const HDA_MAX_CODECS                     =2;
const HDA_MAX_CODEC_ADDRESS         =$0f;

{/* max. connections to a widget */}
const HDA_MAX_CONNECTIONS                =32;
const HDA_MAX_PCM_VOLS                   =2;
const HDA_MAX_NUM_INPUTS                 =16;



{HDA stuff}
AC_NODE_ROOT                    =$00;

{ GET verbs}
AC_VERB_GET_STREAM_FORMAT       =$0a00;
AC_VERB_GET_AMP_GAIN_MUTE       =$0b00;
AC_VERB_GET_PROC_COEF           =$0c00;
AC_VERB_GET_COEF_INDEX          =$0d00;
AC_VERB_PARAMETERS              =$0f00;
AC_VERB_GET_CONNECT_SEL         =$0f01;
AC_VERB_GET_CONNECT_LIST        =$0f02;
AC_VERB_GET_PROC_STATE          =$0f03;
AC_VERB_GET_SDI_SELECT          =$0f04;
AC_VERB_GET_POWER_STATE         =$0f05;
AC_VERB_GET_CONV_STR_CH         =$0f06;{GET Converter Stream Channel}
AC_VERB_GET_PIN_WIDGET_CONTROL  =$0f07;
AC_VERB_GET_UNSOLICITED_RESPONSE=$0f08;
AC_VERB_GET_PIN_SENSE           =$0f09;
AC_VERB_GET_BEEP_CONTROL        =$0f0a;
AC_VERB_GET_EAPD_BTLENABLE      =$0f0c;
AC_VERB_GET_DIGI_CONVERT        =$0f0d;
AC_VERB_GET_VOLUME_KNOB_CONTROL =$0f0f;
AC_VERB_GET_GPIO_DATA           =$0f15;
AC_VERB_GET_GPIO_MASK           =$0f16;
AC_VERB_GET_GPIO_DIRECTION      =$0f17;
{AC_VERB_GET_GPIO_WAKE_MASK     =$0F18
AC_VERB_GET_GPIO_UNSOLICITED_RSP_MASK=$0f19
AC_VERB_GET_GPIO_STICKY_MASK    =$0f1a}
AC_VERB_GET_CONFIG_DEFAULT      =$0f1c;
AC_VERB_GET_SUBSYSTEM_ID        =$0f20;
{
AC_VERB_GET_CVT_CHAN_COUNT      =$0f2d
AC_VERB_GET_HDMI_DIP_SIZE       =$0f2e
AC_VERB_GET_HDMI_ELDD           =$0f2f
AC_VERB_GET_HDMI_DIP_INDEX      =$0f30
AC_VERB_GET_HDMI_DIP_DATA       =$0f31
AC_VERB_GET_HDMI_DIP_XMIT       =$0f32
AC_VERB_GET_HDMI_CP_CTRL        =$0f33
AC_VERB_GET_HDMI_CHAN_SLOT      =$0f34

{
 * SET verbs
 }
AC_VERB_SET_STREAM_FORMAT       =$200;
AC_VERB_SET_AMP_GAIN_MUTE       =$300;
AC_VERB_SET_PROC_COEF           =$400;
AC_VERB_SET_COEF_INDEX          =$500;
AC_VERB_SET_CONNECT_SEL         =$701;
AC_VERB_SET_PROC_STATE          =$703;
AC_VERB_SET_SDI_SELECT          =$704;
AC_VERB_SET_POWER_STATE         =$705;
AC_VERB_SET_CHANNEL_STREAMID    =$706;{SET Converter Stream Channel}
AC_VERB_SET_PIN_WIDGET_CONTROL  =$707;
AC_VERB_SET_UNSOLICITED_ENABLE  =$708;
AC_VERB_SET_PIN_SENSE           =$709;
AC_VERB_SET_BEEP_CONTROL        =$70a;
AC_VERB_SET_EAPD_BTLENABLE      =$70c;
AC_VERB_SET_DIGI_CONVERT_1      =$70d;
AC_VERB_SET_DIGI_CONVERT_2      =$70e;
AC_VERB_SET_VOLUME_KNOB_CONTROL =$70f;
AC_VERB_SET_GPIO_DATA           =$715;
AC_VERB_SET_GPIO_MASK           =$716;
AC_VERB_SET_GPIO_DIRECTION      =$717;
{AC_VERB_SET_GPIO_WAKE_MASK     =$718
AC_VERB_SET_GPIO_UNSOLICITED_RSP_MASK=719
AC_VERB_SET_GPIO_STICKY_MASK    =$71A}
AC_VERB_SET_CONFIG_DEFAULT_BYTES_0 =$71c;
AC_VERB_SET_CONFIG_DEFAULT_BYTES_1 =$71d;
AC_VERB_SET_CONFIG_DEFAULT_BYTES_2 =$71e;
AC_VERB_SET_CONFIG_DEFAULT_BYTES_3 =$71f;
{AC_VERB_SET_CVT_CHAN_COUNT=$72D
AC_VERB_SET_HDMI_DIP_INDEX=$730
AC_VERB_SET_HDMI_DIP_DATA  =$731
AC_VERB_SET_HDMI_DIP_XMIT  =$732
AC_VERB_SET_HDMI_CP_CTRL   =$733
AC_VERB_SET_HDMI_CHAN_SLOT =$734
AC_VERB_SET_EAPD           =$788}
AC_VERB_SET_CODEC_RESET         =$7ff;

{
 * Parameter IDs
 }
AC_PAR_VENDOR_ID                =$00;
AC_PAR_SUBSYSTEM_ID             =$01;
AC_PAR_REV_ID                   =$02;
AC_PAR_NODE_COUNT               =$04;
AC_PAR_FUNCTION_TYPE            =$05;
AC_PAR_AUDIO_FG_CAP             =$08;
AC_PAR_AUDIO_WIDGET_CAP         =$09;
AC_PAR_PCM                      =$0a;
AC_PAR_STREAM                   =$0b;
AC_PAR_PIN_CAP                  =$0c;
AC_PAR_AMP_IN_CAP               =$0d;
AC_PAR_CONNLIST_LEN             =$0e;
AC_PAR_POWER_STATE              =$0f;
AC_PAR_PROC_CAP                 =$10;
AC_PAR_GPIO_CAP                 =$11;
AC_PAR_AMP_OUT_CAP              =$12;
AC_PAR_KNOB=$13;{Volume Knob Capabilities?}
{AC_PAR_HDMI_LPCM_CAP           =$20}

{
 * AC_VERB_PARAMETERS results (32bit)
 }

{ Function Group Type }
AC_FGT_TYPE                     =$ff;
AC_FGT_TYPE_SHIFT                   =0;
AC_FGT_UNSOL_CAP                    =BIT8;

{ Audio Function Group Capabilities }
AC_AFG_OUT_DELAY                =$f;
AC_AFG_IN_DELAY                     =($f shl 8);
AC_AFG_BEEP_GEN                    =BIT16;


const a:array[0..1] of string=('Mono','Stereo');

{ Audio Widget Capabilities }
AC_WCAP_STEREO                      =BIT0;  { stereo I/O }
AC_WCAP_IN_AMP                      =BIT1;  { AMP-in present }
AC_WCAP_OUT_AMP                     =BIT2;  { AMP-out present }
AC_WCAP_AMP_OVRD                    =BIT3;  { AMP-parameter override }
AC_WCAP_FORMAT_OVRD                 =BIT4;  { format override }
AC_WCAP_STRIPE                      =BIT5;  { stripe }
AC_WCAP_PROC_WID                    =BIT6;  { Proc Widget }
AC_WCAP_UNSOL_CAP                   =BIT7;  { Unsol capable }
AC_WCAP_CONN_LIST                   =BIT8;  { connection list }
AC_WCAP_DIGITAL                     =BIT9;  { digital I/O }
AC_WCAP_POWER                       =BIT10; { power control }
AC_WCAP_LR_SWAP                     =BIT11; { L/R swap }
AC_WCAP_DELAY                       =($f shl 16);
AC_WCAP_DELAY_SHIFT                 =16;

{ supported PCM rates and bits }
AC_SUPPCM_RATES                 =$fff;
AC_SUPPCM_BITS_8                    =BIT16;
AC_SUPPCM_BITS_16                   =BIT17;
AC_SUPPCM_BITS_20                   =BIT18;
AC_SUPPCM_BITS_24                   =BIT19;
AC_SUPPCM_BITS_32                   =BIT20;

{ supported PCM stream format }
AC_SUPFMT_PCM                       =BIT0;
AC_SUPFMT_FLOAT32                   =BIT1;
AC_SUPFMT_AC3                       =BIT2;

{ Pin widget capabilies }
AC_PINCAP_IMP_SENSE                 =BIT0;    { impedance sense capable }
AC_PINCAP_TRIG_REQ                  =BIT1;    { trigger required }
AC_PINCAP_PRES_DETECT               =BIT2;    { presence detect capable }
AC_PINCAP_HP_DRV                    =BIT3;    { headphone drive capable }
AC_PINCAP_OUT                       =BIT4;    { output capable }
AC_PINCAP_IN                        =BIT5;    { input capable }
AC_PINCAP_BALANCE                   =BIT6;    { balanced I/O capable }
AC_PINCAP_VREF                      =($37 shl 8);
AC_PINCAP_VREF_SHIFT                =8;
AC_PINCAP_EAPD                      =BIT16;   { EAPD capable }

{ Vref status (used in pin cap) }
AC_PINCAP_VREF_HIZ                  =BIT0;    { Hi-Z }
AC_PINCAP_VREF_50                   =BIT1;    { 50% }
AC_PINCAP_VREF_GRD                  =BIT2;    { ground }
AC_PINCAP_VREF_80                   =BIT3;    { 80% }
AC_PINCAP_VREF_100                  =BIT5;    { 100% }

{ Amplifier capabilities }
AC_AMPCAP_OFFSET                    =($7f shl 0);  { 0dB offset }
AC_AMPCAP_OFFSET_SHIFT              =0;
AC_AMPCAP_NUM_STEPS                 =($7f shl 8); { number of steps }
AC_AMPCAP_NUM_STEPS_SHIFT           =8;
AC_AMPCAP_STEP_SIZE                 =($7f shl 16); { step size 0-32dB in 0.25dB }
AC_AMPCAP_STEP_SIZE_SHIFT           =16;
AC_AMPCAP_MUTE                      =BIT31;        { mute capable }
AC_AMPCAP_MUTE_SHIFT                =31;

{ Supported power status }
AC_PWRST_D0SUP                      =BIT0;
AC_PWRST_D1SUP                      =BIT1;
AC_PWRST_D2SUP                      =BIT2;
AC_PWRST_D3SUP                      =BIT3;

{ Power state values }
AC_PWRST_D0                     =$00;
AC_PWRST_D1	                    =$01;
AC_PWRST_D2                     =$02;
AC_PWRST_D3	                    =$03;

{ Processing capabilies }
AC_PCAP_BENIGN                      =BIT0;
AC_PCAP_NUM_COEF                    =($ff shl 8);

{ Volume knobs capabilities }
AC_KNBCAP_NUM_STEPS             =$7f;
AC_KNBCAP_DELTA                     =BIT8;

{
 * Control Parameters
 }

{ Amplifier gain/mute }
AC_AMP_MUTE                         =BIT7;
AC_AMP_GAIN                         =BIT0 or BIT1 or BIT2 or BIT3 or BIT4 or BIT5 or BIT6;
AC_AMP_GET_INDEX                    =BIT0 or BIT1 or BIT2 or BIT3;

AC_AMP_GET_LEFT                     =BIT13;
AC_AMP_GET_RIGHT                    =0;  { bit13 clear }
AC_AMP_GET_OUTPUT                   =BIT15;
AC_AMP_GET_INPUT                    =0;   { bit15 clear }

AC_AMP_SET_INDEX                    =BIT8 or BIT9 or BIT10 or BIT11;
AC_AMP_SET_RIGHT                    =BIT12;
AC_AMP_SET_LEFT                     =BIT13;
AC_AMP_SET_INPUT                    =BIT14;
AC_AMP_SET_OUTPUT                   =BIT15;

{ DIGITAL1 bits }
AC_DIG1_ENABLE                      =BIT0;
AC_DIG1_V                           =BIT1;
AC_DIG1_VCFG                        =BIT2;
AC_DIG1_EMPHASIS                    =BIT3;
AC_DIG1_COPYRIGHT                   =BIT4;
AC_DIG1_NONAUDIO                    =BIT5;
AC_DIG1_PROFESSIONAL                =BIT6;
AC_DIG1_LEVEL                       =BIT7;

{ Pin widget control - 8bit }
AC_PINCTL_VREFEN                =$7;
AC_PINCTL_VREF_HIZ                  =0;  { Hi-Z }
AC_PINCTL_VREF_50                   =1;  { 50% }
AC_PINCTL_VREF_GRD                  =2;  { ground }
AC_PINCTL_VREF_80                   =4;  { 80% }
AC_PINCTL_VREF_100                  =5;  { 100% }
AC_PINCTL_IN_EN                     =BIT5;
AC_PINCTL_OUT_EN                    =BIT6;
AC_PINCTL_HP_EN                     =BIT7;

{ Unsolicited response - 8bit }
AC_USRSP_EN                         =BIT7;

{ configuration default - 32bit }
AC_DEFCFG_SEQUENCE                  =($f shl 0);
AC_DEFCFG_DEF_ASSOC                 =($f shl 4);
AC_DEFCFG_ASSOC_SHIFT               =4;
AC_DEFCFG_MISC                      =($f shl 8);
AC_DEFCFG_MISC_SHIFT                =8;
AC_DEFCFG_COLOR                     =($f shl 12);
AC_DEFCFG_COLOR_SHIFT               =12;
AC_DEFCFG_CONN_TYPE                 =($f shl 16);
AC_DEFCFG_CONN_TYPE_SHIFT           =16;
AC_DEFCFG_DEVICE                    =($f shl 20);
AC_DEFCFG_DEVICE_SHIFT              =20;
AC_DEFCFG_LOCATION                  =($3f shl 24);
AC_DEFCFG_LOCATION_SHIFT            =24;
AC_DEFCFG_PORT_CONN                 =($3 shl 30);
AC_DEFCFG_PORT_CONN_SHIFT           =30;





{More HDA stuff}


{; HDA defines (simplified info)}
const
HDA_GCAP           =$00;{Global Capabilities}
HDA_VMIN           =$02;{Minor Version}
HDA_VMAJ           =$03;{Major Version}
HDA_OUTPAY         =$04;{Output Payload Capability}
HDA_INPAY          =$06;{Input Payload Capability}
HDA_GCTL           =$08;{Global Control}
 CRST                =BIT0;{Controller reset}
 UREN                =BIT8;{Unsolicited responses}
HDA_WAKEEN         =$0C;{Wake Enable}
HDA_STATESTS       =$0E;{Wake Status}
HDA_GSTS           =$10;{Global Status}
HDA_ECAP           =$14;{Extended capabilities - mobile only}
HDA_OUTSTRMPAY     =$18;{Output stream payload capability}
HDA_INSTRMPAY      =$1A;{Input stream payload capability}

HDA_INTCTL         =$20;{Interrupt Control}
 HDA_INT_ALL_STREAM =$ff;{all stream interrupts mask on IOC}
 HDA_INT_CTRL_EN     =BIT30 ;{controller interrupt enable bit}
 HDA_INT_GLOBAL_EN   =BIT31 ;{global interrupt enable bit}

HDA_INTSTS         =$24;{Interrupt Status}
REG_WALCLK         =$30;{Wall Clock Counter}
 HDA_SSYNC_ICH         =$34;{Stream Synchronization}
HDA_SSYNC          =$38;{or is it $38?}

HDA_CORBLBASE      =$40;{CORB Lower Base Address}
HDA_CORBUBASE      =$44;{CORB Upper Base Address}
HDA_CORBWP         =$48;{CORB Write Pointer}
HDA_CORBRP         =$4A;{CORB Read Pointer}
  HDA_CORBRP_RESET=$8000;{reset CORBRP}
HDA_CORBCTL        =$4C;{CORB Control}
  HDA_CORBCTL_RUN=$02;
HDA_CORBSTS        =$4D;{CORB Status}
HDA_CORBSIZE       =$4E;{CORB Size}

HDA_RIRBLBASE      =$50;{RIRB Lower Base Address}
HDA_RIRBUBASE      =$54;{RIRB Upper Base Address}
HDA_RIRBWP         =$58;{RIRB Write Pointer}
  HDA_RIRBWP_RESET=$8000;{reset RIRBWP}
HDA_RINTCNT        =$5A;{Response Interrupt Count}
HDA_RIRBCTL        =$5C;{RIRB Control}
  HDA_RIRBCTL_RUN=$02;
HDA_RIRBSTS        =$5D;{RIRB Status}
HDA_RIRBSIZE       =$5E;{RIRB Size}

HDA_IC             =$60;{Immediate Command}
HDA_IR             =$64;{Immediate Response}
HDA_IRS            =$68;{Immediate Command Status}

ICW=$60;
ICS=$68;
IRR=$64;



 IRS_BUSY            =BIT0;{immediate command busy}
 IRS_VALID           =BIT1;{immediate command valid}
HDA_DPLBASE        =$70;{DMA Position Lower Base Address}
HDA_DPUBASE        =$74;{DMA Position Upper Base Address}
 HDA_DPLBASE_ENABLE =$1 ;{Enable position buffer}

HDA_SD_CTL         =$00 ;{stream register offsets from stream base}
HDA_SD_STS         =$03;
HDA_SD_LPIB        =$04;
HDA_SD_CBL         =$08;
HDA_SD_LVI         =$0C;
HDA_SD_FIFOW       =$0E;
HDA_SD_FIFOSIZE    =$10;
HDA_SD_FORMAT      =$12;
HDA_SD_BDLPL       =$18;
HDA_SD_BDLPU       =$1C;
HDA_SD_LPIBA       =$2004;

{; SDCTL Stream Descriptor Control Register bits}
SD_CTL_STREAM_RESET	=BIT0;{stream reset bit}
SD_CTL_DMA_START    =BIT1;{stream DMA start bit}
SD_CTL_STREAM_TAG_MASK         = ($F shl 20);{(BIT20 or BIT21 or BIT22 or BIT23)  {set bits 20 - 23 of SD_CTL register}
SD_CTL_STREAM_TAG_SHIFT        = 20;

{; SDSTS Stream Descriptor Status Register bits}
SD_INT_COMPLETE     =BIT2;{completion interrupt}
SD_INT_FIFO_ERR     =BIT3;{FIFO error interrupt}
SD_INT_DESC_ERR     =BIT4;{descriptor error interrupt}
RIRB_INT_MASK                 =  (BIT0 or BIT2);
SD_INT_MASK                   =  (SD_INT_DESC_ERR or SD_INT_FIFO_ERR or SD_INT_COMPLETE);
STATESTS_INT_MASK             =  (BIT0 or BIT1 or BIT2);


{4 Input Stream descirptors:}
HDA_SDI0CTL        =$80;{Stream Descriptor Control}
HDA_SDI0STS        =$83;{Stream Descriptor Status}
HDA_SDI0LPIB       =$84;{Link Position in Current Buffer}
HDA_SDI0CBL        =$88;{Cyclic Buffer Length}
HDA_SDI0LVI        =$8C;{Last Valid Index}
HDA_SDI0FIFOW      =$8E;{FIFO watermark}
HDA_SDI0FIFOSIZE   =$90;{FIFO Size}
HDA_SDI0FORMAT     =$92;{Format}
HDA_SDI0BDLPL      =$98;{List Pointer - Lower}
HDA_SDI0BDLPU      =$9C;{List Pointer - Upper}
HDA_SDI0LPIBA      =$2084;{Link Posiiton in Buffer n Alias}

HDA_SDI1CTL        =$A0;{Stream Descriptor Control}
HDA_SDI1STS        =$A3;{Stream Descriptor Status}
HDA_SDI1LPIB       =$A4;{Link Position in Current Buffer}
HDA_SDI1CBL        =$A8;{Cyclic Buffer Length}
HDA_SDI1LVI        =$AC;{Last Valid Index}
HDA_SDI1FIFOW      =$AE;{FIFO watermark}
HDA_SDI1FIFOSIZE   =$B0;{FIFO Size}
HDA_SDI1FORMAT     =$B2;{Format}
HDA_SDI1BDLPL      =$B8;{List Pointer - Lower}
HDA_SDI1BDLPU      =$BC;{List Pointer - Upper}
HDA_SDI1LPIBA      =$20A4;{Link Posiiton in Buffer n Alias}

HDA_SDI2CTL        =$C0;{Stream Descriptor Control}
HDA_SDI2STS        =$C3;{Stream Descriptor Status}
HDA_SDI2LPIB       =$C4;{Link Position in Current Buffer}
HDA_SDI2CBL        =$C8;{Cyclic Buffer Length}
HDA_SDI2LVI        =$CC;{Last Valid Index}
HDA_SDI2FIFOW      =$CE;{FIFO watermark}
HDA_SDI2FIFOSIZ    =$D0;{FIFO Size}
HDA_SDI2FORMAT     =$D2;{Format}
HDA_SDI2BDLPL      =$D8;{List Pointer - Lower}
HDA_SDI2BDLPU      =$DC;{List Pointer - Upper}
HDA_SDI2LPIBA      =$20D4;{Link Posiiton in Buffer n Alias}

HDA_SDI3CTL        =$E0;{Stream Descriptor Control}
HDA_SDI3STS        =$E3;{Stream Descriptor Status}
HDA_SDI3LPIB       =$E4;{Link Position in Current Buffer}
HDA_SDI3CBL        =$E8;{Cyclic Buffer Length}
HDA_SDI3LVI        =$EC;{Last Valid Index}
HDA_SDI3FIFOW      =$FE;{FIFO watermark}
HDA_SDI3FIFOSIZE   =$F0;{FIFO Size}
HDA_SDI3FORMAT     =$F2;{Format}
HDA_SDI3BDLPL      =$F8;{List Pointer - Lower}
HDA_SDI3BDLPU      =$FC;{List Pointer - Upper}
HDA_SDI3LPIBA      =$20E4;{Link Posiiton in Buffer n Alias}


{4 Output Stream descirptors:}
HDA_SDO0CTL        =$100 ;{Stream Descriptor Control}
HDA_SDO0STS        =$103 ;{Stream Descriptor Status}
HDA_SDO0LPIB       =$104 ;{Link Position in Current Buffer}
HDA_SDO0CBL        =$108 ;{Cyclic Buffer Length}
HDA_SDO0LVI        =$10C ;{Last Valid Index}
HDA_SDO0FIFOW      =$10E ;{FIFO watermark}
HDA_SDO0FIFOSIZE   =$110 ;{FIFO Size}
HDA_SDO0FORMAT     =$112 ;{Format}
HDA_SDO0BDLPL      =$118 ;{List Pointer - Lower}
HDA_SDO0BDLPU      =$11C ;{List Pointer - Upper}
HDA_SDO0LPIBA      =$2104;{Link Posiiton in Buffer n Alias}

HDA_SDO1CTL        =$120 ;{Stream Descriptor Control}
HDA_SDO1STS        =$123 ;{Stream Descriptor Status}
HDA_SDO1LPIB       =$124 ;{Link Position in Current Buffer}
HDA_SDO1CBL        =$128 ;{Cyclic Buffer Length}
HDA_SDO1LVI        =$12C ;{Last Valid Index}
HDA_SDO1FIFOW      =$12E ;{FIFO watermark}
HDA_SDO1FIFOSIZE   =$130 ;{FIFO Size}
HDA_SDO1FORMAT     =$132 ;{Format}
HDA_SDO1BDLPL      =$138 ;{List Pointer - Lower}
HDA_SDO1BDLPU      =$13C ;{List Pointer - Upper}
HDA_SDO1LPIBA      =$2124;{Link Posiiton in Buffer n Alias}

HDA_SDO2CTL        =$140 ;{Stream Descriptor Control}
HDA_SDO2STS        =$143 ;{Stream Descriptor Status}
HDA_SDO2LPIB       =$144 ;{Link Position in Current Buffer}
HDA_SDO2CBL        =$148 ;{Cyclic Buffer Length}
HDA_SDO2LVI        =$14C ;{Last Valid Index}
HDA_SDO2FIFOW      =$14E ;{FIFO watermark}
HDA_SDO2FIFOSIZE   =$150 ;{FIFO Size}
HDA_SDO2FORMAT     =$152 ;{Format}
HDA_SDO2BDLPL      =$158 ;{List Pointer - Lower}
HDA_SDO2BDLPU      =$15C ;{List Pointer - Upper}
HDA_SDO2LPIBA      =$2144;{Link Posiiton in Buffer n Alias}

HDA_SDO3CTL        =$160 ;{Stream Descriptor Control}
HDA_SDO3STS        =$163 ;{Stream Descriptor Status}
HDA_SDO3LPIB       =$164 ;{Link Position in Current Buffer}
HDA_SDO3CBL        =$168 ;{Cyclic Buffer Length}
HDA_SDO3LVI        =$16C ;{Last Valid Index}
HDA_SDO3FIFOW      =$16E ;{FIFO watermark}
HDA_SDO3FIFOSIZE   =$170 ;{FIFO Size}
HDA_SDO3FORMAT     =$172 ;{Format}
HDA_SDO3BDLPL      =$178 ;{List Pointer - Lower}
HDA_SDO3BDLPU      =$17C ;{List Pointer - Upper}



{// 1 HDA node with it's data}
type phda_node = ^hda_node;
hda_node=record
        nid:WORD;                  {  NID of this widget }
        nconns:WORD;                { number of input connections }
        conn_list:array[0..HDA_MAX_CONNECTIONS] of WORD;
        wid_caps:DWORD;             { widget capabilities }
        dtype:DWORD ;                 { node/widget type - bits 20 - 23 of wid_caps }
        pin_caps:DWORD;             { pin widget capabilities }
        pin_ctl:DWORD;              { pin controls }
        def_config:DWORD;           { default configuration }
        amp_out_caps:DWORD;         { AMP out capabilities override over default }
        amp_in_caps:DWORD;          { AMP in capabilities override over default }
        supported_formats:DWORD;    { supported formats value }
        checked:BYTE;               { flag indicator that node is already parsed }
end;

type pcm_vol_str =record
node:hda_node;{Node for PCM volume}
index:DWORD;   {connection of PCM volume}
end;


type HDAcard=record
codec_mask:longint;
codec_index:longint;

afg_root_nodenum:unsignedshort;
afg_num_nodes:longint;
afg_nodes:array[0..128] of hda_node;
def_amp_out_caps:longint;
def_amp_in_caps:longint;
    dac_node:array[0..2]of {p}hda_node;{DAC nodes}
out_pin_node:array[0..2]of phda_node;{Output pin nodes - all (Line-Out/hp-out, etc...)}
    adc_node:array[0..2]of phda_node;{ADC nodes}
 in_pin_node:array[0..2]of phda_node;{Input pin nodes - all (CD-In, etc...) - obsolete}
input_items:longint;                               {Input items for capture}
pcm_num_vols:longint;                              {number of PCM volumes }
pcm_vols:array[0..HDA_MAX_PCM_VOLS] of pcm_vol_str;{ PCM volume nodes}

format_val:longint;                  { stream type}
dacout_num_bits:longint;             { bits for playback (16 bits by default)}
dacout_num_channels:longint;         { channels for playback (2 = stereo by default)}
stream_tag:longint;                  { stream associated with our SD (1 by default)}
supported_formats:longint;
supported_max_freq:longint;
supported_max_bits:longint;

freq_card:longint;                  { current frequency 44100 by default}
chan_card:longint;
bits_card:longint;

{// codec IDs and names}
        codec_id1:word;            {codec vender id}
        codec_id2:word;            {codec device id }
        device_name:array[0..128] of char;{controller name string}
        codec_name:array[0..128] of char; {codec name string}
end;
var audio_pci:hdacard;

var
hda_civ:word;
hda_lpib:word;




Type Wstr = ^wIstr;
wIstr = Record
test:array[0..32500] of word;
end;

Type bstr = ^bIstr;
bIstr = Record
test:array[0..$FFFE] of byte;
end;

Type lstr = ^lIstr;
lIstr =array[0..16100] of longint;




var mpch:wstr;{Cards PCI memory to Win16 memory link}
var PCMbuffer:lstr;{pci/Win16 memory link for Audio buffer}
var abuffer:amem;{pci/Win16 memory link for BDL,CORB,RIRB buffer}
const RIRBofs=$4000;{abuffer}
const CORBofs=$8000;{abuffer}

{pHDABDLentrytable}

function corbrirbget1(data:longint):longint;export;
function HDA_CORBout256(url:string):integer;export;
function HDA_resetCORBRIRB:integer;export;

procedure strlog(v:string); export;
function myHDAreset:byte;export;
Function jhda_reset:boolean;export;
function Scan_PCI_HDA_cards:boolean;export;
function Specify_PCI_HDA_card:boolean;

function  hda_OUTL(code:longint;lng:longint):byte;export;
function  hda_OUTW(code:longint;wrd:word):byte;export;
function  hda_OUTB(code:longint;b:byte):byte;export;
function  hda_INL(code:longint):longint;export;
function  hda_INW(code:longint):word;export;
function  hda_INB(code:longint):byte;export;
function hda_mixer_init:longint;export;
function hda_codec_stop:word;export;
function hda_param_read(nid:longint;param:longint):longint;export;

function  hda_codec_read(nid:unsignedshort;direct,verb,param:longint):longint;export;
function hda_codec_write(nid:unsignedshort;direct,verb,param:longint):longint;export;

function hda_get_vol_mute ( nid,  ch,  direction, index:longint):longint;export;
function hda_set_vol_mute ( nid,  ch,  direction,  index, val:longint):byte;export;


function hda_calc_stream_format(mixrate:longint):longint;export;
function hda_codec_start:byte;export;

function HDAenablecircularbuffer(strt:boolean;volume:longint):byte;export;
function EnablePCIHDAmem:boolean;export;
{function detectHDA(var VID,DID:word):boolean;export;}
function memstart:byte;export;
function memstop:byte;export;

function HDAsetFormat(format:longint):byte;export;
function hdaconfig:byte; export;
function getHDACODECvendor:longint;export;
{function getHDACODECNODEinfo:longint;export;
function getHDACODECREVID:longint;export;}
procedure tgdelay(t:longint);export;
implementation


{This is how AMD does a 30 uSec delay}
procedure AMD_fixed_delay(delay:longint);
begin
 while (delay>0) do begin
  while (port[$61] and 16)=16 do begin {wait till port $61 changes}  end;
 delay:=delay-1;
  while (port[$61] and 16)=0 do begin {wait till port $61 changes}  end;
end;
end;

function realalarmclock(alarm:double):byte;
begin
{time+0.00001=1 wait a sec?}
while time<alarm do begin
inline($90);
end;
end;
{delay for a time using a mmsystem timer}
procedure tgdelay(t:longint);
var new,old,x,e:longint;
begin
x:=0;
old:=timegettime;
if(t=0)then t:=1;
 while (x<t) do begin
  new:=timegettime;
  if(old<new)then begin
   x:=x+(new-old);
  end;
  old:=new;
 end;
end;




function  hda_OUTL(code:longint;lng:longint):byte;
begin
lstr(mpch)^[code div 4]:=Lng;
end;
function  hda_OUTW(code:longint;wrd:word):byte;
begin
wstr(mpch)^.test[code div 2]:=wrd;

end;
function  hda_OUTB(code:longint;b:byte):byte;
begin
bstr(mpch)^.test[code]:=b;
end;
                                     

function  hda_INL(code:longint):longint;
begin
result:=lstr(mpch)^[code div 4];
end;
function  hda_INW(code:longint):word;
begin
result:=wstr(mpch)^.test[code div 2];
end;
function  hda_INB(code:longint):byte;
begin
result:=bstr(mpch)^.test[code];
end;


function hda_codec_stop:word;
const timerout=300;
var i:word;
begin
{hda codec stop - stop DMA engine for output and
disable interrupts (Interrupt on Completion, FIFO Error Interrupt, Descriptor Error Interrupt)}
hda_OUTB(HDA_SDO0CTL, hda_INB (HDA_SDO0CTL) and not(SD_CTL_DMA_START or SD_INT_MASK));
tgdelay(1);
{Software must read a 0 from the DMA run bit before modifying related control registers or restarting the DMA engine}

I:=timerout;
 while i>1 do begin
  dec(i);
   if (hda_INB (HDA_SDO0CTL) and SD_CTL_DMA_START)=0 then begin
    i:=0;
   end;
  tgdelay(2);
 end;

{hda codec close - reset stream 0 data since we're not using other output streams anyway}
hda_OUTL (HDA_DPLBASE, 0);  {DMA Position Lower Base Address}
hda_OUTL (HDA_DPUBASE, 0);  {DMA Position Upper Base Address}
hda_OUTL (HDA_SDO0BDLPL, 0);{SD0 outpuy BDL - lower}
hda_OUTL (HDA_SDO0BDLPU, 0);{SD0 output BDL - upper}
hda_OUTL (HDA_SDO0CTL, 0);  {SD0 output stream descriptor control}
{hda_OUTL(HDA_SDO0LVI, 0);{SD0 output BDL - upper}
hda_OUTL(HDA_SDO0CBL, 0);{buffer length}

{zero out HDA start values in ASM module (current pos and CIV)}
hda_civ := 0;
hda_lpib := 0;

end;


{wat say?}
function HDA_ICsendgetL(vdata:longint):longint;
var x,y:word;
var hda_codec_vender_id:longint;
var L:longint;
begin
result:=$FFFF;
infstr:='         ';
hda_codec_vender_id:=0;

 wstr(mpch)^.test[ICS div 2]:=$0002;{Clear 68}
 delay1(1);
 wstr(mpch)^.test[ICS div 2]:=$0000;{Clear 68}
 delay1(1);
L:=10;
while L>1 do begin
L:=L-1;
x:=bstr(mpch)^.test[ICS{68}] and 3;

 if not(x=0) then begin
 {Busy/not clear yet?}
  delay1(1);
 result:=$FADE;
 infstr[1]:='-';
 end else begin
 L:=0;
 infstr[2]:='+';
 end;

end;


{showmessage('ICB clear');}
{LOAD ICW}
  lstr(mpch)^[ICW{60} div 4]:=vdata;{send data}
{SET ICB}
  bstr(mpch)^.test[ICS{68}]:=bstr(mpch)^.test[ICS] or 1;{Set bit0 of 68}

{ L:=1000;
 while L>1 do begin
 dec(L);
    if not((hda_INW(HDA_IRS) and IRS_BUSY)=IRS_BUSY) then begin
       hda_OUTW (HDA_IRS, hda_INW (HDA_IRS) or IRS_VALID);
       hda_OUTL (HDA_IC, vdata);
       hda_OUTW (HDA_IRS, hda_INW (HDA_IRS) or IRS_BUSY);
       infstr[7]:='b';
    end else begin
    L:=0;
      infstr[8]:='B';
    end;
 end;
 }

{wait and watch...}
 L:=10;
 while L>1 do begin
 y:=(bstr(mpch)^.test[ICS{68}] and 3);

  if(y=3)THEN begin {Busy... But now Finished?}
    result:=lstr(mpch)^[IRR{64} div 4];{Lets Read the data and keep watching...}
    infstr[3]:='?';
    delay1(2);
  end else
   if(y=2)THEN begin {Not busy/Now Finished!}
    result:=lstr(mpch)^[IRR{64} div 4];{Read data}
    bstr(mpch)^.test[ICS]:=bstr(mpch)^.test[ICS] or 2;{clear bit0}
    infstr[6]:='g';
    L:=0;
   end else
   if(y=1)then begin
 {Busy Working on it. Not yet finished...}
    infstr[4]:='w';
    delay1(2);
   end else
    if(y=0)then  begin{not working, not done, and doing nothing?}
     lstr(mpch)^[ICW{60} div 4]:=vdata;{send data... again...}
     bstr(mpch)^.test[ICS]:=bstr(mpch)^.test[ICS] or 1;{Set bit0 of 68... again}
     infstr[5]:='!';
     delay1(2);
    end;
{ lstr(mpc)^.test[HDA_IRS div 4]:=lstr(mpc)^.test[HDA_IRS div 4] or 2;}
{ delay1(1);}
 L:=L-1;
 end;


end;

procedure strlog(v:string); begin
if strlston then strlst.add(v);
end;




function HDA_corbrirb_sendgetL(read60:boolean;icvout:longint):longint;
var x:integer;
var lastc:byte;
begin
if corbactive=false then begin HDA_resetCORBRIRB;delay1(2);end;
{First erase RIRB data}
HugeInc(pointer(abuffer),RIRBofs);{Slide selector to RIRB list}
fillchar(abuffer^,$800,char($00));
HugeDec(pointer(abuffer),RIRBofs);{Slide selector back}

{Then load CORB data}
HugeInc(pointer(abuffer),CORBofs);{Slide selector to CORB list}
x:=0;
while x<256 do begin
{corbtable(abuffer)^[0]:=$00000000;{ignore item 0}
corbtable(abuffer)^[x]:=icvout;{set item 1}
{corbtable(abuffer)^[2]:=icvout;}
inc(x);
end;
HugeDec(pointer(abuffer),CORBofs);{Slide selector back}

{Tell HDA to reset CORB}
{HDA_OUTW(HDA_RIRBWP,BIT15);{reset rirbwp}
{HDA_OUTW(HDA_CORBRP,BIT15);{reset corbrp}
{delay1(5);}
{tgdelay(10);   }
{AMD_fixed_delay(wait1);  }
{realalarmclock(time+0.000001);
{realalarmclock(time+0.00001);}
{HDA_OUTW(HDA_RIRBWP,0);{clear reset rirbwp}
{HDA_OUTW(HDA_CORBRP,0);{clear reset corbrp}
{delay1(5);}
{tgdelay(10);}
{realalarmclock(time+0.000001);
{AMD_fixed_delay(wait1);    }
{realalarmclock(time+0.00001);}
{HDA_OUTW(HDA_CORBRP,0);{clear reset}

lastc:=HDA_INB(HDA_CORBRP) and $FF;
HDA_OUTW(HDA_CORBWP,byte(lastc-1 and $FF));{last place to read}
{delay1(5);}
{tgdelay(10);        }
AMD_fixed_delay(wait1);
{realalarmclock(time+0.000001);}
{realalarmclock(time+0.00001);}
{read RIRB result}
HugeInc(pointer(abuffer),RIRBofs);
result:=lstr(abuffer)^[2];
HugeDec(pointer(abuffer),RIRBofs);

end;


function HDA_sendgetL(vdata:longint):longint;
begin
{result:=corbrirbget(vdata); }
if(HDAinterface=1)then begin
result:=HDA_corbrirb_sendgetL(true,vdata);
end else begin
result:=HDA_ICsendgetL(vdata);
end;
end;

function ICsendget(nid,dir,verb,param:word):longint;
var icvout:longint;
begin
{nibble 7}icvout:=longint((longint(audio_pci.codec_index) and $F) shl 28);
{nibble 6}icvout:=longint(icvout) or longint(longint(dir) shl 27);
{nibble 5}icvout:=longint(icvout) or longint(longint(nid) shl 20);   {// node ID}
{nibble 2}ICvout:=longint(icvout) or longint(longint(verb) shl 8);   { verb}
{nibble 0}icvout:=longint(icvout) or longint(param);   { parameter}
result:=HDA_ICsendgetL(icvout);
end;






function hda_single_corbrirb_send_cmd(read60:boolean;nid:word;dir,verb,param:longint):longint;
var icvout:longint;
var x:integer;
var lastc:byte;
begin
if corbactive=false then HDA_resetCORBRIRB; 
icvout:=0;
{nibble 7}icvout:=longint(longint(longint(audio_pci.codec_index) and $F) shl 28);
{nibble 6}icvout:=longint(icvout) or longint(longint(dir) shl 27);
{nibble 5}icvout:=longint(icvout) or longint(longint(nid) shl 20);   {// node ID}
{nibble 2}ICvout:=longint(icvout) or longint(longint(verb) shl 8);   { verb}
{nibble 0}icvout:=longint(icvout) or longint(param);   { parameter}

{First erase RIRB data}
HugeInc(pointer(abuffer),RIRBofs);{Slide selector to RIRB list}
fillchar(abuffer^,$800,char($00));
HugeDec(pointer(abuffer),RIRBofs);{Slide selector back}

{Then load CORB data}
HugeInc(pointer(abuffer),CORBofs);{Slide selector to CORB list}
x:=0;
while x<256 do begin
{corbtable(abuffer)^[0]:=$00000000;{ignore item 0}
corbtable(abuffer)^[x]:=icvout;{set item 1}
{corbtable(abuffer)^[2]:=icvout;}
inc(x);
end;
HugeDec(pointer(abuffer),CORBofs);{Slide selector back}

{Tell HDA to reset CORB}
{HDA_OUTW(HDA_RIRBWP,BIT15);{reset rirbwp}
{HDA_OUTW(HDA_CORBRP,BIT15);{reset corbrp}
{tgdelay(wait2);
{realalarmclock(time+0.000001);}
{HDA_OUTW(HDA_RIRBWP,0);{clear reset rirbwp}
{HDA_OUTW(HDA_CORBRP,0);{clear reset corbrp}
{tgdelay(wait2);
{realalarmclock(time+0.000001);}
{HDA_OUTW(HDA_CORBRP,0);{clear reset}

lastc:=HDA_INB(HDA_CORBRP) and $FF;
HDA_OUTW(HDA_CORBWP,byte(lastc-1 and $FF));{last place to read}
{HDA_OUTW(HDA_CORBWP,255);{last place to read}

tgdelay(wait2);
{realalarmclock(time+0.000001);}
{read RIRB result}
HugeInc(pointer(abuffer),RIRBofs);
result:=lstr(abuffer)^[2];
HugeDec(pointer(abuffer),RIRBofs);

strlog('$'+inttohex(icvout,8)+'=$'+inttohex(result,8));
    {
str:='Usr'+inttohex(result,8);
writestr1(1,1,str);
 }
end;

{/*********************************************************************************************
  * HDA Basic read/write to codecs - Single immediate command instead of CORB/RIRB buffers for simplicity
 *********************************************************************************************/}

function  hda_single_IC_send_cmd (read60:boolean;nid:word;direct,verb,param:longint):BOOLean;
var timeout1 :longint;
var   value:longint;
var IRSval,iv:longint;
const delaytime=$1FFFF;
begin
newget:=$BADC0DEC;
result:= FALSE;
    value :=longint(longint(longint(audio_pci.codec_index) and $0F) shl 28);   {// CaD - codec address}
    value :=longint(value) or longint(longint(direct) shl 27);   {// 0 = direct NID reference, 1 = indirect NID reference}
    value :=longint(value) or longint(longint(nid) shl 20);   {// node ID}
    value :=longint(value) or longint(longint(verb) shl 8);   { verb}
    value :=longint(value) or longint(param);   { parameter}


{clean up time!}
    irsval:=hda_INW(HDA_IRS);
    if not((IRSval and 3)=0)then begin
    strlog('CODEC busy again after finishing $'+inttohex(lastsend,8));
    hda_OUTW (HDA_IRS, (irsval) or IRS_VALID);
    end;

    lastsend:=value;

  timeout1:=delaytime;
  while (timeout1>2) do begin
  timeout1:=timeout1-1;
    irsval:=hda_INW(HDA_IRS);
     if ((IRSval and 3)=0)then begin
     timeout1:=0;
     end;
  end;

  irsval:=hda_INW(HDA_IRS);
  if ((IRSval and 3)=0)then begin
{  strlog('$68=0  codec is ready to send');}
  end else begin
  hda_OUTW (HDA_IRS, (irsval and $FFFC));
  strlog('Is this the wrong CODEC ID?');
  end;



   timeout1:=1000;
    while (timeout1>2) do begin
      timeout1:=timeout1-1;
      irsval:=hda_INW(HDA_IRS);
{        if not((hda_INW(HDA_IRS) and IRS_BUSY)=IRS_BUSY) then begin}
        if not((irsval and IRS_BUSY)=IRS_BUSY) then begin
            newget:=$FFFFFFFF;
{            hda_OUTW (HDA_IRS, hda_INW (HDA_IRS) or IRS_VALID);}
            hda_OUTL (HDA_IC, value);
            {does CODEC set valid when done?}
            hda_OUTW (HDA_IRS, hda_INW (HDA_IRS) or IRS_BUSY or IRS_VALID);
            {Or Is Software the flag man who holds up a [STOP] sign?}
        end;
    end;


  timeout1:=delaytime;
  while (timeout1>2) do begin
    timeout1:=timeout1-1;
    irsval:=hda_INW(HDA_IRS);
     if((IRSval and 3)<>3)then begin
     timeout1:=0;
     IV:=hda_INL (HDA_IR);
     if(iv>0)then strlog('First IRS change $'+inttohex(IV,8));
     end;
  end;

if(timeout1<>0)then begin
strlog('$68 is silly putty!');
end;

if(timeout1=0)then begin

  timeout1:=delaytime;
  while (timeout1>2) do begin
    timeout1:=timeout1-1;
    irsval:=hda_INW(HDA_IRS);
     if((IRSval and IRS_BUSY)=0)then begin
     {CODEC has ceased being busy?}
       if((IRSval and IRS_VALID)=IRS_VALID)then begin
       {Did the CODEC even use IRS_VALID?}
        timeout1:=0;{CODEC has finished reading command}
        if read60 then newget:=hda_INL (HDA_IR) else newget:=$C0DECD1D;{CODEC did ok}
        result:= TRUE;
       end;
     end;
  end;

end;
{clear IC status}
    irsval:=hda_INW(HDA_IRS);
    if not((IRSval and 3)=0)then begin
    hda_OUTW (HDA_IRS, (irsval) or IRS_VALID);
    end;

  timeout1:=delaytime;
  while (timeout1>2) do begin
  timeout1:=timeout1-1;
    irsval:=hda_INW(HDA_IRS);
     if ((IRSval and 3)=0)then begin
     timeout1:=0;
     end;
  end;

   irsval:=hda_INW(HDA_IRS);
  if not((IRSval and 3)=0)then begin
  hda_OUTB($68,2);
  strlog('CODEC did not clear valid?');

    timeout1:=100;
  while (timeout1>2) do begin
  timeout1:=timeout1-1;
    irsval:=hda_INW(HDA_IRS);
    hda_OUTW (HDA_IRS, (irsval) or IRS_VALID);
  end;
 delay1(1);
   irsval:=hda_INW(HDA_IRS);
  if not((IRSval and 3)=0)then begin
  hda_OUTW($68,0);
  strlog('CODEC does not change VALID?');
  end;

  end;


    irsval:=hda_INW(HDA_IRS);
    if ((IRSval and 3)=0)then begin
{    strlog('clean up ok!');}
    end else begin
    strlog('clean up fail!');
    end;


result:=true;

end;



function  hda_single_send_cmd (read60:boolean;nid:word;dir,verb,param:longint):BOOLean;
begin
if(HDAinterface=1)then begin
 newget:=hda_single_CORBRIRB_send_cmd(read60,nid,dir,verb,param);
 result:=true;
end else begin
result:=hda_single_IC_send_cmd(read60,nid,dir,verb,param);
end;
end;


function hda_single_get_response:longint;
var timeout2:longint;
received:boolean;
const tlimit=$FFFFFFF;
begin
result:= $FFFFFFFF;
received:=false;
 timeout2 := tlimit;
    while (timeout2>1) do begin
    timeout2:=timeout2-1;
        if (hda_INW (HDA_IRS) and IRS_VALID)=IRS_VALID then begin
         result:= hda_INL (HDA_IR);
         timeout2:=0;
        end else begin
         {wait until valid}
        end;
    end;

 if ((hda_INW (HDA_IRS) and IRS_BUSY)=IRS_BUSY) then begin
{    hda_OUTW (HDA_IRS, IRS_VALID);{never became valid?}
{    delay1(2);{And yet still busy?}
{    hda_OUTW (HDA_IRS, 0);{Was it a bad verb command?}
   if result=$FFFFFFFF then begin
    strlog('$'+inttohex(lastsend,8)+' get fail after '+inttostr(tlimit-timeout2)+'='+inttohex(hda_INL (HDA_IR),8));
   end else begin
    strlog('$'+inttohex(lastsend,8)+' get BUSY after '+inttostr(tlimit-timeout2)+'='+inttohex(hda_INL (HDA_IR),8));
   end;
{    delay1(2);}
 end else begin
 {A normal CODEC response?}
 if(timeout2>0)then begin
 strlog('no '+inttostr(tlimit-timeout2));
 end else begin
 strlog('normal');
 end;
 end;

{   if strlston then strlog('$'+inttohex(result,8)+' received');}
end;




{// standard codec write}
function hda_codec_write (nid:unsignedshort;direct,verb,param:longint):longint;
var x:boolean;
begin
x:=hda_single_send_cmd(false,nid, direct, verb, param);
if(x=true)then begin result:=1; end;
if(x=false)then begin result:=0;end;
end;

{// standard codec read}
function hda_codec_read(nid:unsignedshort;direct, verb,param:longint):longint;
var x:boolean;
begin
    result:=0;
    newget:=$DEADC0DE;
    x:=hda_single_send_cmd (true, nid, direct, verb, param);
    result:=newget;
{    if x and not(newget=$FFFFFFFF) then begin
    result:=hda_single_get_response;
    end else begin
     showmessage('hda_codec_write error?');
    end;
}
end;




{// simplified codec read parameters - direct NID reference}
function hda_param_read(nid:longint;param:longint):longint;
begin
    result:= hda_codec_read (nid, 0, AC_VERB_PARAMETERS, param);
end;



{/**********************************
HDA  Nodes identification functions
***********************************/}
{// Subordinate Node Count as in Intel specs}
function  hda_get_sub_nodes (nid:unsignedshort;var  start_node:unsignedshort):longint;
var param:longint; {  // the parameter value - response is 32bit}
begin
    param := hda_param_read (nid, AC_PAR_NODE_COUNT);
    start_node := (param shr 16) and $ff;   {// starting node number bits 16 - 23}
    result:= (param and $ff);               { // total number of nodes bits 0 - 7}

end;




{// Search audio node from Function Group Types}
function hda_search_audio_node:byte;
var total_nodes,i:longint;
var nid:unsignedshort;{ // starting function group node}
var x:longint;
var break:boolean;
begin
NID:=0;
    {// get total function group nodes and save starting function group node}
total_nodes := hda_get_sub_nodes (AC_NODE_ROOT, nid);{nid now:= start node}

   { // bits 0 - 7 of response from parameter read specify the node type}
   { // search and save audio function group node id}
i:=0; break:=false;
   while (i<total_nodes+1)and not(break) do begin
   x:=hda_param_read (nid, AC_PAR_FUNCTION_TYPE);
        if ((x and $ff) = AC_GRP_AUDIO_FUNCTION) then begin
            audio_pci.afg_root_nodenum := nid;
            break:=true;
        end;

    i:=i+1;nid:=nid+1;
   end;
end;


{// set the volume or mute the requested amplifier}
function hda_set_vol_mute ( nid,  ch,  direction,  index, val:longint):byte;
var param:longint;
const	HDA_INPUT=0; HDA_OUTPUT=1;
begin
    param:= ch;

    if(direction=HDA_Output) then param:=param or AC_AMP_SET_OUTPUT else param:=param or AC_AMP_SET_INPUT;
    param :=param or index shl 8;  { // index is bits 8 - 11 for set payload}
    param :=param or val;
    hda_codec_write (nid, 0, AC_VERB_SET_AMP_GAIN_MUTE, param);
end;


{// get the volume or mute status of the requested amplifier}
function hda_get_vol_mute ( nid,  ch,  direction, index:longint):longint;
var val, param:longint;
const	HDA_INPUT=0; HDA_OUTPUT=1;
begin
    if(ch=1)then param:=AC_AMP_GET_RIGHT else param:=AC_AMP_GET_LEFT;
{    param:=param and ch;}
    if(direction=HDA_Output) then param:=param or AC_AMP_GET_OUTPUT else param:=param or AC_AMP_GET_INPUT;
    param :=param or index;   {// index is bits 0 - 3 for get payload}
    val := hda_codec_read (nid, 0, AC_VERB_GET_AMP_GAIN_MUTE, param);
    result:= (val and $ff);  { // bits 8 - 31 are ignored as they should be 0}
end;



{ retrieve connections for the specified node}
{ 0 if none}
{ -1 if more than max_conns}
{ positive on success with array of conn_list filled}
function hda_get_connections (nid:longint;var conn_list:array of WORD;max_conns:longint):longint;

var errors:boolean;
var skip:byte;

var  param:longint;
   shift, num_elements, mask:longint;
var conn_length, conns, i:longint;
var prev_nid:longint;
var val, n:longint;

label endret;
label continueloop;
begin
errors:=false;

    { get Connection List Length for nid}
    param := hda_param_read (nid, AC_PAR_CONNLIST_LEN);

    { if long form connections list - each entry has 16 bits (2 entries)}
    if (param and BIT7)=BIT7 then begin
        shift := 16;
        num_elements := 2;

        { mask is 0x7f for short and 0x7fff for long entries}
        { the highest bit (7 or 15) specifies whether connection is an independent NID or a range of NIDs}
        mask := $7fff;

    { if short form connections list - each entry has 8 bits (4 entries)}
    end else begin
        shift := 8;
        num_elements := 4;

        { mask is 0x7f for short and 0x7fff for long entries}
        { the highest bit (7 or 15) specifies whether connection is an independent NID or a range of NIDs}
        mask := $7f;
    end;



    { Connection List Length bits 0 - 6 (exit if no connections)}
    conn_length := param and $7f;
if (conn_length=0) then begin result:=0;end else begin


    { if only 1 connection - get it and exit}
if (conn_length = 1) then begin
        param := hda_codec_read (nid, 0, AC_VERB_GET_CONNECT_LIST, 0);
        conn_list[0] := param and mask;
        result:= 1;{goto endret;}
end else begin

    { if more connections}
    conns := 0;
    prev_nid := 0;



    i:=0;
    while (i<conn_length)and not(errors) do begin
    {for (i = 0; i < conn_length; i++) begin

        { get 4 entries for short from and 2 entries for long form connections list}
        if (i {%}mod num_elements = 0) then param := hda_codec_read (nid, 0, AC_VERB_GET_CONNECT_LIST, i);

        { current connection}
        val := param and mask;

        { if range of NIDs (highest bit set - 7 or 15 for long entries)}
        if (param and (mask + 1))<>0 then begin
    if (not(prev_nid <> 0) or (prev_nid >= val)) then begin skip:=1;{goto continueloop;}end else begin
    skip:=0;
        { ignore for first entry or if previous NID was equal/higher than current}

           n:=prev_nid+1;
           while (n<=val)and not(errors) do begin{ start at (prev_nid + 1) because prev_nid is already saved as single NID}
                if (conns >= max_conns) then begin errors:=true;{result:= -1;goto endret;}end;
                conns:=conns+1;
                conn_list[conns] := n;
              n:=n+1;
            end;
    end;{continueloop:}
        { if single NID (highest bit clear)}
        end else begin
            if (conns >= max_conns) then begin errors:=true;{result:= -1;goto endret;}end;
            conns:=conns+1;
            conn_list[conns] := val;
        end;

    if(skip=0)then begin
        { save this NID as previous NID in case we have a range of NIDs in next entry}
        prev_nid := val;

        { pass on to next connection entry}
        param :=param shr shift;
    end;
    i:=i+1;
    end;
result:= conns;


end;{conn_length=1}
end;{conn_length=0}

if(1=2)then begin
endret:

end;

if errors then result:=-1;

end;





{// add a new node to our audio structure}
function  hda_add_new_node (var node:hda_node;nid:longint):longint;
var nconns:longint;                  {HDA_NODE[i]}{index nid}
begin
    node.nid := nid;
    nconns := hda_get_connections (nid, node.conn_list, HDA_MAX_CONNECTIONS);
{showmessage(inttostr(nconns));}
    {// when we have connections}
    if (nconns >= 0) then begin
        node.nconns := nconns;
        {// get Audio Widget Capabilities}
        node.wid_caps := hda_param_read (nid, AC_PAR_AUDIO_WIDGET_CAP);

        {// bits 20 - 23 define the node type}
        {// AC_WID_AUD_OUT, AC_WID_AUD_IN, AC_WID_AUD_MIX, AC_WID_AUD_SEL,  AC_WID_PIN,  AC_WID_POWER, AC_WID_VOL_KNB,
           AC_WID_BEEP, AC_WID_VENDOR}
        node.dtype := longint(longint(node.wid_caps and (BIT20 or BIT21 or BIT22 or BIT23)) shr 20);
        strlog('node $'+inttohex(nid,2)+' type=$'+inttohex(node.dtype,1));
        {// if pin complex}
        if (node.dtype = AC_WID_PIN)then begin
        {// get Pin Capabilities (output capable, input capable, vref, etc)}
            node.pin_caps := hda_param_read (node.nid, AC_PAR_PIN_CAP);

            {// get Pin Widget Control status (out enable, in enable, vref enable, etc)}
            node.pin_ctl := hda_codec_read (node.nid, 0, AC_VERB_GET_PIN_WIDGET_CONTROL, 0);

            {// get default config}
            node.def_config := hda_codec_read (node.nid, 0, AC_VERB_GET_CONFIG_DEFAULT, 0);
        end;

        {// if out amplifier present}
        if (node.wid_caps and AC_WCAP_OUT_AMP)=AC_WCAP_OUT_AMP then begin
            {// If Amp Param Override is a 1, the widget contains its own amplifier parameters. If this bit is a 0,
            // then the Audio Function node must contain default amplifier parameters, and they should be used
            // to define all amplifier parameters (both input and output) in this widget.

            {// The Amplifier Properties parameters return the parameters for the input or the output amplifier
            // on a node. In the case of a Pin Widget, the terms input and output are relative to the codec itself;
            // for all other widgets, these terms are relative to the node. The amplifier capabilities are indicated by
            // the step size of the amplifier, the number of steps, the offset of the range with respect to 0 dB, and
            // whether the amplifier supports mute.}
            if (node.wid_caps and AC_WCAP_AMP_OVRD)=AC_WCAP_AMP_OVRD then begin
            node.amp_out_caps := hda_param_read (node.nid, AC_PAR_AMP_OUT_CAP);
            end;
            if ((node.amp_out_caps)=0) then begin node.amp_out_caps := audio_pci.def_amp_out_caps;end;
        end;

        {// if in amplifier present}
        if (node.wid_caps and AC_WCAP_IN_AMP)=AC_WCAP_IN_AMP then begin
           { // If Amp Param Override is a 1, the widget contains its own amplifier parameters. If this bit is a 0,
           { // then the Audio Function node must contain default amplifier parameters, and they should be used
           { // to define all amplifier parameters (both input and output) in this widget.}

           { // The Amplifier Properties parameters return the parameters for the input or the output amplifier
           { // on a node. In the case of a Pin Widget, the terms input and output are relative to the codec itself;
           { // for all other widgets, these terms are relative to the node. The amplifier capabilities are indicated by
           { // the step size of the amplifier, the number of steps, the offset of the range with respect to 0 dB, and
           {// whether the amplifier supports mute.}
            if (node.wid_caps and AC_WCAP_AMP_OVRD)=AC_WCAP_AMP_OVRD then begin
            node.amp_in_caps := hda_param_read (node.nid, AC_PAR_AMP_IN_CAP);
            end;
            if ((node.amp_in_caps)=0) then begin
            node.amp_in_caps := audio_pci.def_amp_in_caps;
            end;
        end;

        {// read supported PCM formats - return 32bit dword with format data as in HDA specification}
        {// for AFG, AI converter and AO converter group}
        node.supported_formats := hda_param_read (node.nid, AC_PAR_PCM);
    end;

    result:=nconns;
end;


{// get the node data pointed by NID from our device structure}
function hda_get_node(nid:longint):longint;
var node:array[0..128] of hda_node;
var i:longint;
var break:boolean;
begin
{result:= nil;}
{node:=audio_pci.afg_nodes;}
result:=0;
i:=0;
break:=false;
while (I<audio_pci.afg_num_nodes)and not(break) do begin

{ for i := 0 to audio_pci.afg_num_nodes-1 do begin}
 if (audio_pci.afg_nodes[i].nid = nid)then begin
 result:= audio_pci.afg_nodes[i].nid;
 break:=true;
 end;

{ end;}

i:=i+1;
end;
end;

{// Parse output path until we reach an audio output widget.}
{// returns 0 if not found, 1 if found}
function hda_parse_output_path (var node:hda_node;dac_idx:longint):longint;
var i,n:longint;
var break:boolean;
var  child:^hda_node;
var error:byte;
begin
error:=0;
result:=0;
    {// exit if node already checked}
if (node.checked=0)then begin result:=0;end else begin

    {// mark this node as checked}
    node.checked := 1;
   {// if we have an Audio Out widget type}
    if (node.dtype = AC_WID_AUD_OUT) then begin
       {// skip DIGITAL OUT node}
    if (node.wid_caps and AC_WCAP_DIGITAL)=AC_WCAP_DIGITAL then  begin result:= 0;error:=1;end else begin
       {// DAC node is assigned already, just unmute and connect}
{        if (audio_pci.dac_node[dac_idx])then return node == audio_pci.dac_node[dac_idx];
       {// assign DAC node}
        audio_pci.dac_node[dac_idx] := node;
       {// if out amplifier present save node to pcm_vols}
if(
(node.wid_caps and AC_WCAP_OUT_AMP)=AC_WCAP_OUT_AMP) and
(audio_pci.pcm_num_vols < HDA_MAX_PCM_VOLS)
 then begin
            audio_pci.pcm_vols[audio_pci.pcm_num_vols].node := node;
            audio_pci.pcm_vols[audio_pci.pcm_num_vols].index := 0;
            audio_pci.pcm_num_vols:=audio_pci.pcm_num_vols+1;
        end;{node.wid_caps and AC_WCAP_DIGITAL}
        {// found}
        result:= 1;
       end;
    end;

if(error=0)then begin

   {// also parse child nodes for the main node using the same function}
 break:=false;
 i:=0;
 while (i<node.nconns)and(break=false) do begin
 {    for (i = 0; i < node.nconns; i++) begin}
{         child := hda_get_node(node.conn_list[i]);}
         if(nil=child)then continue;{skip if nil}
        {// child node found, parse it's output}
{         if (hda_parse_output_path(child, dac_idx)) begin
        {// found - select the path, unmute both input and output}
 {            if (node.nconns > 1)then hda_select_input_connection (node, i);
             hda_unmute_input (node, i);
             hda_unmute_output (node);
             if (audio_pci.dac_node[dac_idx] and (audio_pci.pcm_num_vols < HDA_MAX_PCM_VOLS)
             and !(audio_pci.dac_node[dac_idx].wid_caps and AC_WCAP_OUT_AMP))then begin
                 if((node.wid_caps and AC_WCAP_IN_AMP) or (node.wid_caps and AC_WCAP_OUT_AMP)) begin
                     int n = audio_pci.pcm_num_vols;
                     audio_pci.pcm_vols[n].node := node;
                     audio_pci.pcm_vols[n].index := i;
                     audio_pci.pcm_num_vols++;
                 end;
             end;
             return 1;
         end;}
      i:=i+1;
     end;
     result:= 0;

end;{error=0}

end;{node.checked=0}
end;



function getHDACODECvendor:longint;
var tmp32:longint;
begin
tmp32:=hda_param_read (AC_NODE_ROOT, AC_PAR_VENDOR_ID);
HDACodecVendor:=hiword(tmp32);
HDACodecDevice:=loword(tmp32);
end;




function hda_mixer_init:longint;
var i:word;
var nid:UNSIGNEDSHORT;
var hda_codec_vender_id:longint;
label error_exit_mixinit;
begin
result:=0;
{// get vender and device IDs then save it to our audio_pci structure}
hda_codec_vender_id := hda_param_read (AC_NODE_ROOT, AC_PAR_VENDOR_ID);

if(hda_codec_vender_id=0)then  hda_codec_vender_id := hda_param_read (AC_NODE_ROOT, AC_PAR_VENDOR_ID);
audio_pci.codec_id1:=WORD((hda_codec_vender_id shr 16));{ HDA codec vender ID}
audio_pci.codec_id2:=WORD((hda_codec_vender_id and $ffff));{  HDA codec device ID}




 { // search for audio function group root node, exit if not found}
    hda_search_audio_node;
if (audio_pci.afg_root_nodenum=0) then begin {goto error_exit_mixinit;} end else begin

{// check number of nodes for AFG, nid is the starting AFG node - can not be 0
 // hda_get_sub_nodes returns -1 if more then max connections defined in header file are present}
audio_pci.afg_num_nodes := hda_get_sub_nodes (audio_pci.afg_root_nodenum, nid);
if ((audio_pci.afg_num_nodes <= 0) or (nid=0)) then begin {goto error_exit_mixinit;} end else begin


{    // read default capabilities from main audio function group node }
audio_pci.def_amp_out_caps := hda_param_read (audio_pci.afg_root_nodenum, AC_PAR_AMP_OUT_CAP);
audio_pci.def_amp_in_caps := hda_param_read (audio_pci.afg_root_nodenum, AC_PAR_AMP_IN_CAP);
                               {audio_pci.afg_root_nodenum is 1 in my case}




    {// allocate memory for all AFG nodes}
{    if not(audio_pci.afg_nodes=0) then locked_free(audio_pci.afg_nodes);}
{    audio_pci.afg_nodes = (struct hda_node *) locked_malloc (audio_pci.afg_num_nodes * sizeof(struct hda_node));}
{    if (audio_pci.afg_nodes=0) goto error_exit_mixinit;}




{showmessage('get node data for all '+inttostr(audio_pci.afg_num_nodes));}
{// add all AFG nodes to our structure with hda_add_new_node function}
i:=0;
 while I<audio_pci.afg_num_nodes{-1} do begin
 {for i := 0 to (audio_pci.afg_num_nodes-1) do begin}
 hda_add_new_node (audio_pci.afg_nodes[i], nid);
 nid:= nid+1;
 inc(i);
 end;



{// determine output path}
{  if (0=hda_parse_output) goto error_exit_mixinit;}


{// determine the supported audio format from dac node - first output node}

{    if (audio_pci.dac_node[0]>0)then begin
        audio_pci.supported_formats := audio_pci.dac_node[0].supported_formats;
        if (audio_pci.supported_formats=0) then audio_pci.supported_formats := 0xffffffff; {// then enter fixed max freq}
       {// fixed - we only support 48khz with 16bit PCM stereo max anyway}
{       audio_pci.supported_max_freq := 48000;}

result:=1;
end;{(audio_pci.afg_num_nodes <= 0) or (nid=0)}
end;{audio_pci.afg_root_nodenum=0}
if(1=2)then begin
error_exit_mixinit:result:=0;
end;

end;






function hda_calc_stream_format(mixrate:longint):longint;
     var value :longint;
begin
value:= 0;
{    // we only support 7 rates for HDA - 48000Hz included}
    if (mixrate < 11025) then value := BIT8 + BIT10                {// 8000 (48000 / 6)}
    else if (mixrate < 16000) then value := BIT14 + BIT8 + BIT9    {// 11025 (44000 / 4)}
    else if (mixrate < 22050) then value := BIT9                   {// 16000 (48000 / 3)}
    else if (mixrate < 32000) then value := BIT14 + BIT8           {// 22050 (44000 / 2)}
    else if (mixrate < 44100) then value := BIT11 + BIT9           {// 32000 (96000 / 3)}
    else if (mixrate < 48000) then value := BIT14                  {// 44100}
    else value := 0;                                           {// 48000}

{    // 8bit not supported - we force 16bits PCM anyway}

if(audio_pci.dacout_num_bits=16)then begin
{        case 16:}
            value :=value or BIT4;
end else
if(audio_pci.dacout_num_bits=20)then begin
{        case 20:}
            value :=value or BIT5;
end else
if(audio_pci.dacout_num_bits=24)then begin
{        case 24:}
            value :=value or (BIT4 + BIT5);
end else
if(audio_pci.dacout_num_bits=32)then begin
{        case 32:}
            value :=value or BIT6;
end else begin
{        default:}
            value :=value or BIT4;
end;


    value :=value+ (audio_pci.dacout_num_channels - 1);

    result:= value;
end;

{// start the DMA engine with currently allocated buffers (only for playback) - obsolete - start is done in ASM module}
function hda_codec_start:byte;
begin
     {// start SD0 output DMA engine}
     hda_OUTB (HDA_SDO0CTL, hda_INB (HDA_SDO0CTL) or SD_CTL_DMA_START);
end;


procedure nvidiapatch;
var b:byte;
begin
  readPCIRegisterByte(NVIDIA_HDA_TRANSREG_ADDR,pciBUS,pciFunc,b);
  writePCIRegisterByte(NVIDIA_HDA_TRANSREG_ADDR,pciBUS,pciFunc,(b and $F0) or NVIDIA_HDA_ENABLE_COHBITS);
end;

procedure atihdapatch;
var b:byte;
begin
  readPCIRegisterByte(ATI_SB450_HDAUDIO_MISC_CNTR2_ADDR,pciBUS,pciFunc,b);
  writePCIRegisterByte(ATI_SB450_HDAUDIO_MISC_CNTR2_ADDR,pciBUS,pciFunc,(b and $F8) or ATI_SB450_HDAUDIO_ENABLE_SNOOP);
end;


function HDA_init(busnu,funnu:word;name:longint):boolean;
var vi,di,w:word;
var b,x:byte;
begin
vi:=loword(name);
di:=hiword(name);
HDA_PCIbaseoffset:=0;


if(vi=AMD1_VID)then begin
result:=true;
end else
if(vi=ATI_VID)then begin
   if(di=ATI_SB450_HDA_DID)then begin atihdapatch;end;
   if(di=ATI_SB600_HDA_DID)then begin atihdapatch;end;
result:=true;
end else
if(vi=NVIDIA_VID)then begin
result:=true;
   if(di=NFORCE_HDA_MCP51_DID)then begin nvidiapatch;end;
   if(di=NFORCE_HDA_MCP55_DID)then begin nvidiapatch;end;
end else
if(vi=Intel_VID)then begin
   if(di=$1E20)then begin{PCH?}
     readPCIRegisterword(INTEL_SCH_HDA_DEVC,pciBUS,pciFunc,w);
     if ((w and INTEL_SCH_HDA_DEVC_NOSNOOP)=INTEL_SCH_HDA_DEVC_NOSNOOP) then begin
      writepciregisterWord(INTEL_SCH_HDA_DEVC,pciBUS,pciFunc, word(w and word(not(INTEL_SCH_HDA_DEVC_NOSNOOP))));
     end;
   end;
result:=true;
end else
if(vi=SIS_VID)then begin
result:=true;
end else
if(vi=ULI_VID)then begin
readPCIRegisterword($40,pciBUS,pciFunc,w);
writepciregisterWord($40,pciBUS,pciFunc, w or $10);
writepciregisterWord(PCI_MEM_BASE_ADDRESS_1,pciBUS,pciFunc, 0);
result:=true;
end else
if(vi=RDC_VID)then begin
result:=true;
end else
if(vi=Teradici_VID)then begin
result:=true;
end else
if(vi=VIA_VID)then begin
result:=true;
end else
begin

end;


 {for ICH6?}
 if not(VI= ATI_VID) then begin
  readPCIRegisterbyte($44,BUSnu,Funnu,b);
 writePCIRegisterbyte($44,BUSnu,Funnu,b and $F8);
 end;



end;

function Specify_PCI_HDA_card:boolean;
var value:longint;
var str:string;
begin
result:=false;
si:=tinifile.create('HDAcfg.ini');
str:=si.readstring('HDA','SEARCH','TRUE'); 

if(lowercase(str)='false')then begin
  value:=strtoint(si.readstring('HDA','PCI_BUS','$1FF'));
    if(value<$FF)then begin pcibus:=(value);end;

  value:=si.readinteger('HDA','PCI_FUNCTION',$1FF);
    if(value<$FF)then begin pcifunc:=(value and 3);end;

  value:=si.readinteger('HDA','PCI_DEVICE',$1FF);
    if(value<$FF)then begin pcifunc:=pcifunc or (value shl 3);end;

      readPCIRegisterDWord(0,PCIbus,PCIfunc,value);
      pcivend:=loword(value);
      pcidid:=hiword(value);

      HDA_init(PCIbus,PCIfunc,value);
  result:=true;
end;

si.free;
end;

function Scan_PCI_HDA_cards:boolean;
var w:word;
var I:word;K:word;
const maxbus=$FF;
const maxfun=$FF;
var goal:longint;
var found,name:longint;
var regnu,funnu,busnu:byte;
var foundone:boolean;
begin
foundone:=false;
goal:=$0403;
regnu:=10;busnu:=0;funnu:=0;
{0-31 pci devices per bus}
{0-7 functions per device}
{}
result:=false;
si:=tinifile.create('HDAcfg.ini');
i:=0;
while I<maxbus do begin
k:=0;
 while k<maxfun do begin
  BusNu:=I;FunNu:=k;  w:=$FFFF;
   if( readPCIRegisterWord(regnu,BusNu,FunNu,w) )then begin
    if not(w=$FFFF) and not(w=0)then begin
     if(w=goal)then begin
      found:=(busnu shl 8)+funnu;
      readPCIRegisterDWord(0,BusNu,FunNu,name);
      if not(foundone) then begin
       foundone:=true;
       pcibus:=busnu;
       pcifunc:=funnu;
       pcivend:=loword(name);
       pcidid:=hiword(name);
       HDA_init(busnu,funnu,name);
      end;
      si.writestring('ALLHDA','$'+inttohex(found,4),'$'+INTTOHEX(name,8));
      result:=true;
      {k:=256;i:=256;}
     end;
    end;
   end;
  k:=k+1;
 end;
i:=i+1;
end;

si.free;
end;


{}

function EnablePCIHDAmem:boolean;
var x:word;
var w:word;
var l:longint;
begin
result:=false;
x:=4;{Command Register=4}{enable PCI HDA}
readPCIRegisterWord(x,pciBUS,pciFunc,w);
writePCIRegisterWord(x,pciBUS,pciFunc,w or BIT1 or BIT2{106});
{Get the HDA PCI memory location}
readPCIRegisterword($10,pciBUS,pciFunc,w);
cardmemregistersLO:=(w-HDA_PCIbaseoffset) and $FFF8;
readPCIRegisterword($12,pciBUS,pciFunc,w);
cardmemregistersHI:=w;
result:=true;
end;

function HDAsetFormat(format:longint):byte;
var x:longint;
var B:longint;
const timerout=300;
begin
if(loaded=true)then begin


{Set Output converter FORMAT 44.1khz}
hda_codec_write(OCnvNUM, 0,AC_VERB_SET_STREAM_FORMAT,format);
{Set CODEC stream channel to 1}
hda_codec_write(OCnvNUM,0,AC_VERB_SET_CHANNEL_STREAMID,(convID shl 4)or convchan {BIT4});


{clear the run bit }
hda_OUTB (HDA_SDO0CTL+stroffset, hda_INB (HDA_SDO0CTL+stroffset) and not(SD_CTL_DMA_START));
tgdelay(1);
x:=0;
while x<300 do begin
if not((hda_INB (HDA_SDO0CTL+stroffset) and SD_CTL_DMA_START)=SD_CTL_DMA_START) then begin x:=x+1000;end;
tgdelay(2);{make shure that the stream has stopped}
x:=x+1;
end;

{showmessage('ready?');}
{Set Stream Format 44.1khz}
hda_OUTW (HDA_SDO0FORMAT+stroffset, format);{wstr(mpch)^.test[($92+($20*4)) div 2]:=$11;}
{showmessage('ok?');}

{
B:=(hda_INB(HDA_SDo0STS));
 if (
 (B and(SD_INT_DESC_ERR or SD_INT_FIFO_ERR))=(SD_INT_DESC_ERR or SD_INT_FIFO_ERR)
 )then begin
  hda_OUTB (HDA_SDo0STS,(B or SD_INT_DESC_ERR or SD_INT_FIFO_ERR));
 end;
 }

hda_OUTB (HDA_SDO0CTL+stroffset, hda_INB (HDA_SDO0CTL+stroffset) or SD_CTL_DMA_START);
end;
end;

function HDAloadcommands(url:string):boolean;
var L:longint;
var oldtime,newtime:longint;
var x:word;
var s:string;
var ICommands:tstringlist;
var valu:longint;
begin
result:=false;


if(fileexists(url))then begin
ICommands:=tstringlist.create;
ICommands.loadfromfile(url);
getlst:=tstringlist.create;

x:=0;
while(ICommands.count>0)and(x<255)do begin

 if(ICommands[0][1]='$')then begin
  s:=ICommands[0];
  s[0]:=char(9);
  L:=strtoint(s);

  oldtime:=gettickcount;
  valu:=HDA_sendgetL(L);
  newtime:=gettickcount;

  getlst.add(
  'sent $'+inttohex(L,8)+
  '; got $'+inttohex(valu,8)+
  ' ticks='+inttohex(newtime-oldtime,8)+
  ' '+infstr
  );


 end;

result:=true;
ICommands.delete(0);
x:=x+1;
end;
ICommands.free;
getlst.savetofile(clinurl);
getlst.free;
end;

end;

function HDAenablecircularbuffer(strt:boolean;volume:longint):byte;
var x,y:longint;
const m=2;
var timeout:longint;
var val:byte;
begin

{ //  stop DMA engine if playing and disable interrupts (on Completion, FIFO Err Int, Descriptor Err Int) - RUN bit set to 0}
 hda_OUTB(HDA_SDO0CTL, hda_INB (HDA_SDO0CTL) and byte(not(SD_CTL_DMA_START or SD_INT_MASK)));
 tgdelay(1);

{ // Software must read a 0 from the DMA run bit before modifying related control registers or restarting the DMA engine}
 timeout := 300;
 while (timeout>0) do begin
         if ((hda_INB (HDA_SDO0CTL) and SD_CTL_DMA_START))=0 then timeout:=0;
         tgdelay (2);
         timeout:=timeout-1;
 end;

{  // reset the HDA stream 0}
 hda_OUTB(HDA_SDO0CTL, hda_INB (HDA_SDO0CTL) or SD_CTL_STREAM_RESET);
 tgdelay(1);

 timeout := 300;
 val:=hda_INB (HDA_SDO0CTL);
 while (timeout>0) and not((val and SD_CTL_STREAM_RESET)=SD_CTL_STREAM_RESET) do begin
   val:=hda_INB (HDA_SDO0CTL);
   tgdelay (2);
   timeout:=timeout-1;
 end;
 val :=val and byte(not(SD_CTL_STREAM_RESET));
 hda_OUTB (HDA_SDO0CTL, val);
 delay1 (2);

 {// wait for out of reset confirmation from hardware}
 val := hda_INB (HDA_SDO0CTL);
 timeout := 300;
 while (((val and SD_CTL_STREAM_RESET)=SD_CTL_STREAM_RESET) and (timeout>0)) do begin
 val := hda_INB (HDA_SDO0CTL);
 tgdelay (2);
 timeout:=timeout-1;
 end;

 {?}


{Load custom HDA commands from hdaicout.hda}
if(strt)then begin


if not(HDAloadcommands(clouturl))then begin
{if (HDA_CORBout256(clouturl)=1)then begin}

{ for x:=1 to $F do begin}
x:=1;
 hda_codec_write(x,0,AC_VERB_SET_POWER_STATE,0);
{ end;}

{If not HDAicout.hda then try this:}
 x:=12;
 while x<$1C do begin
 {for x:=$14 to $1B do begin}
 {Enable the AMP for this Pin}
 hda_codec_write(x, 0,AC_VERB_SET_PIN_WIDGET_CONTROL,(AC_PINCTL_OUT_EN or AC_PINCTL_HP_EN));
 tgdelay (2);
 {unmute Pins}
 hda_Set_vol_mute(x,AC_AMP_SET_LEFT or AC_AMP_SET_RIGHT,1,0,0);
 hda_Set_vol_mute(x,AC_AMP_SET_LEFT or AC_AMP_SET_RIGHT,1,0,0);
{ hda_Set_vol_mute(x,AC_AMP_SET_LEFT or AC_AMP_SET_RIGHT,1,0,hiword(myvol)shr 9);}
 delay1(1);
 inc(x);
 end;




 {Enable the AMP for this Pin}
 {hda_codec_write($1B, 0,AC_VERB_SET_PIN_WIDGET_CONTROL,(AC_PINCTL_OUT_EN or AC_PINCTL_HP_EN));
 hda_codec_write($14, 0,AC_VERB_SET_PIN_WIDGET_CONTROL,(AC_PINCTL_OUT_EN or AC_PINCTL_HP_EN));}
 {unmute Pins}
 {hda_Set_vol_mute($1B,AC_AMP_SET_LEFT or AC_AMP_SET_RIGHT,1,0,0);
 hda_Set_vol_mute($14,AC_AMP_SET_LEFT or AC_AMP_SET_RIGHT,1,0,0);}
 {Set Output converter FORMAT 44.1khz}
 {hda_codec_write(2, 0,AC_VERB_SET_STREAM_FORMAT,format);}
 setkhz:=44100;
 {Set CODEC stream channel to 1}
 {hda_codec_write(2,0,AC_VERB_SET_CHANNEL_STREAMID,BIT4);}
 {Stream  7:4 =$00  so bit4=1}

 {shall we try converter number OCnvNUM?}
 hda_codec_write(OCnvNUM,0,AC_VERB_SET_STREAM_FORMAT,format44);
 tgdelay(150);
 hda_codec_write(OCnvNUM,0,AC_VERB_SET_CHANNEL_STREAMID,(convID shl 4));

end;{1=2}
end;{strt}
{clear the run bit}
hda_OUTB (HDA_SDO0CTL+stroffset, hda_INB (HDA_SDO0CTL+stroffset) and not(SD_CTL_DMA_START));

x:=0;
while x<300 do begin
if not((hda_INB (HDA_SDO0CTL+stroffset) and SD_CTL_DMA_START)=SD_CTL_DMA_START) then begin x:=x+1000;end;
tgdelay(5);{make shure that the stream has stopped}
x:=x+1;
end;
{showmessage('ready?');}
{delay1(10);}

{GIve the stream a number}
hda_OUTL (HDA_SDO0CTL+stroffset, (hda_INL (HDA_SDO0CTL+stroffset) or  (strID shl 20) {100000}));
tgdelay(1);
hda_OUTL(HDA_SDO0CBL+stroffset,bsize*2 );{Set Cyclic Buffer Length}
tgdelay(1);
{program the stream LVI (last valid index)  of the BDL}
hda_OUTL(HDA_SDO0LVI+stroffset,$01);{SD0 output Last Valid Index}
tgdelay(1);

{showmessage(inttohex(hda_INL(HDA_SDO0CBL),8));}
hda_OUTW(HDA_SDO0FORMAT+stroffset,format44);


{wstr(mpch)^.test[($92+($20*4)) div 2]:=format{ and BIT8};{div by}

x:=0;
{fillchar(corbbuffer^,$FFFF,'k');}
{wav.seek(0,48);}
{wav.read(MyRMPM^,$10000);}
{HugeInc(pointer(corbbuffer),$10000);}
{wav.read(corbbuffer^.entry, m*($10000));}
{HugeDec(pointer(corbbuffer),$10000);}

fillchar(PCMbuffer^,$FFFF,'Z');

{HugeInc(pointer(corbbuffer),$10000);
wav.read(corbbuffer^.entry,$10000);
HugeDec(pointer(corbbuffer),$10000);}


{ set BDL and clear it}
x:=0;
y:=0;
while x<127 do begin
abuffer^.BDL.entry[y].ADDRHi32:=pointer(0);
abuffer^.BDL.entry[y].ADDRLo32:=pointer(MyPCI);{over 1m too much?}
abuffer^.BDL.entry[y].leng:=bsize;
abuffer^.BDL.entry[y].IOC:=0;
y:=y+1;
abuffer^.BDL.entry[y].ADDRHi32:=pointer(0);
abuffer^.BDL.entry[y].ADDRLo32:=pointer(MyPCI+bsize);{over 1m too much?}
abuffer^.BDL.entry[y].leng:=bsize;
abuffer^.BDL.entry[y].IOC:=0;
y:=y+1;
x:=x+1;
end;


{program the BDL address (lower 32bits and upper 32bits)}
tgdelay(1);{Buffer Descriptor List Address}
hda_OUTL(HDA_SDO0BDLPL+stroffset,aPCI{BDL});{SD0 outpuy BDL - lower}
tgdelay(1);{showmessage('BDL set?');}
hda_OUTL(HDA_SDO0BDLPU+stroffset,0);{SD0 output BDL - upper}
tgdelay(1);




{Set Stream Format 44.1khz}
hda_OUTW (HDA_SDO0FORMAT+stroffset, format44);{wstr(mpch)^.test[($92+($20*4)) div 2]:=$11;}
{showmessage('ok?');}
{delay1(10);}
hda_OUTB (HDA_SDO0CTL+stroffset, hda_INB (HDA_SDO0CTL+stroffset) or SD_CTL_DMA_START);

delay1(1);


end;




function PCMmemstart(CIhi,CIlo:word):byte;
const sellimit=4; var x:longint;
begin
 myphysical1:=ptr(CIhi,CIlo);      {Command Ring Buffer (CORBL)}
mylength:=pointer((longint(((sellimit+1))*$10000)));
mylinear:=MapPhysicalToLinear(MyPhysical1, myLength);
PCMbuffer:=lstr(CreateHugePointer (pointer(myLinear), pointer(myLength)));
PCMbuffer^[0]:=3;{mem test...}



end;



function rirbmemstart(Ihi,Ilo:word):byte;
const sellimit=1;
var x:word;
begin
aPhysical1:=ptr(Ihi,Ilo);
alength:=pointer((longint(((sellimit+1))*$10000)));
alinear:=MapPhysicalToLinear(aPhysical1, aLength);
abuffer:=amem(CreateHugePointer (pointer(aLinear), pointer(aLength)));
abuffer^.rirb.entry[0].flags:=0;{0}
abuffer^.BDL.entry[0].ioc:=0;{+$8000}
end;



function cardmemstart(CardsPCIhi,CardsPCIlo:word):byte;
const sellimit=0;
begin
CardsPhysical:=ptr(CardsPCIhi,CardsPCIlo);
length:=pointer((longint(((sellimit+1))*$10000)));
linear:=MapPhysicalToLinear(CardsPhysical, Length);
mpch:=Wstr(CreateHugePointer (pointer(Linear), pointer(Length)));
mpch^.test[0]:=3;
end;


function memstart:byte;
begin
if not(mpch=nil)then   FreeSelector (HIWORD(longint(mpch)));{one for the card}
if not(PCMbuffer=nil)then FreeSelector (HIWORD(longint(PCMbuffer)));{one for the CORB}
if not(abuffer=nil)then  FreeSelector (HIWORD(longint(abuffer)));{one for the BDL}
PCMmemstart(myPCIHI,myPCILO);
rirbmemstart(aPCIHI,aPCILO);{RIRB and (aPCILO+$8000=BDL}
cardmemstart(cardmemregistersHI,cardmemregistersLO);
result:=0;
end;


function memstop:byte; begin
if not(mpch=nil)then FreeSelector (HIWORD(longint(mpch)));
if not(PCMbuffer=nil)then FreeSelector (HIWORD(longint(PCMbuffer)));
if not(abuffer=nil)then FreeSelector (HIWORD(longint(abuffer)));
result:=0;
end;





function hdaconfig:byte; var w,x,y,z:longint;
const m=2;
{const bsize=$7000;{7000 it likes}
{const format=$4011;}
begin

{lstr(mpc)^.test[HDA_DPLBASE div 4]:=aPCI2+1;{DPL buffer}


{Enable the AMP for this Pin}
hda_codec_write($1B, 0,AC_VERB_SET_PIN_WIDGET_CONTROL,(AC_PINCTL_OUT_EN or AC_PINCTL_HP_EN));
hda_codec_write($14, 0,AC_VERB_SET_PIN_WIDGET_CONTROL,(AC_PINCTL_OUT_EN or AC_PINCTL_HP_EN));
{unmute Pins}
hda_Set_vol_mute($1B,AC_AMP_SET_LEFT or AC_AMP_SET_RIGHT,1,0,0);
hda_Set_vol_mute($14,AC_AMP_SET_LEFT or AC_AMP_SET_RIGHT,1,0,0);
{Set Output converter FORMAT}
hda_codec_write(OCnvNUM, 0,AC_VERB_SET_STREAM_FORMAT,format44);
{Set CODEC stream channel to 1}
hda_codec_write(OCnvNUM,0,AC_VERB_SET_CHANNEL_STREAMID,convID shl 4);
{clear the run bit}
hda_OUTB (HDA_SDO0CTL+stroffset, hda_INB (HDA_SDO0CTL+stroffset) and not SD_CTL_DMA_START);

x:=0;
while x<300 do begin
if not((hda_INB (HDA_SDO0CTL+stroffset) and SD_CTL_DMA_START)=SD_CTL_DMA_START) then begin x:=x+1000;end;
delay1(26);{make shure that the stream has stopped}
x:=x+1;
end;
{showmessage('ready?');}
{GIve the stream a number}
hda_OUTL (HDA_SDO0CTL+stroffset, (hda_INL (HDA_SDO0CTL+stroffset) or   $100000));
hda_OUTL(HDA_SDO0BDLPL+stroffset,aPCI{BDL});{SD0 outpuy BDL - lower}
hda_OUTL(HDA_SDO0BDLPU+stroffset,0);{SD0 output BDL - upper}
{showmessage('BDL set?');}
hda_OUTL(HDA_SDO0LVI+stroffset,$01);{Last valid index}
hda_OUTL(HDA_SDO0CBL+stroffset,bsize*2);{buffer length}



wstr(mpch)^.test[($92+($20*4)) div 2]:=format44{ and BIT8};{div by}
x:=0;
{fillchar(corbbuffer^,$FFFF,'k');}
{wav.read(MyRMPM^,$10000);}
{wav.read(corbbuffer^.entry, (bsize));
HugeInc(pointer(corbbuffer),bsize);
wav.read(corbbuffer^.entry, (bsize));
HugeDec(pointer(corbbuffer),bsize);  }
fillchar(PCMbuffer^,$FFFF,'z');

{HugeInc(pointer(corbbuffer),$10000);
wav.read(corbbuffer^.entry,$10000);
HugeDec(pointer(corbbuffer),$10000);}
{ set BDL and clear it}
x:=0;
y:=0;
while x<15 do begin
abuffer^.BDL.entry[y].ADDRHi32:=pointer(0);
abuffer^.BDL.entry[y].ADDRLo32:=pointer(MyPCI);{over 1m too much?}
abuffer^.BDL.entry[y].leng:=bsize;
abuffer^.BDL.entry[y].IOC:=0;
y:=y+1;
abuffer^.BDL.entry[y].ADDRHi32:=pointer(0);
abuffer^.BDL.entry[y].ADDRLo32:=pointer(MyPCI+bsize);{over 1m too much?}
abuffer^.BDL.entry[y].leng:=bsize;
abuffer^.BDL.entry[y].IOC:=0;
y:=y+1;
x:=x+1;
end;

{Set Stream Format}
hda_OUTW (HDA_SDO0FORMAT+stroffset, format44);{wstr(mpc)^.test[($92+($20*4)) div 2]:=$11;}
{showmessage('ok?');}
hda_OUTB (HDA_SDO0CTL+stroffset, hda_INB (HDA_SDO0CTL+stroffset) or SD_CTL_DMA_START);




end;


function myHDAreset:byte;
var i:word;
var L:longint;
begin
{    // disable global controller interrupts CIE and GIE if enabled}
    hda_OUTL (HDA_INTCTL,longint( hda_INL (HDA_INTCTL) and  $3FFFFFFF{(not(HDA_INT_CTRL_EN or HDA_INT_GLOBAL_EN))}));

{    // ---------------------
    // reset controller
    // ---------------------
 }
    L := hda_INL (HDA_GCTL); {AZBAR + HDA_GCTL}
    L :=L and (not(CRST));
    hda_OUTL(HDA_GCTL, L); { reset bit0 of GCTL}
     i := 50;
 while (hda_INL (HDA_GCTL)=1)and(I>1) do begin
  i:=i-1;
  delay1(1);                        {1 ms delay?}
  end;
delay1(10);{ // must read 0 to verify the controller is in reset}

{bring controller out of reset}
    L := hda_INL (HDA_GCTL);    { AZBAR + HDA_GCTL}
    L :=L or CRST;
    hda_OUTL (HDA_GCTL, L);   { set bit0 of GCTL}

i := 50;
 while (hda_INL(HDA_GCTL)<1)and(I>1) do begin
  i:=i-1;
  delay1(1);                        {1 ms delay?}
  end;
{counted down to about 18 for me before turning back to 1}


delay1(10);{must read 1 before accessing controller registers}
end;






Function jhda_reset:boolean;
var flags:longint;
var i:longint;
begin

    {//  stop the codec if currently playing}
    hda_codec_stop;
    {// disable global controller interrupts CIE and GIE if enabled}
{    hda_OUTL (HDA_INTCTL, hda_INL (HDA_INTCTL) and not(HDA_INT_CTRL_EN or HDA_INT_GLOBAL_EN));}
    hda_OUTL (HDA_INTCTL,longint( longint(hda_INL (HDA_INTCTL)) and longint($3FFFFFFF)));
    tgdelay(20);

    {// ---------------------
    {// reset controller
    {// ---------------------}
    flags := hda_INL (HDA_GCTL);                                         {// AZBAR + HDA_GCTL}
{{    flags :=flags and not(CRST);}
    flags :=flags and $FFFFFFFE;{deactivate}
    hda_OUTL (HDA_GCTL, flags);                                         {// reset bit0 of GCTL}


    i := 100;
    while (((hda_INL (HDA_GCTL) and 1)=1) and(i>0)) do begin
     delay1(11);
     dec(i);
    end;
    tgdelay(500);                                                    {// must read 0 to verify the controller is in reset}

    {// bring controller out of reset}
    flags := hda_INL(HDA_GCTL);                                      {// AZBAR + HDA_GCTL}
    flags := flags or CRST;{reactivate}
    hda_OUTL (HDA_GCTL, flags);                                      {// set bit0 of GCTL}

    i := 100;
    while (((hda_INL (HDA_GCTL) and 1)=0) and (i>0)) do begin
    delay1(11);                       {// 1 ms delay}
    dec(i);
    end;
    tgdelay(500);                                  {// must read 1 before accessing controller registers}

    if not( (hda_INL (HDA_GCTL)and 1)=1 ) then begin
    result:= FALSE;                              {// controller not ready - exit with error}
    end else begin
     {// disable unsolicited responses}
     hda_OUTL (HDA_GCTL, (hda_INL (HDA_GCTL) and not(UREN)) );
     delay1(5);
     {// detect codecs}
     if (audio_pci.codec_mask=0)then begin
         audio_pci.codec_mask := hda_INW (HDA_STATESTS);
     end;





     {// ------------------------------------}
     {// hardware init the controller
     {//-------------------------------------
     {// clear interrupt status for stream 0  - set bits in Buffer Completion Interrupt, FIFO Error,Descriptor Error}
     hda_OUTB (HDA_SDO0STS, SD_INT_MASK);
     {// clear STATESTS - Flg bits dat dicate whch SDI signis wcved a state change event. De bts are clrd by wrtn 1s to tm.}
     hda_OUTW (HDA_STATESTS, STATESTS_INT_MASK);
     {// clear RIRB status - Response Interrupt, Response Overrun Interrupt Status - not used in ICHINIT and JUDAS either}
     hda_OUTB (HDA_RIRBSTS, RIRB_INT_MASK);
     {// clear global interrupt status}
{     hda_OUTL (HDA_INTSTS, HDA_INT_CTRL_EN or HDA_INT_ALL_STREAM);}
     hda_OUTL (HDA_INTSTS, longint(longint(HDA_INT_CTRL_EN) or longint($000000FF){HDA_INT_ALL_STREAM}));


     {// reset the position buffer (program the position buffer when starting playback)}
     hda_OUTL (HDA_DPLBASE, 0);
     hda_OUTL (HDA_DPUBASE, 0);
     tgdelay(5);




     {// hardware init mixer for first detected codec (bits 0, 1, 2, etc)}
     i:=0;
     while i<=HDA_MAX_CODECS do begin
     {for  i := 0 to HDA_MAX_CODECS do begin}
         if (audio_pci.codec_mask and (1 shl i))=(1 shl i) then begin
             audio_pci.codec_index := i;
             if (hda_mixer_init>0)then break;
         end;
     inc(i);
     end;


     result:= TRUE;




     end;
end;



function HDA_resetCORBRIRB:integer;
var w:longint;
var i:longint;
begin
corbactive:=true;

hda_OUTL(HDA_CORBLBASE, aPCI+CORBofs); { CORBL}
hda_OUTL(HDA_CORBUBASE, $00000000); { CORBU}
hda_OUTL(HDA_RIRBLBASE, aPCI+RIRBofs); {RIRBL}
hda_OUTL(HDA_RIRBUBASE, $00000000); {RIRBU}


w:=0;
w:=bstr(mpch)^.test[HDA_CORBCTL];
if not(w=0)then bstr(mpch)^.test[HDA_CORBCTL]:=0;
HDA_OUTB(HDA_CORBSIZE,$42);

mpch^.test[HDA_CORBWP div 2]:=0;

w:=HDA_INW(HDA_CORBRP)and HDA_CORBRP_RESET;
HDA_OUTW(HDA_CORBRP,w);
i:=0;
while (i<9)and not((HDA_INW(HDA_CORBRP) and HDA_CORBRP_RESET)=HDA_CORBRP_RESET) do begin
HDA_OUTW(HDA_CORBRP,(w and not(HDA_CORBRP_RESET)));{as soon as it turns on we clear it!}
delay1(2);
{realalarmclock(time+0.000001);}
I:=I+1;
end;
if(i>8)then begin {?} end else begin result:=0;{CORBRP_RESET ok}end;
HDA_OUTW(HDA_CORBRP,0);
HDA_OUTB(HDA_CORBCTL,HDA_CORBCTL_RUN);
HDA_OUTB(HDA_RIRBSIZE,$02);{256 entries}
HDA_OUTW(HDA_RIRBWP, HDA_CORBRP_RESET);
{realalarmclock(time+0.000001);}
HDA_OUTB(HDA_RIRBCTL,HDA_RIRBCTL_RUN);
{realalarmclock(time+0.000001);}
delay1(10);
end;


function HDA_CORBout256(url:string):integer;
var x,y:integer;
var text:string;
var list:tstringlist;
begin
result:=1;
if(fileexists(url))then begin
list:=tstringlist.create;

list.loadfromfile(url);



if(list.count>0)then begin

{Get the CORB and RIRB ready!}
HDA_resetCORBRIRB;

{First erase RIRB data}
HugeInc(pointer(abuffer),RIRBofs);{Slide selector to RIRB list}
fillchar(abuffer^,$800,char($FF));
HugeDec(pointer(abuffer),RIRBofs);{Slide selector back}

{Then load CORB data}
HugeInc(pointer(abuffer),CORBofs);{Slide selector to CORB list}
corbtable(abuffer)^[0]:=$00000000;{ignore item 0}
x:=0;
 while x<256 do begin
  corbtable(abuffer)^[x]:=$F00F0000;
  lst2[x]:=$F00F0000;
  if(list.count>0)then begin
  text:=list[0];
   if(text[1]='$')then begin
   text[0]:=char(9);
   corbtable(abuffer)^[x]:=strtoint(text);
   lst2[x]:=strtoint(text);
   result:=0;
   end;

  list.delete(0);
  end;

 inc(x);
 end;
HugeDec(pointer(abuffer),CORBofs);{Slide selector back}

{Tell HDA to restart CORB}
HDA_OUTW(HDA_RIRBWP,BIT15);{reset rirbwp}
HDA_OUTW(HDA_CORBRP,BIT15);{reset corbrp}
delay1(10);
HDA_OUTW(HDA_RIRBWP,0);{clear reset rirbwp}
HDA_OUTW(HDA_CORBRP,0);{clear reset corbrp}
delay1(10);
HDA_OUTW(HDA_CORBRP,0);{clear reset}
HDA_OUTW(HDA_CORBWP,255);{last place to read}
delay1(10);


{Finally read RIRB data}
HugeInc(pointer(abuffer),RIRBofs);
 list.clear;
 y:=0*1;
 x:=0*2;{ignore item 0}
 while x<511 do begin
  list.add('$'+inttohex(lst2[y],8)+';$'+
    inttohex(lstr(abuffer)^[x+1],8)+
    inttohex(lstr(abuffer)^[x],8)+';$'+
    inttohex(y,2)
    );
  x:=x+2;y:=y+1;
 end;
HugeDec(pointer(abuffer),RIRBofs);

{and now examine CORB again}
HugeInc(pointer(abuffer),CORBofs);
x:=0;
 while x<256 do begin
 list.add(inttohex(corbtable(abuffer)^[x],8)+';'+inttohex(x,2));
 inc(x);
 end;
HugeDec(pointer(abuffer),CORBofs);
end;
if(result=0)then list.savetofile(clinurl);
list.free;
end;

end;





function corbrirbget1(data:longint):longint;
var x:byte;
begin
{First erase RIRB data}
HugeInc(pointer(abuffer),RIRBofs);{Slide selector to RIRB list}
fillchar(abuffer^,$800,char(255));
HugeDec(pointer(abuffer),RIRBofs);{Slide selector back}

{Then load CORB data}
HugeInc(pointer(abuffer),CORBofs);{Slide selector to CORB list}
x:=0;
WHile x<255 do begin
corbtable(abuffer)^[x]:=data;{set item 1}
inc(x);
end;
HugeDec(pointer(abuffer),CORBofs);{Slide selector back}
{Tell HDA to reset CORB}
HDA_OUTW(HDA_RIRBWP,BIT15);{reset rirbwp}
HDA_OUTW(HDA_CORBRP,BIT15);{reset corbrp}
{delay1(2);}
AMD_fixed_delay(100);
HDA_OUTW(HDA_RIRBWP,0);{clear reset rirbwp}
HDA_OUTW(HDA_CORBRP,0);{clear reset corbrp}
{delay1(2);}
AMD_fixed_delay(100);
{HDA_OUTW(HDA_CORBRP,0);{clear reset}
HDA_OUTW(HDA_CORBWP,255);{last place to read}
{delay1(2);}
AMD_fixed_delay(100);
{read RIRB result}
HugeInc(pointer(abuffer),RIRBofs);
result:=lstr(abuffer)^[2];
HugeDec(pointer(abuffer),RIRBofs);

end;




end.
