unit Nobules;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, StdCtrls, Spin, Buttons, Grids,hda,misc, Menus;

type
  TForm1 = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    GroupBox1: TGroupBox;
    Label11: TLabel;
    Button17: TButton;
    Edit3: TEdit;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    Memo5: TMemo;
    GroupBox4: TGroupBox;
    Label12: TLabel;
    Button55: TButton;
    Button5: TButton;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    Button10: TButton;
    Button11: TButton;
    Button12: TButton;
    Button13: TButton;
    Button1: TButton;
    Edit4: TEdit;
    Edit6: TEdit;
    Label1: TLabel;
    Label6: TLabel;
    Button14: TButton;
    ComboBox3: TComboBox;
    Memo6: TMemo;
    SpeedButton1: TSpeedButton;
    ListBox1: TListBox;
    Button2: TButton;
    Edit1: TEdit;
    SpinEdit1: TSpinEdit;
    Button3: TButton;
    Label2: TLabel;
    Label3: TLabel;
    Button4: TButton;
    Button15: TButton;
    Button16: TButton;
    Button18: TButton;
    Edit2: TEdit;
    procedure Button55Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
    procedure Button11Click(Sender: TObject);
    procedure Button12Click(Sender: TObject);
    procedure Button13Click(Sender: TObject);
    procedure Button17Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure Button14Click(Sender: TObject);
    procedure ComboBox3Change(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button15Click(Sender: TObject);
    procedure Button16Click(Sender: TObject);
    procedure Button18Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
var groups:byte;
var myGrp:byte;
var myGrpStart:byte;
var myGrpStop:byte;
var myGrpTotal:byte;
var vrb:longint;
var inx:longint;
implementation

function booly(b:longint):string;begin
result:='False';
if(b>0)then result:='True';
end;
function  hda_codec_read(nid:unsignedshort;direct,verb,param:longint):longint;far; external 'hda2';
function  hda_codec_write(nid:unsignedshort;direct,verb,param:longint):longint;far; external 'hda2';

{$R *.DFM}

procedure clearwig; begin form1.listbox1.clear; end;
function addwig(number:word):byte;
begin
 if(form1.listbox1.items.count>1000) then clearwig;
 form1.listbox1.items.add('$'+inttohex(number,4));
end;


function writen(str:string):byte; begin
form1.memo5.lines.add(str);
end;


function writemn(str:string):byte;
var x:word;
begin
x:=form1.memo5.lines.count-1;
form1.memo5.lines[x]:=form1.memo5.lines[x]+str;
end;

function write6(str:string):byte; begin
form1.memo6.lines.add(str);
end;


function write6n(str:string):byte;
var x:word;
begin
x:=form1.memo6.lines.count-1;
form1.memo6.lines[x]:=form1.memo6.lines[x]+str;
end;


function writem6(str:string):byte;
var x:word;
begin
x:=form1.memo6.lines.count-1;
form1.memo6.lines[x]:=form1.memo6.lines[x]+str;
end;



procedure TForm1.Button55Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I:longint;
begin
clearwig;
tn:=myGrpStop;
if(tn=0)then tn:=64;
I:=MyGrpStart;
memo6.clear;
memo6.visible:=false;
while i<tn do begin addwig(i);
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
write6('AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' ($'+inttohex(d,8)+')');
write6('Type=$'+inttohex(examinebits(23,20,d),2));
if(examinebits(23,20,d)=0)then write6('  Audio Output');
if(examinebits(23,20,d)=1)then write6('  Audio Input');
if(examinebits(23,20,d)=2)then write6('  Audio Mixer');
if(examinebits(23,20,d)=3)then write6('  Audio Selector');
if(examinebits(23,20,d)=4)then write6('  Pin Complex');
if(examinebits(23,20,d)=5)then write6('  Power Widget');
if(examinebits(23,20,d)=6)then write6('  Volume Knob Widget');
if(examinebits(23,20,d)=7)then write6('  Beep Generator Widget');
if(examinebits(23,20,d)=8)then write6('  Reserved');
if(examinebits(23,20,d)=$F)then write6('  Vendor defined Widget');
 {
write6(' Delay='+inttostr(examinebits(19,16,(d))));
write6(' Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6(' CP Caps='+Booly(D and BIT12));
write6(' L-R Swap='+Booly(D and BIT11));
write6(' Power Cntrl='+Booly(D and BIT10));
write6(' Digital='+Booly(D and BIT9));
write6(' Conn List='+Booly(D and BIT8));
write6(' Unsol Capable='+Booly(D and BIT7));
write6(' ProcWidget='+Booly(D and BIT6));
write6(' Stripe='+Booly(D and BIT5));
write6(' Format Override='+Booly(D and BIT4));
write6(' Amp Param Override='+Booly(D and BIT3));
write6(' Out Amp Present='+Booly(D and BIT2));
write6(' In Amp Present='+Booly(D and BIT1));
write6(' Chan count='+inttostr((D and BIT0)));
write6(' Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));
}
write6('');


i:=i+1;
end;
memo6.visible:=true;
end;

procedure TForm1.Button5Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I,f,val:longint;
begin
tn:=127;f:=0;clearwig;
I:=0;
memo6.clear;
memo6.visible:=false;
while i<tn do begin
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
if(d>0)then begin
if(examinebits(23,20,d)=AC_WID_AUD_OUT)then begin addwig(i);
f:=f+1;
write6('AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' B('+bins32(d)+')');
write6(' Type='+inttostr(examinebits(23,20,d)));

write6(' Delay='+inttostr(examinebits(19,16,(d))));
write6(' Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6(' CP Caps='+Booly(D and BIT12));
write6(' L-R Swap='+Booly(D and BIT11));
write6(' Power Cntrl='+Booly(D and BIT10));
write6(' Digital='+Booly(D and BIT9));
write6(' Conn List='+Booly(D and BIT8));
write6(' Unsol Capable='+Booly(D and BIT7));
write6(' ProcWidget='+Booly(D and BIT6));
write6(' Stripe='+Booly(D and BIT5));
write6(' Format Override='+Booly(D and BIT4));
write6(' Amp Param Override='+Booly(D and BIT3));
write6(' Out Amp Present='+Booly(D and BIT2));
write6(' In Amp Present='+Booly(D and BIT1));
write6(' Chan count='+inttostr((D and BIT0)));
write6('Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));

D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_PCM);{AudFunGrp or Widget}
write6('AC_PAR_PCM of node '+inttostr(i)+' =$'+inttohex((D),8));
write6(' Bit rates=');
if(hiword(d) and BIT0)=BIT0 then write6n(' 8-bit,');
if(hiword(d) and BIT1)=BIT1 then write6n(' 16-bit,');
if(hiword(d) and BIT2)=BIT2 then write6n(' 20-bit,');
if(hiword(d) and BIT3)=BIT3 then write6n(' 24-bit,');
if(hiword(d) and BIT4)=BIT4 then write6n(' 32-bit,');
if(hiword(d) and BIT5)=BIT5 then write6n(' XX-bit,');
write6(' Sample rates=');
if(byte(d) and BIT0)=BIT0 then write6n(' 8.0khz,');
if(byte(d) and BIT1)=BIT1 then write6n(' 11.025khz,');
if(byte(d) and BIT2)=BIT2 then write6n(' 16.0khz,');
if(byte(d) and BIT3)=BIT3 then write6n(' 22.05khz,');
if(byte(d) and BIT4)=BIT4 then write6n(' 32.0khz,');
if(byte(d) and BIT5)=BIT5 then write6n(' 44.1khz,');
if(byte(d) and BIT6)=BIT6 then write6n(' 48.0khz,');
if(byte(d) and BIT7)=BIT7 then write6n(' 88.0khz,');
if(byte(d) and BIT8)=BIT8 then write6n(' 96.0khz,');
if(byte(d) and BIT9)=BIT9 then write6n(' 176.4khz,');
if(byte(d) and BIT10)=BIT10 then write6n(' 192.0khz,');
if(byte(d) and BIT11)=BIT11 then write6n(' 384.0khz,');
if(byte(d) and BIT12)=BIT12 then write6n(' XXX.Xkhz');

D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_STREAM);{AudFunGrp or Widget}
write6('AC_PAR_STREAM of $'+inttohex(i,2)+'= $'+inttohex((D),8));
if(d and BIT0)=BIT0 then write6(' Supports PCM');
if(d and BIT1)=BIT1 then write6(' Supports Float32');
if(d and BIT2)=BIT2 then write6(' Supports Dolby AC-3');

D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_AMP_OUT_CAP);{AudFunGrp or Widget}
write6('AC_PAR_AMP_OUT_CAP '+inttostr(i)+' $'+inttohex((D),8));
write6(' Offset='+inttostr(byte(examinebits(6,0,d))));
write6(' NumSteps='+inttostr(byte(examinebits(14,8,d))));
write6(' StepSize='+inttostr(byte(examinebits(22,16,d))));
if(d and BIT31)=BIT31 then write6(' Mute Capable');


val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONV_STR_CH, 0);
write6('AC_VERB_GET_CONV_STR_CH #$'+inttohex(i,2)+' =$'+inttohex(val,8));
write6('  Stream  3:0 =$'+inttohex(examinebits(7,4,val),2));
write6('  Channel 3:0 =$'+inttohex(examinebits(3,0,val),2));

val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_STREAM_FORMAT, 0);
write6('AC_VERB_GET_STREAM_FORMAT #$'+inttohex(i,2)+' =$'+inttohex(val,8));
if(examinebits(15,15,val)=0)then begin{0=PCM}
 write6(' TYPE (BIT15)=0;(PCM)');
 write6(' Sample Base Rate(BASE) (BIT14 R/W) ='+inttostr(examinebits(14,14,val)));
 if(examinebits(14,14,val)=0)then write6('  0 = 48kHZ');
 if(examinebits(14,14,val)=1)then write6('  1 = 44.1kHZ');
 write6(' RW Sample Base Rate Multiple (MULT) 13:11 ='+inttostr(examinebits(13,11,val)));
 if(examinebits(13,11,val)=0)then write6('  000 = 48kHz/44.1kHz or less');
 if(examinebits(13,11,val)=1)then write6('  001 = x2(96kHz,88.2kHz,32kHz)');
 if(examinebits(13,11,val)=2)then write6('  010 =x3(144kHz)');
 if(examinebits(13,11,val)=3)then write6('  011 =x4(192kHz,176.4kHz)');
 if(examinebits(13,11,val)=4)then write6('  100-111 Reserved');
 write6(' Sample Base Rate Divisor (DIV) 10:8 ='+inttostr(examinebits(10,8,val)));
 if(examinebits(10,8,val)=0)then write6('  000 = Divide by 1(48kHz,44.1kHz)');
 if(examinebits(10,8,val)=1)then write6('  001 = Divide by 2(24kHz,22.05kHz)');
 if(examinebits(10,8,val)=2)then write6('  010 = Divide by 3(16kHz,32kHz)');
 if(examinebits(10,8,val)=3)then write6('  011 = Divide by 4(11.025kHz)');
 if(examinebits(10,8,val)=4)then write6('  100 = Divide by 5(9.6kHz)');
 if(examinebits(10,8,val)=5)then write6('  101 = Divide by 6(8kHz))');
 if(examinebits(10,8,val)=6)then write6('  110 = Divide by 7');
 if(examinebits(10,8,val)=7)then write6('  111 = Divide by 8(6kHz)');
 write6(' Bits per Sample(BITS) 6:4  ='+inttostr(examinebits(6,4,val)));
 if(examinebits(6,4,val)=0)then begin
 write6('  000 = 8 bits. The data will be packed in memory in 8-bit containers on 16-bit boundaries.');end;
 if(examinebits(6,4,val)=1)then begin
 write6('  001 =16 bits. The data will be packed in memory in 16-bit containers on 16-bit boundaries.');end;
 if(examinebits(6,4,val)=2)then begin
 write6('  010 =20 bits. The data will be packed in memory in 32-bit containers on 32-bit boundaries.');end;
 if(examinebits(6,4,val)=3)then begin
 write6('  011 =24 bits. The data will be packed in memory in 32-bit containers on 32-bit boundaries.');end;
 if(examinebits(6,4,val)=4)then begin
 write6('  100 =32 bits. The data will be packed in memory in 32-bit containers on 32-bit boundaries.');end;
 if(examinebits(6,4,val)>4)then begin
 write6('  101-111 Reserved');
 end;
 write6(' Channels(CHAN) 3:0 = '+inttostr(val and $F));
end else begin
 write6(' Type (BIT15)='+inttostr(examinebits(15,15,val))+'; (Non-PCM)');
end;



write6('');



end;
end;
i:=i+1;
end;
memo6.visible:=true;caption:=inttostr(f);
end;



procedure TForm1.Button7Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I,f:longint;
var val:longint;
begin
tn:=127;f:=0;clearwig;
I:=0;
memo6.clear;
memo6.visible:=false;
while i<tn do begin
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
if(examinebits(23,20,d)=AC_WID_AUD_MIX)then begin addwig(i);
f:=f+1;
write6('AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' B('+bins32(d)+')');
write6('Type='+inttostr(examinebits(23,20,d)));
write6('Delay='+inttostr(examinebits(19,16,(d))));
write6('Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6('CP Caps='+Booly(D and BIT12));
write6('L-R Swap='+Booly(D and BIT11));
write6('Power Cntrl='+Booly(D and BIT10));
write6('Digital='+Booly(D and BIT9));
write6('Conn List='+Booly(D and BIT8));
write6('Unsol Capable='+Booly(D and BIT7));
write6('ProcWidget='+Booly(D and BIT6));
write6('Stripe='+Booly(D and BIT5));
write6('Format Override='+Booly(D and BIT4));
write6('Amp Param Override='+Booly(D and BIT3));
write6('Out Amp Present='+Booly(D and BIT2));
write6('In Amp Present='+Booly(D and BIT1));
write6('Chan count='+inttostr((D and BIT0)));
write6('Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));


D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_AMP_IN_CAP);{AudFunGrp or Widget}
write6('AC_PAR_AMP_IN_CAP '+inttostr(i)+' $'+inttohex((D),8));
write6(' Offset='+inttostr(byte(examinebits(6,0,d))));
write6(' NumSteps='+inttostr(byte(examinebits(14,8,d))));
write6(' StepSize='+inttostr(byte(examinebits(22,16,d))));
if(d and BIT31)=BIT31 then write6(' Mute Capable');

D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_CONNLIST_LEN);{Widget}
write6(' AC_PAR_CONNLIST_LEN '+inttostr(i)+' $'+inttohex((D),8));
write6('Connection List Length='+inttostr(examinebits(6,0,byte(d))));
if(d and BIT7)=BIT7 then write6(' Long Form ') else write6(' Short Form');
if(examinebits(6,0,byte(d))=1)then write6(' There is only one hard-wired input possible (read it from the list)');

val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONNECT_LIST, 0);
write6('AC_VERB_GET_CONNECT_LIST #$'+inttohex(i,2)+' =$'+inttohex(val,8));
{short form}
if(d and BIT7)=BIT7 then begin
{long form}
write6(' Long form');
write6('  Connection List Entry N+1 [31:16]=$'+inttohex(examinebits(31,16,val),2));
write6('  Connection List Entry N [15:0]=$'+inttohex(examinebits(15,0,val),2));
end else begin
write6(' Short Form');
write6('  Connection List Entry N+3[31:24]=$'+inttohex(examinebits(31,24,val),2));
write6('  Connection List Entry N+2[23:16] Connectivity[23:16]=$'+inttohex(examinebits(23,16,val),2));
write6('  Connection List Entry N+1[15:8] Connectivity[15:6]=$'+inttohex(examinebits(15,8,val),2));
write6('  Connection List Entry N+0[7:0] Connectivity[7:0]=$'+inttohex(examinebits(7,0,val),2));
end;



write6('');



write6('');

end;
i:=i+1;
end;
memo6.visible:=true;caption:=inttostr(f);


end;

procedure TForm1.Button8Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I,f,val:longint;
begin
tn:=127;f:=0;clearwig;
I:=0;
memo6.clear;
memo6.visible:=false;
while i<tn do begin
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
if(examinebits(23,20,d)=AC_WID_AUD_SEL)then begin addwig(i);
f:=f+1;
write6(' AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' B('+bins32(d)+')');
write6(' Type='+inttostr(examinebits(23,20,d)));
write6(' Delay='+inttostr(examinebits(19,16,(d))));
write6(' Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6(' CP Caps='+Booly(D and BIT12));
write6(' L-R Swap='+Booly(D and BIT11));
write6(' Power Cntrl='+Booly(D and BIT10));
write6(' Digital='+Booly(D and BIT9));
write6(' Conn List='+Booly(D and BIT8));
write6(' Unsol Capable='+Booly(D and BIT7));
write6(' ProcWidget='+Booly(D and BIT6));
write6(' Stripe='+Booly(D and BIT5));
write6(' Format Override='+Booly(D and BIT4));
write6(' Amp Param Override='+Booly(D and BIT3));
write6(' Out Amp Present='+Booly(D and BIT2));
write6(' In Amp Present='+Booly(D and BIT1));
write6(' Chan count='+inttostr((D and BIT0)));
write6('Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));


D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_AMP_IN_CAP);{AudFunGrp or Widget}
write6('AC_PAR_AMP_IN_CAP '+inttostr(i)+' $'+inttohex((D),8));
write6(' Offset='+inttostr(byte(examinebits(6,0,d))));
write6(' NumSteps='+inttostr(byte(examinebits(14,8,d))));
write6(' StepSize='+inttostr(byte(examinebits(22,16,d))));
if(d and BIT31)=BIT31 then write6(' Mute Capable');

D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_CONNLIST_LEN);{Widget}
write6(' AC_PAR_CONNLIST_LEN '+inttostr(i)+' $'+inttohex((D),8));
write6('Connection List Length='+inttostr(examinebits(6,0,byte(d))));
if(d and BIT7)=BIT7 then write6(' Long Form ') else write6(' Short Form');
if(examinebits(6,0,byte(d))=1)then write6(' There is only one hard-wired input possible (read it from the list)');


val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONNECT_LIST, 0);
write6('AC_VERB_GET_CONNECT_LIST #$'+inttohex(i,2)+' =$'+inttohex(val,8));
{short form}
if(d and BIT7)=BIT7 then begin
{long form}
write6(' Long form');
write6('  Connection List Entry N+1 [31:16]=$'+inttohex(examinebits(31,16,val),2));
write6('  Connection List Entry N [15:0]=$'+inttohex(examinebits(15,0,val),2));
end else begin
write6(' Short Form');
write6('  Connection List Entry N+3[31:24]=$'+inttohex(examinebits(31,24,val),2));
write6('  Connection List Entry N+2[23:16] Connectivity[23:16]=$'+inttohex(examinebits(23,16,val),2));
write6('  Connection List Entry N+1[15:8] Connectivity[15:6]=$'+inttohex(examinebits(15,8,val),2));
write6('  Connection List Entry N+0[7:0] Connectivity[7:0]=$'+inttohex(examinebits(7,0,val),2));
end;

val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONNECT_SEL, 0);
write6('AC_VERB_GET_CONNECT_SEL #$'+inttohex(i,2)+' =$'+inttohex(val,8));
write6('Connection Index currently set 7:0=$'+inttohex(byte(val),2));


write6('');

write6('');
end;
i:=i+1;
end;
memo6.visible:=true;caption:=inttostr(f);


end;

procedure TForm1.Button6Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I,f:longint;
var val:longint;
begin
tn:=127;f:=0;clearwig;
I:=0;
memo6.clear;
memo6.visible:=false;
while i<tn do begin
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
if(examinebits(23,20,d)=AC_WID_AUD_IN)then begin addwig(i);
f:=f+1;
write6('AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' B('+bins32(d)+')');
write6(' Type='+inttostr(examinebits(23,20,d)));

write6(' Delay='+inttostr(examinebits(19,16,(d))));
write6(' Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6(' CP Caps='+Booly(D and BIT12));
write6(' L-R Swap='+Booly(D and BIT11));
write6(' Power Cntrl='+Booly(D and BIT10));
write6(' Digital='+Booly(D and BIT9));
write6(' Conn List='+Booly(D and BIT8));
write6(' Unsol Capable='+Booly(D and BIT7));
write6(' ProcWidget='+Booly(D and BIT6));
write6(' Stripe='+Booly(D and BIT5));
write6(' Format Override='+Booly(D and BIT4));
write6(' Amp Param Override='+Booly(D and BIT3));
write6(' Out Amp Present='+Booly(D and BIT2));
write6(' In Amp Present='+Booly(D and BIT1));
write6(' Chan count='+inttostr((D and BIT0)));
write6('Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));

D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_PCM);{AudFunGrp or Widget}
write6('AC_PAR_PCM of node '+inttostr(i)+' =$'+inttohex((D),8));
write6(' Bit rates=');
if(hiword(d) and BIT0)=BIT0 then write6n(' 8-bit,');
if(hiword(d) and BIT1)=BIT1 then write6n(' 16-bit,');
if(hiword(d) and BIT2)=BIT2 then write6n(' 20-bit,');
if(hiword(d) and BIT3)=BIT3 then write6n(' 24-bit,');
if(hiword(d) and BIT4)=BIT4 then write6n(' 32-bit,');
if(hiword(d) and BIT5)=BIT5 then write6n(' XX-bit,');
write6(' Sample rates=');
if(byte(d) and BIT0)=BIT0 then write6n(' 8.0khz,');
if(byte(d) and BIT1)=BIT1 then write6n(' 11.025khz,');
if(byte(d) and BIT2)=BIT2 then write6n(' 16.0khz,');
if(byte(d) and BIT3)=BIT3 then write6n(' 22.05khz,');
if(byte(d) and BIT4)=BIT4 then write6n(' 32.0khz,');
if(byte(d) and BIT5)=BIT5 then write6n(' 44.1khz,');
if(byte(d) and BIT6)=BIT6 then write6n(' 48.0khz,');
if(byte(d) and BIT7)=BIT7 then write6n(' 88.0khz,');
if(byte(d) and BIT8)=BIT8 then write6n(' 96.0khz,');
if(byte(d) and BIT9)=BIT9 then write6n(' 176.4khz,');
if(byte(d) and BIT10)=BIT10 then write6n(' 192.0khz,');
if(byte(d) and BIT11)=BIT11 then write6n(' 384.0khz,');
if(byte(d) and BIT12)=BIT12 then write6n('XXX.Xkhz');

D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_STREAM);{AudFunGrp or Widget}
write6('AC_PAR_STREAM of $'+inttohex(i,2)+'= $'+inttohex((D),8));
if(d and BIT0)=BIT0 then write6(' Supports PCM');
if(d and BIT1)=BIT1 then write6(' Supports Float32');
if(d and BIT2)=BIT2 then write6(' Supports Dolby AC-3');


D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_AMP_IN_CAP);{AudFunGrp or Widget}
write6('AC_PAR_AMP_IN_CAP '+inttostr(i)+' $'+inttohex((D),8));
write6(' Offset='+inttostr(byte(examinebits(6,0,d))));
write6(' NumSteps='+inttostr(byte(examinebits(14,8,d))));
write6(' StepSize='+inttostr(byte(examinebits(22,16,d))));
if(d and BIT31)=BIT31 then write6(' Mute Capable');


D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_CONNLIST_LEN);{Widget}
write6(' AC_PAR_CONNLIST_LEN '+inttostr(i)+' $'+inttohex((D),8));
write6('Connection List Length='+inttostr(examinebits(6,0,byte(d))));
if(d and BIT7)=BIT7 then write6(' Long Form ') else write6(' Short Form');
if(examinebits(6,0,byte(d))=1)then write6(' There is only one hard-wired input possible (read it from the list)');

val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONNECT_LIST, 0);
write6('AC_VERB_GET_CONNECT_LIST #$'+inttohex(i,2)+' =$'+inttohex(val,8));
{short form}
if(d and BIT7)=BIT7 then begin
{long form}
write6(' Long form');
write6('  Connection List Entry N+1 [31:16]=$'+inttohex(examinebits(31,16,val),2));
write6('  Connection List Entry N [15:0]=$'+inttohex(examinebits(15,0,val),2));
end else begin
write6(' Short Form');
write6('  Connection List Entry N+3[31:24]=$'+inttohex(examinebits(31,24,val),2));
write6('  Connection List Entry N+2[23:16] Connectivity[23:16]=$'+inttohex(examinebits(23,16,val),2));
write6('  Connection List Entry N+1[15:8] Connectivity[15:6]=$'+inttohex(examinebits(15,8,val),2));
write6('  Connection List Entry N+0[7:0] Connectivity[7:0]=$'+inttohex(examinebits(7,0,val),2));
end;

val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONNECT_SEL, 0);
write6('AC_VERB_GET_CONNECT_SEL #$'+inttohex(i,2)+' =$'+inttohex(val,8));
write6('Connection Index currently set 7:0=$'+inttohex(byte(val),2));



val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONV_STR_CH, 0);
write6('AC_VERB_GET_CONV_STR_CH #$'+inttohex(i,2)+' =$'+inttohex(val,8));
write6('  Stream  3:0 =$'+inttohex(examinebits(7,4,val),2));
write6('  Channel 3:0 =$'+inttohex(examinebits(3,0,val),2));


val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_STREAM_FORMAT, 0);
write6('AC_VERB_GET_STREAM_FORMAT #$'+inttohex(i,2)+' =$'+inttohex(val,8));
if(examinebits(15,15,val)=0)then begin{0=PCM}
 write6(' TYPE (BIT15)=0;(PCM)');
 write6(' Sample Base Rate(BASE) (BIT14 R/W) ='+inttostr(examinebits(14,14,val)));
 if(examinebits(14,14,val)=0)then write6('  0 = 48kHZ');
 if(examinebits(14,14,val)=1)then write6('  1 = 44.1kHZ');
 write6(' RW Sample Base Rate Multiple (MULT) 13:11 ='+inttostr(examinebits(13,11,val)));
 if(examinebits(13,11,val)=0)then write6('  000 = 48kHz/44.1kHz or less');
 if(examinebits(13,11,val)=1)then write6('  001 = x2(96kHz,88.2kHz,32kHz)');
 if(examinebits(13,11,val)=2)then write6('  010 =x3(144kHz)');
 if(examinebits(13,11,val)=3)then write6('  011 =x4(192kHz,176.4kHz)');
 if(examinebits(13,11,val)=4)then write6('  100-111 Reserved');
 write6(' Sample Base Rate Divisor (DIV) 10:8 ='+inttostr(examinebits(10,8,val)));
 if(examinebits(10,8,val)=0)then write6('  000 = Divide by 1(48kHz,44.1kHz)');
 if(examinebits(10,8,val)=1)then write6('  001 = Divide by 2(24kHz,22.05kHz)');
 if(examinebits(10,8,val)=2)then write6('  010 = Divide by 3(16kHz,32kHz)');
 if(examinebits(10,8,val)=3)then write6('  011 = Divide by 4(11.025kHz)');
 if(examinebits(10,8,val)=4)then write6('  100 = Divide by 5(9.6kHz)');
 if(examinebits(10,8,val)=5)then write6('  101 = Divide by 6(8kHz))');
 if(examinebits(10,8,val)=6)then write6('  110 = Divide by 7');
 if(examinebits(10,8,val)=7)then write6('  111 = Divide by 8(6kHz)');
 write6(' Bits per Sample(BITS) 6:4  ='+inttostr(examinebits(6,4,val)));
 if(examinebits(6,4,val)=0)then begin
 write6('  000 = 8 bits. The data will be packed in memory in 8-bit containers on 16-bit boundaries.');end;
 if(examinebits(6,4,val)=1)then begin
 write6('  001 =16 bits. The data will be packed in memory in 16-bit containers on 16-bit boundaries.');end;
 if(examinebits(6,4,val)=2)then begin
 write6('  010 =20 bits. The data will be packed in memory in 32-bit containers on 32-bit boundaries.');end;
 if(examinebits(6,4,val)=3)then begin
 write6('  011 =24 bits. The data will be packed in memory in 32-bit containers on 32-bit boundaries.');end;
 if(examinebits(6,4,val)=4)then begin
 write6('  100 =32 bits. The data will be packed in memory in 32-bit containers on 32-bit boundaries.');end;
 if(examinebits(6,4,val)>4)then begin
 write6('  101-111 Reserved');
 end;
 write6(' Channels(CHAN) 3:0 = '+inttostr(examinebits(3,0,val)));
end else begin
 write6(' Type (BIT15)='+inttostr(examinebits(15,15,val))+'; (Non-PCM)');
end;

write6('');
write6('');
end;
i:=i+1;
end;
memo6.visible:=true;caption:=inttostr(f);

end;

procedure TForm1.Button9Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I,f,val:longint;

begin
tn:=127;f:=0;clearwig;
I:=0;
memo6.clear;
memo6.visible:=false;
while i<tn do begin
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
if(examinebits(23,20,d)=AC_WID_PIN)then begin addwig(i);
f:=f+1;
write6('AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' B('+bins32(d)+')');
write6(' Type='+inttostr(examinebits(23,20,d)));
write6(' Delay='+inttostr(examinebits(19,16,(d))));
write6(' Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6(' CP Caps='+Booly(D and BIT12));
write6(' L-R Swap='+Booly(D and BIT11));
write6(' Power Cntrl='+Booly(D and BIT10));
write6(' Digital='+Booly(D and BIT9));
write6(' Conn List='+Booly(D and BIT8));
write6(' Unsol Capable='+Booly(D and BIT7));
write6(' ProcWidget='+Booly(D and BIT6));
write6(' Stripe='+Booly(D and BIT5));
write6(' Format Override='+Booly(D and BIT4));
write6(' Amp Param Override='+Booly(D and BIT3));
write6(' Out Amp Present='+Booly(D and BIT2));
write6(' In Amp Present='+Booly(D and BIT1));
write6(' Chan count='+inttostr((D and BIT0)));
write6('Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));
D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_PIN_CAP);{Widget}
write6('AC_PAR_PIN_CAP '+inttostr(i)+' $'+inttohex((D),8));
if(d and BIT0)=BIT0 then write6(' Impedance Sense Capable');
if(d and BIT1)=BIT1 then write6(' Trigger Required');
if(d and BIT2)=BIT2 then write6(' Presence Detect Capable');
if(d and BIT3)=BIT3 then write6(' Headphone Drive Capable');
if(d and BIT4)=BIT4 then write6(' Output Capable');
if(d and BIT5)=BIT5 then write6(' Input Capable');
if(d and BIT6)=BIT6 then write6(' Balanced I/O pins');
if(d and BIT7)=BIT7 then write6(' HDMI');
write6(' VRef Control='+inttostr(examinebits(15,8,byte(d))));
if(d and BIT16)=BIT16 then write6(' EAPD Capable');
if(d and BIT24)=BIT24 then write6(' DP (Display Port)');
if(d and BIT27)=BIT27 then write6(' HBR (High Bit Rate)');

D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_AMP_OUT_CAP);{AudFunGrp or Widget}
write6('AC_PAR_AMP_OUT_CAP '+inttostr(i)+' $'+inttohex((D),8));
write6(' Offset='+inttostr(byte(examinebits(6,0,d))));
write6(' NumSteps='+inttostr(byte(examinebits(14,8,d))));
write6(' StepSize='+inttostr(byte(examinebits(22,16,d))));
if(d and BIT31)=BIT31 then write6(' Mute Capable');

D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_CONNLIST_LEN);{Widget}
write6(' AC_PAR_CONNLIST_LEN '+inttostr(i)+' $'+inttohex((D),8));
write6(' Connection List Length='+inttostr(examinebits(6,0,byte(d))));
if(d and BIT7)=BIT7 then write6(' Long Form ') else write6(' Short Form');
if(examinebits(6,0,byte(d))=1)then write6(' There is only one hard-wired input possible (read it from the list)');

val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONNECT_LIST, 0);
write6('AC_VERB_GET_CONNECT_LIST #$'+inttohex(i,2)+' =$'+inttohex(val,8));
{short form}
if(d and BIT7)=BIT7 then begin
{long form}
write6(' Long form');
write6('  Connection List Entry N+1 [31:16]=$'+inttohex(examinebits(31,16,val),2));
write6('  Connection List Entry N [15:0]=$'+inttohex(examinebits(15,0,val),2));
end else begin
write6(' Short Form');
write6('  Connection List Entry N+3[31:24]=$'+inttohex(examinebits(31,24,val),2));
write6('  Connection List Entry N+2[23:16] Connectivity[23:16]=$'+inttohex(examinebits(23,16,val),2));
write6('  Connection List Entry N+1[15:8] Connectivity[15:6]=$'+inttohex(examinebits(15,8,val),2));
write6('  Connection List Entry N+0[7:0] Connectivity[7:0]=$'+inttohex(examinebits(7,0,val),2));
end;

val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONNECT_SEL, 0);
write6('AC_VERB_GET_CONNECT_SEL #$'+inttohex(i,2)+' =$'+inttohex(val,8));
write6(' Connection Index currently set=$'+inttohex(byte(val),2));


{}

val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONFIG_DEFAULT, 0);
write6('AC_VERB_GET_CONFIG_DEFAULT #$'+inttohex(i,2)+' =$'+inttohex(val,8));
write6('Port Connectivity[31:30]=$'+inttohex(examinebits(31,30,val),2));
if(val shr 30)=0 then write6(' The Port Complex is connected to a jack (1/8",ATAPI,etc.)');
if(val shr 30)=1 then write6(' No physical connection for Port');
if(val shr 30)=2 then write6(' A fixed function device(integrated speaker, integrated mic, etc. is attached.');
if(val shr 30)=3 then begin
write6(' Both a jack and an internal device are attached. The information ');
write6(' provided in all other fields refers to the integrated device. The');
write6(' PD pin will reflect the status of the jack; the user will ned to be');
write6(' queried to figure out what it is.');
end;
write6('Location[29:24]=$'+inttohex(examinebits(29,24,val),2));

if(examinebits(27,24,val))=(0) then  begin write6(' N/A'); end else
if(examinebits(27,24,val))=(1) then  begin write6(' Rear');end else
if(examinebits(27,24,val))=(2) then  begin write6(' Front');end else
if(examinebits(27,24,val))=(3) then  begin write6(' Left');end else
if(examinebits(27,24,val))=(4) then  begin write6(' Right');end else
if(examinebits(27,24,val))=(5) then  begin write6(' Top');end else
if(examinebits(27,24,val))=(6) then  begin write6(' Bottom');end else
if(examinebits(27,24,val))=(7) then  begin write6(' Special');end else
if(examinebits(27,24,val))=(8) then  begin write6(' Extra Special');end else
if(examinebits(27,24,val))=(9) then  begin write6(' Special (Device?)');end;
if(examinebits(27,24,val))>(9) then  begin write6(' Reserved');end;

if(examinebits(28,28,val))=1 then  write6(' Internal') else write6(' External');
if(examinebits(29,29,val))=1 then  write6(' Seperate chassis') else write6(' Main chassis');

if(examinebits(29,24,val)=7) then  begin write6(' Panel');end;
if(examinebits(29,24,val)=8) then  begin write6(' Drive bay');end;

if(examinebits(29,24,val)=(7 + 16)) then  begin write6(' Riser');end;
if(examinebits(29,24,val)=(8 + 16)) then  begin write6(' Digital Display ');end;
if(examinebits(29,24,val)=(9 + 16)) then  begin write6(' ATAPI');end;

if(examinebits(29,24,val)=(7 + 48)) then  begin write6(' (Mobile Lid-Inside)(e.g., mic inside Mobile lid)');end;
if(examinebits(29,24,val)=(8 + 48)) then  begin write6(' Mobile Lid-Outside)');end;


write6('Default Device[23:20]=$'+inttohex(examinebits(23,20,val),2));
if(examinebits(23,20,val))=$0 then write6(' Line Out');
if(examinebits(23,20,val))=$1 then write6(' Speaker');
if(examinebits(23,20,val))=$2 then write6(' HP Out');
if(examinebits(23,20,val))=$3 then write6(' CD');
if(examinebits(23,20,val))=$4 then write6(' SPDIF Out');
if(examinebits(23,20,val))=$5 then write6(' Digital Other Out');
if(examinebits(23,20,val))=$6 then write6(' Modem Line Side');
if(examinebits(23,20,val))=$7 then write6(' Modem Handset Side');
if(examinebits(23,20,val))=$8 then write6(' Line In');
if(examinebits(23,20,val))=$9 then write6(' AUX');
if(examinebits(23,20,val))=$A then write6(' Mic In');
if(examinebits(23,20,val))=$B then write6(' Telephony');
if(examinebits(23,20,val))=$C then write6(' SPDIF In');
if(examinebits(23,20,val))=$D then write6(' Digital Other In');
if(examinebits(23,20,val))=$E then write6(' Reserved');
if(examinebits(23,20,val))=$F then write6(' Other');

write6('Connection Type[19:16]=$'+inttohex(examinebits(19,16,val),2));
if(examinebits(19,16,val))=$0 then write6('Unknown');
if(examinebits(19,16,val))=$1 then write6(' 1/8 stereo/mono');
if(examinebits(19,16,val))=$2 then write6(' 1/4 stereo/mono');
if(examinebits(19,16,val))=$3 then write6(' ATAPI internal');
if(examinebits(19,16,val))=$4 then write6(' RCA');
if(examinebits(19,16,val))=$5 then write6(' Optical');
if(examinebits(19,16,val))=$6 then write6(' Other Digital');
if(examinebits(19,16,val))=$7 then write6(' Other Analog');
if(examinebits(19,16,val))=$8 then write6(' Multichannel Analog (DIN)');
if(examinebits(19,16,val))=$9 then write6(' XLR/Professional');
if(examinebits(19,16,val))=$a then write6(' RJ-11(Modem)');
if(examinebits(19,16,val))=$b then write6(' Combination');
if(examinebits(19,16,val))=$c then write6(' ?');
if(examinebits(19,16,val))=$d then write6(' ?');
if(examinebits(19,16,val))=$e then write6(' ?');
if(examinebits(19,16,val))=$f then write6(' Other');

write6('Color[15:12]=$'+inttohex(examinebits(15,12,val),2));
if(examinebits(15,12,val))=$0 then write6(' Unknown');
if(examinebits(15,12,val))=$1 then write6(' Black');
if(examinebits(15,12,val))=$2 then write6(' Grey');
if(examinebits(15,12,val))=$3 then write6(' Blue');
if(examinebits(15,12,val))=$4 then write6(' Green');
if(examinebits(15,12,val))=$5 then write6(' Red');
if(examinebits(15,12,val))=$6 then write6(' Orange');
if(examinebits(15,12,val))=$7 then write6(' Yellow');
if(examinebits(15,12,val))=$8 then write6(' Purple');
if(examinebits(15,12,val))=$9 then write6(' Pink');
if(examinebits(15,12,val))=$a then write6(' Reserved');
if(examinebits(15,12,val))=$b then write6(' Reserved');
if(examinebits(15,12,val))=$c then write6(' Reserved');
if(examinebits(15,12,val))=$d then write6(' Reserved');
if(examinebits(15,12,val))=$e then write6(' White');
if(examinebits(15,12,val))=$f then write6(' Other');
write6('Misc[11:8]=$'+inttohex(examinebits(11,8,val),2));
if(examinebits(8,8,val))=1 then write6('Jack Detect Override');

write6('Default Association (For Grouping)[7:4]=$'+inttohex(examinebits(7,4,val),2));
write6('Sequence (Index in Group)[3:0]=$'+inttohex(examinebits(3,0,val),2));


val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_PIN_SENSE, 0);
write6('AC_VERB_GET_PIN_SENSE #'+inttohex(i,2)+' =$'+inttohex(val,8));
if(val and BIT31)=bit31 then write6('Connector Presence Detected on this pin.') else
write6('No device detected on this pin.');



write6('');





write6('');

end;
i:=i+1;
end;
memo6.visible:=true;caption:=inttostr(f);


end;

procedure TForm1.Button10Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I,f,val:longint;
begin
tn:=127;f:=0;clearwig;
I:=0;
memo6.clear;
memo6.visible:=false;
while i<tn do begin
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
if(examinebits(23,20,d)=AC_WID_POWER)then begin addwig(i);
f:=f+1;
write6('AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' B('+bins32(d)+')');
write6('Type='+inttostr(examinebits(23,20,d)));
write6('Delay='+inttostr(examinebits(19,16,(d))));
write6('Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6('CP Caps='+Booly(D and BIT12));
write6('L-R Swap='+Booly(D and BIT11));
write6('Power Cntrl='+Booly(D and BIT10));
write6('Digital='+Booly(D and BIT9));
write6('Conn List='+Booly(D and BIT8));
write6('Unsol Capable='+Booly(D and BIT7));
write6('ProcWidget='+Booly(D and BIT6));
write6('Stripe='+Booly(D and BIT5));
write6('Format Override='+Booly(D and BIT4));
write6('Amp Param Override='+Booly(D and BIT3));
write6('Out Amp Present='+Booly(D and BIT2));
write6('In Amp Present='+Booly(D and BIT1));
write6('Chan count='+inttostr((D and BIT0)));
write6('Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));

D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_CONNLIST_LEN);{Widget}
write6(' AC_PAR_CONNLIST_LEN '+inttostr(i)+' $'+inttohex((D),8));
write6('Connection List Length='+inttostr(examinebits(6,0,byte(d))));
if(d and BIT7)=BIT7 then write6(' Long Form ') else write6(' Short Form');
if(examinebits(6,0,byte(d))=1)then write6(' There is only one hard-wired input possible (read it from the list)');

val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_CONNECT_LIST, 0);
write6('AC_VERB_GET_CONNECT_LIST #$'+inttohex(i,2)+' =$'+inttohex(val,8));
if(d and BIT7)=BIT7 then begin
{long form}
write6(' Long form');
write6('  Connection List Entry N+1 [31:16]=$'+inttohex(examinebits(31,16,val),2));
write6('  Connection List Entry N [15:0]=$'+inttohex(examinebits(15,0,val),2));
end else begin
write6(' Short Form');
write6('  Connection List Entry N+3[31:24]=$'+inttohex(examinebits(31,24,val),2));
write6('  Connection List Entry N+2[23:16] Connectivity[23:16]=$'+inttohex(examinebits(23,16,val),2));
write6('  Connection List Entry N+1[15:8] Connectivity[15:6]=$'+inttohex(examinebits(15,8,val),2));
write6('  Connection List Entry N+0[7:0] Connectivity[7:0]=$'+inttohex(examinebits(7,0,val),2));
end;

write6('');

write6('');

end;
i:=i+1;
end;
memo6.visible:=true;caption:=inttostr(f);


end;

procedure TForm1.Button11Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I,f:longint;
begin
tn:=127;f:=0;clearwig;
I:=0;
memo6.clear;
memo6.visible:=false;
while i<tn do begin
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
if(examinebits(23,20,d)=AC_WID_VOL_KNB)then begin addwig(i);
f:=f+1;
write6('AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' B('+bins32(d)+')');
write6(' Type='+inttostr(examinebits(23,20,d)));
write6(' Delay='+inttostr(examinebits(19,16,(d))));
write6(' Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6(' CP Caps='+Booly(D and BIT12));
write6(' L-R Swap='+Booly(D and BIT11));
write6(' Power Cntrl='+Booly(D and BIT10));
write6(' Digital='+Booly(D and BIT9));
write6(' Conn List='+Booly(D and BIT8));
write6(' Unsol Capable='+Booly(D and BIT7));
write6(' ProcWidget='+Booly(D and BIT6));
write6(' Stripe='+Booly(D and BIT5));
write6(' Format Override='+Booly(D and BIT4));
write6(' Amp Param Override='+Booly(D and BIT3));
write6(' Out Amp Present='+Booly(D and BIT2));
write6(' In Amp Present='+Booly(D and BIT1));
write6(' Chan count='+inttostr((D and BIT0)));
write6('Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));
write6('');

end;
i:=i+1;
end;
memo6.visible:=true;caption:=inttostr(f);


end;

procedure TForm1.Button12Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I,f:longint;
begin
tn:=127;f:=0;clearwig;
I:=0;
memo6.clear;
memo6.visible:=false;
while i<tn do begin
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
if(examinebits(23,20,d)=AC_WID_BEEP)then begin addwig(i);
f:=f+1;
write6('AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' B('+bins32(d)+')');
write6(' Type='+inttostr(examinebits(23,20,d)));
write6(' Delay='+inttostr(examinebits(19,16,(d))));
write6(' Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6(' CP Caps='+Booly(D and BIT12));
write6(' L-R Swap='+Booly(D and BIT11));
write6(' Power Cntrl='+Booly(D and BIT10));
write6(' Digital='+Booly(D and BIT9));
write6(' Conn List='+Booly(D and BIT8));
write6(' Unsol Capable='+Booly(D and BIT7));
write6(' ProcWidget='+Booly(D and BIT6));
write6(' Stripe='+Booly(D and BIT5));
write6(' Format Override='+Booly(D and BIT4));
write6(' Amp Param Override='+Booly(D and BIT3));
write6(' Out Amp Present='+Booly(D and BIT2));
write6(' In Amp Present='+Booly(D and BIT1));
write6(' Chan count='+inttostr((D and BIT0)));
write6('Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));
write6('');

end;
i:=i+1;
end;
memo6.visible:=true;caption:=inttostr(f);


end;

procedure TForm1.Button13Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I,f:longint;
begin
tn:=127;f:=0;clearwig;
I:=0;
memo6.clear;
memo6.visible:=false;
while i<tn do begin
D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_WIDGET_CAP);
if(examinebits(23,20,d)=AC_WID_VENDOR)then begin addwig(i);
f:=f+1;
write6('AC_PAR_AUDIO_WIDGET_CAP widget $' +inttohex(i,2)+ ' B('+bins32(d)+')');
write6('Type='+inttostr(examinebits(23,20,d)));
write6(' Delay='+inttostr(examinebits(19,16,(d))));
write6(' Chann Count Ext='+inttostr(D and (BIT13 or BIT14 or BIT15)));
write6(' CP Caps='+Booly(D and BIT12));
write6(' L-R Swap='+Booly(D and BIT11));
write6(' Power Cntrl='+Booly(D and BIT10));
write6(' Digital='+Booly(D and BIT9));
write6(' Conn List='+Booly(D and BIT8));
write6(' Unsol Capable='+Booly(D and BIT7));
write6(' ProcWidget='+Booly(D and BIT6));
write6(' Stripe='+Booly(D and BIT5));
write6(' Format Override='+Booly(D and BIT4));
write6(' Amp Param Override='+Booly(D and BIT3));
write6(' Out Amp Present='+Booly(D and BIT2));
write6(' In Amp Present='+Booly(D and BIT1));
write6(' Chan count='+inttostr((D and BIT0)));
write6('Total Channels-1='+ (inttostr((examinebits(15,13,D) shl 1) + (d and BIT0))));
write6('');

end;
i:=i+1;
end;
memo6.visible:=true;caption:=inttostr(f);


end;

procedure TForm1.Button17Click(Sender: TObject);
var d:longint;
var tn,sn:longint;
var I:integer;
var val:longint;
begin
memo5.clear;
memo5.visible:=false;
d:=hda_param_read (AC_NODE_ROOT,AC_PAR_NODE_COUNT);
sn:=byte(d shr 16);
tn:=byte(d);



writen('Starting node $'+inttohex(sn,2));
writen('Total nodes $'+inttohex(tn,2));
writen('');

I:=sn-1;
while (i<tn) do begin
i:=i+1;

 d:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_NODE_COUNT);
 myGrpStart:=byte(d shr 16);
 myGrpTotal:=byte(d);
 myGrpStop:=myGrpStart+myGrpTotal;

 writen('Function Group $'+inttohex(i,2));
 writen('AC_NODE_COUNT of node $'+inttohex(i,2));
 writen(' Total Nodes (node $'+inttohex(i,2)+')=$'+inttohex(byte(d),2));
 writen(' Starting Node (node $'+inttohex(i,2)+')=$'+inttohex(byte(d shr 16),2));
 d:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_FUNCTION_TYPE);

 writen('AC_PAR_FUNCTION_TYPE of node '+inttostr(i));
 writen(' Node function type $'+inttohex(byte(d),2));
 if(byte(d)=0)then writemn('= Reserved');
 if(byte(d)=1)then writemn('= Audio Function Group');
 if(byte(d)=2)then writemn('= Vendor Defined Modem Function Group');
 if(byte(d)>$7F)then writemn('= Vendor Defined Function Group');
 writen(' Unsolicited Capable $'+inttohex(byte(d shr 8),2));

 D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_AUDIO_FG_CAP);
 writen('AC_PAR_AUDIO_FG_CAP of node '+inttostr(i));
 if((byte(d shr 16) and (1))=1)then writen(' Optional Beep generator present.') else writen(' No Beep generator.');
 writen(' Input Delay $'+inttohex(examinebits(3,0,byte(D shr 8)),1));
 writen(' Output Delay $'+inttohex(examinebits(3,0,byte(d)),1));


 D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_PCM);{AudFunGrp or Widget}
 writen('AC_PAR_PCM of node '+inttostr(i)+' =$'+inttohex((D),8));

 writen(' Bit rates=');
 if(hiword(d) and BIT0)=BIT0 then writemn(' 8-bit,');
 if(hiword(d) and BIT1)=BIT1 then writemn(' 16-bit,');
 if(hiword(d) and BIT2)=BIT2 then writemn(' 20-bit,');
 if(hiword(d) and BIT3)=BIT3 then writemn(' 24-bit,');
 if(hiword(d) and BIT4)=BIT4 then writemn(' 32-bit,');
 if(hiword(d) and BIT5)=BIT5 then writemn(' XX-bit,');
 writen(' Sample rates=');
 if(byte(d) and BIT0)=BIT0 then writemn(' 8.0khz,');
 if(byte(d) and BIT1)=BIT1 then writemn(' 11.025khz,');
 if(byte(d) and BIT2)=BIT2 then writemn(' 16.0khz,');
 if(byte(d) and BIT3)=BIT3 then writemn(' 22.05khz,');
 if(byte(d) and BIT4)=BIT4 then writemn(' 32.0khz,');
 if(byte(d) and BIT5)=BIT5 then writemn(' 44.1khz,');
 if(byte(d) and BIT6)=BIT6 then writemn(' 48.0khz,');
 if(byte(d) and BIT7)=BIT7 then writemn(' 88.0khz,');
 if(byte(d) and BIT8)=BIT8 then writemn(' 96.0khz,');
 if(byte(d) and BIT9)=BIT9 then writemn(' 176.4khz,');
 if(byte(d) and BIT10)=BIT10 then writemn(' 192.0khz,');
 if(byte(d) and BIT11)=BIT11 then writemn(' 384.0khz,');
 if(byte(d) and BIT12)=BIT12 then writemn('XXX.Xkhz');

 D:=hda_param_read (AC_NODE_ROOT+(i),AC_PAR_STREAM);{AudFunGrp or Widget}
 writen('AC_PAR_STREAM of $'+inttohex(i,2)+'= $'+inttohex((D),8));
 if(d and BIT0)=BIT0 then writen(' Supports PCM');
 if(d and BIT1)=BIT1 then writen(' Supports Float32');
 if(d and BIT2)=BIT2 then writen(' Supports Dolby AC-3');


 D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_AMP_IN_CAP);{AudFunGrp or Widget}
 if(d>0)then writen('AC_PAR_AMP_IN_CAP of $'+inttohex(i,2)+' $'+inttohex((D),8));
 {writen(' Offset='+inttostr(byte(examinebits(6,0,d))));
 writen(' NumSteps='+inttostr(byte(examinebits(14,8,d))));
 writen(' StepSize='+inttostr(byte(examinebits(22,16,d))));
 if(d and BIT31)=BIT31 then writen(' Mute Capable');
}
 D:=hda_param_read (AC_NODE_ROOT+i,AC_PAR_AMP_OUT_CAP);{AudFunGrp or Widget}
 if(d>0)then writen('AC_PAR_AMP_OUT_CAP of $'+inttohex(i,2)+' $'+inttohex((D),8));
 {writen(' Offset='+inttostr(byte(examinebits(6,0,d))));
 writen(' NumSteps='+inttostr(byte(examinebits(14,8,d))));
 writen(' StepSize='+inttostr(byte(examinebits(22,16,d))));
 if(d and BIT31)=BIT31 then writen(' Mute Capable');
 }

 D:=hda_param_read (AC_NODE_ROOT+1,AC_PAR_GPIO_CAP);{FunGrp}
 writen('AC_PAR_GPIO_CAP of $'+inttohex(i,2)+' =$'+inttohex(d,8));
 writen(' NumGPIOs=$'+inttohex(byte(examinebits(7,0,d)),2));
 writen(' NumGPOs=$'+inttohex(byte(examinebits(15,8,d)),2));
 writen(' NumGPIs=$'+inttohex(byte(examinebits(23,16,d)),2));
 if(d and BIT30)=BIT30 then writen(' GPIUnsol');
 if(d and BIT31)=BIT31 then writen(' GPIWake');
 writen('');




{VERB_GET}
writen('AC_VERB_GET_SUBSYSTEM_ID of node '+inttostr(i));
writen(' Implementation Identification');
val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_SUBSYSTEM_ID, 0);
writen(' Board Implementation ID (BID) 31:8=$'+inttohex(longint(val shr 8),6));
writen('   Board Manufacturer Identification (BMID) 31:16=$'+inttohex(word(val shr 16),4));
writen('   Board SKU (BSKU)=$'+inttohex(byte(val shr 8),2));
writen(' Assembly ID(AssyID)=$'+inttohex(byte(val),2));


val:=hda_codec_read(AC_NODE_ROOT+i, 0, AC_VERB_GET_POWER_STATE, 0);
if(val>0)then writen('AC_VERB_GET_POWER_STATE of $'+inttohex(i,2)+' =$'+inttohex(val,8));
if(val>0)then begin
writen(' PS-SettingsReset is in bit 10=$'+inttohex(examinebits(10,10,val),2));
writen(' PS-ClkStopOk=$'+inttohex(examinebits(10,10,val),2));
writen(' PS-Error is in bit 8=$'+inttohex(examinebits(8,8,val),2));
writen(' PS-Act is in bits 7:4=$'+inttohex(examinebits(7,4,val),2));
writen(' PS-Set is in bits 3:0=$'+inttohex(examinebits(3,0,val),2));
end;



writen('');
memo5.visible:=true;
end;

end;


procedure TForm1.Button1Click(Sender: TObject);
var nid:byte;
var res,direct,param:longint;
begin

nid:=strtoint(edit6.text);
direct:=0;
vrb:=strtoint(edit3.text);
param:=strtoint(edit4.text);
res:=hda_codec_write(nid,direct,vrb,param);


lastout:=0;
{nibble 7}lastout:=longint(longint(0 and $F) shl 28);
{nibble 6}lastout:=longint(lastout) or longint(longint(direct) shl 27);
{nibble 5}lastout:=longint(lastout) or longint(longint(nid) shl 20);   {// node ID}
{nibble 2}lastout:=longint(lastout) or longint(longint(vrb) shl 8);   { verb}
{nibble 0}lastout:=longint(lastout) or longint(param);   { parameter}

writen('$'+inttohex(lastout,8)+';write result:$'+inttohex(res,8));
caption:='$'+inttohex(lastout,8);
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
var s:string;
begin
s:=edit3.text;
s[2]:=combobox1.text[2];
s[3]:=combobox1.text[3];
s[4]:=combobox1.text[4];
{s[8]:='0'{combobox1.text[5]};
{s[9]:='0'{combobox1.text[6]};
edit3.text:=s;
end;

procedure TForm1.ComboBox2Change(Sender: TObject);
var s:string;
begin
s:=edit3.text;
s[2]:=combobox2.text[1];{}
audio_pci.codec_index:=combobox2.itemindex;
{edit3.text:=s;{}

end;

procedure TForm1.Button14Click(Sender: TObject);
var nid:byte;
var resa,direct,param:longint;
begin

nid:=strtoint(edit6.text);
direct:=0;
vrb:=strtoint(edit3.text);
param:=strtoint(edit4.text);
resa:=hda_codec_read(nid,direct,vrb,param);
{resa:=hda_codec_read(AC_NODE_ROOT,0,AC_VERB_PARAMETERS,AC_PAR_NODE_COUNT);}

lastout:=0;
{nibble 7}lastout:=longint(longint(0 and $F) shl 28);
{nibble 6}lastout:=longint(lastout) or longint(longint(direct) shl 27);
{nibble 5}lastout:=longint(lastout) or longint(longint(nid) shl 20);   {// node ID}
{nibble 2}lastout:=longint(lastout) or longint(longint(vrb) shl 8);   { verb}
{nibble 0}lastout:=longint(lastout) or longint(param);   { parameter}

{caption:='$'+inttohex(lastout,8);{}
writen('$'+inttohex(lastout,8)+';Read result:$'+inttohex(resa,8));


end;

procedure TForm1.ComboBox3Change(Sender: TObject);
var s:string;
begin
s:=edit4.text;
s[4]:=combobox3.text[5];
s[5]:=combobox3.text[6];
{s[9]:=combobox1.text[6];}
{s[8]:='0'{combobox1.text[5]};
{s[9]:='0'{combobox1.text[6]};
edit4.text:=s;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var outc,a,b,c,d,e:longint;
var x,y,z:byte;
begin
a:=$0003907f;
c:=$0003A07F;
d:=$0003B07F;
e:=$00070100;{connection}
x:=0;
while x<$3B do begin
x:=x+1;
b:=longint(x);
b:=longint(b shl longint(20));
outc:=a or b;
edit4.text:='$'+inttohex(outc,8);
button1click(sender);
repaint;
outc:=longint(c) or b;
edit4.text:='$'+inttohex(outc,8);
button1click(sender);
repaint;
outc:=d or b;
edit4.text:='$'+inttohex(outc,8);
button1click(sender);
repaint;
outc:=e or b;
edit4.text:='$'+inttohex(outc,8);
button1click(sender);
repaint;
end;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
 hda_codec_write(AC_NODE_ROOT+spinedit1.value,0,AC_VERB_SET_AMP_GAIN_MUTE,strtoint(edit1.text));
end;

procedure TForm1.ListBox1Click(Sender: TObject);
begin
 if(listbox1.items.count>1)then begin
  spinedit1.value:=strtoint(listbox1.items[listbox1.itemindex]);
 end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
 hda_codec_write(AC_NODE_ROOT+spinedit1.value,0,AC_VERB_SET_CONNECT_SEL,strtoint(edit1.text));
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
 hda_codec_write(AC_NODE_ROOT+spinedit1.value,0,AC_VERB_SET_POWER_STATE,strtoint(edit1.text));
end;

procedure TForm1.Button15Click(Sender: TObject);
begin
edit1.text:='$'+inttohex(
hda_codec_read(AC_NODE_ROOT+spinedit1.value,0,AC_VERB_GET_AMP_GAIN_MUTE,strtoint(edit1.text))
,2);
end;

procedure TForm1.Button16Click(Sender: TObject);
begin
edit1.text:='$'+inttohex(
hda_codec_read(AC_NODE_ROOT+spinedit1.value,0,AC_VERB_GET_CONNECT_SEL,strtoint(edit1.text))
,2);

end;

procedure TForm1.Button18Click(Sender: TObject);
var x:longint;
begin
  x:=strtoint(edit2.text);
{  x:=longint(x) + longint(longint(inx) shl 4);{}
 hda_codec_write(0,0,0,x);
{form1.caption:=inttohex(x,8);{}
end;

end.
