# AnyKernel3 Ramdisk Mod Script
# osm0sis @ xda-developers
#
# Modded for OrangeFox Recovery
# DarthJabba9 @ xda-developers
# 06 January 2020

#set -o xtrace

## AnyKernel setup
# begin properties
properties() { '
kernel.string=OrangeFox Initd Installer, by DarthJabba9
do.devicecheck=0
do.modules=0
do.cleanup=1
do.cleanuponabort=0
supported.versions=
supported.patchlevels=
'; } # end properties

# shell variables
block=/dev/block/bootdevice/by-name/boot;
is_slot_device=0;
ramdisk_compression=auto;


## AnyKernel methods (DO NOT CHANGE)
# import patching functions/variables - see for reference
. tools/ak3-core.sh;

## AnyKernel file attributes
# set permissions/ownership for included ramdisk files
set_perm_recursive 0 0 755 644 $ramdisk/*;
set_perm_recursive 0 0 750 750 $ramdisk/init* $ramdisk/sbin;

## AnyKernel install
dump_boot;

# begin ramdisk changes

# check for system_root #
THE_ROOT="";
#ls -all /system/
#ls -all /system/etc/
#ls -all /system_root/
#ls -all /system_root/etc/
#ls -all $home
if [ -d "/system_root/system/" -a -d "/system_root/etc/" -a -e "/system_root/init.rc" ]; then
   ui_print "- OrangeFox: detected a system-as-root implementation ";
   echo " " >> /tmp/recovery.log;
   echo "- Mounting /system_root in read-write mode..." >> /tmp/recovery.log;
   THE_ROOT="/system_root";
   mount -o rw,remount $THE_ROOT;
   sleep 1
   THE_ROOT=$THE_ROOT"/";
   echo "- Copying files manually..." >> /tmp/recovery.log;
   cp -fp $home/ramdisk/init.dj9.rc $THE_ROOT;
   cp -af $home/ramdisk/sbin/ $THE_ROOT;
   cd $THE_ROOT;
else
   echo "- NOT system-as-root ..." >> /tmp/recovery.log;
fi
# end: system-as-root #

# init.rc
backup_file "$THE_ROOT"init.rc;
insert_line "$THE_ROOT"init.rc "init.dj9.rc" before "on early-init" "import /init.dj9.rc";

# end ramdisk changes

write_boot;
## end install

