/*
 * Decompiled with CFR 0.152.
 */
package GUI.development;

import CASUAL.AudioHandler;
import CASUAL.CASUALConnectionStatusMonitor;
import CASUAL.CASUALMain;
import CASUAL.CASUALMessageObject;
import CASUAL.CASUALScriptParser;
import CASUAL.CASUALStartupTasks;
import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.Statics;
import CASUAL.archiving.Unzip;
import CASUAL.caspac.Caspac;
import CASUAL.caspac.Script;
import CASUAL.communicationstools.adb.ADBTools;
import CASUAL.iCASUALUI;
import CASUAL.misc.CASUALScrFilter;
import CASUAL.network.LinkLauncher;
import GUI.development.CASUALJFrameAboutBox;
import GUI.development.CASUALJFrameDeveloperInstructions;
import GUI.development.CASUALJFrameLog;
import GUI.development.TimeOutOptionPane;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class CASUALGUIMain
extends JFrame
implements iCASUALUI {
    private static final long serialVersionUID = 1L;
    private boolean isReady = false;
    private boolean isDummyGUI = false;
    Caspac caspac;
    String nonResourceFileName;
    FileOperations fileOperations = new FileOperations();
    private String ComboBoxValue = "";
    boolean buttonEnableStage = false;
    private JButton DonateButton;
    private JFileChooser FileChooser1;
    private JMenuItem MenuItemExit;
    private JMenuItem MenuItemOpenScript;
    private JMenuItem MenuItemShowAboutBox;
    private JMenuItem MenuItemShowDeveloperPane;
    private JTextPane ProgressArea;
    private JLabel StatusLabel;
    private JComboBox<String> comboBoxScriptSelector;
    private JScrollPane informationScrollPanel;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JProgressBar progressBar;
    private JButton startButton;
    private JLabel windowBanner;
    long time = System.currentTimeMillis();

    public CASUALGUIMain() {
        this.notificationCASUALSound();
        this.initComponents();
        this.ProgressArea.setText(Statics.PreProgress + this.ProgressArea.getText());
        CASUALStartupTasks.lockGUIformPrep = false;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                CASUALMain.shutdown(0);
            }
        });
    }

    private void initComponents() {
        this.FileChooser1 = new JFileChooser();
        this.windowBanner = new JLabel();
        this.comboBoxScriptSelector = new JComboBox();
        this.startButton = new JButton();
        this.DonateButton = new JButton();
        this.jPanel1 = new JPanel();
        this.progressBar = new JProgressBar();
        this.StatusLabel = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.informationScrollPanel = new JScrollPane();
        this.ProgressArea = new JTextPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.MenuItemOpenScript = new JMenuItem();
        this.MenuItemExit = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.MenuItemShowDeveloperPane = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.MenuItemShowAboutBox = new JMenuItem();
        this.FileChooser1.setDialogTitle("Select a CASUAL \"scr\" file");
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CASUALGUIMain.this.formWindowClosing(evt);
            }
        });
        this.windowBanner.setFont(new Font("Ubuntu", 0, 36));
        this.windowBanner.setText("loading.. please wait");
        this.comboBoxScriptSelector.setEnabled(false);
        this.comboBoxScriptSelector.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                CASUALGUIMain.this.comboBoxScriptSelectorPopupMenuWillBecomeInvisible(evt);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }
        });
        this.comboBoxScriptSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CASUALGUIMain.this.comboBoxScriptSelectorActionPerformed(evt);
            }
        });
        this.startButton.setText("Do It!");
        this.startButton.setEnabled(false);
        this.startButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CASUALGUIMain.this.startButtonMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CASUALGUIMain.this.startButtonMouseExited(evt);
            }
        });
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CASUALGUIMain.this.startButtonActionPerformed(evt);
            }
        });
        this.DonateButton.setText("Donate");
        this.DonateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CASUALGUIMain.this.DonateButtonActionPerformed(evt);
            }
        });
        this.StatusLabel.setFont(new Font("Ubuntu", 0, 20));
        this.StatusLabel.setIcon(new ImageIcon(this.getClass().getResource("/GUI/development/resources/images/DeviceDisconnected.png")));
        this.StatusLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CASUALGUIMain.this.StatusLabelMouseClicked(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                CASUALGUIMain.this.StatusLabelMouseExited(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.StatusLabel, -2, 300, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE)).addComponent(this.jSeparator1)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jSeparator1, -2, 6, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.StatusLabel, -2, 26, -2).addComponent(this.progressBar, -2, -1, -2)).addContainerGap()));
        this.informationScrollPanel.setBorder(BorderFactory.createTitledBorder(null, "Important Information", 0, 0, new Font("Ubuntu", 1, 10)));
        this.ProgressArea.setCursor(new Cursor(2));
        this.informationScrollPanel.setViewportView(this.ProgressArea);
        this.jMenu1.setText("File");
        this.MenuItemOpenScript.setAccelerator(KeyStroke.getKeyStroke(79, 1));
        this.MenuItemOpenScript.setText("Open CASUAL script");
        this.MenuItemOpenScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CASUALGUIMain.this.MenuItemOpenScriptActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.MenuItemOpenScript);
        this.MenuItemExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.MenuItemExit.setText("Exit");
        this.MenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CASUALGUIMain.this.MenuItemExitActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.MenuItemExit);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("About");
        this.MenuItemShowDeveloperPane.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        this.MenuItemShowDeveloperPane.setText("Developing A Script");
        this.MenuItemShowDeveloperPane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CASUALGUIMain.this.MenuItemShowDeveloperPaneActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.MenuItemShowDeveloperPane);
        this.jMenuItem1.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.jMenuItem1.setText("Show Log");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CASUALGUIMain.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem1);
        this.MenuItemShowAboutBox.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.MenuItemShowAboutBox.setText("About");
        this.MenuItemShowAboutBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CASUALGUIMain.this.MenuItemShowAboutBoxActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.MenuItemShowAboutBox);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.windowBanner, -1, 513, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.comboBoxScriptSelector, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.startButton, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.DonateButton)).addComponent(this.informationScrollPanel)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.windowBanner, -2, 61, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.informationScrollPanel, -1, 432, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoxScriptSelector, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startButton).addComponent(this.DonateButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, 41, -2).addGap(1, 1, 1)));
        this.pack();
    }

    @Override
    public void StartButtonActionPerformed() {
        Log.level4Debug("StartButtonActionPerformed() Script Activated");
        Log.level4Debug("Script known as " + this.comboBoxScriptSelector.getSelectedItem().toString() + " is running");
        CASUALConnectionStatusMonitor.stop();
        this.setControlStatus(false);
        String script = this.comboBoxScriptSelector.getSelectedItem().toString();
        if (Statics.CASPAC.getActiveScript().extractionMethod != 2) {
            Log.level4Debug("Loading internal resource: " + script);
            Statics.CASPAC.getActiveScript().scriptContinue = true;
            new CASUALScriptParser().executeSelectedScript(this.caspac, true);
        }
    }

    @Override
    public void setProgressBar(int value) {
        this.progressBar.setValue(value);
        this.repaint();
    }

    @Override
    public void setProgressBarMax(int value) {
        this.progressBar.setMaximum(value);
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        this.StartButtonActionPerformed();
    }

    private void MenuItemShowDeveloperPaneActionPerformed(ActionEvent evt) {
        CASUALJFrameDeveloperInstructions CDI = new CASUALJFrameDeveloperInstructions();
        CDI.setVisible(true);
    }

    private void MenuItemOpenScriptActionPerformed(ActionEvent evt) {
        this.FileChooser1.setDialogTitle("Select a CASUAL \"scr\" file");
        this.FileChooser1.setFileFilter(new CASUALScrFilter());
        int returnVal = this.FileChooser1.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                CASUALConnectionStatusMonitor.stop();
                this.setControlStatus(false);
                String FileName = this.FileChooser1.getSelectedFile().getCanonicalPath();
                this.nonResourceFileName = this.getFilenameWithoutExtension(FileName);
                Log.level2Information("Description for " + this.nonResourceFileName);
                try {
                    Log.level2Information(this.fileOperations.readFile(this.nonResourceFileName + ".txt"));
                }
                catch (Exception e) {
                    Log.level2Information("@textResourceNotFound");
                }
                this.comboBoxScriptSelector.setSelectedItem(this.nonResourceFileName);
                Statics.SelectedScriptFolder = Statics.getTempFolder() + new File(this.nonResourceFileName).getName() + Statics.slash;
                if (new File(this.nonResourceFileName.toString() + ".zip").exists()) {
                    new Unzip(this.nonResourceFileName.toString() + ".zip").unzipFile(Statics.SelectedScriptFolder);
                }
                Statics.ScriptLocation = Statics.SelectedScriptFolder;
                this.comboBoxScriptSelector.setEditable(true);
                this.ComboBoxValue = this.getFilenameWithoutExtension(FileName);
                this.comboBoxScriptSelector.setSelectedItem(this.ComboBoxValue);
                this.comboBoxScriptSelector.setEditable(false);
                CASUALConnectionStatusMonitor.resumeAfterStop();
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
            }
        }
    }

    private void MenuItemShowAboutBoxActionPerformed(ActionEvent evt) {
        CASUALJFrameAboutBox CAB = new CASUALJFrameAboutBox();
        CAB.setVisible(true);
    }

    private void MenuItemExitActionPerformed(ActionEvent evt) {
        CASUALMain.shutdown(0);
    }

    private void DonateButtonActionPerformed(ActionEvent evt) {
        this.setInformationScrollBorderText("Donate");
        int DResult = new CASUALMessageObject("Donate to the developers", "This application was developed by " + this.caspac.build.developerName + " using CASUAL framework.\n" + "Donations give developers a tangeble reason to continue quality software development\n").showTimeoutDialog(60, null, 0, 1, new String[]{"Donate To CASUAL", "Donate To " + this.caspac.build.developerName}, "No");
        if (DResult == 0) {
            CASUALGUIMain.launchLink("https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=ZYM99W5RHRY3Y");
        } else if (DResult == 1) {
            CASUALGUIMain.launchLink(this.caspac.build.donateLink);
        }
    }

    private void comboBoxScriptSelectorPopupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        CASUALConnectionStatusMonitor.stop();
        this.setControlStatus(false);
        CASUALStartupTasks.lockGUIunzip = true;
        String selectedScript = this.comboBoxScriptSelector.getSelectedItem().toString();
        Log.level4Debug("hiding script selector TargetScript: " + selectedScript);
        this.caspac.setActiveScript(this.caspac.getScriptByName(selectedScript));
        Log.level2Information(this.caspac.getActiveScript().discription);
        this.caspac.startAndWaitForUnzip();
        CASUALStartupTasks.lockGUIunzip = false;
        CASUALConnectionStatusMonitor.resumeAfterStop();
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        CASUALJFrameLog CASUALLogJFrame = new CASUALJFrameLog();
        CASUALLogJFrame.setVisible(true);
    }

    private void formWindowClosing(WindowEvent evt) {
        CASUALConnectionStatusMonitor.stop();
        new ADBTools().reset();
    }

    private void startButtonMouseClicked(MouseEvent evt) {
    }

    private void startButtonMouseExited(MouseEvent evt) {
    }

    private void StatusLabelMouseClicked(MouseEvent evt) {
        if (this.buttonEnableStage) {
            Log.level4Debug("Control system override active.  User has manually enabled controls");
            this.startButton.setEnabled(this.buttonEnableStage);
            this.comboBoxScriptSelector.setEnabled(this.buttonEnableStage);
            this.startButton.setText(ResourceBundle.getBundle("SCRIPTS/-build").getString("Window.ExecuteButtonText"));
            this.buttonEnableStage = false;
        }
        if (!this.startButton.isEnabled() && !CASUALStartupTasks.lockGUIformPrep) {
            Log.level4Debug("Control system override clicked");
            this.startButton.setText("Click again to enable all controls");
            this.buttonEnableStage = true;
        }
    }

    private void StatusLabelMouseExited(MouseEvent evt) {
        try {
            this.startButton.setText(ResourceBundle.getBundle("SCRIPTS/-build").getString("Window.ExecuteButtonText"));
        }
        catch (MissingResourceException ex) {
            try {
                this.startButton.setText(ResourceBundle.getBundle("SCRIPTS\\-build").getString("Window.ExecuteButtonText"));
            }
            catch (MissingResourceException er) {
                this.startButton.setText(Statics.CASPAC.build.executeButtonText);
            }
        }
        this.buttonEnableStage = false;
    }

    private void comboBoxScriptSelectorActionPerformed(ActionEvent evt) {
    }

    private static void launchLink(String Link) {
        new LinkLauncher(Link).launch();
    }

    @Override
    public void setStatusLabelIcon(String Icon2, String Text) {
        this.StatusLabel.setIcon(this.createImageIcon(Icon2, Text));
    }

    protected ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    private String getFilenameWithoutExtension(String FileName) {
        if (FileName.endsWith(".scr")) {
            FileName = FileName.replace(".scr", "");
        }
        return FileName;
    }

    @Override
    public void setStatusMessageLabel(String text) {
        this.StatusLabel.setText(text);
    }

    @Override
    public boolean getControlStatus() {
        return this.startButton.isEnabled() && this.comboBoxScriptSelector.isEnabled();
    }

    @Override
    public boolean setControlStatus(boolean status) {
        if (!CASUALStartupTasks.scriptRunLock.isComplete()) {
            return false;
        }
        if (this.caspac != null && this.caspac.build.alwaysEnableControls) {
            status = true;
            this.startButton.setEnabled(status);
            this.comboBoxScriptSelector.setEnabled(status);
            return true;
        }
        if (!CASUALStartupTasks.lockGUIformPrep) {
            if (!CASUALStartupTasks.lockGUIunzip) {
                if (!CASUALStartupTasks.scriptRunLock.isAlive()) {
                    this.startButton.setEnabled(status);
                    this.comboBoxScriptSelector.setEnabled(status);
                    Log.level4Debug("Controls Enabled status: " + status);
                } else {
                    Log.level4Debug("Control Change requested but script is running");
                }
            } else {
                Log.level4Debug("Control Change requested but unzip has not yet finished");
            }
        } else {
            Log.level4Debug("Control Change requested but GUI is not ready is set.");
        }
        return this.checkGUIStatus(status);
    }

    private boolean checkGUIStatus(boolean expectedStatus) {
        if (Statics.isGUIIsAvailable()) {
            return expectedStatus == Statics.GUI.getControlStatus();
        }
        return !Statics.isGUIIsAvailable();
    }

    @Override
    public void setWindowBannerText(String text) {
        this.windowBanner.setText(text);
    }

    @Override
    public void setStartButtonText(String text) {
        this.startButton.setText(text);
    }

    public void setWindowBannerImage(BufferedImage icon, String text) {
        this.windowBanner.setIcon(new ImageIcon(icon, text));
    }

    public void windowCosing(WindowEvent e) {
        CASUALMain.shutdown(0);
    }

    @Override
    public void setScript(Script s) {
    }

    @Override
    public void setCASPAC(Caspac caspac) {
        this.setInformationScrollBorderText("Important Information");
        this.caspac = caspac;
        this.isReady = true;
        Log.level2Information(caspac.overview);
        if (caspac.build.alwaysEnableControls) {
            this.setControlStatus(true);
        }
        if (caspac.scripts.size() > 0) {
            for (Script s : caspac.scripts) {
                boolean addScript = true;
                for (int i = 0; i < this.comboBoxScriptSelector.getItemCount(); ++i) {
                    if (!this.comboBoxScriptSelector.getItemAt(i).equals(s.name)) continue;
                    addScript = false;
                }
                if (addScript) {
                    this.comboBoxScriptSelector.addItem(s.name);
                }
                Log.level4Debug("adding " + s.name + " to UI");
            }
            if (caspac.getActiveScript() != null) {
                this.comboBoxScriptSelector.setSelectedItem(caspac.getActiveScript().name);
                Log.level2Information(caspac.getScriptByName((String)this.comboBoxScriptSelector.getSelectedItem().toString()).discription);
            }
        }
        if (this.comboBoxScriptSelector.getItemCount() < 1) {
            // empty if block
        }
        this.startButton.setText(caspac.build.executeButtonText);
        this.setWindowBannerText("");
        if (caspac.logo != null && caspac.logo.getMinX() < 40) {
            this.setWindowBannerImage(caspac.logo, caspac.build.bannerText);
        } else {
            this.setWindowBannerText(caspac.build.bannerText);
        }
    }

    @Override
    public void setInformationScrollBorderText(String title) {
        Border b = this.informationScrollPanel.getBorder();
        ((TitledBorder)b).setTitle(title);
        if (System.currentTimeMillis() > this.time + 100L) {
            this.repaint();
            this.time = System.currentTimeMillis();
        }
    }

    public void setVisibile(boolean v) {
        this.setVisible(v);
    }

    @Override
    public void deviceConnected(String mode) {
        this.setStatusLabelIcon("/GUI/development/resources/images/DeviceConnected.png", "Device Connected");
        this.setStatusMessageLabel("Target Acquired");
        AudioHandler.playSound("/GUI/development/resources/sounds/Connected-SystemReady.wav");
    }

    @Override
    public void deviceDisconnected() {
        this.setStatusLabelIcon("/GUI/development/resources/images/DeviceDisconnected.png", "Device Not Detected");
        AudioHandler.playSound("/GUI/development/resources/sounds/Disconnected.wav");
    }

    @Override
    public void deviceMultipleConnected(int numberOfDevicesConnected) {
        this.setStatusLabelIcon("/GUI/development/resources/images/TooManyDevices.png", "Target Acquired");
        String[] URLs = new String[]{"/GUI/development/resources/sounds/" + String.valueOf(numberOfDevicesConnected) + ".wav", "/GUI/development/resources/sounds/DevicesDetected.wav"};
        AudioHandler.playMultipleInputStreams(URLs);
    }

    public void notificationCASUALSound() {
        AudioHandler.playSound("/GUI/development/resources/sounds/CASUAL.wav");
    }

    @Override
    public String displayMessage(CASUALMessageObject messageObject) {
        int messageType = messageObject.getMessageType();
        String title = messageObject.title;
        String messageText = messageObject.messageText;
        String retval = "";
        Log.Level1Interaction(messageObject.toString());
        switch (messageType) {
            case 0: {
                return this.showTimeOutInteraction(messageObject, messageText, title);
            }
            case 1: {
                AudioHandler.playSound("/GUI/development/resources/sounds/UserActionIsRequired.wav");
                return this.showActionRequiredInteraction(messageText, title);
            }
            case 2: {
                AudioHandler.playSound("/GUI/development/resources/sounds/RequestToContinue.wav");
                return this.showUserCancelOptionInteraction(title, messageText);
            }
            case 3: {
                AudioHandler.playSound("/GUI/development/resources/sounds/Notification.wav");
                this.showUserNotificationInteraction(title, messageText);
                break;
            }
            case 4: {
                this.showInformationInteraction(messageText, title);
                break;
            }
            case 5: {
                this.showErrorInteraction(messageText, title);
                break;
            }
            case 6: {
                return this.showYesNoInteraction(title, messageText);
            }
            case 7: {
                AudioHandler.playSound("/GUI/development/resources/sounds/InputRequested.wav");
                return this.showInputDialog(title, messageText);
            }
            case 8: {
                this.showUserNotificationInteraction(title, messageText);
                return messageText;
            }
        }
        return retval;
    }

    public String getCommandLineInput() {
        try {
            Log.out.flush();
            String s = Statics.in.readLine();
            if (s == null) {
                while (s == null) {
                    s = Statics.in.readLine();
                }
            }
            return s;
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
            return "";
        }
    }

    private void waitForStandardInputBeforeContinuing() {
        this.getCommandLineInput();
    }

    private String showTimeOutInteraction(CASUALMessageObject messageObject, String messageText, String title) {
        if (Statics.isGUIIsAvailable() && !this.isDummyGUI) {
            return Integer.toString(new TimeOutOptionPane().timeoutDialog(messageObject.timeoutPresetTime, (Component)((Object)Statics.GUI), messageText, title, messageObject.timeoutOptionType, messageObject.timeoutMessageType, messageObject.timeoutOptions, messageObject.timeoutInitialValue));
        }
        Log.Level1Interaction("[STANDARDMESSAGE]" + title + "\n" + messageText + "\n[RESPONSEEXPECTED]");
        String s = this.getCommandLineInput();
        if (s == null || s.equals("")) {
            return "0";
        }
        return "1";
    }

    private String showActionRequiredInteraction(String messageText, String title) throws HeadlessException {
        Log.level4Debug("Displaying Action Is Required Dialog:" + messageText);
        int n = 9999;
        if (Statics.isGUIIsAvailable() && !this.isDummyGUI) {
            Object[] Options = new Object[]{"I did it", "I didn't do it"};
            messageText = "<html>" + messageText.replace("\\n", "<BR>");
            n = JOptionPane.showOptionDialog((Component)((Object)Statics.GUI), messageText, "Dont click through this!", 0, 3, null, Options, Options[1]);
        } else {
            while (n != 0 && n != 1) {
                Log.Level1Interaction("[ACTIONREQUIRED][Q or RETURN]" + title + "\n" + messageText + "\npress Q to quit" + "\n[RESPONSEEXPECTED]");
                String retval = this.getCommandLineInput();
                if (!(retval.equals("q") || retval.equals("Q") || retval.equals(""))) {
                    n = new CASUALMessageObject(messageText).showActionRequiredDialog();
                    continue;
                }
                if (retval.equals("Q") || retval.equals("q")) {
                    n = 1;
                    continue;
                }
                n = 0;
            }
        }
        return Integer.toString(n);
    }

    private String showUserCancelOptionInteraction(String title, String messageText) throws HeadlessException {
        int cancelReturn;
        Object[] Options = new Object[]{"Continue", "Stop"};
        if (Statics.isGUIIsAvailable() && !this.isDummyGUI) {
            cancelReturn = title == null ? JOptionPane.showOptionDialog((Component)((Object)Statics.GUI), messageText, "Do you wish to continue?", 0, 3, null, Options, Options[1]) : JOptionPane.showOptionDialog((Component)((Object)Statics.GUI), messageText, title, 0, 3, null, Options, Options[1]);
        } else {
            Log.Level1Interaction("[CANCELOPTION][Q or RETURN]" + title + "\n" + messageText + "\npress Q to quit" + "\n[RESPONSEEXPECTED]");
            String s = this.getCommandLineInput();
            cancelReturn = s.equals("q") || s.equals("Q") ? 1 : 0;
        }
        return Integer.toString(cancelReturn);
    }

    private void showUserNotificationInteraction(String title, String messageText) throws HeadlessException {
        Log.level4Debug("Showing User Notification Dialog -Title:" + title + " -message:" + messageText);
        if (Statics.isGUIIsAvailable() && !this.isDummyGUI) {
            if (title != null) {
                JOptionPane.showMessageDialog((Component)((Object)Statics.GUI), messageText, title, 1);
            } else {
                JOptionPane.showMessageDialog((Component)((Object)Statics.GUI), messageText, "Information", 1);
            }
        } else {
            Log.Level1Interaction("[NOTIFICATION][RETURN]" + title + "\n" + messageText + "  Press any key to continue." + "\n[RESPONSEEXPECTED]");
            this.waitForStandardInputBeforeContinuing();
        }
    }

    private void showInformationInteraction(String messageText, String title) throws HeadlessException {
        if (Statics.isGUIIsAvailable() && !this.isDummyGUI) {
            JOptionPane.showMessageDialog((Component)((Object)Statics.GUI), messageText, title, 1);
        } else {
            Log.Level1Interaction("[INFOMESSAGE][RETURN]" + title + "\n" + messageText + "  Press any key to continue." + "\n[RESPONSEEXPECTED]");
            this.waitForStandardInputBeforeContinuing();
        }
    }

    private void showErrorInteraction(String messageText, String title) throws HeadlessException {
        if (Statics.isGUIIsAvailable() && !this.isDummyGUI) {
            JOptionPane.showMessageDialog((Component)((Object)Statics.GUI), messageText, title, 0);
        } else {
            Log.Level1Interaction("[ERRORMESSAGE][RETURN]" + title + "\n" + messageText + "  Press any key to continue." + "\n[RESPONSEEXPECTED]");
            this.waitForStandardInputBeforeContinuing();
        }
    }

    private String showYesNoInteraction(String title, String messageText) throws HeadlessException {
        Log.level4Debug("Displaying Yes/No Dialog: " + title + " message: " + messageText + "\n[RESPONSEEXPECTED]");
        if (Statics.isGUIIsAvailable() && !this.isDummyGUI) {
            if (title == null) {
                title = "Yes or No";
            }
            boolean val = JOptionPane.showConfirmDialog((Component)((Object)Statics.GUI), messageText, title, 0) == 0;
            return val ? "true" : "false";
        }
        title = title == null ? "" : title + "\n";
        Log.Level1Interaction("[YESNOOPTION][RETURN or n]" + title + "\n" + messageText + "\npress N for no" + "\n[RESPONSEEXPECTED]");
        String s = this.getCommandLineInput();
        if (s.equals("n") || s.equals("N")) {
            return "false";
        }
        return "true";
    }

    private String showInputDialog(String title, String messageText) throws HeadlessException {
        Log.level4Debug("Requesting User Input.. Title:" + title + " -message:" + messageText + "\n[RESPONSEEXPECTED]");
        messageText = "<html>" + messageText.replace("\\n", "\n");
        if (Statics.isGUIIsAvailable() && !this.isDummyGUI) {
            if (title == null) {
                return JOptionPane.showInputDialog((Component)((Object)Statics.GUI), messageText, "Input Required", 3);
            }
            return JOptionPane.showInputDialog((Component)((Object)Statics.GUI), messageText, title, 3);
        }
        Log.Level1Interaction("[INPUT][ANY]" + title + messageText + "\n input:");
        return this.getCommandLineInput();
    }

    @Override
    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public boolean isDummyGUI() {
        return this.isDummyGUI;
    }

    @Override
    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    @Override
    public void setBlocksUnzipped(int i) {
        this.setInformationScrollBorderText("Unzipping:" + i);
    }

    @Override
    public void sendString(String string) {
        this.ProgressArea.setText(this.ProgressArea.getText().concat(string));
    }

    @Override
    public void sendProgress(String data) {
        char[] dataArray = data.toCharArray();
        String doc = this.ProgressArea.getText();
        block3: for (char c : dataArray) {
            switch (c) {
                case '\b': {
                    doc = doc.substring(0, doc.length() - 1);
                    continue block3;
                }
                default: {
                    doc = doc.concat(data);
                }
            }
        }
        this.ProgressArea.setText(doc);
    }
}

