/*
 * Decompiled with CFR 0.152.
 */
package GUI.CommandLine;

import CASUAL.CASUALMessageObject;
import CASUAL.Log;
import CASUAL.Statics;
import CASUAL.caspac.Caspac;
import CASUAL.caspac.Script;
import CASUAL.iCASUALUI;
import java.awt.HeadlessException;
import java.io.IOException;

public class CommandLineUI
implements iCASUALUI {
    private int progressMax = 0;

    private void msg(String msg) {
        Log.level3Verbose("[UI]" + msg);
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void setReady(boolean ready) {
        this.msg("ready requested");
    }

    @Override
    public boolean isDummyGUI() {
        this.msg("is dummy gui requested");
        return false;
    }

    @Override
    public String displayMessage(CASUALMessageObject messageObject) {
        int messageType = messageObject.getMessageType();
        String title = messageObject.title;
        String messageText = messageObject.messageText;
        String retval = "";
        Log.Level1Interaction(messageObject.toString());
        switch (messageType) {
            case 0: {
                return this.showTimeOutInteraction(messageObject, messageText, title);
            }
            case 1: {
                return this.showActionRequiredInteraction(messageText, title);
            }
            case 2: {
                return this.showUserCancelOptionInteraction(title, messageText);
            }
            case 3: {
                this.showUserNotificationInteraction(title, messageText);
                break;
            }
            case 4: {
                this.showInformationInteraction(messageText, title);
                break;
            }
            case 5: {
                this.showErrorInteraction(messageText, title);
                break;
            }
            case 6: {
                return this.showYesNoInteraction(title, messageText);
            }
            case 7: {
                return this.showInputDialog(title, messageText);
            }
            case 8: {
                this.showUserNotificationInteraction(title, messageText);
                return messageText;
            }
        }
        return retval;
    }

    public String getCommandLineInput() {
        try {
            Log.out.flush();
            String s = Statics.in.readLine();
            if (s == null) {
                while (s == null) {
                    s = Statics.in.readLine();
                }
            }
            return s;
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
            return "";
        }
    }

    private void waitForStandardInputBeforeContinuing() {
        this.getCommandLineInput();
    }

    private String showTimeOutInteraction(CASUALMessageObject messageObject, String messageText, String title) {
        String s = this.getCommandLineInput();
        if (s == null || s.equals("")) {
            return "0";
        }
        return "1";
    }

    private String showActionRequiredInteraction(String messageText, String title) throws HeadlessException {
        int n = 9999;
        while (n != 0 && n != 1) {
            String retval = this.getCommandLineInput();
            if (!(retval.equals("q") || retval.equals("Q") || retval.equals(""))) {
                n = new CASUALMessageObject(messageText).showActionRequiredDialog();
                continue;
            }
            if (retval.equals("Q") || retval.equals("q")) {
                n = 1;
                continue;
            }
            n = 0;
        }
        return Integer.toString(n);
    }

    private String showUserCancelOptionInteraction(String title, String messageText) throws HeadlessException {
        String s = this.getCommandLineInput();
        int cancelReturn = s.equals("q") || s.equals("Q") ? 1 : 0;
        return Integer.toString(cancelReturn);
    }

    private void showUserNotificationInteraction(String title, String messageText) throws HeadlessException {
        this.waitForStandardInputBeforeContinuing();
    }

    private void showInformationInteraction(String messageText, String title) throws HeadlessException {
        this.waitForStandardInputBeforeContinuing();
    }

    private void showErrorInteraction(String messageText, String title) throws HeadlessException {
        this.waitForStandardInputBeforeContinuing();
    }

    private String showYesNoInteraction(String title, String messageText) throws HeadlessException {
        String s = this.getCommandLineInput();
        if (s.equals("n") || s.equals("N")) {
            return "false";
        }
        return "true";
    }

    private String showInputDialog(String title, String messageText) throws HeadlessException {
        messageText = "<html>" + messageText.replace("\\n", "\n");
        return this.getCommandLineInput();
    }

    @Override
    public void dispose() {
        this.msg("Dispose Commanded");
    }

    @Override
    public void StartButtonActionPerformed() {
    }

    @Override
    public boolean setControlStatus(boolean status) {
        this.msg("control status requested:" + status);
        return status;
    }

    @Override
    public boolean getControlStatus() {
        return true;
    }

    @Override
    public void setCASPAC(Caspac caspac) {
        this.msg("Setting caspac" + caspac);
        Statics.CASPAC = caspac;
    }

    @Override
    public void setInformationScrollBorderText(String title) {
        this.msg("boarder title change requested:" + title);
    }

    @Override
    public void setProgressBar(int value) {
        this.msg("Progress percent:" + value);
    }

    @Override
    public void setProgressBarMax(int value) {
        this.msg("Progress bar max" + value);
        this.progressMax = value;
    }

    @Override
    public void setScript(Script s) {
    }

    @Override
    public void setStartButtonText(String text) {
    }

    @Override
    public void setStatusLabelIcon(String Icon, String text) {
        this.msg("Status Label " + text);
    }

    @Override
    public void setStatusMessageLabel(String text) {
    }

    @Override
    public void setWindowBannerText(String text) {
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public void deviceConnected(String mode) {
        this.msg("Device connected");
    }

    @Override
    public void deviceDisconnected() {
    }

    @Override
    public void deviceMultipleConnected(int numberOfDevicesConnected) {
    }

    public void setThisAsGUI() {
        Statics.GUI = this;
    }

    @Override
    public void setBlocksUnzipped(int blocks) {
        this.msg("Progress percent:" + blocks);
    }

    @Override
    public void sendString(String string) {
    }

    @Override
    public void sendProgress(String data) {
    }
}

