/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.network;

import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.Shell;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class LinkLauncher {
    final String link;
    private final Runnable launcher = new Runnable(){

        @Override
        public void run() {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    URI uri = new URI(LinkLauncher.this.link);
                    desktop.browse(uri);
                }
                catch (IOException ioe) {
                    Log.level4Debug("Attempted to open" + LinkLauncher.this.link + " Failed with IO error");
                }
                catch (URISyntaxException use) {
                    Log.level4Debug("Attempted to open" + LinkLauncher.this.link + " Failed with URI Syntax error");
                }
            } else {
                Shell Shell2 = new Shell();
                if (OSTools.isMac()) {
                    Shell2.sendShellCommand(new String[]{"open", LinkLauncher.this.link});
                } else {
                    String retval = Shell2.sendShellCommand(new String[]{"firefox", LinkLauncher.this.link});
                    if (retval.contains("CritERROR!!!")) {
                        Shell2.sendShellCommand(new String[]{"chrome", LinkLauncher.this.link});
                        if (retval.contains("CritERROR!!!")) {
                            Shell2.sendShellCommand(new String[]{"explorer", LinkLauncher.this.link});
                        }
                    }
                }
            }
        }
    };

    public LinkLauncher(String link) {
        this.link = link;
    }

    public void launch() {
        Thread thread = new Thread(this.launcher);
        thread.setName("Link Launcher Thread");
        thread.start();
    }
}

