/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.network.CFAutoroot;

import CASUAL.Log;
import CASUAL.misc.StringOperations;
import CASUAL.network.CFAutoroot.CFAutorootTableException;
import CASUAL.network.CFAutoroot.Device;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

public class CFAutoRootDb {
    final Properties BUILDPROP = new Properties();
    private final ArrayList<Device> deviceList = new ArrayList();
    String defaultValue = "Value was not obtainable.  Cannot find value";

    CFAutoRootDb(String BuildProp) throws URISyntaxException, IOException, MalformedURLException, CFAutorootTableException {
        this.BUILDPROP.load(new StringReader(BuildProp));
        this.grabTable();
    }

    public String returnForMyDevice() {
        for (Device device : this.deviceList) {
            if (!device.oem.equals(this.buildProp("ro.product.manufacturer")) || !device.model.equals(this.buildProp("ro.product.model")) || !device.name.equals(this.buildProp("ro.product.name")) || !device.device.equals(this.buildProp("ro.product.device")) || !device.board.equals(this.buildProp("ro.product.board")) || !this.BUILDPROP.getProperty("ro.board.platform").equals(device.platform)) continue;
            System.out.println("located a " + device.oem + ", model:" + device.model + ", device:" + device.device);
            System.out.println(device.download);
            return device.download + "?retrieve_file=1";
        }
        Log.level2Information("Found nothing available for your device on http://autoroot.chainfire.eu/");
        return "";
    }

    private String buildProp(String propName) {
        return this.BUILDPROP.getProperty(propName, this.defaultValue);
    }

    private void grabTable() throws MalformedURLException, URISyntaxException, IOException, CFAutorootTableException {
        URI uri = new URI("http", "autoroot.chainfire.eu", "/", "", null);
        URL url = new URL(uri.toASCIIString());
        String page = StringOperations.convertStreamToString(url.openStream());
        page = page.substring(page.indexOf("<table>"), page.length());
        page = page.substring(0, page.indexOf("</table>") + 8) + "\n";
        BufferedReader br = new BufferedReader(new StringReader(page));
        int trcount = 0;
        while (trcount < 2) {
            if (!br.readLine().contains("<tr>")) continue;
            while (trcount == 1) {
                if (!br.readLine().contains("OEM")) {
                    throw new CFAutorootTableException("OEM tables On autoroot.chainfire.eu changed");
                }
                if (!br.readLine().contains("Model")) {
                    throw new CFAutorootTableException("Model tables On autoroot.chainfire.eu changed");
                }
                if (!br.readLine().contains("Name")) {
                    throw new CFAutorootTableException("Name tables On autoroot.chainfire.eu changed");
                }
                if (!br.readLine().contains("Device")) {
                    throw new CFAutorootTableException("Device tables On autoroot.chainfire.eu changed");
                }
                if (!br.readLine().contains("Board")) {
                    throw new CFAutorootTableException("Board tables On autoroot.chainfire.eu changed");
                }
                if (!br.readLine().contains("Platform")) {
                    throw new CFAutorootTableException("Platform tables On autoroot.chainfire.eu changed");
                }
                br.readLine();
                br.readLine();
                br.readLine();
                if (!br.readLine().contains("Link")) {
                    throw new CFAutorootTableException("Link tables On autoroot.chainfire.eu changed");
                }
                ++trcount;
            }
            ++trcount;
        }
        while (br.ready()) {
            String line = "";
            while (!line.endsWith("\n")) {
                if (!(line = line + (char)br.read()).endsWith("\uffff")) continue;
                return;
            }
            if (!line.contains("<tr>")) continue;
            Device device = new Device();
            int tdEntry = 0;
            while (!line.contains("</tr>")) {
                line = br.readLine().replace("<td>", "").replace("</td>", "").trim();
                switch (tdEntry) {
                    case 0: {
                        device.oem = line;
                        break;
                    }
                    case 1: {
                        device.model = line;
                        break;
                    }
                    case 2: {
                        device.name = line;
                        break;
                    }
                    case 3: {
                        device.device = line;
                        break;
                    }
                    case 4: {
                        device.board = line;
                        break;
                    }
                    case 5: {
                        device.platform = line;
                        break;
                    }
                    case 9: {
                        device.download = line.replace("\">File</a>", "").replace("<a href=\"", "");
                        break;
                    }
                }
                ++tdEntry;
            }
            this.deviceList.add(device);
        }
    }
}

