/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.network;

import CASUAL.CASUALMain;
import CASUAL.CASUALMessageObject;
import CASUAL.CASUALTools;
import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.Statics;
import CASUAL.caspac.Script;
import CASUAL.crypto.MD5sum;
import CASUAL.misc.StringOperations;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Properties;
import java.util.zip.ZipException;

public class CASUALUpdates {
    public final String CASUALRepo = "http://android-casual.googlecode.com/svn/trunk/CASUALcore/src";
    static String arch = "";
    static String system = "";

    public boolean downloadFileFromInternet(String URL2, String outputFile, String friendlyName) {
        try {
            this.downloadFileFromInternet(this.stringToFormattedURL(URL2), outputFile, friendlyName);
        }
        catch (MalformedURLException ex) {
            Log.errorHandler(ex);
        }
        catch (URISyntaxException ex) {
            Log.errorHandler(ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFileFromInternet(URL url, String outputFile, String friendlyName) {
        Log.progress("Downloading ");
        Log.level4Debug("Downloading " + url);
        Log.level4Debug("To: " + outputFile);
        try {
            InputStream input = url.openStream();
            byte[] buffer = new byte[4096];
            File f = new File(outputFile);
            f.getParentFile().mkdirs();
            FileOutputStream output = new FileOutputStream(f);
            int bytes = 0;
            Log.progress(friendlyName.replace("/SCRIPTS/", ""));
            boolean lastlength = false;
            boolean offset = true;
            try {
                int bytesRead;
                while ((bytesRead = input.read(buffer, 0, buffer.length)) >= 0) {
                    ((OutputStream)output).write(buffer, 0, bytesRead);
                    int length = String.valueOf(1000).length();
                    int kilobytes = (bytes += bytesRead) / 1024;
                    for (int i = 0; i < length; ++i) {
                        Log.progress("\b");
                    }
                    Log.progress(Integer.toString(kilobytes) + "kb ");
                }
            }
            finally {
                output.flush();
                ((OutputStream)output).close();
            }
        }
        catch (IOException ex) {
            Log.level4Debug("Error Downloading " + ex.getMessage());
            return false;
        }
        return true;
    }

    public void displayCASUALString(String[] CASUALString) {
        Log.level4Debug("Identification: " + CASUALString[0]);
        Log.level4Debug("ScriptRevision: " + CASUALString[1]);
        Log.level4Debug("CASUALRevision: " + CASUALString[2]);
        Log.level4Debug("URL: " + CASUALString[3]);
        Log.level4Debug("Server Message: " + CASUALString[4]);
    }

    public URL stringToFormattedURL(String stringURL) throws MalformedURLException, URISyntaxException {
        URL url = new URL(stringURL);
        url = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef()).toURL();
        return url;
    }

    public String getWebData(String script) throws MalformedURLException, IOException, URISyntaxException {
        URL url = this.stringToFormattedURL(script);
        ReadableByteChannel rbc = Channels.newChannel(url.openStream());
        ByteBuffer buf = ByteBuffer.allocateDirect(10);
        String webData = "";
        int numRead = 0;
        while (numRead >= 0) {
            buf.rewind();
            numRead = rbc.read(buf);
            buf.rewind();
            for (int i = 0; i < numRead; ++i) {
                byte b = buf.get();
                webData = webData + new String(new byte[]{b});
            }
        }
        return webData;
    }

    public InputStream downloadMetaFromRepoForScript(Script s) throws MalformedURLException, URISyntaxException, IOException {
        URL url;
        String parentFolder = new File(s.tempDir).getParent() + "/";
        String meta2 = s.name + ".meta";
        if (CASUALTools.IDEMode) {
            url = this.stringToFormattedURL("http://android-casual.googlecode.com/svn/trunk/CASUALcore/src/SCRIPTS/" + meta2);
        } else {
            Log.level3Verbose("http://android-casual.googlecode.com/svn/trunk/CASUALcore/src" + meta2);
            url = this.stringToFormattedURL("http://android-casual.googlecode.com/svn/trunk/CASUALcore/src" + meta2);
            System.out.println(url.toString());
        }
        Log.level3Verbose("opening download stream");
        URLConnection con = url.openConnection();
        con.setConnectTimeout(300);
        con.setReadTimeout(300);
        return con.getInputStream();
    }

    public InputStream streamFileFromNet(String link) throws MalformedURLException, URISyntaxException, IOException {
        URL url = new URL(link);
        return url.openStream();
    }

    public String CASUALRepoDownload(String propertiesFileInCASUALOnlineRepo) throws FileNotFoundException, IOException, InterruptedException {
        String downloadBasename;
        String downloadURL;
        arch = OSTools.is64bitSystem() ? "64" : "32";
        system = OSTools.isWindows() ? "win" : system;
        system = OSTools.isLinux() ? "linux" : system;
        system = OSTools.isMac() ? "mac" : system;
        Log.level3Verbose("Found " + system + " " + arch + "computer");
        String basename = new File(propertiesFileInCASUALOnlineRepo).getName();
        this.downloadFileFromInternet(propertiesFileInCASUALOnlineRepo, Statics.getTempFolder() + basename, "locating files");
        Log.level3Verbose("downloaded" + propertiesFileInCASUALOnlineRepo);
        Properties prop = new Properties();
        prop.load(new FileInputStream(Statics.getTempFolder() + basename));
        int counter = 1;
        String filenumber = "";
        while (prop.getProperty(system + arch + filenumber) != null) {
            downloadURL = prop.getProperty(system + arch + filenumber);
            Log.level3Verbose("based on information, we need to download: " + downloadURL);
            downloadBasename = downloadURL.substring(downloadURL.lastIndexOf(47) + 1, downloadURL.length());
            String availableVersion = prop.getProperty(system + arch + filenumber + "Version");
            String downloadedFile = Statics.getTempFolder() + downloadBasename;
            this.downloadFileFromInternet(downloadURL, downloadedFile, downloadBasename + " ver" + availableVersion);
            String expectedMD5 = new MD5sum().getMD5fromLinuxMD5String(prop.getProperty(system + arch + "md5"));
            if (expectedMD5.length() >= 31 && !new MD5sum().compareFileToMD5(new File(downloadedFile), expectedMD5)) {
                new CASUALMessageObject("@interactionBadDownload").showErrorDialog();
                CASUALMain.shutdown(0);
            }
            filenumber = "-" + Integer.toString(++counter);
        }
        downloadURL = prop.getProperty(system + arch);
        downloadBasename = new File(downloadURL).getName();
        return Statics.getTempFolder() + downloadBasename;
    }

    public Script updateScript(Script script, String tempFolder) throws ZipException, IOException, MalformedURLException, URISyntaxException {
        MD5sum md5sum = new MD5sum();
        for (String md5 : script.metaData.md5s) {
            FileOperations fo = new FileOperations();
            String targetFilename = md5sum.getFileNamefromLinuxMD5String(md5);
            URL url = this.stringToFormattedURL("http://android-casual.googlecode.com/svn/trunk/CASUALcore/src/SCRIPTS/" + targetFilename);
            System.out.println(url);
            String localFilename = tempFolder + targetFilename;
            if (targetFilename.endsWith(".scr")) {
                script.scriptContents = StringOperations.convertStreamToString(url.openStream());
                script.actualMD5s.add(md5sum.getLinuxMD5Sum(StringOperations.convertStringToStream(script.scriptContents), targetFilename));
                continue;
            }
            if (targetFilename.endsWith(".txt")) {
                script.discription = StringOperations.convertStreamToString(url.openStream());
                script.actualMD5s.add(md5sum.getLinuxMD5Sum(StringOperations.convertStringToStream(script.discription), targetFilename));
                continue;
            }
            if (!targetFilename.endsWith(".zip")) continue;
            this.downloadFileFromInternet(url, localFilename, targetFilename);
            script.scriptZipFile = localFilename;
        }
        return script;
    }
}

