/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.network.CASUALDevIntegration;

import CASUAL.misc.MandatoryThread;
import CASUAL.misc.StringOperations;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CASUALDevQuerier {
    static String BUILDPROP;
    static ArrayList<MandatoryThread> searches;

    public CASUALDevQuerier(String deviceBuildProp, String[] additionalProps) {
        BUILDPROP = deviceBuildProp.replace("/", "");
        for (String prop : additionalProps) {
            BUILDPROP = prop + BUILDPROP;
        }
    }

    public String[] recursiveFolderSearch() {
        TreeSet<String> availableURLs = new TreeSet<String>();
        this.searchFolder("files/", availableURLs);
        int threadsComplete = 0;
        while (threadsComplete < searches.size()) {
            threadsComplete = 0;
            for (MandatoryThread search : this.getSearches()) {
                if (!search.isComplete()) {
                    System.out.println("Waiting for " + search.getName());
                    search.waitFor();
                    System.out.println("Done Waiting " + search.getName());
                    continue;
                }
                ++threadsComplete;
            }
        }
        System.out.println(availableURLs);
        availableURLs.remove("http://builds.casual-dev.com/");
        availableURLs.remove("http://builds.casual-dev.com/null");
        return availableURLs.toArray(new String[availableURLs.size()]);
    }

    static synchronized void addSearch(MandatoryThread t) {
        searches.add(t);
    }

    MandatoryThread[] getSearches() {
        return searches.toArray(new MandatoryThread[searches.size()]);
    }

    private void dispatchThreads(String[] availableFolders, final Set<String> availableURLs) {
        for (final String folder : availableFolders) {
            if (folder == null || folder.equals("null") || folder.isEmpty()) {
                return;
            }
            MandatoryThread t = new MandatoryThread(new Runnable(){

                @Override
                public void run() {
                    CASUALDevQuerier.this.searchFolder(folder, availableURLs);
                }
            });
            CASUALDevQuerier.addSearch(t);
            t.start();
            t.setName(folder);
        }
    }

    private void searchFolder(String folder, Set<String> availableURLs) {
        String[] worklist = new String[]{};
        if (!CASUALDevQuerier.isBlacklisted(folder)) {
            try {
                for (String name : worklist = this.folderList(folder, availableURLs)) {
                    System.out.println("Folder: " + name);
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CASUALDevQuerier.class.getName()).log(Level.SEVERE, null, ex);
            }
            this.dispatchThreads(worklist, availableURLs);
        }
    }

    private static boolean isBlacklisted(String folder) {
        String checkValue;
        Properties buildprop = new Properties();
        try {
            URI uri = new URI("http", "builds.casual-dev.com", "/" + folder + "b.prop", null);
            URL url = new URL(uri.toASCIIString());
            System.out.println("Searching " + folder);
            buildprop.load(url.openStream());
        }
        catch (IOException ex) {
            return false;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(CASUALDevQuerier.class.getName()).log(Level.SEVERE, null, ex);
        }
        boolean blacklisted = !buildprop.getProperty("w[0]", "").isEmpty();
        int i = -1;
        while (!(checkValue = buildprop.getProperty("w[" + ++i + "]", "")).isEmpty()) {
            if (!BUILDPROP.contains(checkValue)) continue;
            blacklisted = false;
            break;
        }
        i = -1;
        while (!(checkValue = buildprop.getProperty("b[" + ++i + "]", "")).isEmpty()) {
            if (!BUILDPROP.contains(checkValue)) continue;
            blacklisted = true;
            break;
        }
        System.out.println(folder + (blacklisted ? " does not apply to this device." : " is Whitelisted."));
        return blacklisted;
    }

    private String[] folderList(String remoteFolder, Set<String> availableURLs) throws MalformedURLException, IOException {
        try {
            String[] fileList;
            System.out.println("remoteFolder:" + remoteFolder);
            URI uri = new URI("http", "builds.casual-dev.com", "/query.php", "folder=" + remoteFolder, null);
            URL url = new URL(uri.toASCIIString());
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String folderLine = in.readLine();
            String fileLine = in.readLine();
            System.out.println(folderLine + "\n" + fileLine);
            in.close();
            folderLine = StringOperations.replaceLast(folderLine, "]", "");
            String[] folderList = folderLine.replaceFirst("\\[", "").replace("\\", "").replace("\"", "").split(",");
            fileLine = StringOperations.replaceLast(fileLine, "]", "");
            for (String file : fileList = fileLine.replaceFirst("\\[", "").replace("\\", "").replace("\"", "").split(",")) {
                if (file.endsWith("b.prop")) continue;
                file = "http://builds.casual-dev.com/" + file.replace("\\/", "/");
                availableURLs.add(file);
                System.out.println("Available File: " + file);
            }
            return folderList;
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(CASUALDevQuerier.class.getName()).log(Level.SEVERE, null, ex);
            return new String[0];
        }
    }

    static {
        searches = new ArrayList();
    }
}

