/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.misc;

import CASUAL.Log;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Random;
import java.util.Scanner;

public class StringOperations {
    public static String replaceLast(String string, String toReplace, String replacement) {
        int pos = string.lastIndexOf(toReplace);
        if (pos > -1) {
            return string.substring(0, pos) + replacement + string.substring(pos + toReplace.length(), string.length());
        }
        return string;
    }

    public static String removeLeadingSpaces(String line) {
        while (line.startsWith(" ")) {
            line = line.replaceFirst(" ", "");
        }
        return line;
    }

    public static String removeLeadingAndTrailingSpaces(String line) {
        while (line.startsWith(" ")) {
            line = line.replaceFirst(" ", "");
        }
        while (line.endsWith(" ")) {
            StringBuilder b = new StringBuilder(line);
            b.replace(line.lastIndexOf(" "), line.lastIndexOf(" ") + 1, "");
            line = b.toString();
        }
        return line;
    }

    public static String removeTrailingSpaces(String line) {
        while (line.endsWith(" ")) {
            StringBuilder b = new StringBuilder(line);
            b.replace(line.lastIndexOf(" "), line.lastIndexOf(" ") + 1, "");
            line = b.toString();
        }
        return line;
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    public static InputStream convertStringToStream(String input) {
        ByteArrayInputStream bas = new ByteArrayInputStream(input.getBytes());
        return bas;
    }

    public static String[] convertArrayListToStringArray(ArrayList<String> list) {
        String[] StringArray = new String[list.size()];
        for (int i = 0; i <= list.size() - 1; ++i) {
            StringArray[i] = list.get(i).toString();
        }
        return StringArray;
    }

    public static String[] convertStringToArray(String inputString) {
        StringOperations.removeLeadingAndTrailingSpaces(inputString);
        String[] outputArray = new String[]{};
        int currentQuotePosition = 0;
        int lastQuotePosition = 0;
        for (int i = 0; i <= inputString.length(); ++i) {
            if (inputString.length() == currentQuotePosition) {
                outputArray[i] = inputString.substring(lastQuotePosition, currentQuotePosition);
                break;
            }
            outputArray[i] = inputString.substring(lastQuotePosition, currentQuotePosition - 1);
            lastQuotePosition = currentQuotePosition++;
            currentQuotePosition = inputString.indexOf("\",", currentQuotePosition);
        }
        return outputArray;
    }

    public static String generateRandomHexString(int len) {
        char[] chars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        String random = "";
        for (int i = 0; i < len; ++i) {
            random = random + chars[new Random().nextInt(chars.length)];
        }
        return random;
    }

    public static String arrayToString(String[] stringarray) {
        String str = " ";
        for (int i = 0; i < stringarray.length; ++i) {
            str = str + " " + stringarray[i];
        }
        Log.level4Debug("arrayToString " + stringarray + " expanded to: " + str);
        return str;
    }
}

