/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.misc;

import CASUAL.instrumentation.Instrumentation;
import java.util.concurrent.atomic.AtomicBoolean;

public class MandatoryThread
extends Thread {
    AtomicBoolean hasStarted = new AtomicBoolean(false);
    boolean nullThread = false;

    public MandatoryThread() {
        this.hasStarted.set(true);
        this.nullThread = true;
    }

    public MandatoryThread(Runnable r) {
        super(r);
    }

    @Override
    public synchronized void start() {
        if (this.nullThread) {
            return;
        }
        super.start();
        this.hasStarted.set(true);
        this.notify();
        Instrumentation.trackThread(this);
    }

    public boolean isComplete() {
        return this.hasStarted.get() && !super.isAlive();
    }

    public synchronized void waitFor() {
        try {
            if (this.nullThread) {
                return;
            }
            while (!this.hasStarted.get()) {
                this.wait();
            }
            if (this.isAlive()) {
                System.out.println("waiting for " + this.getName());
                super.join();
                System.out.println(this.getName() + " has completed");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String n = "\n";
        sb.append("Name:").append(this.getName()).append(n);
        sb.append("Started:").append(this.hasStarted).append(n);
        sb.append("Complete:").append(this.isComplete()).append(n);
        return sb.toString();
    }
}

