/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA256sum {
    final ByteArrayInputStream toBeSHA256;
    protected static final String LINUXSPACER = "  ";

    public SHA256sum(String s) throws IOException {
        ByteArrayInputStream bas;
        this.toBeSHA256 = bas = new ByteArrayInputStream(s.getBytes());
        this.toBeSHA256.mark(0);
    }

    public SHA256sum(InputStream is) throws IOException {
        ByteArrayInputStream bin;
        int bytesRead;
        byte[] buff = new byte[8120];
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        while ((bytesRead = is.read(buff)) != -1) {
            bao.write(buff, 0, bytesRead);
        }
        this.toBeSHA256 = bin = new ByteArrayInputStream(bao.toByteArray());
        this.toBeSHA256.mark(0);
    }

    public SHA256sum(File f) throws FileNotFoundException, IOException {
        ByteArrayInputStream bas;
        RandomAccessFile ra = new RandomAccessFile(f, "rw");
        byte[] b = new byte[(int)f.length()];
        ra.read(b);
        this.toBeSHA256 = bas = new ByteArrayInputStream(b);
        this.toBeSHA256.mark(0);
    }

    public String getLinuxSum(String filename) {
        if (filename.isEmpty()) {
            filename = "-";
        }
        try {
            String sha = this.getSha256();
            return sha + LINUXSPACER + filename;
        }
        catch (IOException ex) {
            return null;
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    public static String getLinuxSum(File file) {
        String name = file.getName();
        try {
            String sum = new SHA256sum(file).getSha256();
            String linuxSHA256 = SHA256sum.formatLinuxOutputSHA256Sum(sum, name);
            return linuxSHA256;
        }
        catch (FileNotFoundException ex) {
            return "";
        }
        catch (NoSuchAlgorithmException ex) {
            return "";
        }
        catch (IOException ex) {
            return "";
        }
    }

    public static String getName(String sha256sum) {
        if (sha256sum.contains(LINUXSPACER)) {
            String[] split = sha256sum.split(LINUXSPACER);
            return split[1];
        }
        return "";
    }

    public static String getSum(String sha256sum) {
        if (sha256sum.contains(LINUXSPACER)) {
            String[] split = sha256sum.split(LINUXSPACER);
            return split[0];
        }
        return "";
    }

    public String getSha256() throws IOException, NoSuchAlgorithmException {
        this.toBeSHA256.reset();
        try {
            int read;
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] buffer = new byte[8192];
            while ((read = this.toBeSHA256.read(buffer)) > 0) {
                digest.update(buffer, 0, read);
            }
            byte[] md5sum = digest.digest();
            BigInteger bigInt = new BigInteger(1, md5sum);
            String output = bigInt.toString(16);
            while (output.length() != 64) {
                output = "0" + output;
            }
            return output;
        }
        catch (NoSuchAlgorithmException ex) {
            return "ERROR0NoSuchAlgorythemException0";
        }
        catch (IOException ex) {
            return "ERROR00IOException00000000000000";
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String formatLinuxOutputSHA256Sum(String sum, String name) {
        String linuxSHA256 = sum + LINUXSPACER + name;
        return linuxSHA256;
    }
}

