/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.crypto;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class MD5sum {
    public boolean compareFileToMD5(File f, String MD5) {
        return this.md5sum(f).equals(MD5.toLowerCase());
    }

    public String md5sum(InputStream is) {
        return this.md5sumStream(is);
    }

    public String md5sum(File f) {
        try {
            FileInputStream is = new FileInputStream(f);
            return this.md5sumStream(is);
        }
        catch (FileNotFoundException ex) {
            return "ERROR0FileNotFoundException00000";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String md5sumStream(InputStream is) {
        String string;
        block9: {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            try {
                int read;
                while ((read = is.read(buffer)) > 0) {
                    digest.update(buffer, 0, read);
                }
                byte[] md5sum = digest.digest();
                BigInteger bigInt = new BigInteger(1, md5sum);
                String output = bigInt.toString(16);
                while (output.length() != 32) {
                    output = "0" + output;
                }
                string = output;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (NoSuchAlgorithmException ex) {
                    return "ERROR0NoSuchAlgorythemException0";
                }
                catch (IOException ex) {
                    return "ERROR00IOException00000000000000";
                }
            }
            is.close();
        }
        return string;
    }

    public boolean compareMD5StringsFromLinuxFormatToFilenames(String[] LinuxFormat, String[] MD5Filenames) {
        int n;
        String[][] FilenamesAndMD5 = this.splitFilenamesAndMD5(LinuxFormat);
        boolean[] matches = new boolean[MD5Filenames.length];
        for (n = 0; n < MD5Filenames.length; ++n) {
            matches[n] = false;
            String md5 = this.md5sum(new File(MD5Filenames[n]));
            for (int nn = 0; nn < FilenamesAndMD5.length; ++nn) {
                if (md5.length() != 32) {
                    matches[n] = true;
                    continue;
                }
                if (!md5.equals(FilenamesAndMD5[nn][0])) continue;
                matches[n] = true;
            }
        }
        for (n = 0; n < matches.length; ++n) {
            if (matches[n]) continue;
            return false;
        }
        return true;
    }

    private String[][] splitFilenamesAndMD5(String[] idStrings) {
        int ROWS = idStrings.length;
        int COLUMNS = 2;
        String[][] NameMD5 = new String[ROWS][COLUMNS];
        for (int n = 0; n < ROWS; ++n) {
            if (!idStrings[n].contains("  ")) continue;
            String[] splitID = idStrings[n].split("  ");
            if (splitID.length == 2) {
                if (splitID[0] != null && splitID[1] != null) {
                    NameMD5[n][0] = splitID[0];
                    NameMD5[n][1] = splitID[1];
                    continue;
                }
                NameMD5[n][0] = "";
                NameMD5[n][1] = "";
                continue;
            }
            NameMD5[n][0] = "";
            NameMD5[n][1] = "";
        }
        return NameMD5;
    }

    public String md5sum(String string) {
        return this.md5sum(new File(string));
    }

    public String[] splitMD5String(String md5) {
        String[] retval = md5.split("  ");
        return retval;
    }

    public String getMD5fromLinuxMD5String(String md5) {
        return this.splitMD5String(md5)[0];
    }

    public String getLinuxMD5Sum(File file) {
        String md5 = this.md5sum(file);
        String filename = file.getName();
        return this.convertMD5andFiletoLinuxMD5Sum(md5, filename);
    }

    public String getLinuxMD5Sum(InputStream stream, String filename) {
        String md5 = this.md5sum(stream);
        return this.convertMD5andFiletoLinuxMD5Sum(md5, filename);
    }

    public String getFileNamefromLinuxMD5String(String md5) {
        String[] s = this.splitMD5String(md5);
        if (s.length > 0) {
            return s[1];
        }
        return s[0];
    }

    public String convertMD5andFiletoLinuxMD5Sum(String md5, String filename) {
        return md5 + "  " + filename;
    }

    public boolean lineContainsMD5(String testLine) {
        boolean x = testLine.matches("([0-9a-f]{32}([\\s\\S]*))");
        return x;
    }

    public String pickNewMD5fromArrayList(ArrayList<String> newMd5List, String OldMD5) {
        String[] md5FileSplit = OldMD5.split("  ");
        for (Object item : newMd5List.toArray()) {
            if (!((String)item).endsWith(md5FileSplit[1])) continue;
            return (String)item;
        }
        return OldMD5;
    }
}

