/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.crypto;

import CASUAL.FileOperations;
import CASUAL.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AES128Handler {
    final File targetFile;
    private static final String casualID = "EncryptedCASPAC-CASUAL-Revision";
    private static final String revision = ResourceBundle.getBundle("CASUAL/resources/CASUALApp").getString("Application.revision");
    public static final String header = "EncryptedCASPAC-CASUAL-Revision" + revision.length() + revision;

    public AES128Handler(File targetFile) {
        this.targetFile = targetFile;
    }

    public boolean encrypt(String output, char[] key) {
        Log.level2Information("Encrypting " + this.targetFile.getName());
        try {
            byte[] randomness = this.secureRandomCharGen(key, 16);
            Log.level2Information("Key parsed.  Encrypting...");
            FileInputStream fis = new FileInputStream(this.targetFile);
            List<InputStream> streams = Arrays.asList(new ByteArrayInputStream(randomness), fis);
            Log.level2Information("obtaining key...");
            SequenceInputStream is = new SequenceInputStream(Collections.enumeration(streams));
            this.writeCipherFile(is, randomness, output, key, 1);
        }
        catch (NoSuchAlgorithmException ex) {
            return false;
        }
        catch (FileNotFoundException ex) {
            Log.errorHandler(ex);
        }
        catch (NoSuchPaddingException ex) {
            Log.errorHandler(ex);
        }
        catch (InvalidKeyException ex) {
            Log.errorHandler(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            Log.errorHandler(ex);
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
        return true;
    }

    public String decrypt(String output, char[] key) throws Exception {
        try {
            FileInputStream fis = new FileInputStream(this.targetFile);
            int headersize = AES128Handler.getCASPACHeaderLength(this.targetFile);
            if (headersize < 10) {
                throw new Exception("Invalid CASPAC Format");
            }
            fis.read(new byte[headersize]);
            byte[] IV = new byte[16];
            fis.read(IV);
            return this.writeCipherFile(fis, IV, output, key, 2);
        }
        catch (NoSuchAlgorithmException ex) {
            return null;
        }
    }

    private InputStream appendStream(InputStream appendToFront, InputStream is) {
        List<InputStream> streams = Arrays.asList(appendToFront, is);
        SequenceInputStream newis = new SequenceInputStream(Collections.enumeration(streams));
        return newis;
    }

    private String writeCipherFile(InputStream fis, byte[] iv, String output, char[] key, int mode) throws NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, FileNotFoundException, IOException {
        byte[] bkey = this.oneWayHash(key);
        Cipher c = this.getCipher(bkey, iv, mode);
        CipherInputStream cis = new CipherInputStream(fis, c);
        if (mode == 1) {
            ByteArrayInputStream headerbytes = new ByteArrayInputStream(header.getBytes());
            InputStream doOutput = this.appendStream(headerbytes, cis);
            new FileOperations().writeStreamToFile(new BufferedInputStream(doOutput), output);
        } else {
            new FileOperations().writeStreamToFile(new BufferedInputStream(cis), output);
        }
        return output;
    }

    private byte[] secureRandomCharGen(char[] key, int numberOfChars) throws NoSuchAlgorithmException {
        Log.level4Debug("Generating randomness");
        SecureRandom random = new SecureRandom(SecureRandom.getSeed(key.length));
        byte[] bytes = new byte[numberOfChars];
        random.nextBytes(bytes);
        byte[] temp = new byte[1];
        for (int i = 0; i < numberOfChars - 1; ++i) {
            random.nextBytes(temp);
            bytes[i] = temp[0];
            random = new SecureRandom();
            random.nextBytes(new byte[key.length]);
        }
        return bytes;
    }

    public byte[] oneWayHash(char[] input) {
        try {
            int maxSecurity = Cipher.getMaxAllowedKeyLength("AES");
            Log.level4Debug("The maximum security allowed on this system is AES " + maxSecurity);
            if (maxSecurity > 128) {
                maxSecurity = 128;
            }
            Log.level4Debug("For the sake of compatibility with US Import/Export laws we are using AES " + maxSecurity);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec keyspec = new PBEKeySpec(input, "--salt--".getBytes(), 100000, maxSecurity);
            SecretKey key = factory.generateSecret(keyspec);
            return key.getEncoded();
        }
        catch (NoSuchAlgorithmException ex) {
            Log.errorHandler(ex);
        }
        catch (InvalidKeySpecException ex) {
            Log.errorHandler(ex);
        }
        return null;
    }

    public Cipher getCipher(byte[] key, byte[] iv, int mode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        SecretKeySpec skey = new SecretKeySpec(key, "AES");
        IvParameterSpec ivspec = new IvParameterSpec(iv);
        Cipher c = Cipher.getInstance("AES/CBC/PKCS5Padding");
        c.init(mode, (Key)skey, ivspec);
        return c;
    }

    public static int getCASPACHeaderLength(File f) throws FileNotFoundException, IOException {
        AES128Handler c = new AES128Handler(f);
        FileInputStream fis = new FileInputStream(f);
        byte[] chartest = new byte[casualID.length()];
        byte[] headert = casualID.getBytes();
        fis.read(chartest);
        if (Arrays.equals(chartest, headert)) {
            char charRevisionLength = (char)fis.read();
            int revisionLength = Integer.parseInt(String.valueOf(charRevisionLength));
            return chartest.length + 1 + revisionLength;
        }
        return 0;
    }
}

