/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.heimdall.odin;

import CASUAL.communicationstools.heimdall.odin.CorruptOdinFileException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class OdinFile {
    private final BufferedInputStream odinStream;
    final File odinFile;
    final String actualMd5;
    String expectedMd5 = "";
    ArrayList<File> files = null;
    TarArchiveInputStream tarStream;
    final int type;

    public OdinFile(File odinFile) throws FileNotFoundException, IOException, NoSuchAlgorithmException, CorruptOdinFileException, ArchiveException {
        this.odinFile = odinFile;
        this.odinStream = new BufferedInputStream(new FileInputStream(odinFile));
        String name = odinFile.getName();
        if (name.endsWith("tar")) {
            this.actualMd5 = "";
            this.type = 0;
        } else if (name.endsWith("tar.md5")) {
            this.actualMd5 = this.getActualAndExpectedOdinMd5();
            if (!this.expectedMd5.equals(this.actualMd5)) {
                throw new CorruptOdinFileException(odinFile.getCanonicalPath());
            }
            System.out.println("verified file " + odinFile.getCanonicalPath());
            this.type = 1;
        } else if (name.endsWith("tar.gz.md5")) {
            this.actualMd5 = this.getActualAndExpectedOdinMd5();
            if (!this.expectedMd5.equals(this.actualMd5)) {
                throw new CorruptOdinFileException(odinFile.getCanonicalPath());
            }
            System.out.println("verified file " + odinFile.getCanonicalPath());
            this.type = 2;
        } else {
            this.actualMd5 = "";
            this.type = 3;
        }
        if (this.type == 2 || this.type == 3) {
            GZIPInputStream gzis = new GZIPInputStream(this.odinStream);
            this.tarStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)gzis);
        } else {
            this.tarStream = (TarArchiveInputStream)new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)this.odinStream);
        }
    }

    public OdinFile(String odinFile) throws FileNotFoundException, IOException, NoSuchAlgorithmException, CorruptOdinFileException, ArchiveException {
        this(new File(odinFile));
    }

    public File[] extractOdinContents(String outputDir) throws IOException, ArchiveException, NoSuchAlgorithmException {
        TarArchiveEntry entry;
        if (this.files != null) {
            return this.files.toArray(new File[this.files.size()]);
        }
        this.files = new ArrayList();
        while ((entry = (TarArchiveEntry)this.tarStream.getNextEntry()) != null) {
            File outputFile = new File(outputDir, entry.getName());
            if (entry.isDirectory()) {
                if (!outputFile.exists()) {
                    System.out.println("creating dir:" + outputFile.getCanonicalFile());
                    if (!outputFile.mkdirs()) {
                        throw new IllegalStateException();
                    }
                }
            } else {
                byte[] buffer;
                FileOutputStream outputFileStream = new FileOutputStream(outputFile);
                System.out.println("decompressing file:" + outputFile.getCanonicalFile());
                while ((buffer = new byte[this.tarStream.available()]).length > 1) {
                    this.tarStream.read(buffer);
                    ((OutputStream)outputFileStream).write(buffer);
                }
                ((OutputStream)outputFileStream).close();
            }
            this.files.add(outputFile);
        }
        return this.files.toArray(new File[this.files.size()]);
    }

    private String getActualAndExpectedOdinMd5() throws IOException, FileNotFoundException, NoSuchAlgorithmException {
        FileInputStream fis = new FileInputStream(this.odinFile);
        MessageDigest digest = MessageDigest.getInstance("MD5");
        byte[] buffer = new byte[512];
        while (fis.read(buffer) == 512 && buffer[511] != 255) {
            digest.update(buffer);
        }
        for (byte b : buffer) {
            if (b == 255) break;
            this.expectedMd5 = this.expectedMd5 + (char)b;
        }
        byte[] md5sum = digest.digest();
        BigInteger bigInt = new BigInteger(1, md5sum);
        String localactualMd5 = bigInt.toString(16);
        while (localactualMd5.length() != 32) {
            localactualMd5 = "0" + localactualMd5;
        }
        this.expectedMd5 = this.expectedMd5.split("  ")[0];
        return localactualMd5;
    }
}

