/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.heimdall.odin;

import CASUAL.archiving.libpit.PitData;
import CASUAL.communicationstools.heimdall.odin.CorruptOdinFileException;
import CASUAL.communicationstools.heimdall.odin.OdinFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import org.apache.commons.compress.archivers.ArchiveException;

public class Odin {
    private final PitData pit;

    public Odin(File pit) throws FileNotFoundException {
        this.pit = new PitData(pit);
    }

    public String[] getHeimdallFileParametersFromOdinFile(String tempFolder, File[] files) throws CorruptOdinFileException, FileNotFoundException {
        TreeSet<File> set = new TreeSet<File>();
        for (File file : files) {
            try {
                OdinFile o = new OdinFile(file);
                o.extractOdinContents(tempFolder);
                set.addAll(Arrays.asList(o.extractOdinContents(tempFolder)));
            }
            catch (IOException ex) {
                throw new FileNotFoundException();
            }
            catch (NoSuchAlgorithmException ex) {
                throw new CorruptOdinFileException("This computer cannot handle the file");
            }
            catch (CorruptOdinFileException ex) {
                throw new CorruptOdinFileException("The Archive is corrupt");
            }
            catch (ArchiveException ex) {
                throw new CorruptOdinFileException("The Archive is corrupt");
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (File f : set) {
            String partname = this.pit.findEntryByFilename(f.getName()).getPartitionName();
            list.add("--" + partname);
            list.add(f.getAbsolutePath());
        }
        return list.toArray(new String[list.size()]);
    }
}

