/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.heimdall.drivers;

import CASUAL.Log;
import CASUAL.communicationstools.heimdall.drivers.DriverOperations;
import CASUAL.misc.StringOperations;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DriverRemove {
    private final String[] windowsDriverBlanket = new String[]{"04E8", "0B05", "0BB4", "22B8", "054C", "2080", "18D1"};

    public DriverRemove() {
        Log.level2Information("uninstallCADI() Initializing");
        Log.level2Information("uninstallCADI() Scanning for CADI driver package(s)");
    }

    public boolean removeDriver() {
        this.deleteOemInf();
        Log.level2Information("uninstallCADI() Scanning for orphaned devices");
        boolean driverRemoved = true;
        for (String vid : this.windowsDriverBlanket) {
            driverRemoved = this.removeOrphanedDevices(vid);
        }
        Log.level2Information("removeDriver() Windows will now scan for hardware changes");
        if (!new DriverOperations().rescan()) {
            Log.level0Error("removeDriver() rescan() failed!");
        }
        return driverRemoved;
    }

    public boolean deleteOemInf() {
        DriverOperations driver = new DriverOperations();
        Log.level2Information("deleteOemInf() Enumerating installed driver packages");
        int resultSum = 0;
        Pattern pattern = driver.regexPattern(DriverOperations.PatternChoice.INF);
        String outputBuffer = driver.enumerate();
        if (outputBuffer == null) {
            Log.level0Error("deleteOemInf() installer returned null!");
            return false;
        }
        Matcher matcher = pattern.matcher(outputBuffer);
        while (matcher.find()) {
            Log.level2Information("removeDriver() Forcing removal of driver package" + matcher.group(0));
            String result = driver.delete(matcher.group(0));
            if (result == null || result.contains("Driver package")) {
                Log.level0Error("removeDriver() installer returned null!");
            }
            ++resultSum;
        }
        return resultSum > 0;
    }

    public boolean removeOrphanedDevices(String VID) {
        int i = 0;
        int resultSum = 0;
        DriverOperations driver = new DriverOperations();
        if (VID.equals("")) {
            Log.level0Error("removeOrphanedDevices() no VID specified");
            return false;
        }
        Pattern pattern = driver.regexPattern(DriverOperations.PatternChoice.MATCHINGDEVICES);
        if (pattern == null) {
            Log.level0Error("removeOrphanedDevices() getRegExPattern() returned null!");
            return false;
        }
        String outputBuffer = driver.findall("*USB\\VID_" + VID + "*");
        if (outputBuffer == null) {
            Log.level0Error("removeOrphanedDevices() installer returned null!");
            return false;
        }
        pattern = driver.regexPattern(DriverOperations.PatternChoice.ORPHANS);
        if (pattern == null) {
            Log.level0Error("removeOrphanedDevices() getRegExPattern() returned null!");
            return false;
        }
        Matcher matcher = pattern.matcher(outputBuffer);
        while (matcher.find()) {
            Log.level2Information("removeOrphanedDevices() Removing orphaned device \"@" + StringOperations.removeLeadingAndTrailingSpaces(matcher.group(0).replace("\"", "")) + "\"");
            String result = driver.remove("\"@" + StringOperations.removeLeadingAndTrailingSpaces(matcher.group(0).replace("\"", "")) + "\"");
            if (!result.equals("")) {
                if (result.contains("device(s) are ready to be removed. To remove the devices, reboot the system.")) {
                    ++resultSum;
                } else {
                    Log.level0Error("removeOrphanedDevices() installer returned null!");
                }
            }
            ++i;
        }
        return resultSum > 0;
    }
}

