/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.heimdall.drivers;

import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.Shell;
import CASUAL.Statics;
import CASUAL.archiving.Unzip;
import CASUAL.misc.StringOperations;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DriverOperations {
    private final String pathToCADI = Statics.getTempFolder() + "CADI" + Statics.slash;
    private static volatile boolean driverExtracted = false;
    private static final String cadiXpDrivers = "/CASUAL/communicationstools/heimdall/drivers/resources/xp/CADI.zip";
    private static final String cadiDrivers = "/CASUAL/communicationstools/heimdall/drivers/resources/CADI.zip";

    public DriverOperations() {
        if (!driverExtracted) {
            try {
                this.driverExtract(this.pathToCADI);
            }
            catch (FileNotFoundException ex) {
                Log.errorHandler(ex);
                return;
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
                return;
            }
            driverExtracted = true;
        }
    }

    private boolean driverExtract(String pathToExtract) throws FileNotFoundException, IOException {
        if (OSTools.OSName().contains("Windows XP")) {
            if (new FileOperations().makeFolder(this.pathToCADI)) {
                Log.level4Debug("driverExtract() Unzipping CADI for xp");
                Unzip.unZipResource(cadiXpDrivers, pathToExtract);
                return true;
            }
            return false;
        }
        if (new FileOperations().makeFolder(this.pathToCADI)) {
            Log.level4Debug("driverExtract() Unzipping CADI");
            Unzip.unZipResource(cadiDrivers, pathToExtract);
            return true;
        }
        return false;
    }

    public String[] getDeviceList(String VID) {
        if (VID.equals("")) {
            Log.level0Error("getDeviceList() no VID specified");
            return null;
        }
        String rawDeviceList = this.find("*USB\\VID_" + VID + "*");
        if (rawDeviceList == null) {
            Log.level0Error("getDeviceList() installer returned null!");
            return null;
        }
        Pattern pattern = this.regexPattern(PatternChoice.MATCHINGDEVICES);
        if (pattern == null) {
            Log.level0Error("getDeviceList() getRegExPattern() returned null!");
            return null;
        }
        Matcher matcher = pattern.matcher(rawDeviceList);
        pattern = this.regexPattern(PatternChoice.ALLDEVICES);
        if (pattern == null) {
            Log.level0Error("getDeviceList() getRegExPattern() returned null!");
            return null;
        }
        pattern = this.regexPattern(PatternChoice.ALLDEVICES);
        matcher = pattern.matcher(rawDeviceList);
        ArrayList<String> al = new ArrayList<String>();
        while (matcher.find()) {
            String replacedQuote = StringOperations.removeLeadingAndTrailingSpaces(matcher.group(0).replace("\"", ""));
            al.add(replacedQuote);
        }
        String[] retval = al.toArray(new String[al.size()]);
        if (retval.length == 0) {
            retval = null;
        }
        return retval;
    }

    public String[] getDeviceList(boolean onlyConnected, boolean onlyUSB) {
        String rawDeviceList = onlyConnected && onlyUSB ? this.find("USB*") : (onlyConnected && !onlyUSB ? this.find("*") : (!onlyConnected && onlyUSB ? this.findall("USB*") : this.findall("*")));
        if (rawDeviceList == null) {
            Log.level0Error("getDeviceList() installer returned null!");
            return null;
        }
        Pattern pattern = this.regexPattern(PatternChoice.MATCHINGDEVICES);
        if (pattern == null) {
            Log.level0Error("getDeviceList() getRegExPattern() returned null!");
            return null;
        }
        pattern = this.regexPattern(PatternChoice.ALLDEVICES);
        Matcher matcher = pattern.matcher(rawDeviceList);
        ArrayList<String> al = new ArrayList<String>();
        while (matcher.find()) {
            String replacedQuote = StringOperations.removeLeadingAndTrailingSpaces(matcher.group(0).replace("\"", ""));
            al.add(replacedQuote);
        }
        String[] retval = al.toArray(new String[al.size()]);
        if (retval.length == 0) {
            retval = null;
        }
        return retval;
    }

    public Pattern regexPattern(PatternChoice whatPattern) {
        switch (whatPattern) {
            case ORPHANS: {
                return Pattern.compile("USB.?VID_[0-9a-fA-F]{4}&PID_[0-9a-fA-F]{4}.*(?=:\\s[CASUAL's|Samsung]+\\s[Android\\sDevice])");
            }
            case CASUALDRIVER: {
                return Pattern.compile("USB.?VID_[0-9a-fA-F]{4}&PID_[0-9a-fA-F]{4}.*(?=:\\s[CASUAL's|Samsung]+\\s[Android\\sDevice])");
            }
            case INF: {
                return Pattern.compile("[o|Oe|Em|M]{3}[0-9]{1,4}\\.inf(?=\\s*Provider:\\slibusbK\\s*Class:\\s*libusbK USB Devices)");
            }
            case INSTALL: {
                return Pattern.compile("USB.?VID_[0-9a-fA-F]{4}&PID_[0-9a-fA-F]{4}(?=.*:)");
            }
            case MATCHINGDEVICES: {
                return Pattern.compile("(?<=\\s)[0-9]{1,3}?(?=[\\smatching\\sdevice\\(s\\)\\sfound])");
            }
            case ALLDEVICES: {
                return Pattern.compile("\\S+(?=\\s*:\\s)");
            }
        }
        Log.level0Error("getRegExPattern() no known pattern requested");
        return null;
    }

    public int getCASUALDriverCount() {
        int devCount = 0;
        String outputBuffer = this.findall("USB*");
        if (outputBuffer == null) {
            Log.level0Error("removeOrphanedDevices() installer returned null!");
            return 0;
        }
        Pattern pattern = this.regexPattern(PatternChoice.CASUALDRIVER);
        if (pattern == null) {
            Log.level0Error("removeOrphanedDevices() getRegExPattern() returned null!");
            return 0;
        }
        Matcher matcher = pattern.matcher(outputBuffer);
        while (matcher.find()) {
            ++devCount;
        }
        return devCount;
    }

    public String update(String HWID) {
        if (!HWID.isEmpty()) {
            return this.sendCommand("update " + this.pathToCADI + "cadi.inf " + "\"" + HWID);
        }
        return null;
    }

    public String remove(String HWID) {
        if (!HWID.isEmpty()) {
            return this.sendCommand("remove " + HWID);
        }
        return null;
    }

    public String delete(String infName) {
        if (!infName.isEmpty()) {
            return this.sendCommand("-f dp_delete " + infName);
        }
        return null;
    }

    public String find(String searchString) {
        if (!searchString.isEmpty()) {
            return this.sendCommand("find " + searchString);
        }
        return null;
    }

    public String findall(String searchString) {
        if (!searchString.isEmpty()) {
            return this.sendCommand("findall " + searchString);
        }
        return null;
    }

    public String enumerate() {
        return this.sendCommand("dp_enum");
    }

    public boolean rescan() {
        return this.sendCommand("rescan").contains("Scanning for new hardware");
    }

    private String sendCommand(String cmd) {
        String exec = this.pathToCADI + (OSTools.is64bitSystem() ? "driver_x64.exe " : "driver_x86.exe ") + cmd;
        String retval = new Shell().timeoutShellCommand(new String[]{"cmd.exe", "/C", "\"" + exec + "\""}, 90000);
        if (retval.contains(" failed")) {
            exec = this.pathToCADI + (OSTools.is64bitSystem() ? "driver_x64_elevate.exe " : "driver_x86_elevate.exe ") + cmd;
            retval = new Shell().timeoutShellCommand(new String[]{"cmd.exe", "/C", "\"" + exec + "\""}, 90000);
        }
        Log.level2Information(retval);
        return retval;
    }

    public static enum PatternChoice {
        ORPHANS,
        CASUALDRIVER,
        INF,
        INSTALL,
        MATCHINGDEVICES,
        ALLDEVICES;

    }
}

