/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.heimdall.drivers;

import CASUAL.CASUALMessageObject;
import CASUAL.Log;
import CASUAL.communicationstools.heimdall.drivers.DriverOperations;
import java.util.ArrayList;

public class DriverInstall {
    private final String[] windowsDriverBlanket;
    public static volatile int removeDriverOnCompletion;

    public DriverInstall(int promptInit) {
        removeDriverOnCompletion = promptInit;
        Log.level4Debug("WindowsDrivers() Initializing");
        this.windowsDriverBlanket = new String[]{"04E8", "0B05", "0BB4", "22B8", "054C", "2080", "18D1"};
        if (removeDriverOnCompletion == 0) {
            removeDriverOnCompletion = new CASUALMessageObject("@interactionInstallingCADI").showYesNoOption() ? 2 : 1;
        }
    }

    public boolean installKnownDrivers() {
        String[] deviceList = new DriverOperations().getDeviceList(true, true);
        int retVal = 0;
        ArrayList<String> qualifiedDevices = new ArrayList<String>();
        for (String device : deviceList) {
            this.addDeviceToInstallationQueueIfInList(qualifiedDevices, device);
        }
        ArrayList<String[]> uidVid = new ArrayList<String[]>();
        this.parseUidVidFromQualifiedDevices(qualifiedDevices, uidVid);
        DriverOperations driver = new DriverOperations();
        for (String[] uv : uidVid) {
            String usbVidString = "USB\\VID_" + uv[0] + "&PID_" + uv[1];
            if (!driver.update(usbVidString).contains(" successfully")) continue;
            ++retVal;
        }
        return retVal > 0;
    }

    public ArrayList<String[]> parseUidVidFromQualifiedDevices(ArrayList<String> qualifiedDevices, ArrayList<String[]> uidVid) {
        for (String device : qualifiedDevices) {
            String vid;
            if (!device.startsWith("USB\\VID_") || !(device = device.replace("USB\\VID_", "")).startsWith((vid = device.substring(0, 4)) + "&PID_")) continue;
            device = device.replace(vid + "&PID_", "");
            String uid = device.substring(0, 4);
            uidVid.add(new String[]{vid, uid});
        }
        return uidVid;
    }

    public ArrayList<String> addDeviceToInstallationQueueIfInList(ArrayList<String> installqueue, String device) {
        for (String vid : this.windowsDriverBlanket) {
            if (!device.startsWith("USB\\VID_" + vid)) continue;
            installqueue.add(device);
        }
        return installqueue;
    }
}

