/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.heimdall;

import CASUAL.CASUALMessageObject;
import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.Shell;
import CASUAL.Statics;
import CASUAL.communicationstools.AbstractDeviceCommunicationsProtocol;
import CASUAL.communicationstools.heimdall.HeimdallErrorHandler;
import CASUAL.communicationstools.heimdall.HeimdallInstall;
import CASUAL.communicationstools.heimdall.drivers.DriverInstall;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HeimdallTools
extends AbstractDeviceCommunicationsProtocol {
    static final String[] windowsLocation = new String[]{"/CASUAL/communicationstools/heimdall/resources/heimdall.exe", "/CASUAL/communicationstools/heimdall/resources/libusb-1.0.dll", "/CASUAL/communicationstools/heimdall/resources/msvcr110.dll", "/CASUAL/communicationstools/heimdall/resources/msvcp110.dll"};
    static final String[] macLocation = new String[]{"/CASUAL/communicationstools/heimdall/resources/heimdall-mac.dmg"};
    static final String[] linux32Location = new String[]{"/CASUAL/communicationstools/heimdall/resources/heimdall_i386.deb"};
    static final String[] linux64Location = new String[]{"/CASUAL/communicationstools/heimdall/resources/heimdall_amd64.deb"};
    static final String[] linuxArmv6Location = new String[]{"/CASUAL/communicationstools/heimdall/resources/heimdall_armv6.deb"};
    Shell shell = new Shell();
    int heimdallRetries = 0;
    private static String binaryLocation = "";
    int errorCycles = 0;

    @Override
    public int numberOfDevicesConnected() {
        String[] detectCommand = new String[]{"detect"};
        String connectedString = "Device detected";
        String shellReturn = this.run(detectCommand, 4000, true);
        if (shellReturn.contains(connectedString)) {
            Log.level3Verbose("Heimdall Device detected!");
            this.errorCycles = 100;
            return 1;
        }
        ++this.errorCycles;
        if (this.errorCycles == 60) {
            new CASUALMessageObject("@interactionUnableToDetectDownloadMode").showInformationMessage();
        }
        return 0;
    }

    @Override
    public boolean checkErrorMessage(String[] commandRun, String returnValue) {
        boolean errored;
        if (commandRun[1].equals("detect")) {
            return true;
        }
        CommandDisposition retval = new HeimdallErrorHandler().doErrorCheck(commandRun, returnValue);
        ++this.errorCycles;
        switch (retval) {
            case NOACTIONREQUIRED: {
                this.errorCycles = 0;
                errored = false;
                break;
            }
            case RUNAGAIN: {
                errored = this.checkErrorMessage(commandRun, this.doElevatedHeimdallShellCommand(commandRun));
                if (this.errorCycles <= 4) break;
                retval = CommandDisposition.MAXIMUMRETRIES;
                errored = true;
                break;
            }
            case ELEVATIONREQUIRED: {
                errored = this.checkErrorMessage(commandRun, this.doElevatedHeimdallShellCommand(commandRun));
                if (this.errorCycles <= 4) break;
                retval = CommandDisposition.MAXIMUMRETRIES;
                errored = true;
                break;
            }
            case INSTALLDRIVERS: {
                this.errorCycles = 0;
                this.installDriver();
                errored = this.checkErrorMessage(commandRun, this.doHeimdallShellCommand(commandRun));
                break;
            }
            case HALTSCRIPT: {
                errored = true;
                break;
            }
            case MAXIMUMRETRIES: {
                Log.level0Error("Heimdall has encountered an error we did not forsee");
                errored = true;
                break;
            }
            default: {
                errored = true;
            }
        }
        return !errored;
    }

    @Override
    public boolean installDriver() {
        if (OSTools.isWindows()) {
            return new DriverInstall(0).installKnownDrivers();
        }
        if (OSTools.isMac() || OSTools.isLinux()) {
            return !this.deployBinary(Statics.getTempFolder()).equals("");
        }
        return false;
    }

    @Override
    public String deployBinary(String tempFolder) {
        HeimdallInstall hinstall = new HeimdallInstall();
        try {
            if (OSTools.isLinux()) {
                binaryLocation = hinstall.installLinux(tempFolder);
            } else if (OSTools.isMac()) {
                hinstall.installMac(macLocation, tempFolder);
            } else if (OSTools.isWindows()) {
                binaryLocation = hinstall.installWindows(windowsLocation, tempFolder);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger(HeimdallTools.class.getName()).log(Level.SEVERE, "Error while trying to install heimdall", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(HeimdallTools.class.getName()).log(Level.SEVERE, "Error while trying to install heimdall", ex);
        }
        return binaryLocation;
    }

    @Override
    public void restartConnection() {
        this.reset();
    }

    @Override
    public void reset() {
        this.heimdallRetries = 0;
        binaryLocation = "";
    }

    @Override
    public void shutdown() {
        this.reset();
    }

    @Override
    public String getConnectionMethodName() {
        return "Heimdall";
    }

    @Override
    public String getBinaryLocation() {
        if (binaryLocation != null && !binaryLocation.isEmpty() && new File(binaryLocation).isFile() && new File(binaryLocation).exists()) {
            return binaryLocation;
        }
        binaryLocation = this.locateNativeHeimdall();
        if (!binaryLocation.isEmpty()) {
            return binaryLocation;
        }
        binaryLocation = this.deployBinary(Statics.getTempFolder());
        return binaryLocation;
    }

    private String locateNativeHeimdall() {
        String notFound = "CritERROR!!!";
        if (OSTools.isWindows()) {
            String heimdall = "heimdall";
            String[] cmd = new String[]{heimdall};
            String retval = this.shell.silentShellCommand(cmd);
            if (retval.contains(notFound) || retval.equals("")) {
                return "";
            }
            return heimdall;
        }
        String cmd = "/usr/local/bin/heimdall";
        String check = this.shell.silentShellCommand(new String[]{cmd});
        Log.level4Debug("native search /usr/local/bin/heimdall" + check);
        if (check.equals(notFound)) {
            cmd = "/usr/bin/heimdall";
            check = this.shell.silentShellCommand(new String[]{cmd});
            Log.level4Debug("native search /usr/bin/heimdall" + check);
            if (check.equals(notFound)) {
                cmd = "/bin/heimdall";
                check = this.shell.silentShellCommand(new String[]{cmd});
                Log.level4Debug("native search /bin/heimdall" + check);
                if (check.equals(notFound)) {
                    cmd = "heimdall";
                    check = this.shell.silentShellCommand(new String[]{cmd});
                    Log.level4Debug("native search heimdall" + check);
                    if (check.equals(notFound)) {
                        cmd = "";
                    }
                }
            }
        }
        return cmd;
    }

    private String doElevatedHeimdallShellCommand(String[] command) {
        Log.level4Debug("Executing ELEVATED Heimdall Command:  " + new HeimdallErrorHandler().displayArray(command));
        String returnval = this.shell.elevateSimpleCommandWithMessage(command, "CASUAL uses root to work around Heimdall permissions.  Hit cancel if you know root is not required to access your device.");
        return returnval;
    }

    private String[] getBinaryCommandInArray(String[] command) {
        String[] cmd = new String[command.length + 1];
        cmd[0] = this.getBinaryLocation();
        System.arraycopy(command, 0, cmd, 1, command.length);
        return cmd;
    }

    public String doHeimdallShellCommand(String[] command) {
        HeimdallErrorHandler heh = new HeimdallErrorHandler();
        Log.level4Debug("Executing " + heh.displayArray(command));
        command = this.getBinaryCommandInArray(command);
        int timesRun = 0;
        String returnValue = "";
        String shellRead = this.shell.liveShellCommand(command, true);
        returnValue = returnValue + shellRead;
        ++timesRun;
        return returnValue;
    }

    private String[] getLinuxADBResource() {
        String arch = OSTools.checkLinuxArch();
        if (arch.equals("x86_64")) {
            return linux64Location;
        }
        if (arch.equals("ARMv6")) {
            return linuxArmv6Location;
        }
        return linux32Location;
    }

    public static enum CommandDisposition {
        NOACTIONREQUIRED,
        RUNAGAIN,
        ELEVATIONREQUIRED,
        INSTALLDRIVERS,
        HALTSCRIPT,
        MAXIMUMRETRIES;

    }
}

