/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.heimdall;

import CASUAL.CASUALMain;
import CASUAL.CASUALMessageObject;
import CASUAL.FileOperations;
import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.ResourceDeployer;
import CASUAL.Shell;
import CASUAL.communicationstools.heimdall.HeimdallTools;
import CASUAL.communicationstools.heimdall.drivers.DriverInstall;
import CASUAL.network.CASUALUpdates;
import java.io.File;
import java.io.IOException;

public class HeimdallInstall {
    public static final String heimdallVersion = "140";
    final String[] WindowsDriverBlanket = new String[]{"18D1", "04E8", "0B05", "0BB4", "22B8", "054C", "2080"};
    public String VID = "";
    public String PID = "";
    FileOperations FileOperations = new FileOperations();
    Shell shell = new Shell();

    String installLinux(String tempFolder) {
        String[] resource;
        FileOperations fo = new FileOperations();
        String arch = OSTools.checkLinuxArch();
        if (arch.contains("armv6")) {
            resource = HeimdallTools.linuxArmv6Location;
        } else if (arch.contains("i686")) {
            resource = HeimdallTools.linux32Location;
        } else if (arch.contains("x86_64")) {
            resource = HeimdallTools.linux64Location;
        } else {
            Log.level0Error("@incompatibleWithHeimdal");
            resource = new String[]{};
        }
        ResourceDeployer rd = new ResourceDeployer();
        for (String heimdallResource : resource) {
            String debDeployed = rd.deployResourceTo(heimdallResource, tempFolder);
            this.shell.elevateSimpleCommandWithMessage(new String[]{"dpkg", "-i", debDeployed}, "Permissions escillation required to install Heimdall");
        }
        String heimdallDeployed = "heimdall";
        if (this.checkHeimdallVersion(heimdallDeployed)) {
            return heimdallDeployed;
        }
        return "";
    }

    public boolean installWindowsDrivers() {
        return new DriverInstall(0).installKnownDrivers();
    }

    public void displayWindowsPermissionsMessageAndExit() {
        if (OSTools.isWindows()) {
            new CASUALMessageObject("@interactionwindowsRunAsMessage" + this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath().toString()).showErrorDialog();
        }
        CASUALMain.shutdown(0);
    }

    void runWinHeimdallInstallationProcedure() {
        this.installWindowsDrivers();
    }

    public boolean checkHeimdallVersion(String binaryLocation) {
        int resourceVersion;
        String[] command = new String[]{binaryLocation, "version"};
        String Version = new Shell().silentShellCommand(command);
        if (!Version.contains("CritERROR!!!")) {
            if ((Version = Version.replaceAll("\n", "").replaceAll("v", "")).contains(" ")) {
                Version = Version.split(" ")[0];
            }
            if ((Version = Version.replaceAll("\\.", "")).length() == 2) {
                Version = Version + 0;
            }
        } else {
            return false;
        }
        char[] digits = Version.toCharArray();
        int commandLineVersion = Integer.parseInt(new String(digits));
        return commandLineVersion >= (resourceVersion = Integer.parseInt(heimdallVersion));
    }

    String installWindows(String[] windowsLocation, String tempFolder) {
        HeimdallTools ht = new HeimdallTools();
        String expectedLocation = tempFolder + "heimdall.exe";
        if (ht.fileIsDeployedProperly(expectedLocation)) {
            return expectedLocation;
        }
        ResourceDeployer rt = new ResourceDeployer();
        for (String res : HeimdallTools.windowsLocation) {
            String name = tempFolder + new File(res).getName();
            rt.copyFromResourceToFile(res, name);
        }
        Log.level4Debug("deployHeimdallForWindows- verifying Heimdall deployment");
        if (ht.fileIsDeployedProperly(expectedLocation)) {
            Log.level4Debug("heimdall install sucessful");
            return expectedLocation;
        }
        return null;
    }

    String installMac(String[] resourceLocation, String tempFolder) throws InterruptedException, IOException {
        ResourceDeployer rd = new ResourceDeployer();
        String exec = this.getFile(rd.deployResourceTo(resourceLocation, tempFolder), "");
        if (exec.equals("")) {
            exec = new CASUALUpdates().CASUALRepoDownload("https://android-casual.googlecode.com/svn/trunk/repo/heimdall.properties");
        }
        new Shell().liveShellCommand(new String[]{"open", "-W", exec}, true);
        new CASUALMessageObject("@interactionUnplugItAndPlugItBackIn").showErrorDialog();
        return "heimdall";
    }

    private String getFile(String[] fullyQualifiedPaths, String filename) {
        if (fullyQualifiedPaths.length == 1) {
            return fullyQualifiedPaths[0];
        }
        String retval = "";
        for (String value : fullyQualifiedPaths) {
            if (!value.endsWith(filename)) continue;
            retval = filename;
            break;
        }
        return retval;
    }
}

