/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.fastboot;

import CASUAL.CASUALMessageObject;
import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.ResourceDeployer;
import CASUAL.Shell;
import CASUAL.ShellTools;
import CASUAL.Statics;
import CASUAL.communicationstools.AbstractDeviceCommunicationsProtocol;
import CASUAL.misc.StringOperations;
import java.io.File;
import java.util.ArrayList;

public class FastbootTools
extends AbstractDeviceCommunicationsProtocol {
    private static String binaryLocation = "";
    private static final String fastbootLinux32 = "/CASUAL/communicationstools/fastboot/resources/fastboot-linux32";
    private static final String fastbootMac = "/CASUAL/communicationstools/fastboot/resources/fastboot-mac";
    private static final String fastbootWindows = "/CASUAL/communicationstools/fastboot/resources/fastboot.exe";
    private static final String fastbootLinuxARMv6 = "/CASUAL/communicationstools/fastboot/resources/fastboot-linuxARMv6";
    private static final String fastbootLinux64 = "/CASUAL/communicationstools/fastboot/resources/fastboot-linux64";

    @Override
    public String getBinaryLocation() {
        File loc = new File(binaryLocation);
        if (!loc.isFile() || !loc.exists()) {
            return this.deployBinary(Statics.getTempFolder());
        }
        return binaryLocation;
    }

    private static String getFastbootLinuxResource() {
        String arch = OSTools.checkLinuxArch();
        if (arch.equals("x86_64")) {
            Log.level3Verbose("found x86-64 bit arch");
            return fastbootLinux64;
        }
        if (arch.equals("ARMv6")) {
            Log.level3Verbose("found ARMv6 arch");
            return fastbootLinuxARMv6;
        }
        Log.level3Verbose("found x86-32 bit arch");
        return fastbootLinux32;
    }

    public String doFastbootShellCommand(String line) {
        line = StringOperations.removeLeadingSpaces(line);
        Shell Shell2 = new Shell();
        ArrayList<String> ShellCommand = new ArrayList<String>();
        ShellCommand.add(binaryLocation);
        ShellCommand.addAll(new ShellTools().parseCommandLine(line));
        String[] StringCommand = StringOperations.convertArrayListToStringArray(ShellCommand);
        Log.level3Verbose("Performing standard fastboot command" + line);
        return Shell2.liveShellCommand(StringCommand, true);
    }

    public String doElevatedFastbootShellCommand(String line) {
        line = StringOperations.removeLeadingSpaces(line);
        Shell Shell2 = new Shell();
        ArrayList<String> ShellCommand = new ArrayList<String>();
        ShellCommand.add(binaryLocation);
        ShellCommand.addAll(new ShellTools().parseCommandLine(line));
        String[] StringCommand = StringOperations.convertArrayListToStringArray(ShellCommand);
        Log.level3Verbose("Performing elevated Fastboot command" + line);
        String returnval = Shell2.elevateSimpleCommandWithMessage(StringCommand, "CASUAL uses root to work around fastboot permissions.  Hit cancel if you have setup your UDEV rules.");
        return returnval;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public int numberOfDevicesConnected() {
        String[] devices = this.run(new String[]{"devices"}, 4000, true).trim().split("\n");
        int devcount = 0;
        for (String device : devices) {
            if (!device.trim().endsWith("fastboot")) continue;
            ++devcount;
        }
        return devcount;
    }

    @Override
    public boolean checkErrorMessage(String[] commandRun, String returnValue) {
        return true;
    }

    @Override
    public boolean installDriver() {
        return true;
    }

    @Override
    public String deployBinary(String tempFolder) {
        File loc;
        if (binaryLocation.isEmpty()) {
            String fastbootResource;
            binaryLocation = Statics.getTempFolder() + "fastboot";
            if (OSTools.isWindows()) {
                binaryLocation = binaryLocation + ".exe";
                new CASUALMessageObject("@interactionInstallFastbootDrivers").showInformationMessage();
                fastbootResource = fastbootWindows;
            } else {
                fastbootResource = OSTools.isMac() ? fastbootMac : FastbootTools.getFastbootLinuxResource();
            }
            Log.level2Information("@deployingFastboot");
            Log.level3Verbose("Deploying Fastboot from " + fastbootResource + " to " + binaryLocation);
            binaryLocation = new ResourceDeployer().deployResourceTo(fastbootResource, tempFolder);
            if (OSTools.isLinux() || OSTools.isMac()) {
                new File(binaryLocation).setExecutable(true);
            }
            Log.level2Information("@fastbootDeployed");
        }
        if ((loc = new File(binaryLocation)).exists()) {
            return binaryLocation;
        }
        return "";
    }

    @Override
    public void restartConnection() {
        this.reset();
        this.getBinaryLocation();
    }

    @Override
    public void reset() {
        if (!binaryLocation.isEmpty()) {
            this.shutdown();
        }
        binaryLocation = "";
    }

    @Override
    public String getConnectionMethodName() {
        return "fastboot";
    }
}

