/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.adb.busybox;

import CASUAL.CASUALMessageObject;
import CASUAL.CASUALTools;
import CASUAL.Log;
import CASUAL.Shell;
import CASUAL.Statics;
import CASUAL.communicationstools.adb.ADBTools;
import CASUAL.communicationstools.adb.busybox.BusyboxTools;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Scanner;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;

public class CASUALDataBridge {
    Shell shell = new Shell();
    ADBTools adb = new ADBTools();
    static final String port = "27825";
    static final String ip = "127.0.0.1";
    static final Integer WATCHDOGINTERVAL = 2000;
    private static boolean deviceReadyForReceive = false;
    static String deviceSideMessage = "";
    static boolean shutdownBecauseOfError = false;
    public static boolean commandedShutdown = false;
    static long bytes = 0L;
    static long lastbytes = -1L;
    static String status = "";
    final String USBDISCONNECTED = "USB Disconnected";
    final String DEVICEDISCONNECTED = "error: device not found";
    final String PERMISSIONERROR = "/system/bin/sh: can't open";
    public static Timer timeoutWatchdog = new Timer(WATCHDOGINTERVAL, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (lastbytes == bytes) {
                try {
                    Log.level0Error("Failed to send file.  Timeout. Bytes:" + bytes + " Message:" + deviceSideMessage);
                    deviceReadyForReceive = false;
                    shutdownBecauseOfError = true;
                    timeoutWatchdog.stop();
                    throw new TimeoutException();
                }
                catch (TimeoutException ex) {
                    Logger.getLogger(CASUALDataBridge.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                lastbytes = bytes;
                Statics.setStatus(status + " " + bytes);
            }
        }
    });

    public synchronized String getFile(String remoteFileName, File f) throws IOException, InterruptedException {
        status = "received ";
        FileOutputStream fos = new FileOutputStream(f);
        this.getStream(fos, remoteFileName);
        if (shutdownBecauseOfError) {
            return deviceSideMessage;
        }
        return f.getCanonicalPath();
    }

    public synchronized long sendString(String send, String remoteFileName) throws InterruptedException, SocketException, IOException {
        send = send + "\n" + 4;
        ByteArrayInputStream bis = new ByteArrayInputStream(send.getBytes());
        long retval = this.sendStream(bis, remoteFileName);
        return retval;
    }

    public synchronized long sendFile(File f, String remoteFileName) throws FileNotFoundException, Exception {
        Log.level2Information("sending " + f.getName() + " to device. size=" + f.length());
        FileInputStream fis = new FileInputStream(f);
        long retval = this.sendStream(fis, remoteFileName);
        try {
            fis.close();
        }
        catch (IOException ex) {
            Logger.getLogger(CASUALDataBridge.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (!this.checkErrors()) {
            retval = 0L;
        }
        if (f.length() != retval) {
            retval = 0L;
        }
        return retval;
    }

    public synchronized long sendStream(InputStream input, String remoteFileName) throws InterruptedException, SocketException, IOException {
        this.resetCASUALConnection();
        Thread t = new DeviceSide().startDeviceSideServer(remoteFileName, true);
        Socket socket = this.setupPort();
        OutputStream os = socket.getOutputStream();
        this.copyStreamToDevice(input, os, true);
        this.shutdownCommunications(socket, t);
        if (shutdownBecauseOfError) {
            return 0L;
        }
        return bytes;
    }

    private long getStream(OutputStream output, String remoteFileName) throws IOException, InterruptedException {
        this.resetCASUALConnection();
        Thread t = new DeviceSide().startDeviceSideServer(remoteFileName, false);
        Socket socket = this.setupPort();
        this.copyStreamFromDevice(socket, output);
        this.shutdownCommunications(socket, t);
        return bytes;
    }

    private long copyStreamToDevice(InputStream input, OutputStream output, boolean toDevice) {
        try {
            long startTime = System.currentTimeMillis();
            byte[] buf = new byte[16384];
            timeoutWatchdog.start();
            BufferedOutputStream bos = new BufferedOutputStream(output);
            BufferedInputStream bis = new BufferedInputStream(input);
            int buflen = buf.length - 1;
            while (bis.available() >= buflen && !commandedShutdown) {
                bis.read(buf);
                bos.write(buf);
                bytes += (long)buf.length;
            }
            if (bis.available() > 0) {
                buf = new byte[input.available()];
                bis.read(buf);
                bytes += (long)buf.length;
                bos.write(buf);
            }
            timeoutWatchdog.stop();
            bos.flush();
            Statics.setStatus("Sent:" + bytes + "bytes");
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            double kb = (double)bytes / duration / 1000.0;
            Log.level2Information("Sent:" + bytes / 1000L + "kb in " + duration + "s at " + kb + " KB/s");
        }
        catch (IOException ex) {
            timeoutWatchdog.stop();
            Logger.getLogger(CASUALDataBridge.class.getName()).log(Level.SEVERE, null, ex);
        }
        return bytes;
    }

    private long copyStreamFromDevice(Socket socket, OutputStream output) {
        try {
            Statics.setStatus("Data transfer initiated, please wait");
            BufferedInputStream bis = new BufferedInputStream(socket.getInputStream());
            long startTime = System.currentTimeMillis();
            timeoutWatchdog.start();
            while (deviceReadyForReceive && !commandedShutdown) {
                byte[] buf;
                while ((buf = new byte[bis.available()]).length > 0) {
                    bytes += (long)buf.length;
                    bis.read(buf);
                    output.write(buf);
                }
            }
            timeoutWatchdog.stop();
            output.flush();
            Statics.setStatus("Sent:" + bytes + "bytes");
            long endTime = System.currentTimeMillis();
            double duration = (double)(endTime - startTime) / 1000.0;
            double kb = (double)bytes / duration / 1000.0;
            Log.level2Information("Sent:" + bytes / 1000L + "kb in " + duration + "s at " + kb + " KB/s");
        }
        catch (IOException ex) {
            timeoutWatchdog.stop();
            Logger.getLogger(CASUALDataBridge.class.getName()).log(Level.SEVERE, null, ex);
        }
        return bytes;
    }

    private void resetCASUALConnection() {
        deviceReadyForReceive = false;
        shutdownBecauseOfError = false;
        deviceSideMessage = "";
        bytes = 0L;
        lastbytes = -1L;
        Log.level4Debug("closing existing stream");
        Log.level4Debug("restarting server");
        new ADBTools().restartConnection();
        this.shell.silentShellCommand(new String[]{this.adb.getBinaryLocation(), "forward", "--remove-all"});
        try {
            Socket socket = new Socket(ip, Integer.parseInt(port));
            socket.shutdownInput();
            socket.shutdownOutput();
            socket.close();
        }
        catch (ConnectException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Log.level4Debug("establishing ports");
        this.shell.silentShellCommand(new String[]{this.adb.getBinaryLocation(), "shell", "killall busybox"});
        this.shell.silentShellCommand(new String[]{this.adb.getBinaryLocation(), "forward", "tcp:27825", "tcp:27825"});
        Log.level3Verbose("ports established");
    }

    private void waitForReadySignal() {
        while (!deviceReadyForReceive && !commandedShutdown) {
            this.sleep(100);
        }
    }

    private Socket setupPort() throws SocketException, IOException, NumberFormatException {
        int p = Integer.parseInt(port);
        Socket socket = new Socket(ip, p);
        socket.setTrafficClass(4);
        return socket;
    }

    private void shutdownCommunications(Socket socket, Thread t) throws InterruptedException, IOException {
        Log.level4Debug("Flushing port");
        deviceReadyForReceive = false;
        socket.getOutputStream().flush();
        Log.level4Debug("closing ports");
        socket.shutdownOutput();
        socket.shutdownInput();
        socket.close();
        Log.level4Debug("waiting for device-side server to shutdown");
        t.join();
    }

    private void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private boolean checkErrors() {
        return !deviceSideMessage.equals("USB Disconnected") && !deviceSideMessage.equals("error: device not found") && !deviceSideMessage.startsWith("/system/bin/sh: can't open");
    }

    public String integralGetFile(String remoteFile, File f) {
        String retval = "";
        try {
            retval = this.getFile(remoteFile, f);
        }
        catch (IOException ex) {
            Log.errorHandler(ex);
        }
        catch (InterruptedException ex) {
            Log.errorHandler(ex);
        }
        while (shutdownBecauseOfError && !commandedShutdown) {
            deviceReadyForReceive = false;
            deviceSideMessage = "";
            shutdownBecauseOfError = false;
            bytes = 0L;
            lastbytes = -1L;
            status = "";
            new CASUALMessageObject("@interactionFailedToReceive").showInformationMessage();
            try {
                return this.getFile(remoteFile, f);
            }
            catch (IOException ex) {
                Log.errorHandler(ex);
            }
            catch (InterruptedException ex) {
                Log.errorHandler(ex);
            }
        }
        return retval;
    }

    public static String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    class DeviceSide {
        DeviceSide() {
        }

        private Thread startDeviceSideServer(String remoteFileName, boolean forWrite) {
            Thread t = new Thread(new DeviceSide().openLinkForReadOrWrite(remoteFileName, forWrite));
            t.setName("Device Write Server");
            t.start();
            CASUALDataBridge.this.waitForReadySignal();
            return t;
        }

        private Runnable openLinkForReadOrWrite(final String remoteFileName, final boolean forWrite) {
            return new Runnable(){

                @Override
                public void run() {
                    try {
                        String busybox = BusyboxTools.getBusyboxLocation();
                        String donestring = "operation complete";
                        String sendcommand = busybox + " stty raw;" + busybox + " nc -l " + CASUALDataBridge.ip + ":" + CASUALDataBridge.port + ">'" + remoteFileName + "';echo " + donestring;
                        String receiveCommand = busybox + " stty raw;" + busybox + " nc -l " + CASUALDataBridge.ip + ":" + CASUALDataBridge.port + " <'" + remoteFileName + "';sync;echo " + donestring;
                        String[] cmd = forWrite ? (!CASUALTools.rootAccessCommand().equals("") ? new String[]{CASUALDataBridge.this.adb.getBinaryLocation(), "shell", sendcommand} : new String[]{CASUALDataBridge.this.adb.getBinaryLocation(), "shell", CASUALTools.rootAccessCommand() + " \"" + sendcommand + ";\""}) : (CASUALTools.rootAccessCommand().equals("") ? new String[]{CASUALDataBridge.this.adb.getBinaryLocation(), "shell", receiveCommand} : new String[]{CASUALDataBridge.this.adb.getBinaryLocation(), "shell", CASUALTools.rootAccessCommand() + " '" + receiveCommand + "'"});
                        ProcessBuilder p = new ProcessBuilder(cmd);
                        p.redirectErrorStream(true);
                        Process proc = p.start();
                        InputStream is = proc.getInputStream();
                        is.read(new byte[0]);
                        is = this.waitForDeviceSideConnection(is);
                        Statics.setStatus("device ready");
                        deviceReadyForReceive = true;
                        proc.waitFor();
                        Statics.setStatus("device-side server closed");
                        deviceSideMessage = CASUALDataBridge.convertStreamToString(is);
                        if (!deviceSideMessage.startsWith(donestring)) {
                            if (deviceSideMessage.equals("")) {
                                deviceSideMessage = "USB Disconnected";
                            }
                            shutdownBecauseOfError = true;
                            deviceReadyForReceive = false;
                            Log.level0Error("Failed to send file. Bytes:" + bytes + " Message:" + deviceSideMessage);
                            throw new RuntimeException("Server exited improperly- received");
                        }
                        Log.level4Debug("device reported sucessful shutdown");
                        deviceReadyForReceive = false;
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(CASUALDataBridge.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(CASUALDataBridge.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }

                InputStream waitForDeviceSideConnection(InputStream is) throws IOException {
                    String[] cmd = new String[]{CASUALDataBridge.this.adb.getBinaryLocation(), "shell", "/data/local/tmp/busybox netstat -tul"};
                    boolean ready = false;
                    String received = "";
                    Statics.setStatus("monitoring ports on device");
                    while (!ready && !commandedShutdown) {
                        while (is.available() > 0) {
                            received = received + is.read();
                            Log.level4Debug(received);
                            if (!received.contains("read-only file system") && !received.contains("cannot open") && !received.contains("No such file or directory") && !received.contains("error: device not found") && !received.contains("USB Disconnected") && !received.contains("/system/bin/sh: can't open") && !received.contains("error: more than one device and emulator")) continue;
                            this.shutdownServer(received);
                        }
                        String returnval = CASUALDataBridge.this.shell.silentShellCommand(cmd);
                        if (!returnval.contains(":27825")) continue;
                        ready = true;
                    }
                    return is;
                }

                private void shutdownServer(String message) {
                    shutdownBecauseOfError = true;
                    deviceSideMessage = message;
                    deviceReadyForReceive = true;
                    Log.level0Error(message);
                }
            };
        }
    }
}

