/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.adb.busybox;

import CASUAL.Log;
import CASUAL.ResourceDeployer;
import CASUAL.Shell;
import CASUAL.Statics;
import CASUAL.communicationstools.adb.ADBTools;

public class BusyboxTools {
    public static final String busyboxARM = "/CASUAL/communicationstools/adb/busybox/resources/busybox-armv4tl";
    public static final String busyboxX86 = "/CASUAL/communicationstools/adb/busybox/resources/busybox-i686";
    final String busyboxLocation = "/data/local/tmp/busybox";
    ADBTools adb = new ADBTools();
    Shell shell = new Shell();

    private String getDeviceArch() {
        String[] lines;
        if (Statics.CASPAC != null && !Statics.CASPAC.getActiveScript().deviceArch.equals("")) {
            return Statics.CASPAC.getActiveScript().deviceArch;
        }
        String cpuinfo = this.shell.silentShellCommand(new String[]{this.adb.getBinaryLocation(), "shell", "cat /proc/cpuinfo"});
        for (String line : lines = cpuinfo.split("\n")) {
            if (!line.contains("Processor") || !line.contains("ARM")) continue;
            return "ARM";
        }
        return "X86";
    }

    private boolean busyboxIsInstalled() {
        String temp = this.shell.silentShellCommand(new String[]{this.adb.getBinaryLocation(), "shell", "chmod 777 /data/local/tmp/busybox;ls /data/local/tmp/busybox"});
        return !temp.contains("No such") && !temp.contains("found");
    }

    public static String getBusyboxLocation() {
        BusyboxTools bbtools = new BusyboxTools();
        if (bbtools.busyboxIsInstalled()) {
            return bbtools.busyboxLocation;
        }
        Log.level4Debug("deploying busybox");
        return bbtools.deployBusybox();
    }

    public static void reset() {
    }

    private String deployBusybox() {
        ResourceDeployer rd = new ResourceDeployer();
        String busyboxOnHost = Statics.getTempFolder() + "busybox";
        String[] installCmd = new String[]{this.adb.getBinaryLocation(), "push", busyboxOnHost, "/data/local/tmp/busybox"};
        String busyboxResource = this.getDeviceArch().equals("ARM") ? busyboxARM : busyboxX86;
        rd.copyFromResourceToFile(busyboxResource, busyboxOnHost);
        new Shell().silentShellCommand(installCmd);
        String check = new Shell().sendShellCommand(new String[]{this.adb.getBinaryLocation(), "shell", "chmod 777 /data/local/tmp/busybox;ls /data/local/tmp"});
        if (check.contains("busybox")) {
            return this.busyboxLocation;
        }
        return null;
    }
}

