/*
 * Decompiled with CFR 0.152.
 */
package CASUAL.communicationstools.adb;

import CASUAL.CASUALMessageObject;
import CASUAL.Log;
import CASUAL.OSTools;
import CASUAL.ResourceDeployer;
import CASUAL.Shell;
import CASUAL.Statics;
import CASUAL.communicationstools.AbstractDeviceCommunicationsProtocol;
import CASUAL.misc.DiffTextFiles;
import java.awt.HeadlessException;
import java.io.File;

public class ADBTools
extends AbstractDeviceCommunicationsProtocol {
    private static String binaryLocation = "";
    private static final String[] linux64Location = new String[]{"/CASUAL/communicationstools/adb/resources/adb-linux64"};
    private static final String[] linux32Location = new String[]{"/CASUAL/communicationstools/adb/resources/adb-linux32"};
    private static final String[] windowsLocation = new String[]{"/CASUAL/communicationstools/adb/resources/adb.exe", "/CASUAL/communicationstools/adb/resources/AdbWinApi.dll", "/CASUAL/communicationstools/adb/resources/AdbWinUsbApi.dll"};
    private static final String[] macLocation = new String[]{"/CASUAL/communicationstools/adb/resources/adb-mac"};
    private static final String[] linuxArmv6Location = new String[]{"/CASUAL/communicationstools/adb/resources/adb-linuxARMv6"};
    private static final String adbIniResource = "/CASUAL/communicationstools/adb/resources/adb_usb.ini";

    private String getAdbIniLocation() {
        return System.getProperty("user.home") + Statics.slash + ".android" + Statics.slash + "adb_usb.ini";
    }

    private String[] getLinuxADBResource() {
        String arch = OSTools.checkLinuxArch();
        if (arch.equals("x86_64")) {
            return linux64Location;
        }
        if (arch.equals("ARMv6")) {
            return linuxArmv6Location;
        }
        return linux32Location;
    }

    @Override
    public int numberOfDevicesConnected() {
        String[] devices = this.getIndividualDevices();
        int connected = 0;
        for (String device : devices) {
            if (!device.trim().endsWith("device") && !device.trim().endsWith("recovery")) continue;
            ++connected;
        }
        return connected;
    }

    @Override
    public void restartConnection() {
        Log.level3Verbose("@restartingADBSlowly");
        Shell shell = new Shell();
        shell.timeoutShellCommand(this.getKillServerCmd(), 1000);
        String retval = shell.timeoutShellCommand(this.getDevicesCmd(), 6000);
        new ADBTools().checkErrorMessage(this.getDevicesCmd(), retval);
    }

    @Override
    public boolean checkErrorMessage(String[] commandRun, String returnValue) throws HeadlessException {
        if (OSTools.isLinux() && returnValue.contains("ERROR-3")) {
            Shell shell = new Shell();
            Log.level0Error("@permissionsElevationRequired");
            shell.silentShellCommand(this.getKillServerCmd());
            shell.elevateSimpleCommandWithMessage(this.getDevicesCmd(), "Device permissions problem detected");
            return false;
        }
        if (returnValue.contains("ELFCLASS64") && returnValue.contains("wrong ELF")) {
            new CASUALMessageObject("@interactionELFCLASS64Error").showInformationMessage();
            return false;
        }
        if (returnValue.contains("List of devices attached ")) {
            if (returnValue.contains("unauthorized") || returnValue.contains("Please check the confirmation dialog on your device.")) {
                new CASUALMessageObject("@interactionPairingRequired").showActionRequiredDialog();
                return false;
            }
            if (returnValue.contains("offline")) {
                Object[] ok = new String[]{"All set and done!"};
                new CASUALMessageObject("@interactionOfflineNotification").showTimeoutDialog(120, null, 0, 2, ok, 0);
                Log.level0Error("@disconnectAndReconnect");
                return false;
            }
            if (returnValue.contains("????????????") || returnValue.contains("**************") || returnValue.contains("error: cannot connect to daemon")) {
                Log.level0Error("@unrecognizedDeviceDetected");
                Log.level4Debug("Restarting ADB slowly");
                this.restartConnection();
                returnValue = new Shell().silentShellCommand(this.getDevicesCmd()).replace("List of devices attached \n", "").replace("\n", "").replace("\t", "");
                if (!OSTools.isWindows() && returnValue.contains("????????????") || returnValue.contains("**************") || returnValue.contains("error: cannot connect to daemon")) {
                    Object[] ok = new String[]{"ok"};
                    new CASUALMessageObject("@interactionInsufficientPermissionsWorkaround").showTimeoutDialog(60, null, 0, 2, ok, 0);
                    this.shutdown();
                    this.elevateADBserver();
                }
            }
        }
        return true;
    }

    @Override
    public boolean isConnected() {
        return this.numberOfDevicesConnected() == 1;
    }

    @Override
    public void reset() {
        if (!binaryLocation.isEmpty()) {
            this.shutdown();
        }
        binaryLocation = "";
    }

    @Override
    public boolean installDriver() {
        return true;
    }

    @Override
    public synchronized String deployBinary(String tempFolder) {
        String[] devicesCommand;
        String[] resourceLocation;
        Log.level4Debug("Deploying ADB");
        String tempBinaryLocation = Statics.getTempFolder() + "adb";
        if (OSTools.isLinux()) {
            Log.level4Debug("Found Linux Computer for ADB deployment");
            resourceLocation = this.getLinuxADBResource();
        } else if (OSTools.isMac()) {
            Log.level4Debug("Found Mac Computer for ADB deployment");
            resourceLocation = macLocation;
        } else if (OSTools.isWindows()) {
            Log.level4Debug("Found Windows Computer for ADB deployment");
            resourceLocation = windowsLocation;
        } else {
            new CASUALMessageObject("@interactionsystemNotNativelySupported").showInformationMessage();
            resourceLocation = new String[]{};
        }
        ResourceDeployer rd = new ResourceDeployer();
        File defaultLocation = new File(this.getDefaultBinaryName());
        for (String res : resourceLocation) {
            String deployedName = rd.deployResourceTo(res, tempFolder);
            if (!deployedName.contains("adb-") && !deployedName.endsWith("adb.exe")) continue;
            new File(deployedName).renameTo(defaultLocation);
            defaultLocation.setExecutable(true);
            tempBinaryLocation = defaultLocation.getAbsolutePath();
        }
        this.updateADBini();
        String[] sendcmd = devicesCommand = new String[]{tempBinaryLocation, "devices"};
        String deviceList = new Shell().silentTimeoutShellCommand(sendcmd, 5000);
        if (this.checkErrorMessage(devicesCommand, deviceList)) {
            binaryLocation = tempBinaryLocation;
        }
        return binaryLocation;
    }

    @Override
    public void shutdown() {
        super.run(this.getKillServerCmd(), 4000, false);
    }

    private void updateADBini() {
        ResourceDeployer rd = new ResourceDeployer();
        String adbini = this.getAdbIniLocation();
        File adbIni = new File(adbini);
        if (!adbIni.isFile() && !adbIni.exists()) {
            rd.copyFromResourceToFile(adbIniResource, adbini);
        } else {
            DiffTextFiles DTF = new DiffTextFiles();
            DTF.appendDiffToFile(adbini, DTF.diffResourceVersusFile(adbIniResource, adbini));
        }
    }

    public String[] getIndividualDevices() {
        String[] retval;
        Shell shell = new Shell();
        String devReturn = this.run(new String[]{"devices"}, 5000, true);
        this.checkErrorMessage(this.getDevicesCmd(), devReturn);
        if (devReturn.equals("List of devices attached \n\n")) {
            return new String[0];
        }
        try {
            retval = devReturn.split("List of devices attached ")[1].trim().split("\n");
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            retval = new String[]{};
        }
        return retval;
    }

    private String getDefaultBinaryName() {
        if (OSTools.isWindows()) {
            return Statics.getTempFolder() + "adb.exe";
        }
        return Statics.getTempFolder() + "adb";
    }

    private String[] getWaitForDeviceCmd() {
        return new String[]{this.getBinaryLocation(), "wait-for-device"};
    }

    private String[] getDevicesCmd() {
        return new String[]{this.getBinaryLocation(), "devices"};
    }

    private String[] getStartServerCmd() {
        return new String[]{this.getBinaryLocation(), "start-server"};
    }

    private String[] getKillServerCmd() {
        return new String[]{this.getBinaryLocation(), "kill-server"};
    }

    public String getDevices() {
        Shell shell = new Shell();
        String devReturn = shell.silentTimeoutShellCommand(this.getDevicesCmd(), 5000);
        return devReturn;
    }

    public String startServer() {
        Shell shell = new Shell();
        String retval = shell.timeoutShellCommand(this.getStartServerCmd(), 5000);
        return retval;
    }

    public void elevateADBserver() {
        Log.level3Verbose("@restartingADB");
        Shell shell = new Shell();
        shell.silentShellCommand(this.getKillServerCmd());
        shell.elevateSimpleCommand(this.getDevicesCmd());
    }

    @Override
    public synchronized String getBinaryLocation() {
        if (binaryLocation.isEmpty() || !new File(binaryLocation).exists()) {
            this.deployBinary(Statics.getTempFolder());
        }
        return binaryLocation;
    }

    @Override
    public String getConnectionMethodName() {
        return "ADB";
    }
}

